package com.ejianc.business.production.vo;

import com.baomidou.mybatisplus.annotation.TableField;
import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.math.BigDecimal;
import java.util.Date;


/**
 * 任务单运输信息
 * 
 * @author generator
 * 
 */
public class ProductiontasktransportVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private String billCode; // 单据编号
    private Long taskId; // 生产任务单id
    private String taskCode; // 生产任务单单号
    private Long shippersId; // 运输商主键id
    private String shippersName; // 运输商名称
    private Long shippersVehicleId; // 运输商车辆主键id
    private String shippersVehicleName; // 运输商车辆名称
    private String shippersVehicleCode; // 车辆照号
    private Integer billState; // 单据状态: 0自由态,1已提交,2审批中,3审批通过,4驳回,5提交后有人审批中
    private Long changeId; // 变更单据id
    private String changeState; // 变更状态，1:未变更;2:变更中;3:已变更
    private Long orgId; // 组织id
    private String orgName; // 组织名称
    private BigDecimal transportCount; // 运输重量
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date transportTime; // 运输时间
    private String transportMethod; // 运输方式



    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    @ReferSerialTransfer(referCode="ProductiontaskRef")
    public Long getTaskId() {
        return taskId;
    }
    @ReferDeserialTransfer
    public void setTaskId(Long taskId) {
        this.taskId = taskId;
    }
    public String getTaskCode() {
        return taskCode;
    }

    public void setTaskCode(String taskCode) {
        this.taskCode = taskCode;
    }
    @ReferSerialTransfer(referCode="ShippersRef")
    public Long getShippersId() {
        return shippersId;
    }
    @ReferDeserialTransfer
    public void setShippersId(Long shippersId) {
        this.shippersId = shippersId;
    }
    public String getShippersName() {
        return shippersName;
    }

    public void setShippersName(String shippersName) {
        this.shippersName = shippersName;
    }
    @ReferSerialTransfer(referCode="ShippersVehicleRef")
    public Long getShippersVehicleId() {
        return shippersVehicleId;
    }
    @ReferDeserialTransfer
    public void setShippersVehicleId(Long shippersVehicleId) {
        this.shippersVehicleId = shippersVehicleId;
    }
    public String getShippersVehicleName() {
        return shippersVehicleName;
    }

    public void setShippersVehicleName(String shippersVehicleName) {
        this.shippersVehicleName = shippersVehicleName;
    }
    public String getShippersVehicleCode() {
        return shippersVehicleCode;
    }

    public void setShippersVehicleCode(String shippersVehicleCode) {
        this.shippersVehicleCode = shippersVehicleCode;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public Long getChangeId() {
        return changeId;
    }

    public void setChangeId(Long changeId) {
        this.changeId = changeId;
    }
    public String getChangeState() {
        return changeState;
    }

    public void setChangeState(String changeState) {
        this.changeState = changeState;
    }
    @ReferSerialTransfer(referCode="idm-org")
    public Long getOrgId() {
        return orgId;
    }
    @ReferDeserialTransfer
    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }

    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }

    public BigDecimal getTransportCount() {
        return transportCount;
    }

    public void setTransportCount(BigDecimal transportCount) {
        this.transportCount = transportCount;
    }

    public Date getTransportTime() {
        return transportTime;
    }

    public void setTransportTime(Date transportTime) {
        this.transportTime = transportTime;
    }

    public String getTransportMethod() {
        return transportMethod;
    }

    public void setTransportMethod(String transportMethod) {
        this.transportMethod = transportMethod;
    }
}
