/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.production.controller;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.production.bean.ProductiontaskEntity;
import com.ejianc.business.production.bean.UnitdistributionEntity;
import com.ejianc.business.production.service.IProductiontaskService;
import com.ejianc.business.production.service.IUnitdistributionService;
import com.ejianc.business.production.vo.UnitdistributionVO;
import com.ejianc.business.sale.salesorder.api.ISalesorderApi;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"unitdistribution"})
public class UnitdistributionController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private IProductiontaskService productiontaskService;
    private static final String BILL_CODE = "unit-distribution";
    @Autowired
    private IUnitdistributionService service;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    @Qualifier(value="com.ejianc.business.sale.salesorder.api.ISalesorderApi")
    private ISalesorderApi salesorderApi;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<UnitdistributionVO> saveOrUpdate(@RequestBody UnitdistributionVO saveOrUpdateVO) {
        UnitdistributionEntity entity = (UnitdistributionEntity)((Object)BeanMapper.map((Object)((Object)saveOrUpdateVO), UnitdistributionEntity.class));
        ProductiontaskEntity productiontaskEntity = (ProductiontaskEntity)((Object)this.productiontaskService.selectById(entity.getTaskId()));
        if (entity.getId() == null || entity.getId() == 0L) {
            entity.setProductState(1);
            BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (!billCode.isSuccess()) {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
            entity.setBillCode((String)billCode.getData());
            productiontaskEntity.setTaskStatus(2);
            productiontaskEntity.setUnitId(entity.getUnitId());
            productiontaskEntity.setUnitName(entity.getUnitName());
            this.productiontaskService.saveOrUpdate((Object)productiontaskEntity, false);
        } else if (entity.getAddCount() != null && new BigDecimal(entity.getAddCount().toString()).compareTo(new BigDecimal("0")) == 1) {
            productiontaskEntity.setThisQuantity(productiontaskEntity.getThisQuantity().add(entity.getAddCount()));
            this.productiontaskService.saveOrUpdate((Object)productiontaskEntity, false);
        }
        BigDecimal sum = new BigDecimal("0");
        QueryWrapper query = new QueryWrapper();
        query.eq((Object)"task_id", (Object)entity.getTaskId());
        List list = this.service.list((Wrapper)query);
        for (UnitdistributionEntity Entity : list) {
            if (String.valueOf(Entity.getId()).equals(String.valueOf(entity.getId()))) continue;
            sum = sum.add(Entity.getDistributeCount());
        }
        if (sum.compareTo(entity.getQuantity()) == 1) {
            throw new BusinessException("\u5206\u914d\u6570\u91cf\u4e0d\u80fd\u5927\u4e8e" + entity.getQuantity().subtract(sum).setScale(2).toString());
        }
        if (sum.compareTo(entity.getQuantity()) == 0 && sum.compareTo(new BigDecimal("0")) == 1) {
            throw new BusinessException("\u6b64\u4efb\u52a1\u5355\u5206\u914d\u6570\u91cf\u5df2\u8fbe\u4e0a\u9650");
        }
        this.service.saveOrUpdate((Object)entity, false);
        UnitdistributionVO vo = (UnitdistributionVO)((Object)BeanMapper.map((Object)((Object)entity), UnitdistributionVO.class));
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)((Object)vo));
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<UnitdistributionVO> queryDetail(Long id) {
        UnitdistributionEntity entity = (UnitdistributionEntity)((Object)this.service.selectById(id));
        UnitdistributionVO vo = (UnitdistributionVO)((Object)BeanMapper.map((Object)((Object)entity), UnitdistributionVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)((Object)vo));
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<UnitdistributionVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (UnitdistributionVO unitdistributionVO : vos) {
            }
        }
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<UnitdistributionVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        UserContext userContextCache = this.sessionManager.getUserContext();
        String authOrgIds = userContextCache.getAuthOrgIds();
        List orgVOList = null;
        orgVOList = StringUtils.isNotBlank((CharSequence)authOrgIds) ? (List)this.getRespData(this.iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002") : (List)this.getRespData(this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002");
        ArrayList commonOrgIds = new ArrayList();
        ArrayList departmentIds = new ArrayList();
        orgVOList.stream().forEach(org -> {
            if (5 == org.getOrgType()) {
                departmentIds.add(org.getId());
            } else {
                commonOrgIds.add(org.getId());
            }
        });
        if (CollectionUtils.isNotEmpty(commonOrgIds)) {
            param.getParams().put("orgId", new Parameter("in", commonOrgIds));
        } else if (CollectionUtils.isNotEmpty(departmentIds)) {
            param.getParams().put("projectDepartmentId", new Parameter("in", departmentIds));
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), UnitdistributionVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        List list = this.service.queryList(param);
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", list);
        ExcelExport.getInstance().export("Unitdistribution-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/refUnitdistributionData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<UnitdistributionVO>> refUnitdistributionData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject jSONObject = JSONObject.parseObject((String)condition);
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), UnitdistributionVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @GetMapping(value={"queryDetailBytaskId"})
    @ResponseBody
    public CommonResponse<UnitdistributionVO> queryDetailBytaskId(@RequestParam(value="taskId") Long taskId) {
        ProductiontaskEntity entity = (ProductiontaskEntity)((Object)this.productiontaskService.selectById(taskId));
        UnitdistributionEntity unitdistributionEntity = new UnitdistributionEntity();
        unitdistributionEntity.setTaskId(entity.getId());
        unitdistributionEntity.setTaskCode(entity.getBillCode());
        unitdistributionEntity.setProductId(entity.getProductId());
        unitdistributionEntity.setProductName(entity.getProductName());
        unitdistributionEntity.setCustomerManageId(entity.getCustomerManageId());
        unitdistributionEntity.setCustomerManageName(entity.getCustomerManageName());
        unitdistributionEntity.setProjectId(entity.getProjectId());
        unitdistributionEntity.setProjectName(entity.getProjectName());
        unitdistributionEntity.setProductId(entity.getProductId());
        unitdistributionEntity.setProductName(entity.getProductName());
        unitdistributionEntity.setWorksiteId(entity.getWorksiteId());
        unitdistributionEntity.setWorksiteName(entity.getWorksiteName());
        unitdistributionEntity.setOrgId(entity.getOrgId());
        unitdistributionEntity.setOrgName(entity.getOrgName());
        unitdistributionEntity.setSatrtTime(entity.getTaskTime());
        unitdistributionEntity.setQuantity(entity.getThisQuantity());
        UnitdistributionVO unitdistributionVO = (UnitdistributionVO)((Object)BeanMapper.map((Object)((Object)unitdistributionEntity), UnitdistributionVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6210\u529f\uff01", (Object)((Object)unitdistributionVO));
    }

    @PostMapping(value={"distributeUnit"})
    @ResponseBody
    public CommonResponse distributeUnit(@RequestBody String params) throws ParseException {
        JSONObject object = JSONObject.parseObject((String)params);
        Long taskId = object.getLong("taskId");
        JSONArray unitArray = object.getJSONArray("unit");
        ProductiontaskEntity productiontaskEntity = (ProductiontaskEntity)((Object)this.productiontaskService.selectById(taskId));
        ArrayList<UnitdistributionEntity> unitdistributionList = new ArrayList<UnitdistributionEntity>();
        List maps = unitArray.toJavaList(Map.class);
        BigDecimal sum = new BigDecimal("0");
        for (Map map : maps) {
            UnitdistributionEntity unitdistributionEntity = new UnitdistributionEntity();
            if (map.get("startTime") == null && map.get("distributeCount") == null || new BigDecimal(map.get("distributeCount").toString()).compareTo(new BigDecimal("0")) != 1) continue;
            unitdistributionEntity.setTaskId(productiontaskEntity.getId());
            unitdistributionEntity.setTaskCode(productiontaskEntity.getBillCode());
            unitdistributionEntity.setCustomerManageId(productiontaskEntity.getCustomerManageId());
            unitdistributionEntity.setCustomerManageName(productiontaskEntity.getCustomerManageName());
            unitdistributionEntity.setProjectId(productiontaskEntity.getProjectId());
            unitdistributionEntity.setProjectName(productiontaskEntity.getProjectName());
            unitdistributionEntity.setProductId(productiontaskEntity.getProductId());
            unitdistributionEntity.setProductName(productiontaskEntity.getProductName());
            unitdistributionEntity.setWorksiteId(productiontaskEntity.getWorksiteId());
            unitdistributionEntity.setWorksiteName(productiontaskEntity.getWorksiteName());
            unitdistributionEntity.setQuantity(productiontaskEntity.getThisQuantity());
            unitdistributionEntity.setTenantId(productiontaskEntity.getTenantId());
            unitdistributionEntity.setOrgId(productiontaskEntity.getOrgId());
            unitdistributionEntity.setOrgName(productiontaskEntity.getOrgName());
            unitdistributionEntity.setProductState(1);
            unitdistributionEntity.setVersion(1);
            unitdistributionEntity.setUnitId(Long.parseLong(map.get("id").toString()));
            unitdistributionEntity.setUnitName(map.get("name").toString());
            unitdistributionEntity.setSatrtTime(new SimpleDateFormat("yyyy-mm-dd HH:mm:ss").parse(map.get("startTime").toString()));
            unitdistributionEntity.setDistributeCount(new BigDecimal((String)map.get("distributeCount")));
            unitdistributionEntity.setAddCount(new BigDecimal("0"));
            unitdistributionEntity.setAddedCount(new BigDecimal("0").add(new BigDecimal((String)map.get("distributeCount"))));
            unitdistributionEntity.setWeighNumber(new BigDecimal("0"));
            unitdistributionEntity.setNotWeighNumber(new BigDecimal("0"));
            unitdistributionEntity.setAddCount(new BigDecimal("0"));
            unitdistributionEntity.setAddedCount(new BigDecimal("0"));
            UnitdistributionVO unitdistributionVO = (UnitdistributionVO)((Object)BeanMapper.map((Object)((Object)unitdistributionEntity), UnitdistributionVO.class));
            BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)unitdistributionVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (!billCode.isSuccess()) {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
            unitdistributionEntity.setBillCode((String)billCode.getData());
            sum = sum.add(new BigDecimal((String)map.get("distributeCount")));
            unitdistributionList.add(unitdistributionEntity);
            productiontaskEntity.setUnitId(Long.valueOf(map.get("id").toString()));
            productiontaskEntity.setUnitName(map.get("name").toString());
        }
        boolean isSuccecss = this.service.saveOrUpdateBatch(unitdistributionList, unitdistributionList.size());
        if (isSuccecss && sum.compareTo(productiontaskEntity.getThisQuantity()) == 0) {
            productiontaskEntity.setTaskStatus(2);
        }
        this.productiontaskService.saveOrUpdate((Object)productiontaskEntity, false);
        return CommonResponse.success((String)"\u5206\u914d\u673a\u7ec4\u6210\u529f");
    }

    @GetMapping(value={"showdistribute"})
    @ResponseBody
    public CommonResponse<List<UnitdistributionVO>> showdistribute(@RequestParam(value="taskId") Long taskId) {
        QueryWrapper query = new QueryWrapper();
        query.eq((Object)"product_state", (Object)1);
        List list = this.service.list((Wrapper)query);
        List unitdistributionVOS = BeanMapper.mapList((Iterable)list, UnitdistributionVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u673a\u7ec4\u6210\u529f", (Object)unitdistributionVOS);
    }

    @GetMapping(value={"queryListById"})
    @ResponseBody
    public CommonResponse<List<UnitdistributionVO>> queryListById(@RequestParam(value="unitId") Long unitId, @RequestParam(value="orgId") Long orgId) {
        QueryWrapper query = new QueryWrapper();
        query.eq((Object)"unit_id", (Object)unitId);
        query.eq((Object)"org_id", (Object)orgId);
        query.eq((Object)"product_state", (Object)1);
        List list = this.service.list((Wrapper)query);
        List unitdistributionVOS = BeanMapper.mapList((Iterable)list, UnitdistributionVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u673a\u7ec4\u4efb\u52a1\u6210\u529f", (Object)unitdistributionVOS);
    }
}

