package com.ejianc.business.production.controller.api;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.base.bases.api.BaseApi;
import com.ejianc.business.base.bases.vo.ShippersInfoApiVO;
import com.ejianc.business.base.bases.vo.ShippersfareVO;
import com.ejianc.business.production.bean.ProductiontaskEntity;
import com.ejianc.business.production.bean.ProductiontasktransportEntity;
import com.ejianc.business.production.service.IProductiontaskService;
import com.ejianc.business.production.service.IProductiontasktransportService;
import com.ejianc.business.production.task.vo.DelivergoodsVO;
import com.ejianc.business.production.task.vo.ProductionTaskApiVo;
import com.ejianc.business.production.task.vo.ShipperfareVO;
import com.ejianc.business.production.vo.ProductiontasktransportVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.web.bind.annotation.*;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

@RestController
@RequestMapping("/api/production/productiontaskApi")
public class TaskSelectApi {
    @Autowired
    IProductiontaskService productiontaskService;
    @Qualifier("com.ejianc.business.base.bases.api.BaseApi")
    @Autowired
    BaseApi baseApi;
    @Autowired
    IProductiontasktransportService productiontasktransportService;
    /**
     * 请求获取生产任务单和运输商，运输商车辆信息
     * @param taskId
     * @return
     */
    @PostMapping(value = "/getproductiontask")
    @ResponseBody
    public CommonResponse<ProductionTaskApiVo> getProductiontask(@RequestParam(value = "taskId") String taskId,@RequestParam(value = "carCode") String carCode){
        List<ShipperfareVO> shipperfareVOS=new ArrayList<>();
        ProductiontaskEntity entity= productiontaskService.selectById(taskId);
        QueryWrapper query=new QueryWrapper();
        query.eq("shippers_vehicle_code",carCode);
        query.eq("org_id",entity.getOrgId());
        query.eq("transport_statue",1);
        ProductiontasktransportEntity transportEntity = productiontasktransportService.getOne(query);

        ProductionTaskApiVo apiVo = new ProductionTaskApiVo();
        if (transportEntity!=null){
            apiVo.setTransPortId(transportEntity.getId());
        }
        apiVo.setCustomerManageId(entity.getCustomerManageId());
        apiVo.setCustomerManageName(entity.getCustomerManageName());
        apiVo.setProjectId(entity.getProjectId());
        apiVo.setProjectName(entity.getProjectName());
        apiVo.setProductId(entity.getProductId());
        apiVo.setProductName(entity.getProductName());
        apiVo.setWorksiteId(entity.getWorksiteId());
        apiVo.setWorksiteName(entity.getWorksiteName());
        apiVo.setUnitId(entity.getUnitId());
        apiVo.setUnitName(entity.getUnitName());
        apiVo.setOrgId(entity.getOrgId());
        apiVo.setOrgName(entity.getOrgName());
        apiVo.setDistance(entity.getDistance());
        apiVo.setTransportMethod(entity.getTransportMethod());
        if (entity.getTransportMethod().equals("代运")) {
            Long orgId = entity.getOrgId();
            CommonResponse<ShippersInfoApiVO> shippersInfo = baseApi.getShippersInfo(carCode, orgId);
            if (shippersInfo.getCode() == 0) {
                ShippersInfoApiVO data = shippersInfo.getData();
                apiVo.setShipperVehicleId(data.getCarId());
                apiVo.setShipperVehicleName(data.getCarName());
                apiVo.setShipperId(data.getShipperMId());
                apiVo.setShipperMName(data.getShipperMName());
                apiVo.setTare(data.getTare());
                apiVo.setCategory(data.getCategory());
                List<ShippersfareVO> shippersfareVOS = data.getShippersfareVOS();
                for (ShippersfareVO shippersfareVO : shippersfareVOS) {
                    ShipperfareVO fareVO = new ShipperfareVO();
                    fareVO.setStartDistance(shippersfareVO.getStartDistance());
                    fareVO.setEndDistance(shippersfareVO.getEndDistance());
                    fareVO.setDistance(shippersfareVO.getDistance());
                    fareVO.setTransportFare(shippersfareVO.getTransportFare());
                    shipperfareVOS.add(fareVO);
                }
                apiVo.setShippersfareVOS(shipperfareVOS);
            } else {
                return CommonResponse.error(shippersInfo.getMsg());
            }
        }

        return CommonResponse.success("访问成功！！",apiVo);
    }
    @GetMapping(value = "/getdeliver")
    @ResponseBody
    public CommonResponse<List<DelivergoodsVO>> getDeliver(@RequestParam(value = "carCode") String carCode, @RequestParam(value = "orgId") String orgId){
        List<DelivergoodsVO> delivergoodsVOS=new ArrayList<>();
        QueryWrapper query=new QueryWrapper();
        query.eq("shippers_vehicle_code",carCode);
        query.eq("org_id",orgId);
        query.eq("transport_statue",1);
        List<ProductiontasktransportEntity> list = productiontasktransportService.list(query);
        if (list.size()>0){
            for (ProductiontasktransportEntity entity : list) {
                com.ejianc.business.production.task.vo.DelivergoodsVO delivergoodsVO = new com.ejianc.business.production.task.vo.DelivergoodsVO();
                ProductiontaskEntity taskEntity = productiontaskService.selectById(entity.getTaskId());
                delivergoodsVO.setDeliverDate(entity.getTransportTime());
                delivergoodsVO.setShippersVehicleCode(entity.getShippersVehicleCode());
                delivergoodsVO.setShippersVehicleId(entity.getShippersVehicleId());
                delivergoodsVO.setTare(entity.getTare());
                delivergoodsVO.setId(entity.getId());
                delivergoodsVO.setTransportCount(entity.getTransportCount());
                delivergoodsVO.setTransportStatue(entity.getTransportStatue());
                delivergoodsVO.setDistance(taskEntity.getDistance());
                delivergoodsVO.setCustomerId(taskEntity.getCustomerManageId());
                delivergoodsVO.setCustomerName(taskEntity.getCustomerManageName());
                delivergoodsVO.setProductId(taskEntity.getProductId());
                delivergoodsVO.setProductName(taskEntity.getProductName());
                delivergoodsVO.setProjectId(taskEntity.getProjectId());
                delivergoodsVO.setProjectName(taskEntity.getProjectName());
                delivergoodsVO.setTaskCode(taskEntity.getBillCode());
                delivergoodsVO.setTaskId(taskEntity.getId());
                delivergoodsVO.setWorksiteId(taskEntity.getWorksiteId());
                delivergoodsVO.setWorksiteName(taskEntity.getWorksiteName());
                delivergoodsVO.setWorksiteName(taskEntity.getWorksiteName());
                delivergoodsVOS.add(delivergoodsVO);
            }

        }else {
            return CommonResponse.error("未查询到生产任务单运输信息");
        }
        return CommonResponse.success("访问成功！！",delivergoodsVOS);
    }
    @GetMapping(value = "/updateTransportState")
    @ResponseBody
    public CommonResponse updateTransportState(@RequestParam(value = "transportId") Long transportId, @RequestParam(value = "status") Integer status){
        ProductiontasktransportEntity entity = productiontasktransportService.selectById(transportId);
        if (entity!=null){
            entity.setTransportStatue(status);
            productiontasktransportService.saveOrUpdate(entity,false);
        }else {
            return CommonResponse.error("未查找到此运输信息");
        }
        ProductiontasktransportVO map = BeanMapper.map(entity, ProductiontasktransportVO.class);
        return CommonResponse.success("修改状态成功",map);
    }
}
