package com.ejianc.business.production.vo;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.math.BigDecimal;
import java.util.Date;

public class ProductionTaskDetailVO extends BaseVO {
    private static final long serialVersionUID = 1L;

    private BigDecimal projectTotle; // 工程总数量
    private BigDecimal orderedQuantity; // 已下数量
    private BigDecimal orderedNot; // 待下数量
    private BigDecimal thisQuantity; // 本次数量
    private Integer countingMethod; // 计数方法
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date taskTime; // 任务单日期
    private BigDecimal distance; // 距离
    private String  transportMethod; // 运输方式
    private Long productId; // 产品id
    private String productName; // 产品名称
    private String carCode; // 车号
    private Long regionId; // 区域id
    private String regionName; // 区域名称
    private String asphaltSpec; // 沥青规格
    private String addCount; // 外加剂



    @ReferSerialTransfer(referCode="ProductorInfoRef")
    public Long getProductId() {
        return productId;
    }
    @ReferDeserialTransfer
    public void setProductId(Long productId) {
        this.productId = productId;
    }

    public String getProductName() {
        return productName;
    }

    public void setProductName(String productName) {
        this.productName = productName;
    }

    public Date getTaskTime() {
        return taskTime;
    }

    public void setTaskTime(Date taskTime) {
        this.taskTime = taskTime;
    }

    public BigDecimal getProjectTotle() {
        return projectTotle;
    }

    public void setProjectTotle(BigDecimal projectTotle) {
        this.projectTotle = projectTotle;
    }

    public BigDecimal getOrderedQuantity() {
        return orderedQuantity;
    }

    public void setOrderedQuantity(BigDecimal orderedQuantity) {
        this.orderedQuantity = orderedQuantity;
    }

    public BigDecimal getOrderedNot() {
        return orderedNot;
    }

    public void setOrderedNot(BigDecimal orderedNot) {
        this.orderedNot = orderedNot;
    }

    public BigDecimal getThisQuantity() {
        return thisQuantity;
    }

    public void setThisQuantity(BigDecimal thisQuantity) {
        this.thisQuantity = thisQuantity;
    }

    public Integer getCountingMethod() {
        return countingMethod;
    }

    public void setCountingMethod(Integer countingMethod) {
        this.countingMethod = countingMethod;
    }

    public BigDecimal getDistance() {
        return distance;
    }

    public void setDistance(BigDecimal distance) {
        this.distance = distance;
    }

    public String getTransportMethod() {
        return transportMethod;
    }

    public void setTransportMethod(String transportMethod) {
        this.transportMethod = transportMethod;
    }

    public String getCarCode() {
        return carCode;
    }

    public void setCarCode(String carCode) {
        this.carCode = carCode;
    }
    @ReferSerialTransfer(referCode="RegionRef")
    public Long getRegionId() {
        return regionId;
    }
    @ReferDeserialTransfer
    public void setRegionId(Long regionId) {
        this.regionId = regionId;
    }

    public String getRegionName() {
        return regionName;
    }

    public void setRegionName(String regionName) {
        this.regionName = regionName;
    }

    public String getAsphaltSpec() {
        return asphaltSpec;
    }

    public void setAsphaltSpec(String asphaltSpec) {
        this.asphaltSpec = asphaltSpec;
    }

    public String getAddCount() {
        return addCount;
    }

    public void setAddCount(String addCount) {
        this.addCount = addCount;
    }
}
