/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.production.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.production.bean.ProductiontaskEntity;
import com.ejianc.business.production.bean.UnitdistributionEntity;
import com.ejianc.business.production.service.IProductiontaskService;
import com.ejianc.business.production.service.IProductiontasktransportService;
import com.ejianc.business.production.service.IUnitdistributionService;
import com.ejianc.business.production.vo.ProductInfoVO;
import com.ejianc.business.production.vo.ProductionTaskDetailVO;
import com.ejianc.business.production.vo.ProductiontaskVO;
import com.ejianc.business.production.vo.ProductiontasktransportVO;
import com.ejianc.business.production.vo.UnitdistributionVO;
import com.ejianc.business.sale.salesorder.api.ISalesorderApi;
import com.ejianc.business.sale.salesorder.vo.CloseVO;
import com.ejianc.business.sale.service.ISalesorderService;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Controller;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@CrossOrigin
@Controller
@RequestMapping(value={"productiontask"})
public class ProductiontaskController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    private static final String BILL_CODE = "production-task";
    @Autowired
    private IProductiontaskService service;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IProductiontasktransportService productiontasktransportService;
    @Autowired
    @Qualifier(value="com.ejianc.business.sale.salesorder.api.ISalesorderApi")
    private ISalesorderApi salesorderApi;
    @Autowired
    IUnitdistributionService unitdistributionService;
    @Autowired
    ISalesorderService salesorderService;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<ProductiontaskVO> saveOrUpdate(@RequestBody ProductiontaskVO saveOrUpdateVO) {
        ProductiontaskEntity entity = (ProductiontaskEntity)((Object)BeanMapper.map((Object)((Object)saveOrUpdateVO), ProductiontaskEntity.class));
        if (entity.getId() == null || entity.getId() == 0L) {
            BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                entity.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        if (entity.getTaskStatus() == null) {
            entity.setTaskStatus(1);
        }
        this.service.saveOrUpdate((Object)entity, false);
        ProductiontaskVO vo = (ProductiontaskVO)((Object)BeanMapper.map((Object)((Object)entity), ProductiontaskVO.class));
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)((Object)vo));
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<ProductiontaskVO> queryDetail(Long id) {
        ProductiontaskEntity entity = (ProductiontaskEntity)((Object)this.service.selectById(id));
        ProductiontaskVO vo = (ProductiontaskVO)((Object)BeanMapper.map((Object)((Object)entity), ProductiontaskVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)((Object)vo));
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<ProductiontaskVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (ProductiontaskVO vo : vos) {
                QueryWrapper query = new QueryWrapper();
                query.eq((Object)"task_id", (Object)vo.getId());
                List list = this.unitdistributionService.list((Wrapper)query);
                List VOS = BeanMapper.mapList((Iterable)list, UnitdistributionVO.class);
                this.unitdistributionService.removeByIds(VOS.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
                List list1 = this.productiontasktransportService.list((Wrapper)query);
                List productiontasktransportVOS = BeanMapper.mapList((Iterable)list1, ProductiontasktransportVO.class);
                this.productiontasktransportService.removeByIds(productiontasktransportVOS.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
            }
        }
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<ProductiontaskVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("customerManageName");
        fuzzyFields.add("projectName");
        fuzzyFields.add("productName");
        fuzzyFields.add("worksiteName");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        UserContext userContextCache = this.sessionManager.getUserContext();
        String authOrgIds = userContextCache.getAuthOrgIds();
        List orgVOList = null;
        orgVOList = StringUtils.isNotBlank((CharSequence)authOrgIds) ? (List)this.getRespData(this.iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002") : (List)this.getRespData(this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002");
        ArrayList commonOrgIds = new ArrayList();
        ArrayList departmentIds = new ArrayList();
        orgVOList.stream().forEach(org -> {
            if (5 == org.getOrgType()) {
                departmentIds.add(org.getId());
            } else {
                commonOrgIds.add(org.getId());
            }
        });
        if (CollectionUtils.isNotEmpty(commonOrgIds)) {
            param.getParams().put("orgId", new Parameter("in", commonOrgIds));
        } else if (CollectionUtils.isNotEmpty(departmentIds)) {
            param.getParams().put("projectDepartmentId", new Parameter("in", departmentIds));
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), ProductiontaskVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        List list = this.service.queryList(param);
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", list);
        ExcelExport.getInstance().export("Productiontask-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/refProductiontaskData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<ProductiontaskVO>> refProductiontaskData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        JSONObject _con;
        String orgId;
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition) && (orgId = (_con = JSONObject.parseObject((String)condition)).getString("orgId")) != null) {
            param.getParams().put("org_id", new Parameter("eq", (Object)orgId));
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), ProductiontaskVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @GetMapping(value={"queryDetailBytaskId"})
    @ResponseBody
    public CommonResponse<List<ProductiontasktransportVO>> queryDetailBytaskId(@RequestParam(value="taskId") Long taskId) {
        QueryWrapper query = new QueryWrapper();
        query.eq((Object)"task_id", (Object)taskId);
        List list = this.productiontasktransportService.list((Wrapper)query);
        List map = BeanMapper.mapList((Iterable)list, ProductiontasktransportVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6210\u529f\uff01", (Object)map);
    }

    @GetMapping(value={"querySumCountByProductId"})
    @ResponseBody
    public CommonResponse<BigDecimal> querySumCountByProductId(@RequestParam(value="productId") Long productId) {
        BigDecimal sumCount = new BigDecimal("0");
        QueryWrapper query = new QueryWrapper();
        query.eq((Object)"product_id", (Object)productId);
        List list = this.service.list((Wrapper)query);
        if (list.size() > 0) {
            for (int i = 0; i < list.size(); ++i) {
                ProductiontaskEntity productiontaskEntity = (ProductiontaskEntity)((Object)list.get(i));
                if (productiontaskEntity.getThisQuantity() == null) continue;
                sumCount = sumCount.add(productiontaskEntity.getThisQuantity());
            }
        }
        return CommonResponse.success((Object)sumCount);
    }

    @RequestMapping(value={"/saveList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<List<ProductiontaskVO>> saveList(@RequestBody ProductiontaskVO saveOrUpdateVO) {
        ArrayList<ProductiontaskEntity> productiontaskEntities = new ArrayList<ProductiontaskEntity>();
        List<ProductionTaskDetailVO> productionTaskDetailVOS = saveOrUpdateVO.getProductionTaskDetailVOS();
        for (ProductionTaskDetailVO detailVO : productionTaskDetailVOS) {
            if (detailVO.getRowState().equals("del") || detailVO.getThisQuantity().compareTo(new BigDecimal("0")) != 1) continue;
            ProductiontaskEntity entity = new ProductiontaskEntity();
            entity.setCustomerManageId(saveOrUpdateVO.getCustomerManageId());
            entity.setCustomerManageName(saveOrUpdateVO.getCustomerManageName());
            entity.setProjectId(saveOrUpdateVO.getProjectId());
            entity.setProjectName(saveOrUpdateVO.getProjectName());
            entity.setWorksiteId(saveOrUpdateVO.getWorksiteId());
            entity.setWorksiteName(saveOrUpdateVO.getWorksiteName());
            entity.setOrderName(saveOrUpdateVO.getOrderName());
            entity.setOrderMobile(saveOrUpdateVO.getOrderMobile());
            entity.setTransportRoute(saveOrUpdateVO.getTransportRoute());
            entity.setOrgId(saveOrUpdateVO.getOrgId());
            entity.setOrgName(saveOrUpdateVO.getOrgName());
            entity.setProductId(detailVO.getProductId());
            entity.setProductName(detailVO.getProductName());
            entity.setAsphaltSpec(detailVO.getAsphaltSpec());
            entity.setAddCount(detailVO.getAddCount());
            entity.setProjectTotle(detailVO.getProjectTotle());
            entity.setOrderedQuantity(detailVO.getOrderedQuantity());
            entity.setOrderedNot(detailVO.getOrderedNot());
            entity.setThisQuantity(detailVO.getThisQuantity());
            entity.setCountingMethod(detailVO.getCountingMethod());
            entity.setTransportMethod(detailVO.getTransportMethod());
            entity.setDistance(detailVO.getDistance());
            entity.setTaskTime(detailVO.getTaskTime());
            entity.setTaskStatus(1);
            BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (!billCode.isSuccess()) {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
            entity.setBillCode((String)billCode.getData());
            productiontaskEntities.add(entity);
        }
        this.service.saveOrUpdateBatch(productiontaskEntities, productiontaskEntities.size());
        List productiontaskVOS = BeanMapper.mapList(productiontaskEntities, ProductiontaskVO.class);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6210\u529f\uff01", (Object)productiontaskVOS);
    }

    @GetMapping(value={"queryProductDataSourceByProductId"})
    @ResponseBody
    public CommonResponse<List<ProductInfoVO>> queryProductDataSourceByProductId(@RequestParam(value="projectId") String projectId) {
        ArrayList<ProductInfoVO> productInfoVOList = new ArrayList<ProductInfoVO>();
        List data = (List)this.salesorderApi.getProductInfo(projectId).getData();
        for (com.ejianc.business.sale.salesorder.vo.ProductInfoVO productInfo : data) {
            BigDecimal sumCount = new BigDecimal("0");
            ProductInfoVO productInfoVO = new ProductInfoVO();
            QueryWrapper query = new QueryWrapper();
            query.eq((Object)"product_id", (Object)productInfo.getProductId());
            List list = this.service.list((Wrapper)query);
            for (ProductiontaskEntity entity : list) {
                if (entity.getThisQuantity() == null) continue;
                sumCount = sumCount.add(entity.getThisQuantity());
            }
            productInfoVO.setProductId(productInfo.getProductId());
            productInfoVO.setProductName(productInfo.getProductName());
            productInfoVO.setAsphaltSpec(productInfo.getAsphaltSpec());
            productInfoVO.setAddCount(productInfo.getAddCount());
            productInfoVO.setProjectTotle(productInfo.getProjectTotle());
            productInfoVO.setOrderedQuantity(sumCount);
            productInfoVO.setOrderedNot(productInfo.getProjectTotle().subtract(sumCount));
            productInfoVO.setTransportMethod(productInfo.getTransportMethod());
            productInfoVOList.add(productInfoVO);
        }
        return CommonResponse.success((String)"\u83b7\u53d6\u4ea7\u54c1\u4fe1\u606f\u6210\u529f", productInfoVOList);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Transactional
    @PostMapping(value={"closeproductiontask"})
    @ResponseBody
    public CommonResponse<IPage<ProductiontaskVO>> closeProductionTask(@RequestBody ProductiontaskVO productiontaskVO) {
        CloseVO closeVO = new CloseVO();
        closeVO.setTaskId(productiontaskVO.getId());
        closeVO.setProductId(productiontaskVO.getProductId());
        closeVO.setProductName(productiontaskVO.getProductName());
        closeVO.setProjectId(productiontaskVO.getProjectId());
        closeVO.setProjectName(productiontaskVO.getProjectName());
        closeVO.setWorksiteId(productiontaskVO.getWorksiteId());
        closeVO.setWorksiteName(productiontaskVO.getWorksiteName());
        closeVO.setCustomerManageId(productiontaskVO.getCustomerManageId());
        closeVO.setCustomerManageName(productiontaskVO.getCustomerManageName());
        closeVO.setThisQuantity(productiontaskVO.getThisQuantity());
        CommonResponse commonResponse = this.salesorderApi.saveSaleorder(closeVO);
        if (commonResponse.getCode() != 0) throw new BusinessException(commonResponse.getMsg());
        ProductiontaskEntity entity = (ProductiontaskEntity)((Object)this.service.selectById(productiontaskVO.getId()));
        entity.setTaskStatus(3);
        this.service.saveOrUpdate((Object)entity, false);
        QueryWrapper query = new QueryWrapper();
        query.eq((Object)"task_id", (Object)entity.getId());
        List list = this.unitdistributionService.list((Wrapper)query);
        if (list.size() <= 0) throw new BusinessException("\u672a\u67e5\u5230\u76f8\u5173\u7684\u5206\u914d\u673a\u7ec4\u4fe1\u606f");
        for (UnitdistributionEntity unitdistributionEntity : list) {
            unitdistributionEntity.setProductState(2);
        }
        this.unitdistributionService.saveOrUpdateBatch(list, list.size());
        LinkedHashMap<String, String> hashMap = new LinkedHashMap<String, String>();
        hashMap.put("createTime", "desc");
        QueryParam queryParam = new QueryParam();
        queryParam.setPageIndex(productiontaskVO.getPageIndex().intValue());
        queryParam.setPageSize(productiontaskVO.getPageSize().intValue());
        queryParam.setOrderMap(hashMap);
        CommonResponse<IPage<ProductiontaskVO>> iPageCommonResponse = this.queryList(queryParam);
        IPage data = (IPage)iPageCommonResponse.getData();
        return CommonResponse.success((String)"\u5173\u95ed\u4efb\u52a1\u5355\u6210\u529f", (Object)data);
    }

    @RequestMapping(value={"/queryProductionTask"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<ProductiontaskVO>> queryProductionTask(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        UserContext userContextCache = this.sessionManager.getUserContext();
        String authOrgIds = userContextCache.getAuthOrgIds();
        List orgVOList = null;
        orgVOList = StringUtils.isNotBlank((CharSequence)authOrgIds) ? (List)this.getRespData(this.iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002") : (List)this.getRespData(this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002");
        ArrayList commonOrgIds = new ArrayList();
        ArrayList departmentIds = new ArrayList();
        orgVOList.stream().forEach(org -> {
            if (5 == org.getOrgType()) {
                departmentIds.add(org.getId());
            } else {
                commonOrgIds.add(org.getId());
            }
        });
        if (CollectionUtils.isNotEmpty(commonOrgIds)) {
            param.getParams().put("orgId", new Parameter("in", commonOrgIds));
        } else if (CollectionUtils.isNotEmpty(departmentIds)) {
            param.getParams().put("projectDepartmentId", new Parameter("in", departmentIds));
        }
        param.getParams().put("task_status", new Parameter("eq", (Object)1));
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), ProductiontaskVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @GetMapping(value={"queryUnitdistribute"})
    @ResponseBody
    public CommonResponse<List<UnitdistributionVO>> queryUnitdistribute(@RequestParam(value="taskId") Long taskId) {
        QueryWrapper query = new QueryWrapper();
        query.eq((Object)"task_id", (Object)taskId);
        List list = this.unitdistributionService.list((Wrapper)query);
        List map = BeanMapper.mapList((Iterable)list, UnitdistributionVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6210\u529f\uff01", (Object)map);
    }

    @Transactional
    @PostMapping(value={"cancleclose"})
    @ResponseBody
    public CommonResponse<IPage<ProductiontaskVO>> cancleclose(@RequestBody ProductiontaskVO productiontaskVO) {
        ProductiontaskEntity entity = (ProductiontaskEntity)((Object)this.service.selectById(productiontaskVO.getId()));
        CommonResponse commonResponse = this.salesorderApi.delectSaleorder(entity.getId().toString());
        if (commonResponse.getCode() == 1) {
            return CommonResponse.error((String)commonResponse.getMsg());
        }
        if (commonResponse.getCode() == 0) {
            entity.setTaskStatus(2);
            this.service.saveOrUpdate((Object)entity, false);
        }
        LinkedHashMap<String, String> hashMap = new LinkedHashMap<String, String>();
        hashMap.put("createTime", "desc");
        QueryParam queryParam = new QueryParam();
        queryParam.setPageIndex(productiontaskVO.getPageIndex().intValue());
        queryParam.setPageSize(productiontaskVO.getPageSize().intValue());
        queryParam.setOrderMap(hashMap);
        CommonResponse<IPage<ProductiontaskVO>> iPageCommonResponse = this.queryList(queryParam);
        IPage data = (IPage)iPageCommonResponse.getData();
        return CommonResponse.success((String)"\u53d6\u6d88\u5173\u95ed\u4efb\u52a1\u5355\u6210\u529f", (Object)data);
    }
}

