/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.production.controller;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.production.bean.ProductiontaskEntity;
import com.ejianc.business.production.bean.ProductiontasktransportEntity;
import com.ejianc.business.production.service.IProductiontaskService;
import com.ejianc.business.production.service.IProductiontasktransportService;
import com.ejianc.business.production.vo.ProductiontasktransportVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.refer.util.ReferObjectUtil;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"productiontasktransport"})
public class ProductiontasktransportController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    private static final String BILL_CODE = "task-transport";
    @Autowired
    private IProductiontasktransportService service;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IProductiontaskService productiontaskService;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<ProductiontasktransportVO> saveOrUpdate(@RequestBody ProductiontasktransportVO saveOrUpdateVO) {
        ProductiontasktransportEntity entity = (ProductiontasktransportEntity)((Object)BeanMapper.map((Object)((Object)saveOrUpdateVO), ProductiontasktransportEntity.class));
        if (entity.getId() == null || entity.getId() == 0L) {
            BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                entity.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        ProductiontaskEntity productiontaskEntity = (ProductiontaskEntity)((Object)this.productiontaskService.selectById(entity.getTaskId()));
        BigDecimal sumCount = new BigDecimal("0");
        QueryWrapper query2 = new QueryWrapper();
        query2.eq((Object)"task_id", (Object)entity.getTaskId());
        List taskList = this.service.list((Wrapper)query2);
        if (taskList.size() > 0) {
            for (ProductiontasktransportEntity Entity : taskList) {
                if (String.valueOf(Entity.getId()).equals(String.valueOf(entity.getId()))) continue;
                sumCount = sumCount.add(Entity.getTransportCount());
            }
        }
        BigDecimal subtract = productiontaskEntity.getThisQuantity().subtract(sumCount);
        if (entity.getTransportCount().compareTo(subtract) == 1) {
            throw new BusinessException("\u8fd0\u9001\u6570\u91cf\u4e0d\u80fd\u5927\u4e8e" + subtract.setScale(2).toString() + "\u5428");
        }
        if (entity.getTransportCount().compareTo(subtract) == 0) {
            productiontaskEntity.setTaskStatus(3);
            this.productiontaskService.saveOrUpdate((Object)productiontaskEntity, false);
        }
        this.service.saveOrUpdate((Object)entity, false);
        ProductiontasktransportVO vo = (ProductiontasktransportVO)((Object)BeanMapper.map((Object)((Object)entity), ProductiontasktransportVO.class));
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)((Object)vo));
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<ProductiontasktransportVO> queryDetail(Long id) {
        ProductiontasktransportEntity entity = (ProductiontasktransportEntity)((Object)this.service.selectById(id));
        ProductiontasktransportVO vo = (ProductiontasktransportVO)((Object)BeanMapper.map((Object)((Object)entity), ProductiontasktransportVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)((Object)vo));
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<ProductiontasktransportVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (ProductiontasktransportVO vo : vos) {
                ProductiontaskEntity entity = (ProductiontaskEntity)((Object)this.productiontaskService.selectById(vo.getTaskId()));
                entity.setTaskStatus(2);
                this.productiontaskService.saveOrUpdate((Object)entity, false);
            }
        }
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<ProductiontasktransportVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        UserContext userContextCache = this.sessionManager.getUserContext();
        String authOrgIds = userContextCache.getAuthOrgIds();
        List orgVOList = null;
        orgVOList = StringUtils.isNotBlank((CharSequence)authOrgIds) ? (List)this.getRespData(this.iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002") : (List)this.getRespData(this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002");
        ArrayList commonOrgIds = new ArrayList();
        ArrayList departmentIds = new ArrayList();
        orgVOList.stream().forEach(org -> {
            if (5 == org.getOrgType()) {
                departmentIds.add(org.getId());
            } else {
                commonOrgIds.add(org.getId());
            }
        });
        if (CollectionUtils.isNotEmpty(commonOrgIds)) {
            param.getParams().put("orgId", new Parameter("in", commonOrgIds));
        } else if (CollectionUtils.isNotEmpty(departmentIds)) {
            param.getParams().put("projectDepartmentId", new Parameter("in", departmentIds));
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), ProductiontasktransportVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        List list = this.service.queryList(param);
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", list);
        ExcelExport.getInstance().export("Productiontasktransport-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/refProductiontasktransportData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<ProductiontasktransportVO>> refProductiontasktransportData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        JSONObject _con;
        String status;
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition) && (status = (_con = JSONObject.parseObject((String)condition)).getString("status")) != null) {
            param.getParams().put("transport_statue", new Parameter("eq", (Object)status));
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        List records = BeanMapper.mapList((Iterable)page.getRecords(), ProductiontasktransportVO.class);
        if (ListUtil.isNotEmpty((List)records)) {
            records.forEach(e -> {
                try {
                    JSONArray equcode = ReferObjectUtil.getReferEntityValue((String)e.getTaskId().toString(), (String)"ProductiontaskRef");
                    if (!equcode.isEmpty()) {
                        e.setTaskCode(((JSONObject)equcode.get(0)).getString("billCode"));
                        e.setCustomerManageId(StringUtils.isNotBlank((CharSequence)((JSONObject)equcode.get(0)).getString("customerId")) ? Long.valueOf(((JSONObject)equcode.get(0)).getString("customerId")) : null);
                        e.setProjectId(StringUtils.isNotBlank((CharSequence)((JSONObject)equcode.get(0)).getString("projectId")) ? Long.valueOf(((JSONObject)equcode.get(0)).getString("projectId")) : null);
                        e.setProductId(StringUtils.isNotBlank((CharSequence)((JSONObject)equcode.get(0)).getString("productId")) ? Long.valueOf(((JSONObject)equcode.get(0)).getString("productId")) : null);
                        e.setWorksiteId(StringUtils.isNotBlank((CharSequence)((JSONObject)equcode.get(0)).getString("worksiteId")) ? Long.valueOf(((JSONObject)equcode.get(0)).getString("worksiteId")) : null);
                        e.setUnitId(StringUtils.isNotBlank((CharSequence)((JSONObject)equcode.get(0)).getString("unitId")) ? Long.valueOf(((JSONObject)equcode.get(0)).getString("unitId")) : null);
                        e.setDistance(StringUtils.isNotBlank((CharSequence)((JSONObject)equcode.get(0)).getString("distance")) ? new BigDecimal(((JSONObject)equcode.get(0)).getString("distance")) : null);
                        e.setCustomerManageName(((JSONObject)equcode.get(0)).getString("customerName"));
                        e.setProjectName(((JSONObject)equcode.get(0)).getString("projectName"));
                        e.setProductName(((JSONObject)equcode.get(0)).getString("productName"));
                        e.setWorksiteName(((JSONObject)equcode.get(0)).getString("worksiteName"));
                        e.setPrintCustomerName(((JSONObject)equcode.get(0)).getString("printCustomerName"));
                        e.setPrintProductName(((JSONObject)equcode.get(0)).getString("printProductName"));
                        e.setPrintWorksiteName(((JSONObject)equcode.get(0)).getString("printWorksiteName"));
                        e.setPrintSupplyName(((JSONObject)equcode.get(0)).getString("printSupplyName"));
                        e.setUnitName(((JSONObject)equcode.get(0)).getString("unitName"));
                        e.setTransportMethod(((JSONObject)equcode.get(0)).getString("transportMethod"));
                        e.setOrderName(((JSONObject)equcode.get(0)).getString("orderName"));
                        e.setOrderMobile(((JSONObject)equcode.get(0)).getString("orderMobile"));
                        e.setTransportRoute(((JSONObject)equcode.get(0)).getString("transportRoute"));
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            });
        }
        pageData.setRecords(records);
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }
}

