package com.ejianc.business.production.controller;

import java.io.Serializable;

import com.alibaba.fastjson.JSONArray;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.base.bases.api.BaseApi;
import com.ejianc.business.base.bases.vo.UnitVO;
import com.ejianc.business.production.bean.UnitdistributionEntity;
import com.ejianc.business.production.vo.UnitdistributionVO;
import com.ejianc.business.production.service.IUnitdistributionService;
import com.ejianc.business.production.bean.ProductiontaskEntity;
import com.ejianc.business.production.service.IProductiontaskService;

import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.*;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.*;
import org.apache.commons.collections.CollectionUtils;
import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

/**
 * 分配机组
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("unitdistribution")
public class UnitdistributionController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private BaseApi baseApi;
    @Autowired
    private IProductiontaskService productiontaskService;

    private static final String BILL_CODE = "unit-distribution";//此处需要根据实际修改

    @Autowired
    private IUnitdistributionService service;

    @Autowired
    private SessionManager sessionManager;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @Transactional
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<UnitdistributionVO> saveOrUpdate(@RequestBody UnitdistributionVO saveOrUpdateVO) {
    	UnitdistributionEntity entity = BeanMapper.map(saveOrUpdateVO, UnitdistributionEntity.class);
        ProductiontaskEntity productiontaskEntity = productiontaskService.selectById(entity.getTaskId());
        if(entity.getId() == null || entity.getId() == 0){
            entity.setProductState(1);
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE,InvocationInfoProxy.getTenantid(),saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if(billCode.isSuccess()) {
//                entity.setCode(billCode.getData());//此处需要根据实际修改 删除本行或者下一行
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
            //分配机组新增时回写生产任务单分配机组和分配数量
            productiontaskEntity.setTaskStatus(2);
            productiontaskEntity.setUnitId(entity.getUnitId());
            productiontaskEntity.setUnitName(entity.getUnitName());
            productiontaskEntity.setDistributeCount(entity.getDistributeCount());
        }else{
            // 生产任务单回写追加数量
            if ( entity.getAddCount()!=null&&!(new BigDecimal(entity.getAddCount().toString()).compareTo(new BigDecimal("0"))==0) ){
                entity.setDistributeCount(entity.getDistributeCount().add(entity.getAddCount()));
                StringBuffer stringBuffer=null;
                if (productiontaskEntity.getAddedCount()!=null){
                    stringBuffer = new StringBuffer(productiontaskEntity.getAddedCount());
                    stringBuffer.append(";").append(entity.getAddCount().setScale(2,BigDecimal.ROUND_HALF_DOWN));
                }else {
                    stringBuffer = new StringBuffer();
                    stringBuffer.append(entity.getAddCount().setScale(2,BigDecimal.ROUND_HALF_DOWN));
                }
                productiontaskEntity.setAddedCount(stringBuffer.toString());
                productiontaskEntity.setAfteraddCount(entity.getDistributeCount());
            }
        }
        productiontaskService.saveOrUpdate(productiontaskEntity,false);
        //新增分配机组逻辑校验 ：根据任务单id查找所有分配机组
        /**
         * 累加所有分配机组追加后的数量加上新增的分配数量 数量大于任务单此次数量提示错误
         */
        BigDecimal sum = new BigDecimal("0");
        QueryWrapper query=new QueryWrapper();
        query.eq("task_id",entity.getTaskId());
        List<UnitdistributionEntity> list = service.list(query);
        for (UnitdistributionEntity Entity : list) {
            if (!String.valueOf(Entity.getId()).equals(String.valueOf(entity.getId()))){
//                    System.out.println(saveId == editId);
                sum=sum.add(Entity.getDistributeCount());
            }
        }
        if (sum.compareTo(entity.getQuantity())==1){
            throw new BusinessException("分配数量不能大于"+entity.getQuantity().subtract(sum).setScale(2).toString());
        }else if (sum.compareTo(entity.getQuantity())==0&&sum.compareTo(new BigDecimal("0"))==1){
            throw new BusinessException("此任务单分配数量已达上限");
        }
        entity.setAddCount(new BigDecimal("0"));
        service.saveOrUpdate(entity, false);
    	UnitdistributionVO vo = BeanMapper.map(entity, UnitdistributionVO.class);

    	return CommonResponse.success("保存或修改单据成功！",vo);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<UnitdistributionVO> queryDetail(Long id) {
    	UnitdistributionEntity entity = service.selectById(id);
    	UnitdistributionVO vo = BeanMapper.map(entity, UnitdistributionVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<UnitdistributionVO> vos) {
        if(ListUtil.isNotEmpty(vos)){
            for (UnitdistributionVO vo : vos) {
                // 参数是单据类型编码字符串 根据需求是否打开下面代码
                /* CommonResponse<String> resp = billTypeApi.checkQuote("billTypeCode", vo.getId());
                if(!resp.isSuccess()){
                    return CommonResponse.error("删除失败！"+resp.getMsg());
                }*/
            }
        }
        service.removeByIds(vos.stream().map(UnitdistributionVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<UnitdistributionVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("customerManageName");
        fuzzyFields.add("projectName");
        fuzzyFields.add("productName");
        fuzzyFields.add("worksiteName");
        fuzzyFields.add("unitName");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离 本下 没有组织orgId的删除下面代码-------------开始 */
        UserContext userContextCache =sessionManager.getUserContext();
        //当前应用有权限的根orgId，以逗号分割，可据此查询其本下数据，需判空
        String authOrgIds = userContextCache.getAuthOrgIds();
        List<OrgVO> orgVOList = null;
        if(StringUtils.isNotBlank(authOrgIds)){//移动端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "查询失败，获取当前本下组织信息失败。");
        }else {//pc端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
        }
        //普通组织 id
        List<Long> commonOrgIds = new ArrayList<>();
        //项目部 id
        List<Long> departmentIds = new ArrayList<>();
        orgVOList.stream().forEach(org -> {
            if(5 == org.getOrgType()) {
                //项目部
                departmentIds.add(org.getId());
            } else {
                //普通组织
                commonOrgIds.add(org.getId());
            }
        });
        if(CollectionUtils.isNotEmpty(commonOrgIds)) {
            /** 要求主表有orgId字段，保存单据所属组织 */
            param.getParams().put("orgId", new Parameter(QueryParam.IN, commonOrgIds));
        } else if(CollectionUtils.isNotEmpty(departmentIds)) {
            /** 要求主表有projectDepartmentId字段，保存单据所属项目部 */
            param.getParams().put("projectDepartmentId", new Parameter(QueryParam.IN, departmentIds));
        }
        /** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */

        IPage<UnitdistributionEntity> page = service.queryPage(param,false);
        IPage<UnitdistributionVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), UnitdistributionVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<UnitdistributionEntity> list = service.queryList(param);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("Unitdistribution-export.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/refUnitdistributionData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<UnitdistributionVO>> refUnitdistributionData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<UnitdistributionEntity> page = service.queryPage(param,false);
        IPage<UnitdistributionVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), UnitdistributionVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }
    /**
     * 页面跳转查询生产任务单
     *
     * @param taskId
     * @return
     */
    @GetMapping(value = "queryDetailBytaskId")
    @ResponseBody
    public CommonResponse<UnitdistributionVO> queryDetailBytaskId(@RequestParam(value = "taskId") Long taskId) {
        ProductiontaskEntity entity = productiontaskService.selectById(taskId);
        UnitdistributionEntity unitdistributionEntity=new UnitdistributionEntity();
        unitdistributionEntity.setTaskId(entity.getId());
        unitdistributionEntity.setTaskCode(entity.getBillCode());
        unitdistributionEntity.setProductId(entity.getProductId());
        unitdistributionEntity.setProductName(entity.getProductName());
        unitdistributionEntity.setCustomerManageId(entity.getCustomerManageId());
        unitdistributionEntity.setCustomerManageName(entity.getCustomerManageName());
        unitdistributionEntity.setProjectId(entity.getProjectId());
        unitdistributionEntity.setProjectName(entity.getProjectName());
        unitdistributionEntity.setProductId(entity.getProductId());
        unitdistributionEntity.setProductName(entity.getProductName());
        unitdistributionEntity.setWorksiteId(entity.getWorksiteId());
        unitdistributionEntity.setWorksiteName(entity.getWorksiteName());
        unitdistributionEntity.setOrgId(entity.getOrgId());
        unitdistributionEntity.setOrgName(entity.getOrgName());
        unitdistributionEntity.setSatrtTime(entity.getTaskTime());
        unitdistributionEntity.setQuantity(entity.getThisQuantity());
        UnitdistributionVO unitdistributionVO=BeanMapper.map(unitdistributionEntity,UnitdistributionVO.class);
        return CommonResponse.success("查询详情成功！", unitdistributionVO);
    }

    /**
     * 分配机组保存
     * @param params
     * @return CommonResponse<List<UnitdistributionVO>>
     * @throws ParseException
     */
    @Transactional
    @PostMapping(value = "distributeUnit")
    @ResponseBody
    public CommonResponse distributeUnit(@RequestBody String params) throws ParseException {
        JSONObject object = JSONObject.parseObject(params);
        Long taskId = object.getLong("taskId");
        JSONArray unitArray = object.getJSONArray("unit");
        ProductiontaskEntity productiontaskEntity = productiontaskService.selectById(taskId);
        List<UnitdistributionVO> unitdistributionList=new ArrayList<>();
        List<Map> maps = unitArray.toJavaList(Map.class);
        BigDecimal sum = new BigDecimal("0");
        for (Map map : maps) {
            UnitdistributionVO unitdistributionVO = new UnitdistributionVO();
            if (new BigDecimal(map.get("distributeCount").toString()).compareTo(new BigDecimal("0"))==1){
                unitdistributionVO.setTaskId(productiontaskEntity.getId());
                unitdistributionVO.setTaskCode(productiontaskEntity.getBillCode());
                unitdistributionVO.setCustomerManageId(productiontaskEntity.getCustomerManageId());
                unitdistributionVO.setCustomerManageName(productiontaskEntity.getCustomerManageName());
                unitdistributionVO.setProjectId(productiontaskEntity.getProjectId());
                unitdistributionVO.setProjectName(productiontaskEntity.getProjectName());
                unitdistributionVO.setProductId(productiontaskEntity.getProductId());
                unitdistributionVO.setProductName(productiontaskEntity.getProductName());
                unitdistributionVO.setWorksiteId(productiontaskEntity.getWorksiteId());
                unitdistributionVO.setWorksiteName(productiontaskEntity.getWorksiteName());
                unitdistributionVO.setQuantity(productiontaskEntity.getThisQuantity());
                unitdistributionVO.setTenantId(productiontaskEntity.getTenantId());
                unitdistributionVO.setOrgId(productiontaskEntity.getOrgId());
                unitdistributionVO.setOrgName(productiontaskEntity.getOrgName());
                unitdistributionVO.setProductState(1);
                unitdistributionVO.setVersion(1);
                unitdistributionVO.setUnitId(Long.valueOf(map.get("unitId").toString()));
                unitdistributionVO.setUnitName(map.get("unitName").toString());
                unitdistributionVO.setSatrtTime(new SimpleDateFormat("yyyy-MM-dd HH:mm").parse(map.get("satrtTime").toString()));
                unitdistributionVO.setEndTime(new Date(map.get("endTime").toString()));
                unitdistributionVO.setDistributeCount(new BigDecimal((String) map.get("distributeCount")));
                unitdistributionVO.setAddCount(new BigDecimal("0"));
                unitdistributionVO.setAddedCount(new BigDecimal("0").add(new BigDecimal((String) map.get("distributeCount"))));
                unitdistributionVO.setWeighNumber(new BigDecimal("0"));
                unitdistributionVO.setNotWeighNumber(new BigDecimal("0"));
                unitdistributionVO.setAddCount(new BigDecimal("0"));
                unitdistributionVO.setAddedCount(new BigDecimal("0"));
                BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE,InvocationInfoProxy.getTenantid(),unitdistributionVO);
                CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
                if(billCode.isSuccess()) {
                    unitdistributionVO.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
                }else{
                    throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
                }
                sum = sum.add(new BigDecimal((String) map.get("distributeCount")));
                unitdistributionList.add(unitdistributionVO);
            }
        }
        if (productiontaskEntity.getDistributeCount()!=null){
            sum=sum.add(productiontaskEntity.getDistributeCount());
        }
        productiontaskEntity.setDistributeCount(sum);
        productiontaskEntity.setNotDistributeCount(productiontaskEntity.getThisQuantity().subtract(sum));
        if (sum.compareTo(productiontaskEntity.getThisQuantity())==0){
            productiontaskEntity.setTaskStatus(2);
        }
        List<UnitdistributionEntity> unitdistributionEntityList = BeanMapper.mapList(unitdistributionList, UnitdistributionEntity.class);
        service.saveOrUpdateBatch(unitdistributionEntityList, unitdistributionEntityList.size());

        productiontaskService.saveOrUpdate(productiontaskEntity,false);
        return CommonResponse.success("分配机组成功");
    }
    /**
     * 分配机组展示
     * 根据生产任务单状态查找生产状态的生产任务单并获取生产任务单id
     * 根据获取的生产任务单id查找分配机组数据
     * @param taskId
     * @return CommonResponse<List<UnitdistributionVO>>
     *
     */
    @GetMapping(value = "showdistribute")
    @ResponseBody
    public CommonResponse<List<UnitdistributionVO>> showdistribute(@RequestParam(value = "taskId") Long taskId) {
        QueryWrapper query=new QueryWrapper();
        query.eq("product_state",1);
        List<UnitdistributionEntity> list = service.list(query);
        List<UnitdistributionVO> unitdistributionVOS = BeanMapper.mapList(list, UnitdistributionVO.class);
        return CommonResponse.success("查询机组成功",unitdistributionVOS);
    }

    /**
     * 分配机组展示
     * 根据生产任务单状态查找生产状态的生产任务单并获取生产任务单id
     * 根据获取的生产任务单id查找分配机组数据
     * @param unitId
     * @param orgId
     * @return CommonResponse<List<UnitdistributionVO>>
     *
     */
    @GetMapping(value = "queryListById")
    @ResponseBody
    public CommonResponse<List<UnitdistributionVO>> queryListById(@RequestParam(value = "unitId") Long unitId,@RequestParam(value = "orgId") Long orgId) {
        QueryWrapper query=new QueryWrapper();
        query.eq("unit_id",unitId);
        query.eq("org_id",orgId);
        query.eq("product_state",1);
        List<UnitdistributionEntity> list = service.list(query);
        List<UnitdistributionVO> unitdistributionVOS = BeanMapper.mapList(list, UnitdistributionVO.class);
        return CommonResponse.success("查询机组任务成功",unitdistributionVOS);
    }

    /**
     * 查询机组相关数据
     * @return
     */
    @GetMapping(value = "queryUnit")
    @ResponseBody
    public CommonResponse<List<UnitVO>> queryList(String orgId){
        List<UnitVO> unitVOS = baseApi.queryUnit(orgId);
        if (!unitVOS.isEmpty()){
            for (UnitVO unitVO : unitVOS) {
                QueryWrapper query=new QueryWrapper();
                query.eq("unit_id",unitVO.getId());
                query.orderByDesc("end_time");
                List<UnitdistributionEntity> list = service.list(query);
                if (!list.isEmpty()){
                    UnitdistributionEntity unitdistributionEntity = list.get(0);
                    unitVO.setStartTime(unitdistributionEntity.getEndTime());
                }
            }
        }
        return CommonResponse.success("查询机组数据成功 ",unitVOS);
    }
}
