package com.ejianc.business.production.vo;

import java.util.Date;
import java.math.*;

import com.baomidou.mybatisplus.annotation.TableField;
import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;


/**
 * 分配机组
 * 
 * @author generator
 * 
 */
public class UnitdistributionVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private String billCode; // 单据编号
    private Long unitId; // 机组id
    private String unitName; // 机组名称
    private Long taskId; // 任务单id
    private String taskCode; // 任务单单号
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd HH:mm", timezone = "GMT+8")
    private Date satrtTime; // 开始时间
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd HH:mm", timezone = "GMT+8")
    private Date endTime; // 结束时间
    private BigDecimal distributeCount; // 分配数量
    private Long operatorId; // 经办人id
    private String operatorName; // 经办人名称
    private Integer billState; // 单据状态: 0自由态,1已提交,2审批中,3审批通过,4驳回,5提交后有人审批中
    private Long changeId; // 变更单据id
    private String changeState; // 变更状态，1:未变更;2:变更中;3:已变更
    private Long productId; // 产品id
    private String productName; // 产品名称
    private Long customerManageId; // 客户管理档案id
    private String customerManageName; // 客户管理档案名称
    private Long projectId; // 工程id
    private String projectName; // 工程名称
    private Long worksiteId; // 工地id
    private String worksiteName; // 工地名称
    private Long orgId; // 所属组织id
    private String orgName; // 所属组织名称
    private BigDecimal quantity; // 数量
    private BigDecimal weighNumber; // 过磅数
    private BigDecimal notWeighNumber; // 未过磅数量
    private BigDecimal addCount; // 追加数量
    private BigDecimal addedCount; // 追加后数量
    private Integer productState; // 分配机组生产状态 ：1 生产中 2 生产完成
    private BigDecimal notDistributeCount; // 未分配数量
    private BigDecimal distributedCount; // 已分配数量
    private Integer isDistributeCar; // 分配车辆状态 ：1 未分配 2 已分配
    private Integer pageIndex;
    private Integer pageSize;
    private Integer sort;
    private BigDecimal productedCount; // 已生产数量
    private BigDecimal notProductCount; // 未生产数量



    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    @ReferSerialTransfer(referCode="UnitRef")
    public Long getUnitId() {
        return unitId;
    }
    @ReferDeserialTransfer
    public void setUnitId(Long unitId) {
        this.unitId = unitId;
    }
    public String getUnitName() {
        return unitName;
    }

    public void setUnitName(String unitName) {
        this.unitName = unitName;
    }
    @ReferSerialTransfer(referCode="ProductiontaskRef")
    public Long getTaskId() {
        return taskId;
    }
    @ReferDeserialTransfer
    public void setTaskId(Long taskId) {
        this.taskId = taskId;
    }
    public String getTaskCode() {
        return taskCode;
    }

    public void setTaskCode(String taskCode) {
        this.taskCode = taskCode;
    }
    public Date getSatrtTime() {
        return satrtTime;
    }

    public void setSatrtTime(Date satrtTime) {
        this.satrtTime = satrtTime;
    }
    public Date getEndTime() {
        return endTime;
    }

    public void setEndTime(Date endTime) {
        this.endTime = endTime;
    }
    public BigDecimal getDistributeCount() {
        return distributeCount;
    }

    public void setDistributeCount(BigDecimal distributeCount) {
        this.distributeCount = distributeCount;
    }

    public Long getOperatorId() {
        return operatorId;
    }

    public void setOperatorId(Long operatorId) {
        this.operatorId = operatorId;
    }
    public String getOperatorName() {
        return operatorName;
    }

    public void setOperatorName(String operatorName) {
        this.operatorName = operatorName;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public Long getChangeId() {
        return changeId;
    }

    public void setChangeId(Long changeId) {
        this.changeId = changeId;
    }
    public String getChangeState() {
        return changeState;
    }

    public void setChangeState(String changeState) {
        this.changeState = changeState;
    }
    @ReferSerialTransfer(referCode="ProductorInfoRef")
    public Long getProductId() {
        return productId;
    }
    @ReferDeserialTransfer
    public void setProductId(Long productId) {
        this.productId = productId;
    }
    public String getProductName() {
        return productName;
    }

    public void setProductName(String productName) {
        this.productName = productName;
    }
    @ReferSerialTransfer(referCode="CustomerinfoRef")
    public Long getCustomerManageId() {
        return customerManageId;
    }
    @ReferDeserialTransfer
    public void setCustomerManageId(Long customerManageId) {
        this.customerManageId = customerManageId;
    }
    public String getCustomerManageName() {
        return customerManageName;
    }

    public void setCustomerManageName(String customerManageName) {
        this.customerManageName = customerManageName;
    }
    @ReferSerialTransfer(referCode="ProjectInfoRef")
    public Long getProjectId() {
        return projectId;
    }
    @ReferDeserialTransfer
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    @ReferSerialTransfer(referCode="ConstructionsiteRef")
    public Long getWorksiteId() {
        return worksiteId;
    }
    @ReferDeserialTransfer
    public void setWorksiteId(Long worksiteId) {
        this.worksiteId = worksiteId;
    }
    public String getWorksiteName() {
        return worksiteName;
    }

    public void setWorksiteName(String worksiteName) {
        this.worksiteName = worksiteName;
    }
    @ReferSerialTransfer(referCode="idm-org")
    public Long getOrgId() {
        return orgId;
    }
    @ReferDeserialTransfer
    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public BigDecimal getQuantity() {
        return quantity;
    }

    public void setQuantity(BigDecimal quantity) {
        this.quantity = quantity;
    }
    public BigDecimal getWeighNumber() {
        return weighNumber;
    }

    public void setWeighNumber(BigDecimal weighNumber) {
        this.weighNumber = weighNumber;
    }
    public BigDecimal getNotWeighNumber() {
        return notWeighNumber;
    }

    public void setNotWeighNumber(BigDecimal notWeighNumber) {
        this.notWeighNumber = notWeighNumber;
    }

    public BigDecimal getAddCount() {
        return addCount;
    }

    public void setAddCount(BigDecimal addCount) {
        this.addCount = addCount;
    }

    public BigDecimal getAddedCount() {
        return addedCount;
    }

    public void setAddedCount(BigDecimal addedCount) {
        this.addedCount = addedCount;
    }

    public Integer getProductState() {
        return productState;
    }

    public void setProductState(Integer productState) {
        this.productState = productState;
    }

    public Integer getPageIndex() {
        return pageIndex;
    }

    public void setPageIndex(Integer pageIndex) {
        this.pageIndex = pageIndex;
    }

    public Integer getPageSize() {
        return pageSize;
    }

    public void setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
    }

    public BigDecimal getNotDistributeCount() {
        return notDistributeCount;
    }

    public void setNotDistributeCount(BigDecimal notDistributeCount) {
        this.notDistributeCount = notDistributeCount;
    }

    public BigDecimal getDistributedCount() {
        return distributedCount;
    }

    public void setDistributedCount(BigDecimal distributedCount) {
        this.distributedCount = distributedCount;
    }

    public Integer getIsDistributeCar() {
        return isDistributeCar;
    }

    public void setIsDistributeCar(Integer isDistributeCar) {
        this.isDistributeCar = isDistributeCar;
    }

    public Integer getSort() {
        return sort;
    }

    public void setSort(Integer sort) {
        this.sort = sort;
    }

    public BigDecimal getProductedCount() {
        return productedCount;
    }

    public void setProductedCount(BigDecimal productedCount) {
        this.productedCount = productedCount;
    }

    public BigDecimal getNotProductCount() {
        return notProductCount;
    }

    public void setNotProductCount(BigDecimal notProductCount) {
        this.notProductCount = notProductCount;
    }
}
