package com.ejianc.business.production.controller.api;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.base.bases.api.BaseApi;
import com.ejianc.business.base.bases.vo.ShippersInfoApiVO;
import com.ejianc.business.base.bases.vo.ShippersfareVO;
import com.ejianc.business.production.bean.ProductiontaskEntity;
import com.ejianc.business.production.bean.ProductiontasktransportEntity;
import com.ejianc.business.production.bean.UnitdistributionEntity;
import com.ejianc.business.production.service.IProductiontaskService;
import com.ejianc.business.production.service.IProductiontasktransportService;
import com.ejianc.business.production.service.IUnitdistributionService;
import com.ejianc.business.production.task.vo.*;
import com.ejianc.business.production.vo.ProductiontasktransportVO;
import com.ejianc.business.production.vo.UnitdistributionVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.*;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@RestController
@RequestMapping("/api/production/productiontaskApi")
public class TaskSelectApi {
    @Autowired
    IProductiontaskService productiontaskService;
    @Qualifier("com.ejianc.business.base.bases.api.BaseApi")
    @Autowired
    BaseApi baseApi;
    @Autowired
    IProductiontasktransportService productiontasktransportService;
    @Autowired
    IUnitdistributionService unitdistributionService;
    /**
     * 请求获取生产任务单和运输商，运输商车辆信息
     * @param taskId
     * @return
     */
    @PostMapping(value = "/getproductiontask")
    @ResponseBody
    public CommonResponse<ProductionTaskApiVo> getProductiontask(@RequestParam(value = "taskId") String taskId,@RequestParam(value = "carCode") String carCode){
        List<ShipperfareVO> shipperfareVOS=new ArrayList<>();
        ProductiontaskEntity entity= productiontaskService.selectById(taskId);
        QueryWrapper query=new QueryWrapper();
        query.eq("shippers_vehicle_code",carCode);
        query.eq("org_id",entity.getOrgId());
        query.eq("task_id",entity.getId());
        query.eq("transport_statue",1);
        ProductiontasktransportEntity transportEntity = productiontasktransportService.getOne(query);

        ProductionTaskApiVo apiVo = new ProductionTaskApiVo();
        if (transportEntity!=null){
            apiVo.setTransPortId(transportEntity.getId());
        }
        apiVo.setOldTaskCode(entity.getOldTaskCode());
        apiVo.setCustomerManageId(entity.getCustomerManageId());
        apiVo.setCustomerManageName(entity.getCustomerManageName());
        apiVo.setProjectId(entity.getProjectId());
        apiVo.setProjectName(entity.getProjectName());
        apiVo.setProductId(entity.getProductId());
        apiVo.setProductName(entity.getProductName());
        apiVo.setWorksiteId(entity.getWorksiteId());
        apiVo.setWorksiteName(entity.getWorksiteName());
        apiVo.setPrintCustomerName(entity.getPrintCustomerName());
        apiVo.setPrintProductName(entity.getPrintProductName());
        apiVo.setPrintWorksiteName(entity.getPrintWorksiteName());
        apiVo.setPrintSupplyName(entity.getPrintSupplyName());
        apiVo.setUnitId(transportEntity.getUnitId());
        apiVo.setUnitName(transportEntity.getUnitName());
        apiVo.setUnitdistributeId(transportEntity.getUnitdistributeId());
        apiVo.setOrgId(entity.getOrgId());
        apiVo.setOrgName(entity.getOrgName());
        apiVo.setDistance(entity.getDistance());
        apiVo.setTransportMethod(entity.getTransportMethod());
        apiVo.setOrderMobile(entity.getOrderMobile());
        apiVo.setOrderName(entity.getOrderName());
        apiVo.setProductName(entity.getProductName());
        apiVo.setTransportRoute(entity.getTransportRoute());
        if (entity.getTransportMethod().equals("代运")) {
            Long orgId = entity.getOrgId();
            CommonResponse<ShippersInfoApiVO> shippersInfo = baseApi.getShippersInfo(carCode, orgId);
            if (shippersInfo.getCode() == 0) {
                ShippersInfoApiVO data = shippersInfo.getData();
                apiVo.setShipperVehicleId(data.getCarId());
                apiVo.setShipperVehicleName(data.getCarName());
                apiVo.setShipperId(data.getShipperMId());
                apiVo.setShipperMName(data.getShipperMName());
                apiVo.setTare(data.getTare());
                apiVo.setCategory(data.getCategory());
                List<ShippersfareVO> shippersfareVOS = data.getShippersfareVOS();
                for (ShippersfareVO shippersfareVO : shippersfareVOS) {
                    ShipperfareVO fareVO = new ShipperfareVO();
                    fareVO.setStartDistance(shippersfareVO.getStartDistance());
                    fareVO.setEndDistance(shippersfareVO.getEndDistance());
                    fareVO.setDistance(shippersfareVO.getDistance());
                    fareVO.setTransportFare(shippersfareVO.getTransportFare());
                    shipperfareVOS.add(fareVO);
                }
                apiVo.setShippersfareVOS(shipperfareVOS);
            } else {
                return CommonResponse.error(shippersInfo.getMsg());
            }
        }
        return CommonResponse.success("访问成功！！",apiVo);
    }

    /**
     * 获取发货运输信息
     * @param carCode
     * @param orgId
     * @return
     */
    @GetMapping(value = "/getdeliver")
    @ResponseBody
    public CommonResponse<List<DelivergoodsVO>> getDeliver(@RequestParam(value = "carCode") String carCode, @RequestParam(value = "orgId") String orgId){
        List<DelivergoodsVO> delivergoodsVOS=new ArrayList<>();
        QueryWrapper query=new QueryWrapper();
        query.eq("shippers_vehicle_code",carCode);
        query.eq("org_id",orgId);
        query.eq("transport_statue",1);
        List<ProductiontasktransportEntity> list = productiontasktransportService.list(query);
        if (list.size()>0){
            for (ProductiontasktransportEntity entity : list) {
                com.ejianc.business.production.task.vo.DelivergoodsVO delivergoodsVO = new com.ejianc.business.production.task.vo.DelivergoodsVO();
                ProductiontaskEntity taskEntity = productiontaskService.selectById(entity.getTaskId());
                delivergoodsVO.setDeliverDate(entity.getTransportTime());
                delivergoodsVO.setShipperMId(entity.getShippersId());
                delivergoodsVO.setShipperMName(entity.getShippersName());
                delivergoodsVO.setShippersVehicleCode(entity.getShippersVehicleCode());
                delivergoodsVO.setShippersVehicleId(entity.getShippersVehicleId());
                delivergoodsVO.setTare(entity.getTare());
                delivergoodsVO.setId(entity.getId());
                delivergoodsVO.setTransportCount(entity.getTransportCount());
                delivergoodsVO.setTransportStatue(entity.getTransportStatue());
                delivergoodsVO.setDistance(taskEntity.getDistance());
                delivergoodsVO.setCustomerId(taskEntity.getCustomerManageId());
                delivergoodsVO.setCustomerName(taskEntity.getCustomerManageName());
                delivergoodsVO.setProductId(taskEntity.getProductId());
                delivergoodsVO.setProductName(taskEntity.getProductName());
                delivergoodsVO.setProjectId(taskEntity.getProjectId());
                delivergoodsVO.setProjectName(taskEntity.getProjectName());
                delivergoodsVO.setTaskCode(taskEntity.getBillCode());
                delivergoodsVO.setTaskId(taskEntity.getId());
                delivergoodsVO.setWorksiteId(taskEntity.getWorksiteId());
                delivergoodsVO.setWorksiteName(taskEntity.getWorksiteName());
                delivergoodsVO.setUnitId(entity.getUnitId());
                delivergoodsVO.setUnitName(entity.getUnitName());
                delivergoodsVO.setPrintCustomerName(taskEntity.getPrintCustomerName());
                delivergoodsVO.setPrintProductName(taskEntity.getPrintProductName());
                delivergoodsVO.setPrintWorksiteName(taskEntity.getPrintWorksiteName());
                delivergoodsVO.setPrintSupplyName(taskEntity.getPrintSupplyName());
                delivergoodsVO.setAddCount(taskEntity.getAddCount());
                delivergoodsVO.setSort(entity.getSort());
                delivergoodsVOS.add(delivergoodsVO);
            }

        }else {
            return CommonResponse.error("未查询到生产任务单运输信息");
        }
        return CommonResponse.success("访问成功！！",delivergoodsVOS);
    }

    /**
     * 更新生产运输信息状态
     * @param transportId
     * @param status
     * @return
     */
    @Transactional
    @GetMapping(value = "/updateTransportState")
    @ResponseBody
    public CommonResponse updateTransportState(@RequestParam(value = "transportId") Long transportId, @RequestParam(value = "status") Integer status){
        ProductiontasktransportEntity entity = productiontasktransportService.selectById(transportId);
        if (entity!=null){
            entity.setTransportStatue(status);
            boolean b = productiontasktransportService.saveOrUpdate(entity, false);
            if (b){
                CommonResponse updatestatus = baseApi.updatestatus(entity.getShippersVehicleId(), 1);
                if (updatestatus.getCode()==1){
                    return CommonResponse.error(updatestatus.getMsg());
                }
            }
        }else {
            return CommonResponse.error("未查找到此运输信息");
        }
        ProductiontasktransportVO map = BeanMapper.map(entity, ProductiontasktransportVO.class);
        return CommonResponse.success("修改状态成功",map);
    }
    /**
     * 更新生产运输信息状态
     * @param
     * @param
     * @return
     */
    @Transactional
    @PostMapping(value = "/updateTransport")
    @ResponseBody
    public CommonResponse updateTransport(@RequestBody TasktransportVO tasktransportVO){
        ProductiontasktransportEntity entity = productiontasktransportService.selectById(tasktransportVO.getId());
        UnitdistributionEntity unitdistributionEntity = unitdistributionService.selectById(entity.getUnitdistributeId());
        //回写生产任务单分配车辆净重，出场时间，运输单据状态
        entity.setShipmentQuantity(tasktransportVO.getTransportCount());
        entity.setTransportTime(tasktransportVO.getTransportTime());
        entity.setTransportStatue(tasktransportVO.getTransportStatue());
        //回写生产任务单分配机组过磅数，未过磅数，已生产数量，未生产数量
        unitdistributionEntity.setWeighNumber(unitdistributionEntity.getWeighNumber().add(tasktransportVO.getTransportCount()));
        unitdistributionEntity.setNotWeighNumber(unitdistributionEntity.getNotWeighNumber().subtract(tasktransportVO.getTransportCount()));
        unitdistributionEntity.setProductedCount(unitdistributionEntity.getProductedCount()==null?new BigDecimal("0").add(tasktransportVO.getTransportCount()):unitdistributionEntity.getProductedCount().add(tasktransportVO.getTransportCount()));
        unitdistributionEntity.setNotProductCount(unitdistributionEntity.getNotProductCount()==null?unitdistributionEntity.getDistributeCount().subtract(tasktransportVO.getTransportCount()):unitdistributionEntity.getNotProductCount().subtract(tasktransportVO.getTransportCount()));
        unitdistributionService.saveOrUpdate(unitdistributionEntity,false);
        productiontasktransportService.saveOrUpdate(entity,false);
        return CommonResponse.success("生产任务运输单信息更新成功");
    }
    /**
     * 查询生产任务单发货车辆信息
     * @param
     * @param
     * @return
     */
    @GetMapping(value = "/queryshipment")
    @ResponseBody
    public CommonResponse<Map<String, Object>> queryShipment(@RequestParam(value = "taskId") Long taskId){
        Map<String,Object> map=new HashMap<>();
        ProductiontaskEntity entity = productiontaskService.selectById(taskId);
        if (entity!=null)
            map.put("taskQuantity",entity.getThisQuantity());
        QueryWrapper<ProductiontasktransportEntity> query = new QueryWrapper<>();
        query.eq("task_id",taskId);
        List<ProductiontasktransportEntity> list = productiontasktransportService.list(query);
        List<TaskDistributeCarVO> voList=new ArrayList<>();
        if (!list.isEmpty()){
            list.forEach(e->{
                TaskDistributeCarVO taskDistributeCarVO = new TaskDistributeCarVO();
                taskDistributeCarVO.setUnitId(e.getUnitId());
                taskDistributeCarVO.setUnitName(e.getUnitName());
                taskDistributeCarVO.setTransportTime(e.getTransportTime());
                taskDistributeCarVO.setTransportCount(e.getTransportCount());
                taskDistributeCarVO.setShipmentQuantity(e.getShipmentQuantity());
                taskDistributeCarVO.setTransportStatue(e.getTransportStatue());
                taskDistributeCarVO.setCarCode(e.getShippersVehicleCode());
                voList.add(taskDistributeCarVO);
            });
            map.put("tasktransportList",voList);
        }else {
            throw new BusinessException("此任务单为查询到分配车辆信息");
        }
        return CommonResponse.success("查询生产任务单相关信息成功",map);
    }
    @GetMapping(value = "/queryunitdistribute")
    @ResponseBody
    public CommonResponse<List<ProductionTaskVO>> queryUnitdistribute(Long orgId){
        List<ProductionTaskVO> productionTaskVOS=new ArrayList<>();
        QueryWrapper<UnitdistributionEntity> query = new QueryWrapper<>();
        query.eq("org_id",orgId);
        query.eq("product_state",1);
        List<UnitdistributionEntity> list = unitdistributionService.list(query);
        if (!list.isEmpty()){
            list.forEach(element->{
                ProductionTaskVO productionTaskVO = new ProductionTaskVO();
                productionTaskVO.setId(element.getId());
                productionTaskVO.setTaskTime(element.getTaskTime());
                productionTaskVO.setQuantity(element.getQuantity());
                productionTaskVO.setProductName(element.getProductName());
                productionTaskVO.setCustomerName(element.getCustomerManageName());
                productionTaskVO.setWorksiteName(element.getWorksiteName());
                productionTaskVO.setUnitName(element.getUnitName());
                productionTaskVO.setNotWeighNumber(element.getNotWeighNumber().toPlainString());
                productionTaskVO.setWeighNumber(element.getWeighNumber().toPlainString());
                productionTaskVOS.add(productionTaskVO);
            });
        }
        return CommonResponse.success("查询生产任务数据成功",productionTaskVOS);
    }
}
