/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.production.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.base.bases.api.BaseApi;
import com.ejianc.business.production.bean.ProductiontaskEntity;
import com.ejianc.business.production.bean.ProductiontasktransportEntity;
import com.ejianc.business.production.bean.UnitdistributionEntity;
import com.ejianc.business.production.mapper.UnitdistributionMapper;
import com.ejianc.business.production.service.IProductiontaskService;
import com.ejianc.business.production.service.IUnitdistributionService;
import com.ejianc.business.production.task.vo.UnitdistributionVO;
import com.ejianc.business.production.vo.TransitionVO;
import com.ejianc.business.sale.salesorder.api.IGenerateManualshipmentApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.RequestBody;

@Service(value="unitdistributionService")
public class UnitdistributionServiceImpl
extends BaseServiceImpl<UnitdistributionMapper, UnitdistributionEntity>
implements IUnitdistributionService {
    @Autowired
    private IProductiontaskService productiontaskService;
    @Autowired
    private IUnitdistributionService service;
    @Qualifier(value="com.ejianc.business.sale.salesorder.api.IGenerateManualshipmentApi")
    @Autowired
    private IGenerateManualshipmentApi generateManualshipmentApi;
    @Qualifier(value="com.ejianc.business.base.bases.api.BaseApi")
    @Autowired
    private BaseApi baseApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    private static final String BILL_CODE = "unit-distribution";

    @Override
    @Transactional
    public CommonResponse saveDistributeCar(@RequestBody UnitdistributionVO saveOrUpdateVO) {
        UnitdistributionEntity entity = (UnitdistributionEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, UnitdistributionEntity.class));
        UnitdistributionEntity unitdistributionEntity = this.setValue(entity);
        if ((entity = unitdistributionEntity).getDistributeCount().compareTo(entity.getDistributedCount()) == 0) {
            entity.setIsDistributeCar(2);
        }
        this.service.saveOrUpdate((Object)entity, false);
        ProductiontaskEntity entity1 = (ProductiontaskEntity)((Object)this.productiontaskService.selectById(entity.getTaskId()));
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01");
    }

    @Override
    public UnitdistributionEntity initUnitDistribute(ProductiontaskEntity entity) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"org_id", (Object)entity.getOrgId());
        Integer i = this.service.list((Wrapper)queryWrapper).size() + 1;
        TransitionVO transitionVO = (TransitionVO)((Object)BeanMapper.map((Object)((Object)entity), TransitionVO.class));
        UnitdistributionEntity distributeEntity = (UnitdistributionEntity)((Object)BeanMapper.map((Object)((Object)transitionVO), UnitdistributionEntity.class));
        distributeEntity.setId(null);
        distributeEntity.setTaskId(entity.getId());
        distributeEntity.setTaskCode(entity.getBillCode());
        distributeEntity.setQuantity(entity.getThisQuantity());
        distributeEntity.setDistributeCount(entity.getThisQuantity());
        distributeEntity.setWeighNumber(entity.getThisQuantity());
        distributeEntity.setDistributedCount(entity.getThisQuantity());
        distributeEntity.setProductedCount(entity.getThisQuantity());
        distributeEntity.setSatrtTime(new Date());
        distributeEntity.setEndTime(new Date());
        distributeEntity.setProductState(1);
        distributeEntity.setIsDistributeCar(2);
        distributeEntity.setSort(i);
        com.ejianc.business.production.vo.UnitdistributionVO map = (com.ejianc.business.production.vo.UnitdistributionVO)((Object)BeanMapper.map((Object)((Object)distributeEntity), com.ejianc.business.production.vo.UnitdistributionVO.class));
        BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)map);
        CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
        if (!billCode.isSuccess()) {
            throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
        }
        distributeEntity.setBillCode((String)billCode.getData());
        ArrayList<ProductiontasktransportEntity> list = new ArrayList<ProductiontasktransportEntity>();
        ProductiontasktransportEntity transportEntity = (ProductiontasktransportEntity)((Object)BeanMapper.map((Object)((Object)entity), ProductiontasktransportEntity.class));
        transportEntity.setId(null);
        transportEntity.setBillCode(null);
        transportEntity.setTaskId(entity.getId());
        transportEntity.setTaskCode(entity.getBillCode());
        transportEntity.setTransportTime(new Date());
        transportEntity.setTransportStatue(2);
        transportEntity.setTransportCount(entity.getThisQuantity());
        transportEntity.setShipmentQuantity(entity.getThisQuantity());
        transportEntity.setShippersVehicleCode(entity.getCarCode());
        transportEntity.setRowState("add");
        list.add(transportEntity);
        distributeEntity.setTaskTransportList(list);
        this.service.saveOrUpdate((Object)distributeEntity, false);
        return distributeEntity;
    }

    @Transactional
    public UnitdistributionEntity setValue(UnitdistributionEntity unitdistributionEntity) {
        List<ProductiontasktransportEntity> taskTransportList = unitdistributionEntity.getTaskTransportList();
        ProductiontaskEntity entity = (ProductiontaskEntity)((Object)this.productiontaskService.selectById(unitdistributionEntity.getTaskId()));
        if (!taskTransportList.isEmpty()) {
            for (ProductiontasktransportEntity productiontasktransportEntity : taskTransportList) {
                if (productiontasktransportEntity.getId() != null && "del".equals(productiontasktransportEntity.getRowState())) {
                    unitdistributionEntity.setDistributedCount(unitdistributionEntity.getDistributedCount().subtract(productiontasktransportEntity.getTransportCount()));
                    unitdistributionEntity.setIsDistributeCar(1);
                    this.baseApi.updatestatus(productiontasktransportEntity.getShippersVehicleId(), Integer.valueOf(1));
                }
                if ("add".equals(productiontasktransportEntity.getRowState())) {
                    productiontasktransportEntity.setTransportMethod(entity.getTransportMethod());
                    productiontasktransportEntity.setTaskId(unitdistributionEntity.getTaskId());
                    productiontasktransportEntity.setUnitdistributeId(unitdistributionEntity.getId());
                    productiontasktransportEntity.setTaskCode(unitdistributionEntity.getTaskCode());
                    productiontasktransportEntity.setCustomerManageId(unitdistributionEntity.getCustomerManageId());
                    productiontasktransportEntity.setCustomerManageName(unitdistributionEntity.getCustomerManageName());
                    productiontasktransportEntity.setProjectId(unitdistributionEntity.getProjectId());
                    productiontasktransportEntity.setProjectName(unitdistributionEntity.getProjectName());
                    productiontasktransportEntity.setProductId(unitdistributionEntity.getProductId());
                    productiontasktransportEntity.setProductName(unitdistributionEntity.getProductName());
                    productiontasktransportEntity.setWorksiteId(unitdistributionEntity.getWorksiteId());
                    productiontasktransportEntity.setWorksiteName(unitdistributionEntity.getWorksiteName());
                    productiontasktransportEntity.setUnitId(unitdistributionEntity.getUnitId());
                    productiontasktransportEntity.setUnitName(unitdistributionEntity.getUnitName());
                    productiontasktransportEntity.setOrgId(unitdistributionEntity.getOrgId());
                    productiontasktransportEntity.setOrgName(unitdistributionEntity.getOrgName());
                    productiontasktransportEntity.setPrintCustomerName(entity.getPrintCustomerName());
                    productiontasktransportEntity.setPrintWorksiteName(entity.getPrintWorksiteName());
                    productiontasktransportEntity.setPrintProductName(entity.getPrintProductName());
                    productiontasktransportEntity.setPrintSupplyName(entity.getPrintSupplyName());
                    productiontasktransportEntity.setOrderMobile(entity.getOrderMobile());
                    productiontasktransportEntity.setOrderName(entity.getOrderName());
                    productiontasktransportEntity.setTransportRoute(entity.getTransportRoute());
                    productiontasktransportEntity.setDistance(entity.getDistance());
                    if (1 == entity.getCountingMethod()) {
                        productiontasktransportEntity.setTransportStatue(2);
                        productiontasktransportEntity.setTransportTime(new Date());
                        productiontasktransportEntity.setShipmentQuantity(productiontasktransportEntity.getTransportCount());
                    } else {
                        productiontasktransportEntity.setTransportStatue(1);
                    }
                }
                if (!"\u5426".equals(productiontasktransportEntity.getIsMoreProject()) || productiontasktransportEntity.getShippersVehicleId() == null) continue;
                this.baseApi.updatestatus(productiontasktransportEntity.getShippersVehicleId(), Integer.valueOf(2));
            }
        }
        unitdistributionEntity.setTaskTime(entity.getTaskTime());
        return unitdistributionEntity;
    }

    private QueryParam genaretorQueryParam() {
        QueryParam queryParam = new QueryParam();
        LinkedHashMap<String, String> orderMap = new LinkedHashMap<String, String>();
        orderMap.put("create_time", "desc");
        queryParam.setPageSize(50);
        queryParam.setPageIndex(1);
        queryParam.setOrderMap(orderMap);
        Parameter parameter = new Parameter();
        parameter.setType("eq");
        parameter.setValue((Object)1);
        HashMap<String, Parameter> map = new HashMap<String, Parameter>();
        map.put("is_distribute_car", parameter);
        map.put("is_add_car", parameter);
        queryParam.setParams(map);
        return queryParam;
    }
}

