package com.ejianc.business.production.controller.api;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.production.bean.ProductiontasktransportEntity;
import com.ejianc.business.production.bean.UnitdistributionEntity;
import com.ejianc.business.production.service.IProductiontasktransportService;
import com.ejianc.business.production.service.IUnitdistributionService;
import com.ejianc.business.production.vo.UnitdistributionVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

/**
 * @authoer:禹鹏杰
 * @createDate:2022/6/24
 * @description:
 */
@RestController
@RequestMapping("/api/production/distributecarmanageApi")
public class DistributeCarManageApi {
    @Autowired
    private IUnitdistributionService unitdistributionService;
    @Autowired
    private IProductiontasktransportService productiontasktransportService;

    /**
     * 查询所有分配机组数据
     * @param param
     * @return
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<com.ejianc.business.production.task.vo.UnitdistributionVO>> queryList(@RequestBody QueryParam param) {
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        IPage<UnitdistributionEntity> page = unitdistributionService.queryPage(param,false);
        List<UnitdistributionEntity> records = page.getRecords();
        for (UnitdistributionEntity entity : records) {
            QueryWrapper query=new QueryWrapper();
            query.eq("unitdistribute_id",entity.getId());
            List<ProductiontasktransportEntity> list = productiontasktransportService.list(query);
            entity.setTaskTransportList(list);
        }
        IPage<com.ejianc.business.production.task.vo.UnitdistributionVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        //pageData.setRecords(BeanMapper.mapList(records, UnitdistributionVO.class));
        List<com.ejianc.business.production.task.vo.UnitdistributionVO> unitdistributionVOS = BeanMapper.mapList(records, com.ejianc.business.production.task.vo.UnitdistributionVO.class);
        unitdistributionVOS.forEach(element->{
            element.setNotWeighNumber(element.getDistributeCount().subtract(element.getWeighNumber()));
            element.setNotDistributeCount(element.getDistributeCount().subtract(element.getDistributedCount()));
            element.setNotProductCount(element.getDistributeCount().subtract(element.getProductedCount()));
        });
        pageData.setRecords(unitdistributionVOS);
        return CommonResponse.success("查询列表数据成功！",pageData);
    }
    /**
     * 机组分配车辆保存
     * @param saveOrUpdateVO
     * @return
     */
    @RequestMapping(value = "/savedistributecar", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse save(@RequestBody com.ejianc.business.production.task.vo.UnitdistributionVO saveOrUpdateVO){
        unitdistributionService.saveDistributeCar(saveOrUpdateVO);
        return CommonResponse.success("分配车辆成功");
    }
}
