package com.ejianc.business.production.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.base.bases.api.BaseApi;
import com.ejianc.business.production.bean.ProductiontaskEntity;
import com.ejianc.business.production.bean.ProductiontasktransportEntity;
import com.ejianc.business.production.bean.UnitdistributionEntity;
import com.ejianc.business.production.mapper.UnitdistributionMapper;
import com.ejianc.business.production.service.IProductiontaskService;
import com.ejianc.business.production.service.IUnitdistributionService;
import com.ejianc.business.production.vo.TransitionVO;
import com.ejianc.business.production.vo.UnitdistributionVO;
import com.ejianc.business.sale.salesorder.api.IGenerateManualshipmentApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.RequestBody;

import java.util.*;

/**
 * 分配机组
 * 
 * @author generator
 * 
 */
@Service("unitdistributionService")
public class UnitdistributionServiceImpl extends BaseServiceImpl<UnitdistributionMapper, UnitdistributionEntity> implements IUnitdistributionService {
    @Autowired
    private IProductiontaskService productiontaskService;
    @Autowired
    private IUnitdistributionService service;
    @Qualifier("com.ejianc.business.sale.salesorder.api.IGenerateManualshipmentApi")
    @Autowired
    private IGenerateManualshipmentApi generateManualshipmentApi;
    @Qualifier("com.ejianc.business.base.bases.api.BaseApi")
    @Autowired
    private BaseApi baseApi;
    @Autowired
    private IBillCodeApi billCodeApi;

    private static final String BILL_CODE = "unit-distribution";//此处需要根据实际修改

    /**
     * 分配车辆保存
     * @param saveOrUpdateVO
     * @return
     */
    @Transactional
    @Override
    public CommonResponse saveDistributeCar(@RequestBody com.ejianc.business.production.task.vo.UnitdistributionVO saveOrUpdateVO) {
        UnitdistributionEntity entity = BeanMapper.map(saveOrUpdateVO, UnitdistributionEntity.class);
        //分配机组子表分配车辆初始化值
        UnitdistributionEntity unitdistributionEntity = this.setValue(entity);
        entity=unitdistributionEntity;
        //判断未分配数量 如果等于0修改分配机组分配车辆状态
        if (entity.getDistributeCount().compareTo(entity.getDistributedCount())==0)
            entity.setIsDistributeCar(2);
        //保存分配机组
        service.saveOrUpdate(entity, false);
        ProductiontaskEntity entity1 = productiontaskService.selectById(entity.getTaskId());

        return CommonResponse.success("保存或修改单据成功！");
    }

    /**
     * 生产任务单生成一条分配机组信息
     * @param entity
     * @return
     */
    @Override
    public UnitdistributionEntity initUnitDistribute(ProductiontaskEntity entity) {
        QueryWrapper queryWrapper=new QueryWrapper();
        queryWrapper.eq("org_id",entity.getOrgId());
        Integer i = service.count(queryWrapper)+1;
        TransitionVO transitionVO = BeanMapper.map(entity, TransitionVO.class);
        UnitdistributionEntity distributeEntity = BeanMapper.map(transitionVO, UnitdistributionEntity.class);
        distributeEntity.setId(null);
        distributeEntity.setTaskId(entity.getId());
        distributeEntity.setTaskCode(entity.getBillCode());
        distributeEntity.setQuantity(entity.getThisQuantity());
        distributeEntity.setDistributeCount(entity.getThisQuantity());
        distributeEntity.setWeighNumber(entity.getThisQuantity());
        distributeEntity.setDistributedCount(entity.getThisQuantity());
        distributeEntity.setProductedCount(entity.getThisQuantity());
        distributeEntity.setSatrtTime(new Date());
        distributeEntity.setEndTime(new Date());
        distributeEntity.setProductState(1);
        distributeEntity.setIsDistributeCar(2);
        distributeEntity.setSort(i);
        UnitdistributionVO map = BeanMapper.map(distributeEntity, UnitdistributionVO.class);
        BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE,InvocationInfoProxy.getTenantid(),map);
        CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
        if(billCode.isSuccess()) {
            distributeEntity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
        }else{
            throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
        }
        List<ProductiontasktransportEntity> list=new ArrayList<>();
        ProductiontasktransportEntity transportEntity = BeanMapper.map(entity, ProductiontasktransportEntity.class);
        transportEntity.setId(null);
        transportEntity.setBillCode(null);
        transportEntity.setTaskId(entity.getId());
        transportEntity.setTaskCode(entity.getBillCode());
        transportEntity.setTransportTime(new Date());
        transportEntity.setTransportStatue(2);
        transportEntity.setTransportCount(entity.getThisQuantity());
        transportEntity.setShipmentQuantity(entity.getThisQuantity());
        transportEntity.setShippersVehicleCode(entity.getCarCode());
        transportEntity.setRowState("add");
        list.add(transportEntity);
        distributeEntity.setTaskTransportList(list);
        service.saveOrUpdate(distributeEntity,false);
        return distributeEntity;
    }

    /**
     * 保存分配机组字段初始化
     * @param unitdistributionEntity
     * @return
     */
    @Transactional
    public UnitdistributionEntity setValue(UnitdistributionEntity unitdistributionEntity){
        List<ProductiontasktransportEntity> taskTransportList = unitdistributionEntity.getTaskTransportList();
        ProductiontaskEntity entity = productiontaskService.selectById(unitdistributionEntity.getTaskId());
        if (!taskTransportList.isEmpty()){
            for (ProductiontasktransportEntity productiontasktransportEntity : taskTransportList) {
                //分配车辆修改删除数据回填分配机组的分配车辆预计发货重量
                if (productiontasktransportEntity.getId()!=null&&"del".equals(productiontasktransportEntity.getRowState())){
                    unitdistributionEntity.setDistributedCount(unitdistributionEntity.getDistributedCount().subtract(productiontasktransportEntity.getTransportCount()));
                    unitdistributionEntity.setIsDistributeCar(1);
                    baseApi.updatestatus(productiontasktransportEntity.getShippersVehicleId(),1);
                }
                if ("add".equals(productiontasktransportEntity.getRowState())){
                    //写入分配车辆的初始化值
                    productiontasktransportEntity.setTransportMethod(entity.getTransportMethod());
                    productiontasktransportEntity.setTaskId(unitdistributionEntity.getTaskId());
                    productiontasktransportEntity.setUnitdistributeId(unitdistributionEntity.getId());
                    productiontasktransportEntity.setTaskCode(unitdistributionEntity.getTaskCode());
                    productiontasktransportEntity.setCustomerManageId(unitdistributionEntity.getCustomerManageId());
                    productiontasktransportEntity.setCustomerManageName(unitdistributionEntity.getCustomerManageName());
                    productiontasktransportEntity.setProjectId(unitdistributionEntity.getProjectId());
                    productiontasktransportEntity.setProjectName(unitdistributionEntity.getProjectName());
                    productiontasktransportEntity.setProductId(unitdistributionEntity.getProductId());
                    productiontasktransportEntity.setProductName(unitdistributionEntity.getProductName());
                    productiontasktransportEntity.setWorksiteId(unitdistributionEntity.getWorksiteId());
                    productiontasktransportEntity.setWorksiteName(unitdistributionEntity.getWorksiteName());
                    productiontasktransportEntity.setUnitId(unitdistributionEntity.getUnitId());
                    productiontasktransportEntity.setUnitName(unitdistributionEntity.getUnitName());
                    productiontasktransportEntity.setOrgId(unitdistributionEntity.getOrgId());
                    productiontasktransportEntity.setOrgName(unitdistributionEntity.getOrgName());
                    productiontasktransportEntity.setPrintCustomerName(entity.getPrintCustomerName());
                    productiontasktransportEntity.setPrintWorksiteName(entity.getPrintWorksiteName());
                    productiontasktransportEntity.setPrintProductName(entity.getPrintProductName());
                    productiontasktransportEntity.setPrintSupplyName(entity.getPrintSupplyName());
                    productiontasktransportEntity.setOrderMobile(entity.getOrderMobile());
                    productiontasktransportEntity.setOrderName(entity.getOrderName());
                    productiontasktransportEntity.setTransportRoute(entity.getTransportRoute());
                    productiontasktransportEntity.setDistance(entity.getDistance());
                    //根据计数方式 如果是机台计数则默认此分配车辆为已发货
                    if (1==entity.getCountingMethod()){
                        productiontasktransportEntity.setTransportStatue(2);
                        productiontasktransportEntity.setTransportTime(new Date());
                        productiontasktransportEntity.setShipmentQuantity(productiontasktransportEntity.getTransportCount());
                    }else {
                        productiontasktransportEntity.setTransportStatue(1);
                    }
                }
                //分配车辆如果不是多任务则修改车辆状态为2
                if ("否".equals(productiontasktransportEntity.getIsMoreProject())&&productiontasktransportEntity.getShippersVehicleId()!=null)
                    baseApi.updatestatus(productiontasktransportEntity.getShippersVehicleId(),2);
            }
        }
        //分配机组存入生产任务单日期
        unitdistributionEntity.setTaskTime(entity.getTaskTime());
        return unitdistributionEntity;
    }

}
