/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.production.excel;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.production.bean.ProductiontaskEntity;
import com.ejianc.business.production.service.IProductiontaskService;
import com.ejianc.business.production.service.ISiteorderService;
import com.ejianc.business.production.utils.DateUtil;
import com.ejianc.business.production.vo.ProductiontaskVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.core.util.ImportTemplate;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.ejianc.support.idworker.util.IdWorker;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@Controller
@RequestMapping(value={"productiontaskExcel"})
public class ExcelProductiontaskController
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Autowired
    private ISiteorderService iSiteorderService;
    @Autowired
    private IProductiontaskService service;
    @Autowired
    private IBillCodeApi billCodeApi;
    private static final String BILL_CODE = "production-task";

    @RequestMapping(value={"/downloadProductiontask"})
    @ResponseBody
    public void downloadProductiontask(HttpServletRequest request, HttpServletResponse response) {
        ImportTemplate.initialize((HttpServletResponse)response);
        ImportTemplate.templetdownload((HttpServletRequest)request, (String)"Productiontask-import.xlsx", (String)"\u751f\u4ea7\u4efb\u52a1\u5355\u5bfc\u5165\u6a21\u677f");
    }

    @RequestMapping(value={"/excelImportProductiontask"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<Object> excelImportProductiontask(HttpServletRequest request, HttpServletResponse response) throws ParseException {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
        Map fileMap = multipartRequest.getFileMap();
        ArrayList<ProductiontaskVO> successList = new ArrayList<ProductiontaskVO>();
        ArrayList<ProductiontaskVO> errorList = new ArrayList<ProductiontaskVO>();
        HashMap map = new HashMap();
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry entity : fileMap.entrySet()) {
            mf = (MultipartFile)entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt((String)originalFileName, (Boolean)false);
            if ("xls".equals(extName) || "xlsx".equals(extName)) continue;
            isFailed = true;
            break;
        }
        if (isFailed) {
            return CommonResponse.error((String)"\u6587\u4ef6\u683c\u5f0f\u4e0d\u5408\u6cd5");
        }
        List result = ExcelReader.readExcel(mf);
        if (result.size() > 0) {
            for (int i = 1; i < result.size(); ++i) {
                List data = (List)result.get(i);
                ProductiontaskVO VO = new ProductiontaskVO();
                VO.setId(IdWorker.getId());
                VO.setOldTaskCode(StringUtils.isNotBlank((CharSequence)((CharSequence)data.get(0))) ? (String)data.get(0) : null);
                VO.setTaskTime(StringUtils.isNotBlank((CharSequence)((CharSequence)data.get(1))) ? DateUtil.DoubleToDate(Double.valueOf((String)data.get(1))) : null);
                VO.setCustomerManageName(StringUtils.isNotBlank((CharSequence)((CharSequence)data.get(2))) ? (String)data.get(2) : null);
                VO.setProjectName(StringUtils.isNotBlank((CharSequence)((CharSequence)data.get(3))) ? (String)data.get(3) : null);
                VO.setProductName(StringUtils.isNotBlank((CharSequence)((CharSequence)data.get(4))) ? (String)data.get(4) : null);
                VO.setAsphaltSpec(StringUtils.isNotBlank((CharSequence)((CharSequence)data.get(5))) ? (String)data.get(5) : null);
                VO.setAddCount(StringUtils.isNotBlank((CharSequence)((CharSequence)data.get(6))) ? (String)data.get(6) : null);
                VO.setWorksiteName(StringUtils.isNotBlank((CharSequence)((CharSequence)data.get(7))) ? (String)data.get(7) : null);
                VO.setTransportMethod(StringUtils.isNotBlank((CharSequence)((CharSequence)data.get(8))) ? (String)data.get(8) : null);
                VO.setThisQuantity(StringUtils.isNotBlank((CharSequence)((CharSequence)data.get(9))) ? new BigDecimal((String)data.get(9)) : null);
                VO.setDistributeCount(StringUtils.isNotBlank((CharSequence)((CharSequence)data.get(10))) ? new BigDecimal((String)data.get(10)) : null);
                VO.setAddedCount(StringUtils.isNotBlank((CharSequence)((CharSequence)data.get(11))) ? (String)data.get(11) : null);
                VO.setAfteraddCount(StringUtils.isNotBlank((CharSequence)((CharSequence)data.get(12))) ? new BigDecimal((String)data.get(12)) : null);
                VO.setWeightNumber(StringUtils.isNotBlank((CharSequence)((CharSequence)data.get(13))) ? new BigDecimal((String)data.get(13)) : null);
                VO.setOrderName(StringUtils.isNotBlank((CharSequence)((CharSequence)data.get(14))) ? (String)data.get(14) : null);
                VO.setOrderMobile(StringUtils.isNotBlank((CharSequence)((CharSequence)data.get(15))) ? (String)data.get(15) : null);
                VO.setTransportRoute(StringUtils.isNotBlank((CharSequence)((CharSequence)data.get(16))) ? (String)data.get(16) : null);
                VO.setDistance(StringUtils.isNotBlank((CharSequence)((CharSequence)data.get(17))) ? new BigDecimal((String)data.get(17)) : null);
                VO.setOrgName(StringUtils.isNotBlank((CharSequence)((CharSequence)data.get(18))) ? (String)data.get(18) : null);
                VO.setProjectTotle(StringUtils.isNotBlank((CharSequence)((CharSequence)data.get(19))) ? new BigDecimal((String)data.get(19)) : null);
                VO.setOrderedQuantity(StringUtils.isNotBlank((CharSequence)((CharSequence)data.get(20))) ? new BigDecimal((String)data.get(20)) : null);
                VO.setOrderedNot(StringUtils.isNotBlank((CharSequence)((CharSequence)data.get(21))) ? new BigDecimal((String)data.get(21)) : null);
                VO.setOrderedNot(StringUtils.isNotBlank((CharSequence)((CharSequence)data.get(21))) ? new BigDecimal((String)data.get(21)) : null);
                if ("\u5df2\u521b\u5efa".equals(data.get(22))) {
                    VO.setTaskStatus(1);
                } else if ("\u5df2\u5206\u914d ".equals(data.get(22))) {
                    VO.setTaskStatus(2);
                } else if ("\u5df2\u5173\u95ed ".equals(data.get(22))) {
                    VO.setTaskStatus(3);
                }
                VO.setCreateTime(new Date());
                VO.setTenantId(InvocationInfoProxy.getTenantid());
                VO.setOrgId(InvocationInfoProxy.getOrgId());
                VO.setCreateUserCode(InvocationInfoProxy.getUsercode());
                VO.setCreateTime(new Date());
                if (StringUtils.isEmpty((CharSequence)((CharSequence)data.get(2))) || data.get(2) == null) {
                    VO.setErrorMsg("'\u5ba2\u6237'\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                    errorList.add(VO);
                    continue;
                }
                successList.add(VO);
            }
            if (errorList.size() == 0) {
                List productiontaskEntities = BeanMapper.mapList(successList, ProductiontaskEntity.class);
                for (ProductiontaskEntity entity : productiontaskEntities) {
                    ProductiontaskVO VO = (ProductiontaskVO)((Object)BeanMapper.map((Object)((Object)entity), ProductiontaskVO.class));
                    BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)VO);
                    CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
                    if (!billCode.isSuccess()) continue;
                    entity.setBillCode((String)billCode.getData());
                }
                this.service.saveBatch(productiontaskEntities, successList.size());
            }
        }
        JSONObject json = new JSONObject();
        json.put("successNum", (Object)successList.size());
        json.put("successList", successList);
        json.put("errorList", errorList);
        json.put("errorNum", (Object)errorList.size());
        return CommonResponse.success((Object)json);
    }
}

