package com.ejianc.business.production.controller;

import java.io.Serializable;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.base.bases.api.BaseApi;
import com.ejianc.business.production.bean.ProductiontaskEntity;
import com.ejianc.business.production.bean.ProductiontaskdetailEntity;
import com.ejianc.business.production.bean.ProductiontasktransportEntity;
import com.ejianc.business.production.bean.UnitdistributionEntity;
import com.ejianc.business.production.service.IUnitdistributionService;
import com.ejianc.business.production.vo.*;
import com.ejianc.business.production.service.IProductiontaskService;
import com.ejianc.business.production.service.IProductiontasktransportService;
import com.ejianc.business.sale.salesorder.api.IGenerateManualshipmentApi;
import com.ejianc.business.sale.salesorder.api.ISalesorderApi;

import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.ss.formula.functions.T;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.math.BigDecimal;
import java.util.*;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Controller;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.*;
import org.apache.commons.collections.CollectionUtils;
import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

/**
 * 生产任务单
 *
 * @author generator
 *
 */
@CrossOrigin
@Controller
@RequestMapping("productiontask")
public class ProductiontaskController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "production-task";//此处需要根据实际修改

    @Autowired
    private IProductiontaskService service;

    @Qualifier("com.ejianc.business.sale.salesorder.api.IGenerateManualshipmentApi")
    @Autowired
    private IGenerateManualshipmentApi generateManualshipmentApi;

    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IProductiontasktransportService productiontasktransportService;
    @Autowired
    @Qualifier("com.ejianc.business.sale.salesorder.api.ISalesorderApi")
    private ISalesorderApi salesorderApi;
    @Autowired
    IUnitdistributionService unitdistributionService;
    @Autowired
    @Qualifier("com.ejianc.business.base.bases.api.BaseApi")
    BaseApi baseApi;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @Transactional
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<ProductiontaskVO> saveOrUpdate(@RequestBody ProductiontaskVO saveOrUpdateVO) {
        ProductiontaskEntity entity = BeanMapper.map(saveOrUpdateVO,ProductiontaskEntity.class);
        // 老系统任务单号校验重复性
        QueryWrapper query=new QueryWrapper();
        query.eq("old_task_code",entity.getOldTaskCode());
        query.eq("org_id",entity.getOrgId());
        if(entity.getId() != null)
            query.ne("id",entity.getId());
        int count = service.count(query);
        if (count > 0)
            throw new BusinessException("老系统任务单号已存在，请检查修改后保存");

        boolean flag=false;
    	if(entity.getId() == null || entity.getId() == 0){
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE,InvocationInfoProxy.getTenantid(),saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if(billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
            //初始化追加后数量 已分配数量 过磅数
            entity.setAfteraddCount(entity.getThisQuantity());
            entity.setDistributeCount(BigDecimal.ZERO);
            entity.setWeightNumber(BigDecimal.ZERO);
            //初始化生产任务单状态
            entity.setTaskStatus(1);
            //去除老系统任务单号字段数据的空格
            if (entity.getOldTaskCode()!=null){
                entity.setOldTaskCode(entity.getOldTaskCode().trim());
            }
            flag=true;
        }else {
    	    //编辑修改重新初始化生产任务单相关字段数据
            unitdistributionService.initProductionTask(saveOrUpdateVO);
        }
    	//初始化生产任务单状态
        if (flag && entity.getCountingMethod()==1) {
            entity.setTaskStatus(2);
            entity.setWeightNumber(entity.getThisQuantity());
        }
    	service.saveOrUpdate(entity, false);
    	//新增并且是机台计数时新增分配机组 分配车辆 发货信息
    	if (flag && entity.getCountingMethod()==1){
            UnitdistributionEntity unitdistributionEntity = unitdistributionService.initUnitDistribute(entity);
            //生产任务单如果是机台计数则生成手动发货记录
            List<com.ejianc.business.sale.salesorder.vo.ProductiontasktransportVO> productiontasktransportVOS = BeanMapper.mapList(unitdistributionEntity.getTaskTransportList(), com.ejianc.business.sale.salesorder.vo.ProductiontasktransportVO.class);
            CommonResponse commonResponse = generateManualshipmentApi.saveList(productiontasktransportVOS);
            if (commonResponse.getCode()==1){
                throw new BusinessException("网络问题，生成发货管理失败");
            }
        }
    	ProductiontaskVO vo = BeanMapper.map(entity, ProductiontaskVO.class);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<ProductiontaskVO> queryDetail(Long id) {
    	ProductiontaskEntity entity = service.selectById(id);
    	ProductiontaskVO vo = BeanMapper.map(entity, ProductiontaskVO.class);
    	vo.setNotDistributeCount(vo.getThisQuantity().subtract(vo.getDistributeCount()));
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @Transactional
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<ProductiontaskVO> vos) {

        if(ListUtil.isNotEmpty(vos)){
            for (ProductiontaskVO vo : vos) {
                ProductiontaskEntity entity = service.selectById(vo.getId());
                if (3==entity.getTaskStatus())
                    throw new BusinessException("删除数据有已关闭生产任务单数据，删除失败");
                QueryWrapper query=new QueryWrapper();
                query.eq("task_id",vo.getId());
                //查询生产任务单所属的分配车辆并回写车辆状态删除分配车辆
                List<ProductiontasktransportEntity> list1 = productiontasktransportService.list(query);
                if (!list1.isEmpty()){
                    List<ProductiontasktransportVO> productiontasktransportVOS = BeanMapper.mapList(list1, ProductiontasktransportVO.class);
                    for (ProductiontasktransportVO productiontasktransportVO : productiontasktransportVOS) {
                        if (productiontasktransportVO.getTransportStatue()==2){
                            throw new BusinessException("删除生产任务单数据中存在已经发货任务单，不能删除");
                        }else {
                            logger.info("删除生产任务单更新车辆状态传参={}" + productiontasktransportVO.getShippersVehicleId()+"车牌号={}"+productiontasktransportVO.getShippersVehicleCode());
                            baseApi.updatestatus(productiontasktransportVO.getShippersVehicleId(),1);
                        }
                    }
                    productiontasktransportService.removeByIds(productiontasktransportVOS.stream().map(ProductiontasktransportVO::getId).collect(Collectors.toList()),true);
                }
                List<UnitdistributionEntity> list = unitdistributionService.list(query);
                if (!list.isEmpty()) {
                    List<UnitdistributionVO> VOS = BeanMapper.mapList(list, UnitdistributionVO.class);
                    unitdistributionService.removeByIds(VOS.stream().map(UnitdistributionVO::getId).collect(Collectors.toList()), true);
                }
                // 参数是单据类型编码字符串 根据需求是否打开下面代码
                /* CommonResponse<String> resp = billTypeApi.checkQuote("billTypeCode", vo.getId());
                if(!resp.isSuccess()){
                    return CommonResponse.error("删除失败！"+resp.getMsg());
                }*/
            }
        }
        service.removeByIds(vos.stream().map(ProductiontaskVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<ProductiontaskVO>> queryList(@RequestBody QueryParam param) {
        if (param.getOrderMap().isEmpty()){
            LinkedHashMap<String,String> map=new LinkedHashMap<>();
            map.put("createTime","desc");
            param.setOrderMap(map);
        }
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("customerManageName");
        fuzzyFields.add("projectName");
        fuzzyFields.add("productName");
        fuzzyFields.add("worksiteName");
        fuzzyFields.add("oldTaskCode");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离 本下 没有组织orgId的删除下面代码-------------开始 */
        UserContext userContextCache =sessionManager.getUserContext();
        //当前应用有权限的根orgId，以逗号分割，可据此查询其本下数据，需判空
        String authOrgIds = userContextCache.getAuthOrgIds();
        List<OrgVO> orgVOList = null;
        if(StringUtils.isNotBlank(authOrgIds)){//移动端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "查询失败，获取当前本下组织信息失败。");
        }else {//pc端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
        }
        //普通组织 id
        List<Long> commonOrgIds = new ArrayList<>();
        //项目部 id
        List<Long> departmentIds = new ArrayList<>();
        orgVOList.stream().forEach(org -> {
            if(5 == org.getOrgType()) {
                //项目部
                departmentIds.add(org.getId());
            } else {
                //普通组织
                commonOrgIds.add(org.getId());
            }
        });
        if(CollectionUtils.isNotEmpty(commonOrgIds)) {
            /** 要求主表有orgId字段，保存单据所属组织 */
            param.getParams().put("orgId", new Parameter(QueryParam.IN, commonOrgIds));
        } else if(CollectionUtils.isNotEmpty(departmentIds)) {
            /** 要求主表有projectDepartmentId字段，保存单据所属项目部 */
            param.getParams().put("projectDepartmentId", new Parameter(QueryParam.IN, departmentIds));
        }
        /** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */

        IPage<ProductiontaskEntity> page = service.queryPage(param,false);
        IPage<ProductiontaskVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        //查询过磅数、追加后数量、本次任务单数量合计
        QueryWrapper query = new QueryWrapper();//条件构造器
        query.select("FORMAT(SUM(this_quantity),2) as thisQuantitySum, " +
                "FORMAT(SUM(afteradd_count),2) as afteraddCountSum, " +
                "FORMAT(SUM(weight_number),2) as weightNumberSum");
        query.in("org_id",commonOrgIds);
        Map<String, Object> map = service.getMap(query);
        //pageData.setRecords(BeanMapper.mapList(page.getRecords(), ProductiontaskVO.class));
        List<ProductiontaskVO> records =BeanMapper.mapList(page.getRecords(), ProductiontaskVO.class);
        records.forEach(element->{
            element.setNotDistributeCount(element.getThisQuantity().subtract(element.getDistributeCount()));
            element.setNotWeightNumber(element.getThisQuantity().subtract(element.getWeightNumber()));
            element.setThisQuantitySum(map.get("thisQuantitySum").toString().replace(",",""));
            element.setAfteraddCountSum(map.get("afteraddCountSum").toString().replace(",",""));
            element.setWeightNumberSum((map.get("weightNumberSum").toString()).replace(",",""));
        });
        pageData.setRecords(records);

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<ProductiontaskEntity> list = service.queryList(param);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("Productiontask-export.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/refProductiontaskData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<ProductiontaskVO>> refProductiontaskData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);

            String orgId = _con.getString("orgId");
            if (orgId!=null) {
                param.getParams().put("org_id", new Parameter(QueryParam.EQ, orgId));
            }
        }

        IPage<ProductiontaskEntity> page = service.queryPage(param,false);
        IPage<ProductiontaskVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), ProductiontaskVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }

    /**
     * 通过任务单id查询运输单信息
     * @param taskId
     * @return
     */
    @GetMapping(value = "queryDetailBytaskId")
    @ResponseBody
    public CommonResponse<List<ProductiontasktransportVO>> queryDetailBytaskId(@RequestParam(value = "taskId") Long taskId) {
        QueryWrapper query=new QueryWrapper();
        query.eq("task_id",taskId);
        List<ProductiontasktransportEntity> list = productiontasktransportService.list(query);
        List<ProductiontasktransportVO> map = BeanMapper.mapList(list,ProductiontasktransportVO.class);
        return CommonResponse.success("查询详情成功！", map);
    }
    /**
     * 通过产品id查询任务单累计本次生产数量信息
     * @param productId
     * @return
     */
    @GetMapping(value = "querySumCountByProductId")
    @ResponseBody
    public CommonResponse<BigDecimal> querySumCountByProductId(@RequestParam(value = "productId") Long productId) {
        BigDecimal sumCount=new BigDecimal("0");
        QueryWrapper query=new QueryWrapper();
        query.eq("product_id",productId);
        List<ProductiontaskEntity> list = service.list(query);
        if(list.size()>0){
            for (int i = 0; i < list.size(); i++) {
                ProductiontaskEntity productiontaskEntity = list.get(i);
                if (productiontaskEntity.getThisQuantity()!=null) {
                    sumCount = sumCount.add(productiontaskEntity.getThisQuantity());
                }
            }
        }

        return CommonResponse.success(sumCount);
    }

    /**
     * 通过组织id查询该组织下的所有生产任务单的任务数量合计
     * @param orgId
     * @return
     */
    @GetMapping(value = "querySumCountOrgId")
    @ResponseBody
    public CommonResponse<Map<String,Object>> querySumCountOrgId(@RequestParam(value = "orgId") Long orgId) {
        QueryWrapper query = new QueryWrapper();//条件构造器
        query.select("FORMAT(SUM(this_quantity),2) as thisQuantitySum, FORMAT(SUM(afteradd_count),2) as afteraddCountSum");
        query.eq("org_id",orgId);
        Map<String,Object> map = service.getMap(query);
        return CommonResponse.success(map);//返回最后相加的数量
    }
        /**
         * @Description saveOrUpdate 批量新增
         */
    @RequestMapping(value = "/saveList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse saveList(@RequestBody ProductiontaskVO saveOrUpdateVO) {
        List<ProductionTaskDetailVOS> productionTaskDetailVOS = saveOrUpdateVO.getProductionTaskDetailVOS();
        for (ProductionTaskDetailVOS detailVO : productionTaskDetailVOS) {
            if (!detailVO.getRowState().equals("del")) {
                if (detailVO.getThisQuantity().compareTo(new BigDecimal("0")) == 1) {
                    List<ProductiontaskdetailEntity> entities=new ArrayList<>();
                    ProductiontaskEntity entity = new ProductiontaskEntity();
                    entity.setCustomerManageId(saveOrUpdateVO.getCustomerManageId());
                    entity.setCustomerManageName(saveOrUpdateVO.getCustomerManageName());
                    entity.setProjectId(saveOrUpdateVO.getProjectId());
                    entity.setProjectName(saveOrUpdateVO.getProjectName());
                    entity.setWorksiteId(saveOrUpdateVO.getWorksiteId());
                    entity.setWorksiteName(saveOrUpdateVO.getWorksiteName());
                    entity.setPrintCustomerName(saveOrUpdateVO.getPrintCustomerName());
                    entity.setPrintWorksiteName(saveOrUpdateVO.getPrintWorksiteName());
                    entity.setPrintSupplyName(saveOrUpdateVO.getPrintSupplyName());
                    entity.setOrderName(saveOrUpdateVO.getOrderName());
                    entity.setOrderMobile(saveOrUpdateVO.getOrderMobile());
                    entity.setTransportRoute(saveOrUpdateVO.getTransportRoute());
                    entity.setOrgId(saveOrUpdateVO.getOrgId());
                    entity.setOrgName(saveOrUpdateVO.getOrgName());
                    entity.setProductId(detailVO.getProductId());
                    entity.setProductName(detailVO.getProductName());
                    entity.setPrintProductName(detailVO.getPrintProductName());
                    entity.setAsphaltSpec(detailVO.getAsphaltSpec());
                    entity.setAddCount(detailVO.getAddCount());
                    entity.setProjectTotle(detailVO.getProjectTotle());
                    entity.setOrderedQuantity(detailVO.getOrderedQuantity());
                    entity.setOrderedNot(detailVO.getOrderedNot());
                    entity.setThisQuantity(detailVO.getThisQuantity());
                    entity.setRegionId(detailVO.getRegionId());
                    entity.setRegionName(detailVO.getRegionName());
                    entity.setCountingMethod(detailVO.getCountingMethod());
                    entity.setTransportMethod(detailVO.getTransportMethod());
                    entity.setDistance(detailVO.getDistance());
                    entity.setTaskTime(detailVO.getTaskTime());
                    if (detailVO.getVarietiesId1()!=null){
                        ProductiontaskdetailEntity productiontaskdetailEntity = new ProductiontaskdetailEntity();
                        productiontaskdetailEntity.setMaterailId(detailVO.getVarietiesId1());
                        productiontaskdetailEntity.setMaterailName(detailVO.getVarietiesName1());
                        productiontaskdetailEntity.setMaterailSpecId(detailVO.getCategoryId1());
                        productiontaskdetailEntity.setMaterailSpecName(detailVO.getCategoryName1());
                        productiontaskdetailEntity.setPercent(detailVO.getThousandRate1());
                        productiontaskdetailEntity.setRowState("add");
                        entities.add(productiontaskdetailEntity);
                    }
                    if (detailVO.getVarietiesId2()!=null){
                        ProductiontaskdetailEntity productiontaskdetailEntity = new ProductiontaskdetailEntity();
                        productiontaskdetailEntity.setMaterailId(detailVO.getVarietiesId2());
                        productiontaskdetailEntity.setMaterailName(detailVO.getVarietiesName2());
                        productiontaskdetailEntity.setMaterailSpecId(detailVO.getCategoryId2());
                        productiontaskdetailEntity.setMaterailSpecName(detailVO.getCategoryName2());
                        productiontaskdetailEntity.setPercent(detailVO.getThousandRate2());
                        productiontaskdetailEntity.setRowState("add");
                        entities.add(productiontaskdetailEntity);
                    }
                    if (detailVO.getVarietiesId3()!=null){
                        ProductiontaskdetailEntity productiontaskdetailEntity = new ProductiontaskdetailEntity();
                        productiontaskdetailEntity.setMaterailId(detailVO.getVarietiesId3());
                        productiontaskdetailEntity.setMaterailName(detailVO.getVarietiesName3());
                        productiontaskdetailEntity.setMaterailSpecId(detailVO.getCategoryId3());
                        productiontaskdetailEntity.setMaterailSpecName(detailVO.getCategoryName3());
                        productiontaskdetailEntity.setPercent(detailVO.getThousandRate3());
                        productiontaskdetailEntity.setRowState("add");
                        entities.add(productiontaskdetailEntity);
                    }
                    if (!entities.isEmpty()){
                        entity.setProductiontaskdetailEntities(entities);
                    }
                    entity.setTaskStatus(1);
                    entity.setIsSmallCar("否");
                    entity.setIsIncomeMaterial("否");
                    entity.setIsSmallTonnage("否");
                    entity.setIsTransition("否");
                    entity.setIsDistributeCar(0);
                    entity.setDistributeCount(new BigDecimal("0"));
                    entity.setAfteraddCount(detailVO.getThisQuantity());
                    entity.setWeightNumber(new BigDecimal("0"));
                    BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE, InvocationInfoProxy.getTenantid(), saveOrUpdateVO);
                    CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
                    if (billCode.isSuccess()) {
                        entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
                    } else {
                        throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
                    }
                    service.saveOrUpdate(entity,false);
                }
            }
        }
        return CommonResponse.success("保存成功！");
    }
    /**
     * 通过工程id查询产品相关信息
     * @param projectId
     * @return
     */
    @GetMapping(value = "queryProductDataSourceByProductId")
    @ResponseBody
    public CommonResponse<List<ProductInfoVO>> queryProductDataSourceByProductId(@RequestParam(value = "projectId") String projectId) {

        List<ProductInfoVO> productInfoVOList=new ArrayList<>();
        List<com.ejianc.business.sale.salesorder.vo.ProductInfoVO> data = salesorderApi.getProductInfo(projectId).getData();
        if (data!=null&&!data.isEmpty()){
            for (com.ejianc.business.sale.salesorder.vo.ProductInfoVO productInfo : data) {
                BigDecimal sumCount=new BigDecimal("0");
                ProductInfoVO productInfoVO = new ProductInfoVO();
                QueryWrapper query=new QueryWrapper();
                query.eq("product_id",productInfo.getProductId());
//            计算产品对应已下数量
                List<ProductiontaskEntity> list = service.list(query);
                for (ProductiontaskEntity entity : list) {
                    if (entity.getThisQuantity()!=null) {
                        sumCount = sumCount.add(entity.getThisQuantity());
                    }
                }
                productInfoVO.setProductId(productInfo.getProductId());
                productInfoVO.setProductName(productInfo.getProductName());
                productInfoVO.setPrintProductName(productInfo.getProductName());
                productInfoVO.setAsphaltSpec(productInfo.getAsphaltSpec());
                productInfoVO.setAddCount(productInfo.getAddCount());
                productInfoVO.setProjectTotle(productInfo.getProjectTotle());
                productInfoVO.setOrderedQuantity(sumCount);
                productInfoVO.setOrderedNot(productInfo.getProjectTotle().subtract(sumCount));
                productInfoVO.setTransportMethod(productInfo.getTransportMethod());
                productInfoVO.setTaskTime(new Date());
                productInfoVO.setCategoryId1(productInfo.getCategoryId1());
                productInfoVO.setCategoryName1(productInfo.getCategoryName1());
                productInfoVO.setThousandRate1(productInfo.getThousandRate1());
                productInfoVO.setVarietiesId1(productInfo.getVarietiesId1());
                productInfoVO.setVarietiesName1(productInfo.getVarietiesName1());
                productInfoVO.setCategoryId2(productInfo.getCategoryId2());
                productInfoVO.setCategoryName2(productInfo.getCategoryName2());
                productInfoVO.setThousandRate2(productInfo.getThousandRate2());
                productInfoVO.setVarietiesId2(productInfo.getVarietiesId2());
                productInfoVO.setVarietiesName2(productInfo.getVarietiesName2());
                productInfoVO.setCategoryId3(productInfo.getCategoryId3());
                productInfoVO.setCategoryName3(productInfo.getCategoryName3());
                productInfoVO.setThousandRate3(productInfo.getThousandRate3());
                productInfoVO.setVarietiesId3(productInfo.getVarietiesId3());
                productInfoVO.setVarietiesName3(productInfo.getVarietiesName3());
                productInfoVOList.add(productInfoVO);
            }
        }
        return CommonResponse.success("获取产品信息成功",productInfoVOList);
    }
    /**
     * 关闭此单
     * @param productiontaskVO
     * @return
     */
    @Transactional
    @PostMapping(value = "closeproductiontask")
    @ResponseBody
    public CommonResponse<IPage<ProductiontaskVO>> closeProductionTask(@RequestBody ProductiontaskVO productiontaskVO) {
        ProductiontaskEntity entity = service.selectById(productiontaskVO.getId());
        entity.setTaskStatus(3);
        service.saveOrUpdate(entity, false);
        QueryWrapper query=new QueryWrapper();
        query.eq("task_id",entity.getId());
        List<UnitdistributionEntity> list = unitdistributionService.list(query);
        if (!list.isEmpty()) {
            for (UnitdistributionEntity unitdistributionEntity : list) {
                unitdistributionEntity.setProductState(2);
                unitdistributionEntity.setBillState(3);
            }
            unitdistributionService.saveOrUpdateBatch(list, list.size());
        }
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq("task_id",entity.getId());
        List<ProductiontasktransportEntity> list1 = productiontasktransportService.list(queryWrapper);
        if (!list1.isEmpty()){
            for (ProductiontasktransportEntity productiontasktransportEntity : list1) {
                logger.info("关闭生产任务单更新车辆状态传参={}" + productiontasktransportEntity.getShippersVehicleId()+"车牌号={}"+productiontasktransportEntity.getShippersVehicleCode());
                baseApi.updatestatus(productiontasktransportEntity.getShippersVehicleId(),1);
            }
        }
        //关闭生产任务单后重新查询分页数据
        LinkedHashMap<String, String> hashMap = new LinkedHashMap<>();
        hashMap.put("createTime","desc");
        QueryParam queryParam = new QueryParam();
        queryParam.setPageIndex(productiontaskVO.getPageIndex());
        queryParam.setPageSize(productiontaskVO.getPageSize());
        queryParam.setOrderMap(hashMap);
        CommonResponse<IPage<ProductiontaskVO>> iPageCommonResponse = this.queryList(queryParam);
        IPage<ProductiontaskVO> data = iPageCommonResponse.getData();
        return CommonResponse.success("关闭任务单成功",data);
    }
    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryProductionTask", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<ProductiontaskVO>> queryProductionTask(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离 本下 没有组织orgId的删除下面代码-------------开始 */
        UserContext userContextCache =sessionManager.getUserContext();
        //当前应用有权限的根orgId，以逗号分割，可据此查询其本下数据，需判空
        String authOrgIds = userContextCache.getAuthOrgIds();
        List<OrgVO> orgVOList = null;
        if(StringUtils.isNotBlank(authOrgIds)){//移动端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "查询失败，获取当前本下组织信息失败。");
        }else {//pc端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
        }
        //普通组织 id
        List<Long> commonOrgIds = new ArrayList<>();
        //项目部 id
        List<Long> departmentIds = new ArrayList<>();
        orgVOList.stream().forEach(org -> {
            if(5 == org.getOrgType()) {
                //项目部
                departmentIds.add(org.getId());
            } else {
                //普通组织
                commonOrgIds.add(org.getId());
            }
        });
        if(CollectionUtils.isNotEmpty(commonOrgIds)) {
            /** 要求主表有orgId字段，保存单据所属组织 */
            param.getParams().put("orgId", new Parameter(QueryParam.IN, commonOrgIds));
        } else if(CollectionUtils.isNotEmpty(departmentIds)) {
            /** 要求主表有projectDepartmentId字段，保存单据所属项目部 */
            param.getParams().put("projectDepartmentId", new Parameter(QueryParam.IN, departmentIds));
        }
        /** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */
        param.getParams().put("task_status", new Parameter(QueryParam.EQ, 1));
        IPage<ProductiontaskEntity> page = service.queryPage(param,false);
        IPage<ProductiontaskVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), ProductiontaskVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }
    /**
     * 通过任务单id查询运输单信息
     * @param taskId
     * @return
     */
    @GetMapping(value = "queryUnitdistribute")
    @ResponseBody
    public CommonResponse<List<UnitdistributionVO>> queryUnitdistribute(@RequestParam(value = "taskId") Long taskId) {
        QueryWrapper query=new QueryWrapper();
        query.eq("task_id",taskId);
        List<UnitdistributionEntity> list = unitdistributionService.list(query);
        List<UnitdistributionVO> map = BeanMapper.mapList(list,UnitdistributionVO.class);
        return CommonResponse.success("查询详情成功！", map);
    }
    /**
     * 取消关闭任务单
     * @param productiontaskVO
     * @return
     */
    @Transactional
    @PostMapping(value = "cancleclose")
    @ResponseBody
    public CommonResponse<IPage<ProductiontaskVO>> cancleclose(@RequestBody ProductiontaskVO productiontaskVO) {
        ProductiontaskEntity entity = service.selectById(productiontaskVO.getId());
        /**
         * 查询生产任务单下的分配车辆信息
         * 如果分配车辆信息未发货则更新分配车辆状态为2
         */
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq("task_id",entity.getId());
        List<ProductiontasktransportEntity> list1 = productiontasktransportService.list(queryWrapper);
        if (!list1.isEmpty()){
            for (ProductiontasktransportEntity productiontasktransportEntity : list1) {
                if (productiontasktransportEntity.getTransportStatue()==1){
                    logger.info("取消关闭生产任务单更新车辆状态传参={}" + productiontasktransportEntity.getShippersVehicleId()+"车牌号={}"+productiontasktransportEntity.getShippersVehicleCode());
                    baseApi.updatestatus(productiontasktransportEntity.getShippersVehicleId(),2);
                }
            }
        }
        QueryWrapper query = new QueryWrapper();
        query.eq("task_id", entity.getId());
        List<UnitdistributionEntity> list = unitdistributionService.list(query);
        if (!list.isEmpty()) {
            for (UnitdistributionEntity unitdistributionEntity : list) {
                unitdistributionEntity.setProductState(1);
                unitdistributionEntity.setBillState(0);
            }
            unitdistributionService.updateBatchById(list);
        }
        entity.setTaskStatus(2);
        entity.setBillState(0);
        service.saveOrUpdate(entity, false);
        LinkedHashMap<String, String> hashMap = new LinkedHashMap<>();
        hashMap.put("createTime","desc");
        QueryParam queryParam = new QueryParam();
        queryParam.setPageIndex(productiontaskVO.getPageIndex());
        queryParam.setPageSize(productiontaskVO.getPageSize());
        queryParam.setOrderMap(hashMap);
        CommonResponse<IPage<ProductiontaskVO>> iPageCommonResponse = this.queryList(queryParam);
        IPage<ProductiontaskVO> data = iPageCommonResponse.getData();
        return CommonResponse.success("取消关闭任务单成功",data);
    }
    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryProductionList", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<List<ProductiontaskVO>> queryProductionList(@RequestParam(value = "orgId") String orgId) {

        QueryWrapper queryWrapper=new QueryWrapper();
        queryWrapper.eq("org_id",orgId);
        queryWrapper.eq("task_status",1);
        List<ProductiontaskEntity> list = service.list(queryWrapper);
        List<ProductiontaskVO> productiontaskVOS = BeanMapper.mapList(list, ProductiontaskVO.class);

        return CommonResponse.success("查询列表数据成功！",productiontaskVOS);
    }
    /**
     * 批量关闭此单
     * @param closeTaskVO
     * @return
     */
    @Transactional
    @PostMapping(value = "closeproductiontasklist")
    @ResponseBody
    public CommonResponse<IPage<ProductiontaskVO>> closeProductionTaskList(@RequestBody CloseTaskVO closeTaskVO) {
        List<ProductiontaskEntity> productiontaskEntities = BeanMapper.mapList(closeTaskVO.getList(), ProductiontaskEntity.class);
        productiontaskEntities.forEach(element->{
            element.setTaskStatus(3);
            element.setBillState(3);
            QueryWrapper query=new QueryWrapper();
            query.eq("task_id",element.getId());
            List<UnitdistributionEntity> list = unitdistributionService.list(query);
            if (!list.isEmpty()) {
                list.forEach(el->{
                    el.setProductState(2);
                    el.setBillState(3);
                });
                unitdistributionService.saveOrUpdateBatch(list, list.size());
            }
            /**
             * 批量关闭生产任务单更新任务单下分配车辆状态为1
             */
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.eq("task_id",element.getId());
            List<ProductiontasktransportEntity> list1 = productiontasktransportService.list(queryWrapper);
            if (!list1.isEmpty()){
                for (ProductiontasktransportEntity productiontasktransportEntity : list1) {
                    logger.info("批量关闭生产任务单更新车辆状态传参={}" + productiontasktransportEntity.getShippersVehicleId()+"车牌号={}"+productiontasktransportEntity.getShippersVehicleCode());
                    baseApi.updatestatus(productiontasktransportEntity.getShippersVehicleId(),1);
                }
            }
        });
        service.saveOrUpdateBatch(productiontaskEntities,productiontaskEntities.size());
        LinkedHashMap<String, String> hashMap = new LinkedHashMap<>();
        hashMap.put("createTime","desc");
        QueryParam queryParam = new QueryParam();
        queryParam.setPageIndex(closeTaskVO.getPageIndex());
        queryParam.setPageSize(closeTaskVO.getPageSize());
        queryParam.setOrderMap(hashMap);
        CommonResponse<IPage<ProductiontaskVO>> iPageCommonResponse = this.queryList(queryParam);
        IPage<ProductiontaskVO> data = iPageCommonResponse.getData();
        return CommonResponse.success("关闭任务单成功",data);
    }
}
