package com.ejianc.business.production.controller;

import java.io.Serializable;

import com.alibaba.fastjson.JSONArray;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.base.bases.api.BaseApi;
import com.ejianc.business.base.bases.vo.UnitVO;
import com.ejianc.business.production.bean.ProductiontasktransportEntity;
import com.ejianc.business.production.bean.UnitdistributionEntity;
import com.ejianc.business.production.service.IProductiontasktransportService;
import com.ejianc.business.production.vo.ProductiontaskVO;
import com.ejianc.business.production.vo.ProductiontasktransportVO;
import com.ejianc.business.production.vo.UnitdistributionVO;
import com.ejianc.business.production.service.IUnitdistributionService;
import com.ejianc.business.production.bean.ProductiontaskEntity;
import com.ejianc.business.production.service.IProductiontaskService;

import com.ejianc.business.sale.salesorder.api.IGenerateManualshipmentApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.util.ExcelExport;
import io.seata.spring.annotation.GlobalTransactional;
import org.apache.commons.lang3.StringUtils;
import org.elasticsearch.search.aggregations.metrics.Sum;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.*;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Controller;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.*;
import org.apache.commons.collections.CollectionUtils;
import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

/**
 * 分配机组
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("unitdistribution")
public class UnitdistributionController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    @Qualifier("com.ejianc.business.base.bases.api.BaseApi")
    @Autowired
    private BaseApi baseApi;
    @Autowired
    private IProductiontaskService productiontaskService;

    private static final String BILL_CODE = "unit-distribution";//此处需要根据实际修改

    @Autowired
    private IUnitdistributionService service;
    @Autowired
    private IProductiontasktransportService productiontasktransportService;
    @Autowired
    private ProductiontaskController productiontaskController;


    @Autowired
    private SessionManager sessionManager;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @Transactional
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<UnitdistributionVO> saveOrUpdate(@RequestBody UnitdistributionVO saveOrUpdateVO) {
    	UnitdistributionEntity entity = BeanMapper.map(saveOrUpdateVO, UnitdistributionEntity.class);
        ProductiontaskEntity productiontaskEntity = productiontaskService.selectById(entity.getTaskId());
        if(entity.getId() == null || entity.getId() == 0){
            //写入分配机组生产状态
            entity.setProductState(1);
            //生成单据编号
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE,InvocationInfoProxy.getTenantid(),saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if(billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }else{
            // 分配机组追加回填追加数量
            if ( entity.getAddCount()!=null&&!(new BigDecimal(entity.getAddCount().toString()).compareTo(new BigDecimal("0"))==0) ){
                //回填分配机组追加后数量和分配数量
                entity.setAddedCount(entity.getDistributeCount().add(entity.getAddCount()));
                entity.setDistributeCount(entity.getDistributeCount().add(entity.getAddCount()));
                StringBuffer stringBuffer=null;
                if (productiontaskEntity.getAddedCount()!=null){
                    stringBuffer = new StringBuffer(productiontaskEntity.getAddedCount());
                    stringBuffer.append(";").append(entity.getAddCount().setScale(2,BigDecimal.ROUND_HALF_DOWN));
                }else {
                    stringBuffer = new StringBuffer();
                    stringBuffer.append(entity.getAddCount().setScale(2,BigDecimal.ROUND_HALF_DOWN));
                }
                //回填生产任务单追加数量  追加后数量
                productiontaskEntity.setAddedCount(stringBuffer.toString());
                productiontaskEntity.setAfteraddCount(productiontaskEntity.getAfteraddCount().add(entity.getAddCount()));
                productiontaskEntity.setDistributeCount(productiontaskEntity.getDistributeCount().add(entity.getAddCount()));
                //回填分配机组分配数量 追加后数量后将追加数量置零
                entity.setAddCount(new BigDecimal("0"));
                //判断如果分配机组生产数量大于分配车辆数量则将分配车辆状态修改为1
                if (entity.getDistributeCount().compareTo(entity.getDistributedCount())==1)
                    entity.setIsDistributeCar(1);
                if (entity.getDistributeCount().compareTo(entity.getDistributedCount())==0 || entity.getDistributeCount().compareTo(entity.getDistributedCount())==-1)
                    entity.setIsDistributeCar(2);
            }
        }
        //如果更换机组则修改分配机组所属分配车辆未发货的机组名称
        if (entity.getId()!=null){
            UnitdistributionEntity unitdistributionEntity = service.selectById(entity.getId());
            if (!unitdistributionEntity.getUnitId().equals(entity.getUnitId())){
                QueryWrapper query=new QueryWrapper();
                query.eq("unitdistribute_id",entity.getId());
                List<ProductiontasktransportEntity> list = productiontasktransportService.list(query);
                if (!list.isEmpty()){
                    list.forEach(element->{
                        if (element.getTransportStatue()==1){
                            element.setUnitId(entity.getUnitId());
                            element.setUnitName(entity.getUnitName());
                        }
                    });
                    productiontasktransportService.updateBatchById(list,list.size());
                }
            }
        }
        productiontaskService.saveOrUpdate(productiontaskEntity,false);
        //新增分配机组逻辑校验 ：根据任务单id查找所有分配机组
        service.saveOrUpdate(entity, false);
    	UnitdistributionVO vo = BeanMapper.map(entity, UnitdistributionVO.class);

    	return CommonResponse.success("保存或修改单据成功！",vo);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<UnitdistributionVO> queryDetail(Long id) {
    	UnitdistributionEntity entity = service.selectById(id);
    	UnitdistributionVO vo = BeanMapper.map(entity, UnitdistributionVO.class);
    	vo.setNotDistributeCount(vo.getDistributeCount().subtract(vo.getDistributedCount()));
    	vo.setNotWeighNumber(vo.getDistributeCount().subtract(vo.getWeighNumber()));
    	vo.setNotProductCount(vo.getDistributeCount().subtract(vo.getProductedCount()));
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @Transactional
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<UnitdistributionVO> vos) {

        if(ListUtil.isNotEmpty(vos)){
            List<ProductiontaskEntity> productiontaskEntityList=new ArrayList<>();
            for (UnitdistributionVO vo : vos) {
                UnitdistributionEntity Entity = service.selectById(vo.getId());
                ProductiontaskEntity entity1 = productiontaskService.selectById(Entity.getTaskId());
                if (3==entity1.getTaskStatus())
                    throw new BusinessException("删除数据中有已关闭生产任务单，删除失败");
                QueryWrapper<ProductiontasktransportEntity> query=new QueryWrapper();
                query.eq("unitdistribute_id",vo.getId());
                List<ProductiontasktransportEntity> list = productiontasktransportService.list(query);
                if (!list.isEmpty()){
                    List<ProductiontasktransportVO> productiontasktransportVOS = BeanMapper.mapList(list, ProductiontasktransportVO.class);
                    for (ProductiontasktransportVO productiontasktransportVO : productiontasktransportVOS) {
                        if (productiontasktransportVO.getTransportStatue()==2){
                            throw new BusinessException("删除分配机组数据中存在已经发货任务单，删除失败");
                        }else {
                            logger.info("删除分配机组更新车辆状态传参={}"+productiontasktransportVO.getShippersVehicleId()+"车牌号={}"+productiontasktransportVO.getShippersVehicleCode());
                            baseApi.updatestatus(productiontasktransportVO.getShippersVehicleId(),1);
                        }
                    }
                    productiontasktransportService.removeByIds(productiontasktransportVOS.stream().map(ProductiontasktransportVO::getId).collect(Collectors.toList()),true);
                }
                UnitdistributionEntity unitdistributionEntity = service.selectById(vo.getId());
                ProductiontaskEntity entity = productiontaskService.selectById(unitdistributionEntity.getTaskId());
                entity.setDistributeCount(entity.getDistributeCount().subtract(unitdistributionEntity.getDistributeCount()));
                entity.setTaskStatus(1);
                productiontaskEntityList.add(entity);
                // 参数是单据类型编码字符串 根据需求是否打开下面代码
                /* CommonResponse<String> resp = billTypeApi.checkQuote("billTypeCode", vo.getId());
                if(!resp.isSuccess()){
                    return CommonResponse.error("删除失败！"+resp.getMsg());
                }*/
            }
            if (!productiontaskEntityList.isEmpty())
                productiontaskService.saveOrUpdateBatch(productiontaskEntityList,productiontaskEntityList.size());
            }
        service.removeByIds(vos.stream().map(UnitdistributionVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<UnitdistributionVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("customerManageName");
        fuzzyFields.add("projectName");
        fuzzyFields.add("productName");
        fuzzyFields.add("worksiteName");
        fuzzyFields.add("unitName");
        fuzzyFields.add("taskCode");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离 本下 没有组织orgId的删除下面代码-------------开始 */
        UserContext userContextCache =sessionManager.getUserContext();
        //当前应用有权限的根orgId，以逗号分割，可据此查询其本下数据，需判空
        String authOrgIds = userContextCache.getAuthOrgIds();
        List<OrgVO> orgVOList = null;
        if(StringUtils.isNotBlank(authOrgIds)){//移动端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "查询失败，获取当前本下组织信息失败。");
        }else {//pc端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
        }
        //普通组织 id
        List<Long> commonOrgIds = new ArrayList<>();
        //项目部 id
        List<Long> departmentIds = new ArrayList<>();
        orgVOList.stream().forEach(org -> {
            if(5 == org.getOrgType()) {
                //项目部
                departmentIds.add(org.getId());
            } else {
                //普通组织
                commonOrgIds.add(org.getId());
            }
        });
        if(CollectionUtils.isNotEmpty(commonOrgIds)) {
            /** 要求主表有orgId字段，保存单据所属组织 */
            param.getParams().put("orgId", new Parameter(QueryParam.IN, commonOrgIds));
        } else if(CollectionUtils.isNotEmpty(departmentIds)) {
            /** 要求主表有projectDepartmentId字段，保存单据所属项目部 */
            param.getParams().put("projectDepartmentId", new Parameter(QueryParam.IN, departmentIds));
        }
        /** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */

        IPage<UnitdistributionEntity> page = service.queryPage(param,false);
        List<UnitdistributionEntity> records = page.getRecords();
        for (UnitdistributionEntity entity : records) {
            QueryWrapper query=new QueryWrapper();
            query.eq("unitdistribute_id",entity.getId());
            List<ProductiontasktransportEntity> list = productiontasktransportService.list(query);
            entity.setTaskTransportList(list);
        }
        IPage<UnitdistributionVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		//pageData.setRecords(BeanMapper.mapList(records, UnitdistributionVO.class));
        List<UnitdistributionVO> unitdistributionVOS = BeanMapper.mapList(records, UnitdistributionVO.class);
        unitdistributionVOS.forEach(element->{
            ProductiontaskEntity productiontaskEntity = productiontaskService.selectById(element.getTaskId());
            element.setNotWeighNumber(element.getDistributeCount().subtract(element.getWeighNumber()));
            element.setNotDistributeCount(element.getDistributeCount().subtract(element.getDistributedCount()));
            element.setNotProductCount(element.getDistributeCount().subtract(element.getProductedCount()));
            element.setDistance(productiontaskEntity.getDistance());
        });
        pageData.setRecords(unitdistributionVOS);
        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }
    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<UnitdistributionEntity> list = service.queryList(param);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("Unitdistribution-export.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/refUnitdistributionData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<UnitdistributionVO>> refUnitdistributionData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<UnitdistributionEntity> page = service.queryPage(param,false);
        IPage<UnitdistributionVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), UnitdistributionVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }
    /**
     * 页面跳转查询生产任务单
     *
     * @param taskId
     * @return
     */
    @GetMapping(value = "queryDetailBytaskId")
    @ResponseBody
    public CommonResponse<UnitdistributionVO> queryDetailBytaskId(@RequestParam(value = "taskId") Long taskId) {
        ProductiontaskEntity entity = productiontaskService.selectById(taskId);
        UnitdistributionEntity unitdistributionEntity=new UnitdistributionEntity();
        unitdistributionEntity.setTaskId(entity.getId());
        unitdistributionEntity.setTaskCode(entity.getBillCode());
        unitdistributionEntity.setProductId(entity.getProductId());
        unitdistributionEntity.setProductName(entity.getProductName());
        unitdistributionEntity.setCustomerManageId(entity.getCustomerManageId());
        unitdistributionEntity.setCustomerManageName(entity.getCustomerManageName());
        unitdistributionEntity.setProjectId(entity.getProjectId());
        unitdistributionEntity.setProjectName(entity.getProjectName());
        unitdistributionEntity.setProductId(entity.getProductId());
        unitdistributionEntity.setProductName(entity.getProductName());
        unitdistributionEntity.setWorksiteId(entity.getWorksiteId());
        unitdistributionEntity.setWorksiteName(entity.getWorksiteName());
        unitdistributionEntity.setOrgId(entity.getOrgId());
        unitdistributionEntity.setOrgName(entity.getOrgName());
        unitdistributionEntity.setSatrtTime(entity.getTaskTime());
        unitdistributionEntity.setQuantity(entity.getThisQuantity());
        UnitdistributionVO unitdistributionVO=BeanMapper.map(unitdistributionEntity,UnitdistributionVO.class);
        return CommonResponse.success("查询详情成功！", unitdistributionVO);
    }

    /**
     * 分配机组保存
     * @param params
     * @return CommonResponse<List<UnitdistributionVO>>
     * @throws ParseException
     */
    @Transactional
    @PostMapping(value = "distributeUnit")
    @ResponseBody
    public CommonResponse<IPage<ProductiontaskVO>> distributeUnit(@RequestBody String params) throws ParseException {
        JSONObject object = JSONObject.parseObject(params);
        Long taskId = object.getLong("taskId");
        String orgId = object.getString("orgId");
        JSONArray unitArray = object.getJSONArray("unit");
        ProductiontaskEntity productiontaskEntity = productiontaskService.selectById(taskId);
        QueryWrapper queryWrapper=new QueryWrapper();
        queryWrapper.eq("org_id",orgId);
        int i = service.count(queryWrapper)+1;
        List<UnitdistributionVO> unitdistributionList=new ArrayList<>();
        List<Map> maps = unitArray.toJavaList(Map.class);
        BigDecimal sum = new BigDecimal("0");
        for (Map map : maps) {
            UnitdistributionVO unitdistributionVO = new UnitdistributionVO();
            if (new BigDecimal(map.get("distributeCount").toString()).compareTo(new BigDecimal("0"))==1){
                unitdistributionVO.setTaskId(productiontaskEntity.getId());
                unitdistributionVO.setTaskCode(productiontaskEntity.getBillCode());
                unitdistributionVO.setCustomerManageId(productiontaskEntity.getCustomerManageId());
                unitdistributionVO.setCustomerManageName(productiontaskEntity.getCustomerManageName());
                unitdistributionVO.setProjectId(productiontaskEntity.getProjectId());
                unitdistributionVO.setProjectName(productiontaskEntity.getProjectName());
                unitdistributionVO.setProductId(productiontaskEntity.getProductId());
                unitdistributionVO.setProductName(productiontaskEntity.getProductName());
                unitdistributionVO.setWorksiteId(productiontaskEntity.getWorksiteId());
                unitdistributionVO.setWorksiteName(productiontaskEntity.getWorksiteName());
                unitdistributionVO.setQuantity(productiontaskEntity.getThisQuantity());
                unitdistributionVO.setTenantId(productiontaskEntity.getTenantId());
                unitdistributionVO.setOrgId(productiontaskEntity.getOrgId());
                unitdistributionVO.setOrgName(productiontaskEntity.getOrgName());
                unitdistributionVO.setProductState(1);
                unitdistributionVO.setVersion(1);
                unitdistributionVO.setUnitId(Long.valueOf(map.get("unitId").toString()));
                unitdistributionVO.setUnitName(map.get("unitName").toString());
                if (map.get("satrtTime").toString().contains("T")){
                    unitdistributionVO.setSatrtTime(new SimpleDateFormat("yyyy-MM-dd HH:mm").parse(map.get("satrtTime").toString().replace("T"," ").replace("Z","")));
                }else {
                    unitdistributionVO.setSatrtTime(new SimpleDateFormat("yyyy-MM-dd HH:mm").parse(map.get("satrtTime").toString()));
                }
                unitdistributionVO.setEndTime(new Date(map.get("endTime").toString()));
                unitdistributionVO.setDistributeCount(new BigDecimal(map.get("distributeCount").toString()));
                unitdistributionVO.setAddCount(new BigDecimal("0"));
                unitdistributionVO.setAddedCount(new BigDecimal("0").add(new BigDecimal((String) map.get("distributeCount"))));
                unitdistributionVO.setWeighNumber(new BigDecimal("0"));
                unitdistributionVO.setProductedCount(new BigDecimal("0"));
                unitdistributionVO.setTaskTime(productiontaskEntity.getTaskTime());
                unitdistributionVO.setIsDistributeCar(1);
                unitdistributionVO.setSort(i);
                unitdistributionVO.setDistributedCount(new BigDecimal("0"));
                unitdistributionVO.setDistance(productiontaskEntity.getDistance());
                BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE,InvocationInfoProxy.getTenantid(),unitdistributionVO);
                CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
                if(billCode.isSuccess()) {
                    unitdistributionVO.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
                }else{
                    throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
                }
                sum = sum.add(new BigDecimal((String) map.get("distributeCount")));
                unitdistributionList.add(unitdistributionVO);
                i++;
            }
        }
        if (productiontaskEntity.getDistributeCount()!=null){
            sum=sum.add(productiontaskEntity.getDistributeCount());
        }
        productiontaskEntity.setDistributeCount(sum);
        if (sum.compareTo(productiontaskEntity.getThisQuantity())==0){
            productiontaskEntity.setTaskStatus(2);
        }
        List<UnitdistributionEntity> unitdistributionEntityList = BeanMapper.mapList(unitdistributionList, UnitdistributionEntity.class);
        service.saveOrUpdateBatch(unitdistributionEntityList, unitdistributionEntityList.size());
        productiontaskService.saveOrUpdate(productiontaskEntity,false);
        return CommonResponse.success("分配机组成功",productiontaskController.queryList(this.genaretorQueryParam("task_status")).getData());
    }

    /**
     * 查询机组相关数据
     * @return
     */
    @GetMapping(value = "queryUnit")
    @ResponseBody
    public CommonResponse<List<UnitVO>> queryUnit(String orgId){
        List<UnitVO> unitVOS = baseApi.queryUnit(orgId);
        if (!unitVOS.isEmpty()){
            for (UnitVO unitVO : unitVOS) {
                QueryWrapper query=new QueryWrapper();
                query.eq("unit_id",unitVO.getId());
                query.orderByDesc("end_time");
                List<UnitdistributionEntity> list = service.list(query);
                if (!list.isEmpty()){
                    UnitdistributionEntity unitdistributionEntity = list.get(0);
                    unitVO.setStartTime(unitdistributionEntity.getEndTime());
                }
            }
        }
        return CommonResponse.success("查询机组数据成功 ",unitVOS);
    }

    /**
     * 更换机组时如果未生产数量不为空并且大于0时
     * 插入一条分配机组数据
     * @param unitdistributionVO
     * @return
     */
    private CommonResponse<UnitdistributionVO> insertUnitDistribute(UnitdistributionVO unitdistributionVO){
        QueryWrapper queryWrapper=new QueryWrapper();
        queryWrapper.eq("org_id",unitdistributionVO.getOrgId());
        List<UnitdistributionEntity> list = service.list(queryWrapper);
        Integer i=list.size()+1;
        UnitdistributionVO VO = new UnitdistributionVO();
        VO.setUnitId(unitdistributionVO.getUnitId());
        VO.setUnitName(unitdistributionVO.getUnitName());
        VO.setTaskId(unitdistributionVO.getTaskId());
        VO.setTaskCode(unitdistributionVO.getTaskCode());
        VO.setSatrtTime(unitdistributionVO.getSatrtTime());
        VO.setEndTime(unitdistributionVO.getEndTime());
        VO.setDistributeCount(unitdistributionVO.getNotProductCount());
        VO.setOrgId(unitdistributionVO.getOrgId());
        VO.setOrgName(unitdistributionVO.getOrgName());
        VO.setProductId(unitdistributionVO.getProductId());
        VO.setProductName(unitdistributionVO.getProductName());
        VO.setProjectId(unitdistributionVO.getProjectId());
        VO.setProjectName(unitdistributionVO.getProjectName());
        VO.setCustomerManageId(unitdistributionVO.getCustomerManageId());
        VO.setCustomerManageName(unitdistributionVO.getCustomerManageName());
        VO.setWorksiteId(unitdistributionVO.getWorksiteId());
        VO.setWorksiteName(unitdistributionVO.getWorksiteName());
        VO.setQuantity(unitdistributionVO.getQuantity());
        VO.setWeighNumber(new BigDecimal("0"));
        VO.setNotWeighNumber(new BigDecimal("0"));
        VO.setAddCount(new BigDecimal("0"));
        VO.setAddedCount(unitdistributionVO.getDistributeCount());
        VO.setSort(i);
        VO.setProductState(1);
        VO.setIsDistributeCar(1);
        BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE,InvocationInfoProxy.getTenantid(),VO);
        CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
        if(billCode.isSuccess()) {
            VO.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
        }else{
            throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
        }
        UnitdistributionEntity entity = BeanMapper.map(VO, UnitdistributionEntity.class);
        service.saveOrUpdate(entity,false);
        UnitdistributionVO map = BeanMapper.map(entity, UnitdistributionVO.class);
        return CommonResponse.success(map);
    }

    /**
     * 移动分配机组数据时重新排序数据序号
     * 
     * @param unitDistributeId
     * @param state
     * @return
     */
    @GetMapping(value = "updatesort")
    @ResponseBody
    public CommonResponse<List<UnitdistributionVO>> updateSort(@RequestParam(value = "unitDistributeId") Long unitDistributeId,@RequestParam(value = "state") Integer state) {
        List<UnitdistributionEntity> list = new ArrayList<>();
        if (state==1){
            UnitdistributionEntity unitdistributionEntity = service.selectById(unitDistributeId);
            QueryWrapper queryWrapper=new QueryWrapper();
            queryWrapper.eq("org_id",unitdistributionEntity.getOrgId());
            queryWrapper.eq("unit_id",unitdistributionEntity.getUnitId());
            queryWrapper.orderByDesc("sort");
            List<UnitdistributionEntity> list1 = service.list(queryWrapper);
            Integer i = 0;
            for (UnitdistributionEntity entity : list1) {
                UnitdistributionEntity unitdistributionEntity1 = list1.get(i);
                if (unitdistributionEntity.getId().equals(unitdistributionEntity1.getId())){
                    break;
                }
                i++;
            }
            UnitdistributionEntity entity = list1.get(i - 1);
            Integer sort = entity.getSort();
            Integer sort1 = unitdistributionEntity.getSort();
            unitdistributionEntity.setSort(sort);
            entity.setSort(sort1);
            list.add(entity);
            list.add(unitdistributionEntity);
            service.saveOrUpdateBatch(list,list.size());
        }else if (state==2){
            UnitdistributionEntity unitdistributionEntity = service.selectById(unitDistributeId);
            QueryWrapper queryWrapper=new QueryWrapper();
            queryWrapper.eq("org_id",unitdistributionEntity.getOrgId());
            queryWrapper.eq("unit_id",unitdistributionEntity.getUnitId());
            queryWrapper.orderByDesc("sort");
            List<UnitdistributionEntity> list1 = service.list(queryWrapper);
            Integer i = 0;
            for (UnitdistributionEntity entity : list1) {
                UnitdistributionEntity unitdistributionEntity1 = list1.get(i);
                if (unitdistributionEntity.getId().equals(unitdistributionEntity1.getId())){
                    break;
                }
                i++;
            }
            UnitdistributionEntity entity = list1.get(i + 1);
            Integer sort = entity.getSort();
            Integer sort1 = unitdistributionEntity.getSort();
            unitdistributionEntity.setSort(sort);
            entity.setSort(sort1);
            list.add(entity);
            list.add(unitdistributionEntity);
            service.saveOrUpdateBatch(list,list.size());
        }else if (state==3){
            UnitdistributionEntity unitdistributionEntity = service.selectById(unitDistributeId);
            QueryWrapper queryWrapper=new QueryWrapper();
            queryWrapper.eq("org_id",unitdistributionEntity.getOrgId());
            queryWrapper.ne("id",unitdistributionEntity.getId());
            queryWrapper.orderByDesc("sort");
            List<UnitdistributionEntity> list1 = service.list(queryWrapper);
            Integer i=list1.size();
            for (UnitdistributionEntity entity : list1) {
                entity.setSort(i);
                i--;
            }
            unitdistributionEntity.setSort(list1.size()+1);
            list1.add(unitdistributionEntity);
            service.saveOrUpdateBatch(list1,list1.size());
        }
        else if (state==4){
            UnitdistributionEntity unitdistributionEntity = service.selectById(unitDistributeId);
            QueryWrapper queryWrapper=new QueryWrapper();
            queryWrapper.eq("org_id",unitdistributionEntity.getOrgId());
            queryWrapper.ne("id",unitdistributionEntity.getId());
            queryWrapper.orderByAsc("sort");
            List<UnitdistributionEntity> list1 = service.list(queryWrapper);
            Integer i=2;
            for (UnitdistributionEntity entity : list1) {
                entity.setSort(i);
                i++;
            }
            unitdistributionEntity.setSort(1);
            list1.add(unitdistributionEntity);
            service.saveOrUpdateBatch(list1,list1.size());
        }
        return CommonResponse.success("操作成功");
    }


    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/save", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<UnitdistributionVO> save(@RequestBody UnitdistributionVO saveOrUpdateVO) {
        UnitdistributionVO unitdistributionVO = service.distribuetCar(saveOrUpdateVO);
        List<ProductiontasktransportVO> taskTransportList = saveOrUpdateVO.getTaskTransportList();
        for (ProductiontasktransportVO productiontasktransportVO : taskTransportList) {
            //分配车辆修改删除数据回填分配机组的分配车辆预计发货重量
            if (productiontasktransportVO.getId()!=null&&"del".equals(productiontasktransportVO.getRowState())){
                logger.info("删除分配车辆更新车辆状态传参={}"+productiontasktransportVO.getShippersVehicleId()+"车牌号={}"+productiontasktransportVO.getShippersVehicleCode());
                baseApi.updatestatus(productiontasktransportVO.getShippersVehicleId(),1);
            }
            //分配车辆如果不是多任务则修改车辆状态为2
            if ("否".equals(productiontasktransportVO.getIsMoreProject())&&productiontasktransportVO.getShippersVehicleId()!=null&&"add".equals(productiontasktransportVO.getRowState())) {
                logger.info("新增分配车辆更新车辆状态传参={}" + productiontasktransportVO.getShippersVehicleId()+"车牌号={}"+productiontasktransportVO.getShippersVehicleCode());
                baseApi.updatestatus(productiontasktransportVO.getShippersVehicleId(), 2);
            }
        }
        return CommonResponse.success("保存或修改单据成功！",unitdistributionVO);
    }
    /**
     * 构造分页查询参数
     * @return
     */
    private QueryParam genaretorQueryParam(String state){
        QueryParam queryParam = new QueryParam();
        LinkedHashMap<String, String> orderMap = new LinkedHashMap<>();
        orderMap.put("create_time","desc");
        queryParam.setPageSize(50);
        queryParam.setPageIndex(1);
        queryParam.setOrderMap(orderMap);
        Parameter parameter = new Parameter();
        parameter.setType("eq");
        parameter.setValue(1);
        Map<String, Parameter> map = new HashMap<>();
        map.put(state,parameter);

        queryParam.setParams(map);
        return queryParam;
    }

}
