package com.ejianc.business.production.controller.api;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.production.bean.ProductiontasktransportEntity;
import com.ejianc.business.production.bean.UnitdistributionEntity;
import com.ejianc.business.production.service.IProductiontasktransportService;
import com.ejianc.business.production.service.IUnitdistributionService;
import com.ejianc.business.production.task.vo.ProductionCarVO;
import com.ejianc.business.production.task.vo.ProductionTaskVO;
import com.ejianc.business.production.task.vo.ProductionUnitVO;
import com.ejianc.business.production.utils.CurrentUtils;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * @authoer:禹鹏杰
 * @createDate:2022/8/22
 * @description:同步分配机组和分配车辆数据查询接口
 */
@RestController
@RequestMapping("/api/production/queryApi")
public class SynchronizedDataApi {
    @Autowired
    private IProductiontasktransportService productiontasktransportService;
    @Autowired
    private IUnitdistributionService unitdistributionService;

    /**
     * 查询分配机组相关数据
     * @param orgId
     * @return
     */
    @GetMapping(value = "/queryunitdistribute")
    @ResponseBody
    public CommonResponse<List<ProductionUnitVO>> queryUnitdistribute(Long orgId){
        String startTime = new CurrentUtils().getStartTime();
        String endTime = new CurrentUtils().getEndTime();
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq("org_id",orgId);
        queryWrapper.ge("create_time",startTime);
        queryWrapper.le("create_time",endTime);
        List<UnitdistributionEntity> list = unitdistributionService.list(queryWrapper);
        List<ProductionUnitVO> productionUnitVOS = BeanMapper.mapList(list, ProductionUnitVO.class);
        return CommonResponse.success("查询数据成功",productionUnitVOS);
    }

    /**
     * 查询分配车辆相关数据
     * @param orgId
     * @return
     */
    @GetMapping(value = "/queryunitdistributecar")
    @ResponseBody
    public CommonResponse<List<ProductionCarVO>> queryUnitdistributeCar(Long orgId){
        String startTime = new CurrentUtils().getStartTime();
        String endTime = new CurrentUtils().getEndTime();
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq("org_id",orgId);
        queryWrapper.ge("create_time",startTime);
        queryWrapper.le("create_time",endTime);
        List<ProductiontasktransportEntity> list = productiontasktransportService.list(queryWrapper);
        List<ProductionCarVO> productionCarVOS = BeanMapper.mapList(list, ProductionCarVO.class);
        return CommonResponse.success("查询数据成功",productionCarVOS);
    }
}
