package com.ejianc.business.production.controller.api;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.base.bases.api.BaseApi;
import com.ejianc.business.production.bean.ProductiontaskEntity;
import com.ejianc.business.production.bean.ProductiontasktransportEntity;
import com.ejianc.business.production.bean.UnitdistributionEntity;
import com.ejianc.business.production.service.IProductiontaskService;
import com.ejianc.business.production.service.IProductiontasktransportService;
import com.ejianc.business.production.service.IUnitdistributionService;
import com.ejianc.business.production.task.vo.ProductionOrderVO;
import com.ejianc.business.production.task.vo.TasktransportVO;
import com.ejianc.business.production.vo.ProductiontasktransportVO;
import com.ejianc.business.production.vo.UnitdistributionVO;
import com.ejianc.business.vehiclemanagement.controller.api.VehicleTypeApi;
import com.ejianc.business.vehiclemanagement.task.api.IVehicleTypeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.web.bind.annotation.*;

import java.util.ArrayList;
import java.util.List;

/**
 * @authoer:冯国安
 * @createDate:2022/9/22
 * @description:
 */
@RestController
@RequestMapping("/no_auth/api/production/vehicleSchedulingApi")
public class VehicleSchedulingApi {

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IUnitdistributionService unitdistributionService;
    @Autowired
    private IProductiontasktransportService productiontasktransportService;
    @Qualifier("com.ejianc.business.vehiclemanagement.task.api.IVehicleTypeApi")
    @Autowired
    private IVehicleTypeApi VehicleTypeApi;
    @Autowired
    private IProductiontaskService productiontaskService;


    /**
     * 根据组织查询任务单信息
     * @param orgId -- 组织id  status -- 类型 0-已分配  1-未分配
     * @return
     */
    @RequestMapping(value = "/queryOrder", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<List<ProductionOrderVO>> queryOrder(@RequestParam Long orgId, Integer status){
        //创建条件构造器
        QueryWrapper<UnitdistributionEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("org_id",orgId);
        queryWrapper.eq("is_add_car",0);
        if(status == 0){
            queryWrapper.eq("is_distribute_car",2);
        }else if(status == 1){
            queryWrapper.eq("is_distribute_car",1);
        }
        //根据组织id和是否中栋派车字段查询
        List<UnitdistributionEntity> lsit = unitdistributionService.list(queryWrapper);
        List<ProductionOrderVO> orderList = BeanMapper.mapList(lsit,ProductionOrderVO.class);
        orderList.forEach(element->{
            ProductiontaskEntity productiontaskEntity = productiontaskService.selectById(element.getTaskId());
            element.setNotWeighNumber(element.getDistributeCount().subtract(element.getWeighNumber()));
            element.setNotDistributeCount(element.getDistributeCount().subtract(element.getDistributedCount()));
            element.setNotProductCount(element.getDistributeCount().subtract(element.getProductedCount()));
            element.setDistance(productiontaskEntity.getDistance());
        });
        return CommonResponse.success("查询成功",orderList);
    }
    /**
     * 查询分配机组下的分配车辆信息
     * @param unitdistributeId 分配机组主键id
     * @return 分配车辆信息列表
     */
    @GetMapping(value = "/queryunitdistributedetail")
    @ResponseBody
    public CommonResponse<List<TasktransportVO>> queryUnitdistributeDetail(@RequestParam(value = "unitdistributeId") Long unitdistributeId){
        QueryWrapper<ProductiontasktransportEntity> query = new QueryWrapper<>();
        query.eq("unitdistribute_id",unitdistributeId);
        List<ProductiontasktransportEntity> list = productiontasktransportService.list(query);
        List<TasktransportVO> voList=new ArrayList<>();
        if (!list.isEmpty()){
            voList = BeanMapper.mapList(list, TasktransportVO.class);
        }
        return CommonResponse.success("查询生产任务单相关信息成功",voList);
    }
    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/save", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<ProductionOrderVO> save(@RequestBody ProductionOrderVO saveOrUpdateVO) {
        UnitdistributionVO vo = BeanMapper.map(saveOrUpdateVO,UnitdistributionVO.class);
        UnitdistributionVO unitdistributionVO = unitdistributionService.distribuetCar(vo);
        List<ProductiontasktransportVO> taskTransportList = BeanMapper.mapList(saveOrUpdateVO.getTaskTransportList(),ProductiontasktransportVO.class);
        for (ProductiontasktransportVO productiontasktransportVO : taskTransportList) {
            //分配车辆修改删除数据回填分配机组的分配车辆预计发货重量
            if (productiontasktransportVO.getId()!=null&&"del".equals(productiontasktransportVO.getRowState())){
                logger.info("删除分配车辆更新车辆状态传参={}"+productiontasktransportVO.getShippersVehicleId()+"车牌号={}"+productiontasktransportVO.getShippersVehicleCode());
                VehicleTypeApi.updateVehicleStatus(productiontasktransportVO.getShippersVehicleId(),1);
            }
            //分配车辆如果不是多任务则修改车辆状态为2
            if ("否".equals(productiontasktransportVO.getIsMoreProject())&&productiontasktransportVO.getShippersVehicleId()!=null&&"add".equals(productiontasktransportVO.getRowState())) {
                logger.info("新增分配车辆更新车辆状态传参={}" + productiontasktransportVO.getShippersVehicleId()+"车牌号={}"+productiontasktransportVO.getShippersVehicleCode());
                VehicleTypeApi.updateVehicleStatus(productiontasktransportVO.getShippersVehicleId(),1);
            }
            if(productiontasktransportVO.getId()!=null&&"edit".equals(productiontasktransportVO.getRowState())){
                logger.info("新增分配车辆更新车辆状态传参={}" + productiontasktransportVO.getShippersVehicleId()+"车牌号={}"+productiontasktransportVO.getShippersVehicleCode());
                ProductiontasktransportEntity entity = productiontasktransportService.selectById(productiontasktransportVO.getId());
                if(entity != null){
                    VehicleTypeApi.updateVehicleStatus(entity.getShippersVehicleId(),1);
                }
                VehicleTypeApi.updateVehicleStatus(productiontasktransportVO.getShippersVehicleId(),0);
            }
        }
        ProductionOrderVO productionOrderVO = BeanMapper.map(unitdistributionVO,ProductionOrderVO.class);
        return CommonResponse.success("保存或修改单据成功！",productionOrderVO);
    }
}
