package com.ejianc.business.production.excel;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.production.utils.DateUtil;
import com.ejianc.business.production.bean.ProductiontaskEntity;
import com.ejianc.business.production.bean.SiteorderEntity;
import com.ejianc.business.production.service.IProductiontaskService;
import com.ejianc.business.production.service.ISiteorderService;
import com.ejianc.business.production.vo.ProductiontaskVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.core.util.ImportTemplate;
import com.ejianc.support.idworker.util.IdWorker;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.ParseException;
import java.util.*;

/**
 * 生产任务单的导入导出
 */
@Controller
@RequestMapping("productiontaskExcel")
public class ExcelProductiontaskController implements Serializable {
    private static final long serialVersionUID = 1L;
    @Autowired
    private ISiteorderService iSiteorderService;
    @Autowired
    private IProductiontaskService service;
    @Autowired
    private IBillCodeApi billCodeApi;

    private static final String BILL_CODE = "production-task";//此处需要根据实际修改

    /**
     * 导入模板下载
     *
     * @param request
     * @param response
     */
    @RequestMapping(value = "/downloadProductiontask")
    @ResponseBody
    public void downloadProductiontask(HttpServletRequest request, HttpServletResponse response) {
        ImportTemplate.initialize(response);
        ImportTemplate.templetdownload(request, "Productiontask-import.xlsx", "生产任务单导入模板");
    }

    /**
     * excel导入
     *
     * @param request
     * @param response
     * @return
     */
    @RequestMapping(value = "/excelImportProductiontask", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<Object> excelImportProductiontask(HttpServletRequest request, HttpServletResponse response) throws ParseException {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest) request;
        Map<String, MultipartFile> fileMap = multipartRequest.getFileMap();
//        返回导入合法的数据的VO
        List<ProductiontaskVO> successList = new ArrayList<>();
//        返回导入数据不合法的VO
        List<ProductiontaskVO> errorList = new ArrayList<>();
        HashMap<String, String> map = new HashMap<>();
        boolean isFailed = false;
        MultipartFile mf = null;
//        校验导入文件合法性
        for (Map.Entry<String, MultipartFile> entity : fileMap.entrySet()) {
            mf = entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt(originalFileName, false);
            if (!"xls".equals(extName) && !"xlsx".equals(extName)) {
                isFailed = true;
                break;
            }
        }
        if (isFailed) {
            return CommonResponse.error("文件格式不合法");
        } else {
//            读取导入excel文件的数据
            List<List<String>> result = ExcelReader.readExcel(mf);
            if (result.size() > 0) {
                for (int i = 1; i < result.size(); i++) {
//                    获取导入数据的每一条数据校验合法性
                    List<String> data = result.get(i);
                    ProductiontaskVO VO = new ProductiontaskVO();
//                    具体逻辑 data.get（index）为获取某个单元格的数据
                    VO.setId(IdWorker.getId());
                    VO.setOldTaskCode(StringUtils.isNotBlank(data.get(0)) ? data.get(0) : null);
                    VO.setTaskTime(StringUtils.isNotBlank(data.get(1)) ? DateUtil.DoubleToDate(Double.valueOf(data.get(1))) : null);
//                    VO.setCustomerManageId(Long.parseLong(StringUtils.isNotBlank(data.get(2)) ? data.get(2) : null));
                    VO.setCustomerManageName(StringUtils.isNotBlank(data.get(2)) ? data.get(2) : null);
                    VO.setProjectName(StringUtils.isNotBlank(data.get(3)) ? data.get(3) : null);
                    VO.setProductName(StringUtils.isNotBlank(data.get(4)) ? data.get(4) : null);
                    VO.setAsphaltSpec(StringUtils.isNotBlank(data.get(5)) ? data.get(5) : null);
                    VO.setAddCount(StringUtils.isNotBlank(data.get(6)) ? data.get(6) : null);
                    VO.setWorksiteName(StringUtils.isNotBlank(data.get(7)) ? data.get(7) : null);
                    VO.setTransportMethod(StringUtils.isNotBlank(data.get(8)) ? data.get(8) : null);
                    VO.setThisQuantity(StringUtils.isNotBlank(data.get(9)) ? new BigDecimal(data.get(9)) : null);
                    VO.setDistributeCount(StringUtils.isNotBlank(data.get(10)) ? new BigDecimal(data.get(10)) : null);
                    VO.setAddedCount(StringUtils.isNotBlank(data.get(11)) ? data.get(11) : null);
                    VO.setAfteraddCount(StringUtils.isNotBlank(data.get(12)) ? new BigDecimal(data.get(12)) : null);
                    VO.setWeightNumber(StringUtils.isNotBlank(data.get(13)) ? new BigDecimal(data.get(13)) : null);
                    VO.setOrderName(StringUtils.isNotBlank(data.get(14)) ? data.get(14) : null);
                    VO.setOrderMobile(StringUtils.isNotBlank(data.get(15)) ? data.get(15) : null);
                    VO.setTransportRoute(StringUtils.isNotBlank(data.get(16)) ? data.get(16) : null);
                    VO.setDistance(StringUtils.isNotBlank(data.get(17)) ? new BigDecimal(data.get(17)) : null);
                    VO.setOrgName(StringUtils.isNotBlank(data.get(18)) ? data.get(18) : null);
                    VO.setProjectTotle(StringUtils.isNotBlank(data.get(19)) ? new BigDecimal(data.get(19)) : null);
                    VO.setOrderedQuantity(StringUtils.isNotBlank(data.get(20)) ? new BigDecimal(data.get(20)) : null);
                    VO.setOrderedNot(StringUtils.isNotBlank(data.get(21)) ? new BigDecimal(data.get(21)) : null);
                    VO.setOrderedNot(StringUtils.isNotBlank(data.get(21)) ? new BigDecimal(data.get(21)) : null);
                    if ("已创建".equals(data.get(22))) {
                        VO.setTaskStatus(1);//已创建
                    } else if ("已分配 ".equals(data.get(22))) {
                        VO.setTaskStatus(2);//已分配
                    } else if ("已关闭 ".equals(data.get(22))) {
                        VO.setTaskStatus(3);//已关闭
                    }
                    VO.setCreateTime(new Date());
//                    每一条数据都要设置租户id
                    VO.setTenantId(InvocationInfoProxy.getTenantid());
//                    每一条数据设置组织id
                    VO.setOrgId(InvocationInfoProxy.getOrgId());
//                    每一条数据设置创建人
                    VO.setCreateUserCode(InvocationInfoProxy.getUsercode());
//                    每一条数据设置创建时间
                    VO.setCreateTime(new Date());
//                    校验每一个单元格的合法性 如不能为空 或重复性校验
                    if (StringUtils.isEmpty(data.get(2)) || data.get(2) == null) {
//                        如果不合法设置错误信息
                        VO.setErrorMsg("'客户'不能为空！");
//                        添加到不合法信息数据的VO里
                        errorList.add(VO);
//                        退出本次循环
                        continue;
                    }
//                    else {
//                        QueryWrapper query = new QueryWrapper();
//                        query.eq("product_name", data.get(7));
////                        query.eq("org_id", InvocationInfoProxy.getOrgId());
//                        SiteorderEntity entity = iSiteorderService.getOne(query);
//                        if (entity != null && (entity.getId() != null || entity.getId() != 0)) {
//                            VO.setProjectId(entity.getId());
//                        } else {
//                            VO.setErrorMsg("工地名称库未查找到工地名称，请检查！");
//                            errorList.add(VO);
//                            continue;
//                        }
//                    }
//                    if (StringUtils.isEmpty(data.get(3)) || data.get(3) == null) {
//                        VO.setErrorMsg("'工程名称'不能为空！");
//                        errorList.add(VO);
//                        continue;
//                    }
//                    if (StringUtils.isEmpty(data.get(1)) || data.get(1) == null) {
//                        VO.setErrorMsg("'供应商名称'不能为空！");
//                        errorList.add(VO);
//                        continue;
//                    }
//                    if (StringUtils.isEmpty(data.get(2)) || data.get(2) == null) {
//                        VO.setErrorMsg("'扣率名称'不能为空！");
//                        errorList.add(VO);
//                        continue;
//                    }
//                    else {
//                        QueryWrapper query=new QueryWrapper();
//                        query.eq("bank_code",data.get(2));
//                        query.eq("org_id",InvocationInfoProxy.getOrgId());
//                        MaterialdiscountrateEntity entity = service.getOne(query);
//                        if (entity!=null&&(entity.getId()!=null|| entity.getId() != 0)){
//                            VO.setErrorMsg("查重校验:'银行账号'已存在，请检查！");
//                            errorList.add(VO);
//                            continue;
//                        }
//                    }
//                  如果校验合法 将这条数据放入合法的list里面
                    successList.add(VO);
                }
//                插入保存逻辑 当不合法的数据为空时才插入保存到数据库
                if (errorList.size() == 0) {
//                    如果都合法 将所有的合法数据由VO转换为Entity进行批量保存 如果涉及到子表则需要主表和子表分开保存
                    List<ProductiontaskEntity> productiontaskEntities = BeanMapper.mapList(successList, ProductiontaskEntity.class);
//                    循环生产每条导入数据的单据编号
                    for (ProductiontaskEntity entity : productiontaskEntities) {
                        ProductiontaskVO VO = BeanMapper.map(entity, ProductiontaskVO.class);
                        BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE, InvocationInfoProxy.getTenantid(), VO);
                        CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
                        if (billCode.isSuccess()) {
                            entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者下一行
                        }
                    }
                    service.saveBatch(productiontaskEntities, successList.size());
                }
            }
        }
        JSONObject json = new JSONObject();
        json.put("successNum", successList.size());
        json.put("successList", successList);
        json.put("errorList", errorList);
        json.put("errorNum", errorList.size());
        return CommonResponse.success(json);
    }
}
