package com.ejianc.business.production.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.production.bean.ProductiontaskEntity;
import com.ejianc.business.production.bean.ProductiontasktransportEntity;
import com.ejianc.business.production.bean.UnitdistributionEntity;
import com.ejianc.business.production.mapper.ProductiontasktransportMapper;
import com.ejianc.business.production.vo.ProductiontaskVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.production.service.IProductiontasktransportService;

import java.util.Date;
import java.util.List;

/**
 * 任务单运输信息
 * 
 * @author generator
 * 
 */
@Service("productiontasktransportService")
public class ProductiontasktransportServiceImpl extends BaseServiceImpl<ProductiontasktransportMapper, ProductiontasktransportEntity> implements IProductiontasktransportService{
    @Autowired
    private IProductiontasktransportService service;

    /**
     * 分配车辆初始化生产任务单相关数据
     * @param productiontaskVO
     * @return
     */
    @Override
    public boolean initProductionTask(ProductiontaskVO productiontaskVO) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq("task_id",productiontaskVO.getId());
        List<ProductiontasktransportEntity> list = service.list(queryWrapper);
        if (!list.isEmpty()){
            for (ProductiontasktransportEntity productiontasktransportEntity : list) {
                if (productiontasktransportEntity.getTransportStatue() == 1){
                    productiontasktransportEntity.setTransportRoute(productiontaskVO.getTransportRoute());
                    productiontasktransportEntity.setTransportMethod(productiontaskVO.getTransportMethod());
                    productiontasktransportEntity.setPrintProductName(productiontaskVO.getPrintProductName());
                    productiontasktransportEntity.setPrintCustomerName(productiontaskVO.getPrintCustomerName());
                    productiontasktransportEntity.setPrintWorksiteName(productiontaskVO.getPrintWorksiteName());
                    productiontasktransportEntity.setPrintSupplyName(productiontaskVO.getPrintSupplyName());
                    productiontasktransportEntity.setOrderMobile(productiontaskVO.getOrderMobile());
                    productiontasktransportEntity.setOrderName(productiontaskVO.getOrderName());
                    productiontasktransportEntity.setWorksiteId(productiontaskVO.getWorksiteId());
                    productiontasktransportEntity.setWorksiteName(productiontaskVO.getWorksiteName());
                    productiontasktransportEntity.setProductId(productiontaskVO.getProductId());
                    productiontasktransportEntity.setProductName(productiontaskVO.getProductName());
                    productiontasktransportEntity.setOldTaskCode(productiontaskVO.getOldTaskCode());
                    productiontasktransportEntity.setDistance(productiontaskVO.getDistance());
                }
            }
            service.updateBatchById(list);
        }
        return true;
    }
}
