package com.ejianc.business.order.vo;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * 租赁订单
 * 
 * @author generator
 * 
 */
@ApiModel("租赁订单")
public class SupRentOrderVO {
    private static final long serialVersionUID = 1L;
    @ApiModelProperty("主键")
    private Long id;
    @ApiModelProperty("单据编号")
    private String billCode;
    @ApiModelProperty("项目")
    private Long projectId;
    @ApiModelProperty("项目编码")
    private String projectCode;
    @ApiModelProperty("项目名称")
    private String projectName;
    @ApiModelProperty("组织")
    private Long orgId;
    @ApiModelProperty("组织名称")
    private String orgName;
    @ApiModelProperty("组织编码")
    private String orgCode;
    @ApiModelProperty("项目部上级组织Id")
    private Long parentOrgId;
    @ApiModelProperty("项目部上级组织名称")
    private String parentOrgName;
    @ApiModelProperty("项目部上级组织编码")
    private String parentOrgCode;
    @ApiModelProperty("合同主键")
    private Long contractId;
    @ApiModelProperty("合同名称")
    private String contractName;
    @ApiModelProperty("合同编号")
    private String contractCode;
    @ApiModelProperty("设备供应商")
    private Long supplierId;
    @ApiModelProperty("供应商名称")
    private String supplierName;
    @ApiModelProperty("设备名称集合")
    private String equipmentName;
    @ApiModelProperty("经办人")
    private Long employeeId;
    @ApiModelProperty("经办人名称")
    private String employeeName;
    @ApiModelProperty("联系人")
    private Long linkId;
    @ApiModelProperty("联系人名称")
    private String linkName;
    @ApiModelProperty("联系人电话")
    private String linkTelephone;
    @ApiModelProperty("订单日期")
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date orderCreateDate;
    @ApiModelProperty("到货日期")
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date orderExpiryDate;
    @ApiModelProperty("施工部位")
    private String construction;
    @ApiModelProperty("送货要求")
    private String orderNote;
    @ApiModelProperty("送货地址")
    private String orderAddress;
    @ApiModelProperty("接收状态（0-待确认,1-全部接收，2-部分接受，3-已拒绝）")
    private Integer receiveState;
    @ApiModelProperty("发货状态（0-待发货，1-部分送货，2-已送货）")
    private Integer deliverState;
    @ApiModelProperty("关闭状态（0-正常，1-已关闭）")
    private Integer orderFlag;
    @ApiModelProperty("单据状态（审批必须字段）")
    private Integer billState;
    @ApiModelProperty("经办部门")
    private Long departmentId;
    @ApiModelProperty("经办部门名称")
    private String departmentName;
    @ApiModelProperty("提交人")
    private Long commitId;
    @ApiModelProperty("接收原因")
    private String receiveReason;
    private String systemId;//来源业务系统id
    
    @ApiModelProperty("租赁订单明细")
    @SubEntity
    private List<SupRentOrderDetailVO> rentOrderDetailList = new ArrayList<>();
    /**
     * 来源业务系统id
     */
    public String getSystemId() {
        return systemId;
    }

    public void setSystemId(String systemId) {
        this.systemId = systemId;
    }

    /**
     * 主键
     */
    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }
    /**
     * 单据编号
     */
    public String getBillCode() {
        return billCode;
    }

    /**
     * 单据编号
     */
    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    /**
     * 项目
     */
    public Long getProjectId() {
        return projectId;
    }

    /**
     * 项目
     */
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    /**
     * 项目编码
     */
    public String getProjectCode() {
        return projectCode;
    }

    /**
     * 项目编码
     */
    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }
    /**
     * 项目名称
     */
    public String getProjectName() {
        return projectName;
    }

    /**
     * 项目名称
     */
    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    /**
     * 组织
     */
    public Long getOrgId() {
        return orgId;
    }

    /**
     * 组织
     */
    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    /**
     * 组织名称
     */
    public String getOrgName() {
        return orgName;
    }

    /**
     * 组织名称
     */
    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    /**
     * 组织编码
     */
    public String getOrgCode() {
        return orgCode;
    }

    /**
     * 组织编码
     */
    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }
    /**
     * 项目部上级组织Id
     */
    public Long getParentOrgId() {
        return parentOrgId;
    }

    /**
     * 项目部上级组织Id
     */
    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }
    /**
     * 项目部上级组织名称
     */
    public String getParentOrgName() {
        return parentOrgName;
    }

    /**
     * 项目部上级组织名称
     */
    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }
    /**
     * 项目部上级组织编码
     */
    public String getParentOrgCode() {
        return parentOrgCode;
    }

    /**
     * 项目部上级组织编码
     */
    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }
    /**
     * 合同主键
     */
    public Long getContractId() {
        return contractId;
    }

    /**
     * 合同主键
     */
    public void setContractId(Long contractId) {
        this.contractId = contractId;
    }
    /**
     * 合同名称
     */
    public String getContractName() {
        return contractName;
    }

    /**
     * 合同名称
     */
    public void setContractName(String contractName) {
        this.contractName = contractName;
    }
    /**
     * 合同编号
     */
    public String getContractCode() {
        return contractCode;
    }

    /**
     * 合同编号
     */
    public void setContractCode(String contractCode) {
        this.contractCode = contractCode;
    }
    /**
     * 设备供应商
     */
    public Long getSupplierId() {
        return supplierId;
    }

    /**
     * 设备供应商
     */
    public void setSupplierId(Long supplierId) {
        this.supplierId = supplierId;
    }
    /**
     * 供应商名称
     */
    public String getSupplierName() {
        return supplierName;
    }

    /**
     * 供应商名称
     */
    public void setSupplierName(String supplierName) {
        this.supplierName = supplierName;
    }
    /**
     * 设备名称集合
     */
    public String getEquipmentName() {
        return equipmentName;
    }

    /**
     * 设备名称集合
     */
    public void setEquipmentName(String equipmentName) {
        this.equipmentName = equipmentName;
    }
    /**
     * 经办人
     */
    public Long getEmployeeId() {
        return employeeId;
    }

    /**
     * 经办人
     */
    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    /**
     * 经办人名称
     */
    public String getEmployeeName() {
        return employeeName;
    }

    /**
     * 经办人名称
     */
    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    /**
     * 联系人
     */
    public Long getLinkId() {
        return linkId;
    }

    /**
     * 联系人
     */
    public void setLinkId(Long linkId) {
        this.linkId = linkId;
    }
    /**
     * 联系人名称
     */
    public String getLinkName() {
        return linkName;
    }

    /**
     * 联系人名称
     */
    public void setLinkName(String linkName) {
        this.linkName = linkName;
    }
    /**
     * 联系人电话
     */
    public String getLinkTelephone() {
        return linkTelephone;
    }

    /**
     * 联系人电话
     */
    public void setLinkTelephone(String linkTelephone) {
        this.linkTelephone = linkTelephone;
    }
    /**
     * 订单日期
     */
    public Date getOrderCreateDate() {
        return orderCreateDate;
    }

    /**
     * 订单日期
     */
    public void setOrderCreateDate(Date orderCreateDate) {
        this.orderCreateDate = orderCreateDate;
    }
    /**
     * 到货日期
     */
    public Date getOrderExpiryDate() {
        return orderExpiryDate;
    }

    /**
     * 到货日期
     */
    public void setOrderExpiryDate(Date orderExpiryDate) {
        this.orderExpiryDate = orderExpiryDate;
    }
    /**
     * 施工部位
     */
    public String getConstruction() {
        return construction;
    }

    /**
     * 施工部位
     */
    public void setConstruction(String construction) {
        this.construction = construction;
    }
    /**
     * 送货要求
     */
    public String getOrderNote() {
        return orderNote;
    }

    /**
     * 送货要求
     */
    public void setOrderNote(String orderNote) {
        this.orderNote = orderNote;
    }
    /**
     * 送货地址
     */
    public String getOrderAddress() {
        return orderAddress;
    }

    /**
     * 送货地址
     */
    public void setOrderAddress(String orderAddress) {
        this.orderAddress = orderAddress;
    }
    /**
     * 接收状态（0-待确认,1-全部接收，2-部分接受，3-已拒绝）
     */
    public Integer getReceiveState() {
        return receiveState;
    }

    /**
     * 接收状态（0-待确认,1-全部接收，2-部分接受，3-已拒绝）
     */
    public void setReceiveState(Integer receiveState) {
        this.receiveState = receiveState;
    }
    /**
     * 发货状态（0-待发货，1-部分送货，2-已送货）
     */
    public Integer getDeliverState() {
        return deliverState;
    }

    /**
     * 发货状态（0-待发货，1-部分送货，2-已送货）
     */
    public void setDeliverState(Integer deliverState) {
        this.deliverState = deliverState;
    }
    /**
     * 关闭状态（0-正常，1-已关闭）
     */
    public Integer getOrderFlag() {
        return orderFlag;
    }

    /**
     * 关闭状态（0-正常，1-已关闭）
     */
    public void setOrderFlag(Integer orderFlag) {
        this.orderFlag = orderFlag;
    }
    /**
     * 单据状态（审批必须字段）
     */
    public Integer getBillState() {
        return billState;
    }

    /**
     * 单据状态（审批必须字段）
     */
    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    /**
     * 经办部门
     */
    public Long getDepartmentId() {
        return departmentId;
    }

    /**
     * 经办部门
     */
    public void setDepartmentId(Long departmentId) {
        this.departmentId = departmentId;
    }
    /**
     * 经办部门名称
     */
    public String getDepartmentName() {
        return departmentName;
    }

    /**
     * 经办部门名称
     */
    public void setDepartmentName(String departmentName) {
        this.departmentName = departmentName;
    }
    /**
     * 提交人
     */
    public Long getCommitId() {
        return commitId;
    }

    /**
     * 提交人
     */
    public void setCommitId(Long commitId) {
        this.commitId = commitId;
    }
    /**
     * 接收原因
     */
    public String getReceiveReason() {
        return receiveReason;
    }

    /**
     * 接收原因
     */
    public void setReceiveReason(String receiveReason) {
        this.receiveReason = receiveReason;
    }
    
     /**
      * 租赁订单明细
      */
      public List<SupRentOrderDetailVO> getRentOrderDetailList() {
         return rentOrderDetailList;
      }
     /**
      * 租赁订单明细
      */
     public void setRentOrderDetailList(List<SupRentOrderDetailVO> rentOrderDetailList) {
         this.rentOrderDetailList = rentOrderDetailList;
     }
}
