package com.ejianc.business.pricelib.enums;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

public enum PriceSourceTypeEnum {
    设备租赁合同("设备租赁合同", "equipment"),
    设备购置合同("设备购置合同", "equipmentP"),
    设备公司租出合同("设备公司租出合同", "corpOut"),
    设备公司租入合同("设备公司租入合同", "corpIn"),
    设备公司购置合同("设备公司购置合同", "corpPurchase")
    ;

    private final String name;
    private final String code;
    private static Map<String, PriceSourceTypeEnum> enumMap = new HashMap();

    private PriceSourceTypeEnum(String name, String code) {
        this.name = name;
        this.code = code;
    }

    public String getName() {
        return this.name;
    }

    public String getCode() {
        return this.code;
    }

    public static PriceSourceTypeEnum getEnumByName(String billTypeName) {
        return (PriceSourceTypeEnum)enumMap.get(billTypeName);
    }

    static {
        enumMap = (Map)EnumSet.allOf(PriceSourceTypeEnum.class).stream().collect(Collectors.toMap(PriceSourceTypeEnum::getName, Function.identity(), (k1, k2) -> {
            return k2;
        }));
    }
}
