package com.ejianc.business.rent.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.baomidou.mybatisplus.annotation.TableField;
import com.ejianc.business.tools.refer.annotation.ReferJsonField;
import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;


/**
 * 租金计算月租明细
 * 
 * @author generator
 * 
 */
@ApiModel("租金计算月租明细")
public class RentRentalMonthVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    @ApiModelProperty("单据编号")
    private String billCode;
    @ApiModelProperty("设备名称")
    private String equipmentName;
    @ApiModelProperty("单据状态：0自由态，1已提交，2审批中，3审批通过，4驳回，5提交后有人审批中")
    private Integer billState;
    @ApiModelProperty("设备出厂编号")
    private String monthFactoryCode;
    @ApiModelProperty("设备类别id")
    @ReferJsonField(referCode = "equipmentType001",referFields = "code",resultFields = "equipmentTypeCode")
    private Long categoryId;
    @ApiModelProperty("设备类别名称")
    private String categoryName;
    @ApiModelProperty("规格型号")
    private String spec;
    @ApiModelProperty("单位")
    private String unitName;
    @ApiModelProperty("月租单价")
    private BigDecimal monthRentPrice;
    @ApiModelProperty("不足月日租单价")
    private BigDecimal insufficientMonthDayRentPrice;
    @ApiModelProperty("停租单价")
    private BigDecimal stopRentPrice;
    @ApiModelProperty("租赁数量")
    private Integer rentNum;
    @ApiModelProperty("税率")
    private BigDecimal tax;
    @ApiModelProperty("月租单价无税")
    private BigDecimal monthRentNotTaxPrice;
    @ApiModelProperty("不足月日租单价(无税)")
    private BigDecimal insufficientMonthNotTaxRentPrice;
    @ApiModelProperty("计划进程日期")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date planIntoDate;
    @ApiModelProperty("计划出场日期")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date planOutDate;
    @ApiModelProperty("生产厂家")
    private String productionManufactor;
    @ApiModelProperty("备注")
    private String memo;
    @ApiModelProperty("主表id")
    private Long rentalId;
    @ApiModelProperty("设备编号")
    private String equipmentCode;
    @ApiModelProperty("设备id")
    private Long equipmentId;
    @ApiModelProperty("含税日租单价")
    private BigDecimal dayTaxPrice;
    @ApiModelProperty("")
    private BigDecimal taxMny;
    @ApiModelProperty("")
    private BigDecimal notTaxMonthPrice;
    @ApiModelProperty("无税日租单价")
    private BigDecimal dayRentNotTaxPrice;
    @ApiModelProperty("无税停租单价")
    private BigDecimal notTaxStopPrice;
    @ApiModelProperty("来源id")
    private Long sourceId;
    @ApiModelProperty("租赁金额(无税)")
    private BigDecimal rentMonthMny;
    @ApiModelProperty("租赁金额")
    private BigDecimal rentMonthTaxMny;
    @ApiModelProperty("租赁税额")
    private BigDecimal rentMonthTax;
    @ApiModelProperty("计费开始日期")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date chargingStartDate;
    @ApiModelProperty("计费结束日期")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date chargingEndDate;
    @ApiModelProperty("来源明细主键ID")
    private Long sourceDetailId;
    @ApiModelProperty("来源类型名称(记录—100231)")
    private String sourceName;
    @ApiModelProperty("来源类型")
    private Integer sourceType;
    @ApiModelProperty("来源编码")
    private String sourceCode;
    private Long wbsId; // 核算对象主键
    private String wbsCode; // 核算对象编码
    private String wbsName; // 核算对象名称
    private Long subjectId; // 成本科目主键
    private String subjectCode; // 成本科目编码
    private String subjectName; // 成本科目名称

    private Integer equipmentState;
    private Integer rentDayDate;
    private Integer rentMonthDate;
    private Integer flagOil; // 是否含油 (1:是，0：否)
    private Integer flagOperation; // 是否含操作手(1:是，0：否)
    private String equipmentTypeCode;//设备类别编码

    public String getEquipmentTypeCode() {
        return equipmentTypeCode;
    }

    public void setEquipmentTypeCode(String equipmentTypeCode) {
        this.equipmentTypeCode = equipmentTypeCode;
    }
    public Integer getFlagOil() {
        return flagOil;
    }

    public void setFlagOil(Integer flagOil) {
        this.flagOil = flagOil;
    }

    public Integer getFlagOperation() {
        return flagOperation;
    }

    public void setFlagOperation(Integer flagOperation) {
        this.flagOperation = flagOperation;
    }
    public Integer getEquipmentState() {
        return equipmentState;
    }

    public void setEquipmentState(Integer equipmentState) {
        this.equipmentState = equipmentState;
    }

    public Integer getRentDayDate() {
        return rentDayDate;
    }

    public void setRentDayDate(Integer rentDayDate) {
        this.rentDayDate = rentDayDate;
    }

    public Integer getRentMonthDate() {
        return rentMonthDate;
    }

    public void setRentMonthDate(Integer rentMonthDate) {
        this.rentMonthDate = rentMonthDate;
    }

    public Long getSourceDetailId() {
        return sourceDetailId;
    }

    public void setSourceDetailId(Long sourceDetailId) {
        this.sourceDetailId = sourceDetailId;
    }

    public String getSourceName() {
        return sourceName;
    }

    public void setSourceName(String sourceName) {
        this.sourceName = sourceName;
    }

    public Integer getSourceType() {
        return sourceType;
    }

    public void setSourceType(Integer sourceType) {
        this.sourceType = sourceType;
    }

    public String getSourceCode() {
        return sourceCode;
    }

    public void setSourceCode(String sourceCode) {
        this.sourceCode = sourceCode;
    }

    @ReferSerialTransfer(referCode = "subject-project-wbs-ref")
    public Long getWbsId() {
        return wbsId;
    }
    @ReferDeserialTransfer
    public void setWbsId(Long wbsId) {
        this.wbsId = wbsId;
    }

    public String getWbsCode() {
        return wbsCode;
    }

    public void setWbsCode(String wbsCode) {
        this.wbsCode = wbsCode;
    }

    public String getWbsName() {
        return wbsName;
    }

    public void setWbsName(String wbsName) {
        this.wbsName = wbsName;
    }
    @ReferSerialTransfer(referCode = "subject-project-org-ref")
    public Long getSubjectId() {
        return subjectId;
    }
    @ReferDeserialTransfer
    public void setSubjectId(Long subjectId) {
        this.subjectId = subjectId;
    }

    public String getSubjectCode() {
        return subjectCode;
    }

    public void setSubjectCode(String subjectCode) {
        this.subjectCode = subjectCode;
    }

    public String getSubjectName() {
        return subjectName;
    }

    public void setSubjectName(String subjectName) {
        this.subjectName = subjectName;
    }

    /**
     * 单据编号
     */
    public String getBillCode() {
        return billCode;
    }

    /**
     * 单据编号
     */
    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }

    public String getEquipmentName() {
        return equipmentName;
    }

    public void setEquipmentName(String equipmentName) {
        this.equipmentName = equipmentName;
    }

    /**
     * 单据状态：0自由态，1已提交，2审批中，3审批通过，4驳回，5提交后有人审批中
     */
    public Integer getBillState() {
        return billState;
    }

    /**
     * 单据状态：0自由态，1已提交，2审批中，3审批通过，4驳回，5提交后有人审批中
     */
    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    /**
     * 设备出厂编号
     */
    public String getMonthFactoryCode() {
        return monthFactoryCode;
    }

    /**
     * 设备出厂编号
     */
    public void setMonthFactoryCode(String monthFactoryCode) {
        this.monthFactoryCode = monthFactoryCode;
    }
    /**
     * 设备类别id
     */
    public Long getCategoryId() {
        return categoryId;
    }

    /**
     * 设备类别id
     */
    public void setCategoryId(Long categoryId) {
        this.categoryId = categoryId;
    }
    /**
     * 设备类别名称
     */
    public String getCategoryName() {
        return categoryName;
    }

    /**
     * 设备类别名称
     */
    public void setCategoryName(String categoryName) {
        this.categoryName = categoryName;
    }
    /**
     * 规格型号
     */
    public String getSpec() {
        return spec;
    }

    /**
     * 规格型号
     */
    public void setSpec(String spec) {
        this.spec = spec;
    }
    /**
     * 单位
     */
    public String getUnitName() {
        return unitName;
    }

    /**
     * 单位
     */
    public void setUnitName(String unitName) {
        this.unitName = unitName;
    }
    /**
     * 月租单价
     */
    public BigDecimal getMonthRentPrice() {
        return monthRentPrice;
    }

    /**
     * 月租单价
     */
    public void setMonthRentPrice(BigDecimal monthRentPrice) {
        this.monthRentPrice = monthRentPrice;
    }
    /**
     * 不足月日租单价
     */
    public BigDecimal getInsufficientMonthDayRentPrice() {
        return insufficientMonthDayRentPrice;
    }

    /**
     * 不足月日租单价
     */
    public void setInsufficientMonthDayRentPrice(BigDecimal insufficientMonthDayRentPrice) {
        this.insufficientMonthDayRentPrice = insufficientMonthDayRentPrice;
    }
    /**
     * 停租单价
     */
    public BigDecimal getStopRentPrice() {
        return stopRentPrice;
    }

    /**
     * 停租单价
     */
    public void setStopRentPrice(BigDecimal stopRentPrice) {
        this.stopRentPrice = stopRentPrice;
    }
    /**
     * 租赁数量
     */
    public Integer getRentNum() {
        return rentNum;
    }

    /**
     * 租赁数量
     */
    public void setRentNum(Integer rentNum) {
        this.rentNum = rentNum;
    }
    /**
     * 税率
     */
    public BigDecimal getTax() {
        return tax;
    }

    /**
     * 税率
     */
    public void setTax(BigDecimal tax) {
        this.tax = tax;
    }
    /**
     * 月租单价无税
     */
    public BigDecimal getMonthRentNotTaxPrice() {
        return monthRentNotTaxPrice;
    }

    /**
     * 月租单价无税
     */
    public void setMonthRentNotTaxPrice(BigDecimal monthRentNotTaxPrice) {
        this.monthRentNotTaxPrice = monthRentNotTaxPrice;
    }
    /**
     * 不足月日租单价(无税)
     */
    public BigDecimal getInsufficientMonthNotTaxRentPrice() {
        return insufficientMonthNotTaxRentPrice;
    }

    /**
     * 不足月日租单价(无税)
     */
    public void setInsufficientMonthNotTaxRentPrice(BigDecimal insufficientMonthNotTaxRentPrice) {
        this.insufficientMonthNotTaxRentPrice = insufficientMonthNotTaxRentPrice;
    }
    /**
     * 计划进程日期
     */
    public Date getPlanIntoDate() {
        return planIntoDate;
    }

    /**
     * 计划进程日期
     */
    public void setPlanIntoDate(Date planIntoDate) {
        this.planIntoDate = planIntoDate;
    }
    /**
     * 计划出场日期
     */
    public Date getPlanOutDate() {
        return planOutDate;
    }

    /**
     * 计划出场日期
     */
    public void setPlanOutDate(Date planOutDate) {
        this.planOutDate = planOutDate;
    }
    /**
     * 生产厂家
     */
    public String getProductionManufactor() {
        return productionManufactor;
    }

    /**
     * 生产厂家
     */
    public void setProductionManufactor(String productionManufactor) {
        this.productionManufactor = productionManufactor;
    }
    /**
     * 备注
     */
    public String getMemo() {
        return memo;
    }

    /**
     * 备注
     */
    public void setMemo(String memo) {
        this.memo = memo;
    }
    /**
     * 主表id
     */
    public Long getRentalId() {
        return rentalId;
    }

    /**
     * 主表id
     */
    public void setRentalId(Long rentalId) {
        this.rentalId = rentalId;
    }
    /**
     * 设备编号
     */
    public String getEquipmentCode() {
        return equipmentCode;
    }

    /**
     * 设备编号
     */
    public void setEquipmentCode(String equipmentCode) {
        this.equipmentCode = equipmentCode;
    }
    /**
     * 设备id
     */
    public Long getEquipmentId() {
        return equipmentId;
    }

    /**
     * 设备id
     */
    public void setEquipmentId(Long equipmentId) {
        this.equipmentId = equipmentId;
    }
    /**
     * 含税日租单价
     */
    public BigDecimal getDayTaxPrice() {
        return dayTaxPrice;
    }

    /**
     * 含税日租单价
     */
    public void setDayTaxPrice(BigDecimal dayTaxPrice) {
        this.dayTaxPrice = dayTaxPrice;
    }
    /**
     * 
     */
    public BigDecimal getTaxMny() {
        return taxMny;
    }

    /**
     * 
     */
    public void setTaxMny(BigDecimal taxMny) {
        this.taxMny = taxMny;
    }
    /**
     * 
     */
    public BigDecimal getNotTaxMonthPrice() {
        return notTaxMonthPrice;
    }

    /**
     * 
     */
    public void setNotTaxMonthPrice(BigDecimal notTaxMonthPrice) {
        this.notTaxMonthPrice = notTaxMonthPrice;
    }
    /**
     * 无税日租单价
     */
    public BigDecimal getDayRentNotTaxPrice() {
        return dayRentNotTaxPrice;
    }

    /**
     * 无税日租单价
     */
    public void setDayRentNotTaxPrice(BigDecimal dayRentNotTaxPrice) {
        this.dayRentNotTaxPrice = dayRentNotTaxPrice;
    }
    /**
     * 无税停租单价
     */
    public BigDecimal getNotTaxStopPrice() {
        return notTaxStopPrice;
    }

    /**
     * 无税停租单价
     */
    public void setNotTaxStopPrice(BigDecimal notTaxStopPrice) {
        this.notTaxStopPrice = notTaxStopPrice;
    }
    /**
     * 来源id
     */
    public Long getSourceId() {
        return sourceId;
    }

    /**
     * 来源id
     */
    public void setSourceId(Long sourceId) {
        this.sourceId = sourceId;
    }
    /**
     * 租赁金额(无税)
     */
    public BigDecimal getRentMonthMny() {
        return rentMonthMny;
    }

    /**
     * 租赁金额(无税)
     */
    public void setRentMonthMny(BigDecimal rentMonthMny) {
        this.rentMonthMny = rentMonthMny;
    }
    /**
     * 租赁金额
     */
    public BigDecimal getRentMonthTaxMny() {
        return rentMonthTaxMny;
    }

    /**
     * 租赁金额
     */
    public void setRentMonthTaxMny(BigDecimal rentMonthTaxMny) {
        this.rentMonthTaxMny = rentMonthTaxMny;
    }
    /**
     * 租赁税额
     */
    public BigDecimal getRentMonthTax() {
        return rentMonthTax;
    }

    /**
     * 租赁税额
     */
    public void setRentMonthTax(BigDecimal rentMonthTax) {
        this.rentMonthTax = rentMonthTax;
    }
    /**
     * 计费开始日期
     */
    public Date getChargingStartDate() {
        return chargingStartDate;
    }

    /**
     * 计费开始日期
     */
    public void setChargingStartDate(Date chargingStartDate) {
        this.chargingStartDate = chargingStartDate;
    }
    /**
     * 计费结束日期
     */
    public Date getChargingEndDate() {
        return chargingEndDate;
    }

    /**
     * 计费结束日期
     */
    public void setChargingEndDate(Date chargingEndDate) {
        this.chargingEndDate = chargingEndDate;
    }
    
}
