package com.ejianc.business.temporary.contract.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.ejianc.business.tools.refer.annotation.ReferJsonField;
import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;


/**
 * 临时设备租赁合同-设备明细变更
 * 
 * @author generator
 * 
 */
public class TemporaryEquipmentChangeVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private String code; // 单据编号
    private String name; // 设备名称
    private Integer billState; // 单据状态：0自由态，1已提交，2审批中，3审批通过，4驳回，5提交后有人审批中
    @ReferJsonField(referCode = "equipmentType001",referFields = "code",resultFields = "equipmentTypeCode")
    private Long categoryId; // 设备类别id
    private String categoryName; // 设备类别名称
    private String spec; // 规格型号
    private String unitName; // 单位
    private BigDecimal tax; // 税率
    private String productionManufactor; // 生产厂家
    private String memo; // 备注
    private Long pid; // 主表id
    private Long equipmentId; // 设备id
    private Long changeBid; // 变更子表id
    private Long rentTypeId; // 计租方式id
    private String rentTypeName; // 计租方式名称
    private BigDecimal taxPrice; // 含税单价
    private BigDecimal quantities; // 计费工程量
    private BigDecimal taxMny; // 含税金额
    private BigDecimal price; // 无税单价
    private BigDecimal mny; // 
    private Long contractId; // 合同id
    private Long changeId; // 变更id
    private Long srcTblId; // 来源子表主键
    private Boolean contrastFlag;
    private String equipmentCode; // 设备编号
    private String equipmentTypeCode;//设备类别编码

    public String getEquipmentTypeCode() {
        return equipmentTypeCode;
    }

    public void setEquipmentTypeCode(String equipmentTypeCode) {
        this.equipmentTypeCode = equipmentTypeCode;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }
    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public Long getCategoryId() {
        return categoryId;
    }

    public void setCategoryId(Long categoryId) {
        this.categoryId = categoryId;
    }
    public String getCategoryName() {
        return categoryName;
    }

    public void setCategoryName(String categoryName) {
        this.categoryName = categoryName;
    }
    public String getSpec() {
        return spec;
    }

    public void setSpec(String spec) {
        this.spec = spec;
    }
    public String getUnitName() {
        return unitName;
    }

    public void setUnitName(String unitName) {
        this.unitName = unitName;
    }
    public BigDecimal getTax() {
        return tax;
    }

    public void setTax(BigDecimal tax) {
        this.tax = tax;
    }
    public String getProductionManufactor() {
        return productionManufactor;
    }

    public void setProductionManufactor(String productionManufactor) {
        this.productionManufactor = productionManufactor;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    public Long getPid() {
        return pid;
    }

    public void setPid(Long pid) {
        this.pid = pid;
    }
    public Long getEquipmentId() {
        return equipmentId;
    }

    public void setEquipmentId(Long equipmentId) {
        this.equipmentId = equipmentId;
    }
    public Long getChangeBid() {
        return changeBid;
    }

    public void setChangeBid(Long changeBid) {
        this.changeBid = changeBid;
    }
    @ReferSerialTransfer(referCode="share-unit")
    public Long getRentTypeId() {
        return rentTypeId;
    }
    @ReferDeserialTransfer
    public void setRentTypeId(Long rentTypeId) {
        this.rentTypeId = rentTypeId;
    }
    public String getRentTypeName() {
        return rentTypeName;
    }

    public void setRentTypeName(String rentTypeName) {
        this.rentTypeName = rentTypeName;
    }
    public BigDecimal getTaxPrice() {
        return taxPrice;
    }

    public void setTaxPrice(BigDecimal taxPrice) {
        this.taxPrice = taxPrice;
    }

    public BigDecimal getQuantities() {
        return quantities;
    }

    public void setQuantities(BigDecimal quantities) {
        this.quantities = quantities;
    }

    public BigDecimal getTaxMny() {
        return taxMny;
    }

    public void setTaxMny(BigDecimal taxMny) {
        this.taxMny = taxMny;
    }
    public BigDecimal getPrice() {
        return price;
    }

    public void setPrice(BigDecimal price) {
        this.price = price;
    }
    public BigDecimal getMny() {
        return mny;
    }

    public void setMny(BigDecimal mny) {
        this.mny = mny;
    }
    public Long getContractId() {
        return contractId;
    }

    public void setContractId(Long contractId) {
        this.contractId = contractId;
    }
    public Long getChangeId() {
        return changeId;
    }

    public void setChangeId(Long changeId) {
        this.changeId = changeId;
    }
    public Long getSrcTblId() {
        return srcTblId;
    }

    public void setSrcTblId(Long srcTblId) {
        this.srcTblId = srcTblId;
    }

    public Boolean getContrastFlag() {
        return contrastFlag;
    }

    public void setContrastFlag(Boolean contrastFlag) {
        this.contrastFlag = contrastFlag;
    }

    public String getEquipmentCode() {
        return equipmentCode;
    }

    public void setEquipmentCode(String equipmentCode) {
        this.equipmentCode = equipmentCode;
    }
}
