package com.ejianc.business.rent.api;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.rent.hystrix.RentContractHystrix;
import com.ejianc.business.rent.hystrix.RentPlanHystrix;
import com.ejianc.business.tender.common.vo.SignContractVo;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;

import java.util.List;

@FeignClient(
        name = "ejc-proequipment-web",
        url = "${common.env.feign-client-url}",
        path = "ejc-proequipment-web",
        fallback = RentContractHystrix.class
)
public interface IRentContractApi {

    /**
     * 根据定标参照id查询对应的合同
     *
     * @param targetResultIdList 定标结果参照id
     * @return 修改结果
     */
    @RequestMapping(
            value = {"/api/rentContract/queryContractByTargetResultId"},
            method = {RequestMethod.GET}
    )
    CommonResponse<List<SignContractVo>> queryContractByTargetResultId(@RequestParam("targetResultIdList") List<String> targetResultIdList);


    /**
     * 接收设备公司内租合同
     * @param json,type
     * @return
     */
    @PostMapping(value = "/api/rentContract/contractSync")
    CommonResponse<String> contractSync(@RequestBody JSONObject json, @RequestParam("type") String type);

    /**
     * 设备公司中心内租合同删除
     * @param id,type
     * @return
     */
    @PostMapping(value = "/api/rentContract/delContract")
    CommonResponse<String> delContract(@RequestParam("id") Long id,@RequestParam("type") String type);
}
