package com.ejianc.business.temporary.userecord.api;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.temporary.userecord.hystrix.ITemporaryUseRecordHystrix;
import com.ejianc.business.temporary.userecord.vo.TemporaryUseRecordVO;
import com.ejianc.framework.core.response.CommonResponse;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

import java.util.List;

@FeignClient(
        name = "ejc-proequipment-web",
        url = "${common.env.feign-client-url}",
        path = "ejc-proequipment-web",
        fallback = ITemporaryUseRecordHystrix.class
)
public interface ITemporaryUseRecordApi {

    /**
     * 根据 项目和收款单位 查询合同为空的 已生效的 临时设备使用记录 的 使用金额之和
     *
     * @param projectId  项目id
     * @param supplierId 供应商id
     * @return 查询结果
     */
    @RequestMapping(
            value = {"/api/temporaryUseRecord/queryTemporaryUseRecordMny"},
            method = {RequestMethod.GET}
    )
    CommonResponse<JSONObject> queryTemporaryUseRecordMny(@RequestParam("projectId") Long projectId,
                                                          @RequestParam("supplierId") Long supplierId);

    /**
     * 根据 项目查询所有状态临时设备使用记录 的 使用金额之和
     *
     * @param projectId  项目id
     * @return 查询结果
     */
    @RequestMapping(
            value = {"/api/temporaryUseRecord/queryProTemporaryUseRecordMny"},
            method = {RequestMethod.GET}
    )
    CommonResponse<JSONObject> queryProTemporaryUseRecordMny(@RequestParam("projectId") Long projectId);
    /**
     * 根据 项目 查询合同为空的 已生效的 临时设备使用记录 的 使用金额之和
     *
     * @param projectId  项目id
     * @return 查询结果
     */
    @RequestMapping(value = "/api/temporaryUseRecord/queryTemporaryUseProject", method = RequestMethod.GET)
    CommonResponse<JSONObject> queryTemporaryUseProject(@RequestParam("projectId") Long projectId);
    /**
     * 根据 项目 查询合同为空的 已生效的 临时设备使用记录
     *
     * @param projectId  项目id
     * @return 查询结果
     */
    @ApiOperation("根据 项目 查询合同为空的 已生效的 临时设备使用记录")
    @RequestMapping(value = "/api/temporaryUseRecord/queryTemporaryListUseProject", method = RequestMethod.GET)
    @ResponseBody
    CommonResponse<List<TemporaryUseRecordVO>> queryTemporaryListUseProject(@RequestParam("projectId") Long projectId);

}

