package com.ejianc.business.rent.api;


import com.ejianc.business.rent.hystrix.RentRentalHystrix;
import com.ejianc.business.rent.vo.RentalSumVo;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestParam;

/**
 * 结算API
 */
@FeignClient(name = "ejc-proequipment-web", url = "${common.env.feign-client-url}", path = "ejc-proequipment-web", fallback = RentRentalHystrix.class)
public interface IRentRentalApi {

    /**
     * 根据合同id查询审批通过的租金计算金额
     *
     * @param contractId 合同id
     * @return 租金计算金额
     */
    @GetMapping(value = "/api/rentRental/queryRentalMnyByContractId")
    CommonResponse<RentalSumVo> queryRentalMnyByContractId(@RequestParam(value = "contractId") Long contractId);
}
