package com.ejianc.business.rent.vo;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.math.BigDecimal;
import java.util.Date;


/**
 * 设备租赁结算日租明细
 * 
 * @author generator
 * 
 */
@ApiModel("设备租赁结算日租明细")
public class SupRentSettlementDayVO{
    private static final long serialVersionUID = 1L;
    
    @ApiModelProperty("结算主键ID")
    private Long settlementId;
    @ApiModelProperty("来源主键ID")
    private Long sourceId;
    @ApiModelProperty("来源明细主键ID")
    private Long sourceDetailId;
    @ApiModelProperty("来源类型名称(记录—100231)")
    private String sourceName;
    @ApiModelProperty("来源类型")
    private Integer sourceType;
    @ApiModelProperty("来源编码")
    private String sourceCode;
    @ApiModelProperty("出厂编码")
    private String dayFactoryCode;
    @ApiModelProperty("设备类别")
    private Long equipmentTypeId;
    @ApiModelProperty("设备类别名称")
    private String equipmentTypeName;
    @ApiModelProperty("设备主键")
    private Long equipmentId;
    @ApiModelProperty("设备名称")
    private String equipmentName;
    @ApiModelProperty("设备编码")
    private String equipmentCode;
    @ApiModelProperty("规格型号")
    private String spec;
    @ApiModelProperty("单位")
    private String unit;
    @ApiModelProperty("单位id")
    private Long unitId;
    @ApiModelProperty("开始日期")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date dayStartDate;
    @ApiModelProperty("结束日期")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date dayEndDate;
    @ApiModelProperty("日租赁单价(无税)")
    private BigDecimal dayPrice;
    @ApiModelProperty("日租赁单价")
    private BigDecimal dayTaxPrice;
    @ApiModelProperty("停租赁单价(无税)")
    private BigDecimal dayStopPrice;
    @ApiModelProperty("停租赁单价")
    private BigDecimal dayStopTaxPrice;
    @ApiModelProperty("租赁数量")
    private BigDecimal dayNum;
    @ApiModelProperty("日租赁金额(无税)")
    private BigDecimal dayMny;
    @ApiModelProperty("日租赁金额)")
    private BigDecimal dayTaxMny;
    @ApiModelProperty("日租赁税率")
    private BigDecimal dayTaxRate;
    @ApiModelProperty("日租赁税额")
    private BigDecimal dayTax;
    @ApiModelProperty("备注")
    private String memo;
    private String productionManufactor; // 生产厂家
    private Long wbsId; // 核算对象主键
    private String wbsCode; // 核算对象编码
    private String wbsName; // 核算对象名称
    private Long subjectId; // 成本科目主键
    private String subjectCode; // 成本科目编码
    private String subjectName; // 成本科目名称
    private Long id; // 主键

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }


    public Long getWbsId() {
        return wbsId;
    }

    public void setWbsId(Long wbsId) {
        this.wbsId = wbsId;
    }

    public String getWbsCode() {
        return wbsCode;
    }

    public void setWbsCode(String wbsCode) {
        this.wbsCode = wbsCode;
    }

    public String getWbsName() {
        return wbsName;
    }

    public void setWbsName(String wbsName) {
        this.wbsName = wbsName;
    }


    public Long getSubjectId() {
        return subjectId;
    }

    public void setSubjectId(Long subjectId) {
        this.subjectId = subjectId;
    }


    public String getSubjectCode() {
        return subjectCode;
    }

    public void setSubjectCode(String subjectCode) {
        this.subjectCode = subjectCode;
    }

    public String getSubjectName() {
        return subjectName;
    }

    public void setSubjectName(String subjectName) {
        this.subjectName = subjectName;
    }

    public String getProductionManufactor() {
        return productionManufactor;
    }

    public void setProductionManufactor(String productionManufactor) {
        this.productionManufactor = productionManufactor;
    }

    /**
     * 结算主键ID
     */
    public Long getSettlementId() {
        return settlementId;
    }

    /**
     * 结算主键ID
     */
    public void setSettlementId(Long settlementId) {
        this.settlementId = settlementId;
    }
    /**
     * 来源主键ID
     */
    public Long getSourceId() {
        return sourceId;
    }

    /**
     * 来源主键ID
     */
    public void setSourceId(Long sourceId) {
        this.sourceId = sourceId;
    }
    /**
     * 来源明细主键ID
     */
    public Long getSourceDetailId() {
        return sourceDetailId;
    }

    /**
     * 来源明细主键ID
     */
    public void setSourceDetailId(Long sourceDetailId) {
        this.sourceDetailId = sourceDetailId;
    }
    /**
     * 来源类型名称(记录—100231)
     */
    public String getSourceName() {
        return sourceName;
    }

    /**
     * 来源类型名称(记录—100231)
     */
    public void setSourceName(String sourceName) {
        this.sourceName = sourceName;
    }
    /**
     * 来源类型
     */
    public Integer getSourceType() {
        return sourceType;
    }

    /**
     * 来源类型
     */
    public void setSourceType(Integer sourceType) {
        this.sourceType = sourceType;
    }
    /**
     * 来源编码
     */
    public String getSourceCode() {
        return sourceCode;
    }

    /**
     * 来源编码
     */
    public void setSourceCode(String sourceCode) {
        this.sourceCode = sourceCode;
    }
    /**
     * 出厂编码
     */
    public String getDayFactoryCode() {
        return dayFactoryCode;
    }

    public void setDayFactoryCode(String dayFactoryCode) {
        this.dayFactoryCode = dayFactoryCode;
    }

    /**
     * 设备类别
     */
    public Long getEquipmentTypeId() {
        return equipmentTypeId;
    }

    /**
     * 设备类别
     */
    public void setEquipmentTypeId(Long equipmentTypeId) {
        this.equipmentTypeId = equipmentTypeId;
    }
    /**
     * 设备类别名称
     */
    public String getEquipmentTypeName() {
        return equipmentTypeName;
    }

    /**
     * 设备类别名称
     */
    public void setEquipmentTypeName(String equipmentTypeName) {
        this.equipmentTypeName = equipmentTypeName;
    }
    /**
     * 设备主键
     */
    public Long getEquipmentId() {
        return equipmentId;
    }

    /**
     * 设备主键
     */
    public void setEquipmentId(Long equipmentId) {
        this.equipmentId = equipmentId;
    }
    /**
     * 设备名称
     */
    public String getEquipmentName() {
        return equipmentName;
    }

    /**
     * 设备名称
     */
    public void setEquipmentName(String equipmentName) {
        this.equipmentName = equipmentName;
    }
    /**
     * 设备编码
     */
    public String getEquipmentCode() {
        return equipmentCode;
    }

    /**
     * 设备编码
     */
    public void setEquipmentCode(String equipmentCode) {
        this.equipmentCode = equipmentCode;
    }
    /**
     * 规格型号
     */
    public String getSpec() {
        return spec;
    }

    /**
     * 规格型号
     */
    public void setSpec(String spec) {
        this.spec = spec;
    }
    /**
     * 单位
     */
    public String getUnit() {
        return unit;
    }

    /**
     * 单位
     */
    public void setUnit(String unit) {
        this.unit = unit;
    }
    /**
     * 单位id
     */
    public Long getUnitId() {
        return unitId;
    }

    /**
     * 单位id
     */
    public void setUnitId(Long unitId) {
        this.unitId = unitId;
    }
    /**
     * 开始日期
     */
    public Date getDayStartDate() {
        return dayStartDate;
    }

    /**
     * 开始日期
     */
    public void setDayStartDate(Date dayStartDate) {
        this.dayStartDate = dayStartDate;
    }
    /**
     * 结束日期
     */
    public Date getDayEndDate() {
        return dayEndDate;
    }

    /**
     * 结束日期
     */
    public void setDayEndDate(Date dayEndDate) {
        this.dayEndDate = dayEndDate;
    }
    /**
     * 日租赁单价(无税)
     */
    public BigDecimal getDayPrice() {
        return dayPrice;
    }

    /**
     * 日租赁单价(无税)
     */
    public void setDayPrice(BigDecimal dayPrice) {
        this.dayPrice = dayPrice;
    }
    /**
     * 日租赁单价
     */
    public BigDecimal getDayTaxPrice() {
        return dayTaxPrice;
    }

    /**
     * 日租赁单价
     */
    public void setDayTaxPrice(BigDecimal dayTaxPrice) {
        this.dayTaxPrice = dayTaxPrice;
    }
    /**
     * 停租赁单价(无税)
     */
    public BigDecimal getDayStopPrice() {
        return dayStopPrice;
    }

    /**
     * 停租赁单价(无税)
     */
    public void setDayStopPrice(BigDecimal dayStopPrice) {
        this.dayStopPrice = dayStopPrice;
    }
    /**
     * 停租赁单价
     */
    public BigDecimal getDayStopTaxPrice() {
        return dayStopTaxPrice;
    }

    /**
     * 停租赁单价
     */
    public void setDayStopTaxPrice(BigDecimal dayStopTaxPrice) {
        this.dayStopTaxPrice = dayStopTaxPrice;
    }
    /**
     * 租赁数量
     */
    public BigDecimal getDayNum() {
        return dayNum;
    }

    /**
     * 租赁数量
     */
    public void setDayNum(BigDecimal dayNum) {
        this.dayNum = dayNum;
    }
    /**
     * 日租赁金额(无税)
     */
    public BigDecimal getDayMny() {
        return dayMny;
    }

    public void setDayMny(BigDecimal dayMny) {
        this.dayMny = dayMny;
    }

    /**
     * 日租赁金额)
     */
    public BigDecimal getDayTaxMny() {
        return dayTaxMny;
    }

    /**
     * 日租赁金额)
     */
    public void setDayTaxMny(BigDecimal dayTaxMny) {
        this.dayTaxMny = dayTaxMny;
    }
    /**
     * 日租赁税率
     */
    public BigDecimal getDayTaxRate() {
        return dayTaxRate;
    }

    /**
     * 日租赁税率
     */
    public void setDayTaxRate(BigDecimal dayTaxRate) {
        this.dayTaxRate = dayTaxRate;
    }
    /**
     * 日租赁税额
     */
    public BigDecimal getDayTax() {
        return dayTax;
    }

    /**
     * 日租赁税额
     */
    public void setDayTax(BigDecimal dayTax) {
        this.dayTax = dayTax;
    }
    /**
     * 备注
     */
    public String getMemo() {
        return memo;
    }

    /**
     * 备注
     */
    public void setMemo(String memo) {
        this.memo = memo;
    }
    
}
