/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.order.controller.api;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.business.ac.enums.BillPushStatusEnum;
import com.ejianc.business.ac.enums.SupplierSignStatusEnum;
import com.ejianc.business.appearance.bean.AppearanceEntity;
import com.ejianc.business.appearance.bean.AppearanceSubEntity;
import com.ejianc.business.appearance.service.IAppearanceService;
import com.ejianc.business.appearance.service.impl.AppearanceServiceImpl;
import com.ejianc.business.contractbase.pool.enums.ContractPerformanceStateEnum;
import com.ejianc.business.order.bean.RentOrderDetailEntity;
import com.ejianc.business.order.bean.RentOrderEntity;
import com.ejianc.business.order.enums.RentReceiptsEnum;
import com.ejianc.business.order.enums.StatusTypeEnum;
import com.ejianc.business.order.mapper.RentOrderMapper;
import com.ejianc.business.order.service.IRentOrderService;
import com.ejianc.business.order.service.impl.RentOrderServiceImpl;
import com.ejianc.business.procost.api.ICostDetailApi;
import com.ejianc.business.rent.bean.RentAcceptanceEntity;
import com.ejianc.business.rent.bean.RentAcceptanceSubEntity;
import com.ejianc.business.rent.bean.RentContractEntity;
import com.ejianc.business.rent.bean.RentEquipmentStartEntity;
import com.ejianc.business.rent.bean.RentEquipmentStartSubEntity;
import com.ejianc.business.rent.bean.RentEquipmentStopEntity;
import com.ejianc.business.rent.bean.RentEquipmentStopSubEntity;
import com.ejianc.business.rent.bean.RentParameterDetailEntity;
import com.ejianc.business.rent.bean.RentParameterEntity;
import com.ejianc.business.rent.bean.RentRentalEntity;
import com.ejianc.business.rent.bean.RentSettlementEntity;
import com.ejianc.business.rent.bean.RentSettlementRentalEntity;
import com.ejianc.business.rent.enums.EntranceRentFlagEnum;
import com.ejianc.business.rent.enums.RentEquipmentStateEnum;
import com.ejianc.business.rent.enums.RentParameterTypeEnum;
import com.ejianc.business.rent.enums.RentalSettlementStateEnum;
import com.ejianc.business.rent.service.IRentAcceptanceService;
import com.ejianc.business.rent.service.IRentContractService;
import com.ejianc.business.rent.service.IRentEquipmentStartService;
import com.ejianc.business.rent.service.IRentEquipmentStopService;
import com.ejianc.business.rent.service.IRentParameterService;
import com.ejianc.business.rent.service.IRentRentalService;
import com.ejianc.business.rent.service.IRentSettlementService;
import com.ejianc.business.rent.service.impl.RentAcceptanceServiceImpl;
import com.ejianc.business.rent.service.impl.RentEquipmentStartServiceImpl;
import com.ejianc.business.rent.service.impl.RentEquipmentStopServiceImpl;
import com.ejianc.business.rent.service.impl.RentRentalServiceImpl;
import com.ejianc.business.rent.service.impl.RentSettlementBpmServiceImpl;
import com.ejianc.business.rent.service.impl.RentSettlementServiceImpl;
import com.ejianc.business.rent.vo.RentAcceptanceVO;
import com.ejianc.business.rent.vo.RentParameterVO;
import com.ejianc.business.rent.vo.RentSettlementVO;
import com.ejianc.business.targetcost.api.IExecutionApi;
import com.ejianc.business.targetcost.vo.ExecutionVO;
import com.ejianc.business.targetcost.vo.TotalExecutionVO;
import com.ejianc.business.utils.RentEntityUtil;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.orgcenter.api.IUserApi;
import com.ejianc.foundation.usercenter.vo.UserVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseEntity;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/proequipment/"})
public class RentReceiptsApi {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IRentContractService service;
    @Autowired
    private IRentAcceptanceService checkService;
    @Autowired
    private IRentEquipmentStartService startService;
    @Autowired
    private IRentEquipmentStopService stopService;
    @Autowired
    private IRentSettlementService settleService;
    @Autowired
    private IRentRentalService rentalService;
    @Autowired
    private ICostDetailApi costDetailApi;
    @Autowired
    private IAttachmentApi attachmentApi;
    @Autowired
    private RentSettlementBpmServiceImpl settleBpmService;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IRentOrderService orderService;
    @Autowired
    private IExecutionApi executionApi;
    @Autowired
    private RentOrderMapper mapper;
    @Autowired
    private IUserApi userApi;
    @Autowired
    private IAppearanceService appearanceService;
    @Autowired
    private IRentParameterService parameterService;

    @PostMapping(value={"/receiptsSync"})
    @Transactional(rollbackFor={Exception.class})
    public CommonResponse<String> receiptsSync(@RequestBody JSONObject json, @RequestParam(value="type") String type) {
        String msg = "\u5355\u636e\u5df2\u7ecf\u8fdb\u884c\u8fc7\u540c\u6b65\u64cd\u4f5c\uff0c\u8bf7\u52ff\u91cd\u590d\u64cd\u4f5c\uff01";
        ArrayList<RentParameterEntity> parameterList = new ArrayList<RentParameterEntity>();
        switch (RentReceiptsEnum.getEnumByName((String)type)) {
            case \u79df\u8d41\u8ba2\u5355: {
                this.orderSync(json);
                break;
            }
            case \u9a8c\u6536\u5355: {
                RentAcceptanceVO orderVO = (RentAcceptanceVO)JSON.parseObject((String)json.toJSONString(), RentAcceptanceVO.class);
                RentAcceptanceEntity rentAcceptanceEntity = (RentAcceptanceEntity)((Object)BeanMapper.map((Object)orderVO, RentAcceptanceEntity.class));
                rentAcceptanceEntity.setRentAcceptanceSubList(BeanMapper.mapList((Iterable)orderVO.getRentAcceptanceSubList(), RentAcceptanceSubEntity.class));
                RentAcceptanceEntity data = (RentAcceptanceEntity)((Object)RentEntityUtil.selectOneService("id", rentAcceptanceEntity.getId(), RentAcceptanceServiceImpl.class));
                if (null != data) {
                    return CommonResponse.error((String)msg);
                }
                rentAcceptanceEntity.setCheckState(1);
                rentAcceptanceEntity.setRentType("1");
                rentAcceptanceEntity.setCommitDate(new Date());
                this.checkService.saveOrUpdate((Object)rentAcceptanceEntity, false);
                RentContractEntity contractEntity = (RentContractEntity)((Object)this.service.selectById(rentAcceptanceEntity.getContractId()));
                for (RentAcceptanceSubEntity e : rentAcceptanceEntity.getRentAcceptanceSubList()) {
                    RentParameterEntity parameter = new RentParameterEntity();
                    parameter.setContractId(rentAcceptanceEntity.getContractId());
                    parameter.setContractName(rentAcceptanceEntity.getContractName());
                    parameter.setEngineeringId(rentAcceptanceEntity.getEngineeringId());
                    parameter.setEngineeringName(rentAcceptanceEntity.getEngineeringName());
                    parameter.setSupplierId(rentAcceptanceEntity.getSupplierId());
                    parameter.setSupplierName(rentAcceptanceEntity.getSupplierName());
                    parameter.setProjectId(rentAcceptanceEntity.getProjectId());
                    parameter.setProjectCode(rentAcceptanceEntity.getProjectCode());
                    parameter.setProjectName(rentAcceptanceEntity.getProjectName());
                    parameter.setAcceptanceId(rentAcceptanceEntity.getId());
                    parameter.setAcceptanceDate(rentAcceptanceEntity.getAcceptanceDate());
                    parameter.setSourceId(rentAcceptanceEntity.getId());
                    parameter.setOrgId(contractEntity.getOrgId());
                    parameter.setOrgName(contractEntity.getOrgName());
                    parameter.setParentOrgId(contractEntity.getParentOrgId());
                    parameter.setParentOrgCode(contractEntity.getParentOrgCode());
                    parameter.setParentOrgName(contractEntity.getParentOrgName());
                    parameter.setRentHarborType(contractEntity.getRentHarborType().equals("\u5185\u79df") ? 1 : 2);
                    parameter.setFactoryCode(e.getFactoryCode());
                    parameter.setCategoryId(e.getCategoryId());
                    parameter.setCategoryName(e.getCategoryName());
                    parameter.setSpec(e.getSpecs());
                    parameter.setUnitName(e.getUnitName());
                    parameter.setStartDate(rentAcceptanceEntity.getAcceptanceDate());
                    parameter.setPlanIntoDate(e.getPlanIntoDate());
                    parameter.setPlanOutDate(e.getPlanOutDate());
                    parameter.setProductionManufactor(e.getProductionManufactor());
                    parameter.setMemo(e.getMemo());
                    parameter.setEquipmentCode(e.getEquipmentCode());
                    parameter.setEquipmentId(e.getEquipmentId());
                    parameter.setName(e.getName());
                    parameter.setNum(e.getNum());
                    parameter.setRentNum(e.getNum());
                    parameter.setRentTypeId(e.getRentTypeId());
                    parameter.setRentTypeName(e.getRentTypeName());
                    parameter.setAcceptanceDetailId(e.getId());
                    parameter.setEquipmentName(e.getName());
                    parameter.setPrice(e.getPrice());
                    parameter.setNotTaxPrice(e.getNotTaxPrice());
                    if (rentAcceptanceEntity.getEntranceRentFlag() == 1) {
                        parameter.setMeterRentDate(e.getMeterRentDate());
                    } else {
                        parameter.setMeterRentDate(null);
                    }
                    parameter.setOperationDate(new Date());
                    parameter.setEquipmentState(RentEquipmentStateEnum.\u5f85\u542f\u7528.getCode());
                    parameter.setQuantitiesNum(e.getQuantitiesNum() == null ? BigDecimal.ZERO : e.getQuantitiesNum());
                    this.parameterService.saveOrUpdate((Object)parameter, false);
                }
                break;
            }
            case \u542f\u7528\u5355: {
                RentEquipmentStartEntity startEntity = (RentEquipmentStartEntity)((Object)JSON.parseObject((String)json.toJSONString(), RentEquipmentStartEntity.class));
                RentEquipmentStartEntity startData = (RentEquipmentStartEntity)((Object)RentEntityUtil.selectOneService("id", startEntity.getId(), RentEquipmentStartServiceImpl.class));
                if (null != startData) {
                    return CommonResponse.error((String)msg);
                }
                startEntity.setRentType("1");
                startEntity.setType(1);
                this.startService.saveOrUpdate((Object)startEntity, false);
                List<RentEquipmentStartSubEntity> startSubEntityList = startEntity.getRentEquipmentStartSubList();
                for (RentEquipmentStartSubEntity subEntity : startSubEntityList) {
                    RentParameterEntity parameterEntity = new RentParameterEntity();
                    parameterEntity.setId(subEntity.getSourceId());
                    parameterEntity.setStartDate(startEntity.getTypeDate());
                    parameterEntity.setOperationDate(new Date());
                    parameterEntity.setEquipmentState(RentEquipmentStateEnum.\u542f\u7528.getCode());
                    if (EntranceRentFlagEnum.\u662f.getCode().equals(startEntity.getEntranceRentFlag())) {
                        parameterEntity.setMeterRentDate(subEntity.getTypeDate());
                    }
                    parameterList.add(parameterEntity);
                }
                this.logger.info("\u63a8\u9001\u53f0\u8d26\u6570\u636eparameterList\uff1a{}", (Object)JSONObject.toJSONString(parameterList));
                this.parameterService.changeParameter(parameterList, RentParameterTypeEnum.\u542f\u7528\u5355.getCode());
                break;
            }
            case \u505c\u7528\u5355: {
                RentEquipmentStopEntity stopEntity = (RentEquipmentStopEntity)((Object)JSON.parseObject((String)json.toJSONString(), RentEquipmentStopEntity.class));
                RentEquipmentStopEntity stopData = (RentEquipmentStopEntity)((Object)RentEntityUtil.selectOneService("id", stopEntity.getId(), RentEquipmentStopServiceImpl.class));
                if (null != stopData) {
                    return CommonResponse.error((String)msg);
                }
                stopEntity.setRentType("1");
                stopEntity.setType(0);
                this.stopService.saveOrUpdate((Object)stopEntity, false);
                List<RentEquipmentStopSubEntity> subEntityList = stopEntity.getRentEquipmentStopSubList();
                for (RentEquipmentStopSubEntity subEntity : subEntityList) {
                    RentParameterEntity parameterEntity = new RentParameterEntity();
                    parameterEntity.setId(subEntity.getSourceId());
                    parameterEntity.setStopDate(subEntity.getTypeDate());
                    parameterEntity.setOperationDate(new Date());
                    if (EntranceRentFlagEnum.\u662f.getCode().equals(stopEntity.getEntranceRentFlag())) {
                        parameterEntity.setEquipmentState(RentEquipmentStateEnum.\u505c\u79df.getCode());
                    } else {
                        parameterEntity.setEquipmentState(RentEquipmentStateEnum.\u505c\u7528.getCode());
                    }
                    parameterList.add(parameterEntity);
                }
                this.logger.info("\u63a8\u9001\u53f0\u8d26\u6570\u636eparameterList\uff1a{}", (Object)JSONObject.toJSONString(parameterList));
                this.parameterService.changeParameter(parameterList, RentParameterTypeEnum.\u505c\u7528\u5355.getCode());
                break;
            }
            case \u79df\u8d41\u5408\u540c\u7ed3\u7b97\u5355: {
                RentSettlementEntity settleEntity = (RentSettlementEntity)((Object)JSON.parseObject((String)json.toJSONString(), RentSettlementEntity.class));
                RentSettlementEntity settleData = (RentSettlementEntity)((Object)RentEntityUtil.selectOneService("id", settleEntity.getId(), RentSettlementServiceImpl.class));
                if (null != settleData) {
                    return CommonResponse.error((String)msg);
                }
                UserContext userContext = this.sessionManager.getUserContext();
                Boolean poolRes = this.settleService.pushSettleToPool((RentSettlementVO)BeanMapper.map((Object)((Object)settleEntity), RentSettlementVO.class));
                if (Boolean.TRUE.equals(poolRes)) {
                    settleEntity.setBillPushFlag(BillPushStatusEnum.\u63a8\u9001\u6210\u529f.getStatus());
                } else {
                    settleEntity.setBillPushFlag(BillPushStatusEnum.\u672a\u6210\u529f\u63a8\u9001.getStatus());
                }
                this.settleService.updateContractPoolSettle((RentSettlementVO)BeanMapper.map((Object)((Object)settleEntity), RentSettlementVO.class), true);
                this.settleService.saveOrUpdate((Object)settleEntity, false);
                if (CollectionUtils.isNotEmpty(settleEntity.getRentSettlementRentalList())) {
                    List<RentSettlementRentalEntity> rentalList = settleEntity.getRentSettlementRentalList();
                    List<Long> ids = rentalList.stream().filter(t -> t.getSourceId() != null).map(RentSettlementRentalEntity::getSourceId).collect(Collectors.toList());
                    this.rentalService.updateRentalSettlementState(ids, RentalSettlementStateEnum.\u5df2\u7ed3\u7b97.getCode());
                }
                if (settleEntity.getSettlementType() == 1) {
                    LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
                    updateWrapper.set(RentContractEntity::getContractPerformanceState, (Object)ContractPerformanceStateEnum.\u5df2\u7ec8\u6b62.getStateCode());
                    updateWrapper.eq(BaseEntity::getId, (Object)settleEntity.getContractId());
                    this.service.update((Wrapper)updateWrapper);
                    ExecutionVO executionVO = this.settleService.targetCost(settleEntity);
                    CommonResponse response = this.executionApi.aggPush(executionVO);
                    if (!response.isSuccess()) {
                        this.logger.error("\u63a8\u9001\u76ee\u6807\u6210\u672c\u5931\u8d25: , {}", (Object)response.getMsg());
                        throw new BusinessException(response.getMsg());
                    }
                }
                this.logger.info("\u63a8\u9001\u5b9e\u9645\u6210\u672c---");
                this.settleService.costPush(settleEntity);
                break;
            }
            case \u79df\u91d1\u8ba1\u7b97\u5355: {
                RentRentalEntity rentalEntity = (RentRentalEntity)((Object)JSON.parseObject((String)json.toJSONString(), RentRentalEntity.class));
                this.logger.info("\u63a5\u6536\u5230\u79df\u91d1\u8ba1\u7b97\u5355\uff1a{}", (Object)JSONObject.toJSONString((Object)((Object)rentalEntity)));
                RentRentalEntity rentalData = (RentRentalEntity)((Object)RentEntityUtil.selectOneService("id", rentalEntity.getId(), RentRentalServiceImpl.class));
                if (null != rentalData) {
                    return CommonResponse.error((String)msg);
                }
                this.rentalService.saveOrUpdate((Object)rentalEntity, false);
                this.logger.info("\u79df\u91d1\u8ba1\u7b97\u63a8\u9001\u5b9e\u9645\u6210\u672c---");
                this.rentalService.costPush(rentalEntity);
                break;
            }
            case \u9000\u573a\u5355: {
                AppearanceEntity appearanceEntity = (AppearanceEntity)((Object)JSON.parseObject((String)json.toJSONString(), AppearanceEntity.class));
                AppearanceEntity appearanceData = (AppearanceEntity)((Object)RentEntityUtil.selectOneService("id", appearanceEntity.getId(), AppearanceServiceImpl.class));
                if (null != appearanceData) {
                    return CommonResponse.error((String)msg);
                }
                appearanceEntity.setRentType("1");
                this.appearanceService.saveOrUpdate((Object)appearanceEntity, false);
                for (AppearanceSubEntity subEntity : appearanceEntity.getAppearanceSubList()) {
                    RentParameterEntity parameterEntity = new RentParameterEntity();
                    parameterEntity.setId(subEntity.getSourceId());
                    parameterEntity.setOutDate(appearanceEntity.getAppearanceDate());
                    parameterEntity.setOperationDate(new Date());
                    parameterEntity.setEquipmentState(RentEquipmentStateEnum.\u9000\u573a.getCode());
                    if (subEntity.getState() == 6) continue;
                    ArrayList<RentParameterDetailEntity> parameterDetailList = new ArrayList<RentParameterDetailEntity>();
                    RentParameterDetailEntity detailEntity = new RentParameterDetailEntity();
                    detailEntity.setSourceType(RentParameterTypeEnum.\u9000\u573a\u5355.getCode());
                    detailEntity.setSourceId(appearanceEntity.getId());
                    detailEntity.setOperationDate(appearanceEntity.getRentEndDate());
                    detailEntity.setEquipmentState(RentEquipmentStateEnum.\u542f\u7528.getCode());
                    detailEntity.setParameterId(subEntity.getSourceId());
                    parameterDetailList.add(detailEntity);
                    parameterEntity.setRentParameterDetailList(parameterDetailList);
                    parameterList.add(parameterEntity);
                }
                this.parameterService.changeParameter(parameterList, RentParameterTypeEnum.\u505c\u7528\u5355.getCode());
            }
        }
        return CommonResponse.success((String)"\u540c\u6b65\u6210\u529f\uff01");
    }

    @PostMapping(value={"/delReceipts"})
    public CommonResponse<String> delReceipts(@RequestParam(value="id") Long id, @RequestParam(value="type") String type) {
        String msg = "\u64cd\u4f5c\u5931\u8d25,\u672a\u67e5\u5230\u5355\u636e!";
        switch (RentReceiptsEnum.getEnumByName((String)type)) {
            case \u9a8c\u6536\u5355: {
                RentAcceptanceEntity data = (RentAcceptanceEntity)((Object)RentEntityUtil.selectOneService("id", id, RentAcceptanceServiceImpl.class));
                if (null == data) {
                    return CommonResponse.error((String)msg);
                }
                this.checkService.delById(id);
                break;
            }
            case \u542f\u7528\u5355: {
                RentEquipmentStartEntity startData = (RentEquipmentStartEntity)((Object)RentEntityUtil.selectOneService("id", id, RentEquipmentStartServiceImpl.class));
                if (null == startData) {
                    return CommonResponse.error((String)msg);
                }
                this.startService.delById(id);
                break;
            }
            case \u505c\u7528\u5355: {
                RentEquipmentStopEntity stopData = (RentEquipmentStopEntity)((Object)RentEntityUtil.selectOneService("id", id, RentEquipmentStopServiceImpl.class));
                if (null == stopData) {
                    return CommonResponse.error((String)msg);
                }
                this.stopService.delById(id);
                break;
            }
            case \u9000\u573a\u5355: {
                AppearanceEntity appearanceEntity = (AppearanceEntity)((Object)RentEntityUtil.selectOneService("id", id, AppearanceServiceImpl.class));
                if (null == appearanceEntity) {
                    return CommonResponse.error((String)msg);
                }
                this.appearanceService.delById(id);
                break;
            }
            case \u79df\u8d41\u5408\u540c\u7ed3\u7b97\u5355: {
                RentSettlementEntity settleData = (RentSettlementEntity)((Object)RentEntityUtil.selectOneService("id", id, RentSettlementServiceImpl.class));
                if (null == settleData) {
                    return CommonResponse.error((String)msg);
                }
                Boolean unPushRes = this.settleService.delSettleFromPool(settleData.getId());
                if (!Boolean.TRUE.equals(unPushRes)) {
                    throw new BusinessException("\u7ed3\u7b97\u5355\u4ece\u7ed3\u7b97\u6c60\u5220\u9664\u5931\u8d25!");
                }
                settleData.setBillPushFlag(BillPushStatusEnum.\u672a\u6210\u529f\u63a8\u9001.getStatus());
                LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
                updateWrapper.set(RentContractEntity::getContractPerformanceState, (Object)ContractPerformanceStateEnum.\u5c65\u7ea6\u4e2d.getStateCode());
                updateWrapper.eq(BaseEntity::getId, (Object)settleData.getContractId());
                this.service.update((Wrapper)updateWrapper);
                this.settleService.updateContractPoolSettle((RentSettlementVO)BeanMapper.map((Object)((Object)settleData), RentSettlementVO.class), false);
                if (CollectionUtils.isNotEmpty(settleData.getRentSettlementRentalList())) {
                    List<RentSettlementRentalEntity> rentalList = settleData.getRentSettlementRentalList();
                    List<Long> ids = rentalList.stream().filter(t -> t.getSourceId() != null).map(RentSettlementRentalEntity::getSourceId).collect(Collectors.toList());
                    this.rentalService.updateRentalSettlementState(ids, RentalSettlementStateEnum.\u672a\u7ed3\u7b97.getCode());
                }
                ArrayList<TotalExecutionVO> totalExecutionVOList = new ArrayList<TotalExecutionVO>();
                ExecutionVO executionVO = this.settleService.targetCost(settleData);
                totalExecutionVOList.add(executionVO.getTotalVO());
                CommonResponse response = this.executionApi.aggDel(totalExecutionVOList);
                if (!response.isSuccess()) {
                    throw new BusinessException("\u76ee\u6807\u6210\u672c\u5220\u9664\u5931\u8d25\uff01");
                }
                this.logger.info("\u5220\u9664\u5b9e\u9645\u6210\u672c---");
                this.settleService.delById(id);
                break;
            }
            case \u79df\u91d1\u8ba1\u7b97\u5355: {
                RentRentalEntity rentalEntity = (RentRentalEntity)((Object)RentEntityUtil.selectOneService("id", id, RentRentalServiceImpl.class));
                this.logger.info("\u67e5\u5230\u79df\u91d1\u8ba1\u7b97\u5355\uff1a{}", (Object)JSONObject.toJSONString((Object)((Object)rentalEntity)));
                if (null == rentalEntity) {
                    return CommonResponse.error((String)msg);
                }
                this.logger.info("\u5220\u9664\u6210\u672c\u4e2d\u5fc3\u4e4b\u524d\u7684\u6570\u636e-Id---{}", (Object)id);
                CommonResponse stringCommonResponse = this.costDetailApi.deleteSubject(id);
                this.logger.info("\u7ed3\u679c" + JSONObject.toJSONString((Object)stringCommonResponse));
                if (!stringCommonResponse.isSuccess()) {
                    throw new BusinessException(stringCommonResponse.getMsg());
                }
                this.logger.info("\u5220\u9664\u79df\u91d1\u8ba1\u7b97\u5355---");
                this.rentalService.delRentalById(id);
            }
        }
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f!");
    }

    @PostMapping(value={"/updateEquipmentState"})
    public CommonResponse<String> updateEquipmentState(@RequestBody JSONArray jsonArray, @RequestParam(value="updateStartFlag") Boolean updateStartFlag) {
        List rentParameterList = jsonArray.toJavaList(RentParameterVO.class);
        if (CollectionUtils.isEmpty((Collection)rentParameterList)) {
            throw new BusinessException("\u4f20\u53c2\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        this.logger.info("\u83b7\u53d6\u53c2\u6570rentParameterList\uff1a{}", (Object)JSONObject.toJSONString((Object)rentParameterList));
        Map<String, Integer> equipmentStateMap = rentParameterList.stream().collect(Collectors.toMap(RentParameterVO::getFactoryCode, RentParameterVO::getEquipmentState, (k1, k2) -> k2));
        Map<String, Date> equipmentStartDateMap = rentParameterList.stream().collect(Collectors.toMap(RentParameterVO::getFactoryCode, RentParameterVO::getStartDate, (k1, k2) -> k2));
        Map<String, Date> equipmentStopDateMap = rentParameterList.stream().collect(Collectors.toMap(RentParameterVO::getFactoryCode, RentParameterVO::getStopDate, (k1, k2) -> k2));
        Map<String, Date> equipmentOutDateMap = rentParameterList.stream().collect(Collectors.toMap(RentParameterVO::getFactoryCode, RentParameterVO::getOutDate, (k1, k2) -> k2));
        List factoryCodeList = rentParameterList.stream().map(RentParameterVO::getFactoryCode).collect(Collectors.toList());
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("factory_code", new Parameter("in", factoryCodeList));
        List rentParameterEntityList = this.parameterService.queryList(queryParam);
        if (CollectionUtils.isEmpty((Collection)rentParameterEntityList)) {
            throw new BusinessException("\u64cd\u4f5c\u5931\u8d25,\u672a\u67e5\u5230\u5bf9\u5e94\u5355\u636e\uff01");
        }
        this.logger.info("\u67e5\u8be2\u5230\u53f0\u8d26\u4fe1\u606frentParameterList\uff1a{}", (Object)JSONObject.toJSONString((Object)rentParameterEntityList));
        for (RentParameterEntity rentParameterEntity : rentParameterEntityList) {
            if (null == equipmentStateMap.get(rentParameterEntity.getFactoryCode())) continue;
            rentParameterEntity.setEquipmentState(equipmentStateMap.get(rentParameterEntity.getFactoryCode()));
            rentParameterEntity.setStartDate(equipmentStartDateMap.get(rentParameterEntity.getFactoryCode()));
            rentParameterEntity.setStopDate(equipmentStopDateMap.get(rentParameterEntity.getFactoryCode()));
            rentParameterEntity.setOutDate(equipmentOutDateMap.get(rentParameterEntity.getFactoryCode()));
            rentParameterEntity.setOperationDate(new Date());
            if (!updateStartFlag.booleanValue()) continue;
            rentParameterEntity.setMeterRentDate(null);
            rentParameterEntity.setStartDate(null);
        }
        this.parameterService.saveOrUpdateBatch(rentParameterEntityList, rentParameterEntityList.size(), false);
        return CommonResponse.success((String)"\u4fee\u6539\u6210\u529f!");
    }

    private void orderSync(JSONObject json) {
        RentOrderEntity orderEntity = (RentOrderEntity)((Object)JSON.parseObject((String)json.toJSONString(), RentOrderEntity.class));
        RentOrderEntity orderData = (RentOrderEntity)((Object)RentEntityUtil.selectOneService("id", orderEntity.getId(), RentOrderServiceImpl.class));
        if (null != orderData) {
            List<RentOrderDetailEntity> list = orderEntity.getRentOrderDetailList();
            if (orderEntity.getReceiveState() == 1 || orderEntity.getReceiveState() == 2) {
                orderData.setReceiveState(orderEntity.getReceiveState());
                if (CollectionUtils.isNotEmpty(orderData.getRentOrderDetailList())) {
                    Map collect = list.stream().collect(Collectors.toMap(BaseEntity::getId, Function.identity(), (k1, k2) -> k2));
                    for (RentOrderDetailEntity detailEntity : orderData.getRentOrderDetailList()) {
                        if (collect.get(detailEntity.getId()) == null) continue;
                        RentOrderDetailEntity detail = (RentOrderDetailEntity)((Object)collect.get(detailEntity.getId()));
                        detailEntity.setReceiveNumsSum(detail.getReceiveNumsSum());
                    }
                }
            } else {
                orderData.setReceiveReason(orderEntity.getReceiveReason());
                orderData.setReceiveState(orderEntity.getReceiveState());
            }
            this.orderService.saveOrUpdate((Object)orderData, false);
        }
    }

    @GetMapping(value={"/writeBackSign"})
    public CommonResponse<String> writeBackSign(@RequestParam(value="id") String id, @RequestParam(value="type") String type) {
        CommonResponse userResp = this.userApi.findUserByUserId(InvocationInfoProxy.getUserid());
        if (!userResp.isSuccess()) {
            this.logger.error("\u67e5\u8be2\u5f53\u524d\u7528\u6237id-{},\u4fe1\u606f\u5931\u8d25\uff0c {}", (Object)InvocationInfoProxy.getUserid(), (Object)userResp.getMsg());
            throw new BusinessException("\u67e5\u8be2\u5f53\u524d\u7528\u6237\u4fe1\u606f\u5931\u8d25!");
        }
        UserVO user = (UserVO)userResp.getData();
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("billId", id);
        map.put("supOperatorName", user.getUserName());
        map.put("supOperatorPhone", user.getUserMobile());
        map.put("supOperatorUserCode", user.getUserCode());
        map.put("supOperateTime", Long.toString(System.currentTimeMillis()));
        if (Boolean.FALSE.equals(true)) {
            return CommonResponse.error((String)"\u56de\u5199\u5931\u8d25!");
        }
        switch (RentReceiptsEnum.getEnumBySourceName((String)type)) {
            case \u9a8c\u6536\u5355: {
                RentAcceptanceEntity entity = (RentAcceptanceEntity)((Object)this.checkService.selectById((Serializable)((Object)id)));
                entity.setSupOperateTime(new Date());
                entity.setSupOperatorPhone(user.getUserMobile());
                entity.setSupOperatorName(user.getUserName());
                entity.setSupOperatorUserCode(user.getUserCode());
                entity.setSignStatus(SupplierSignStatusEnum.\u4e59\u65b9\u5df2\u7b7e\u5b57.getCode());
                this.checkService.saveOrUpdate((Object)entity, false);
                break;
            }
            case \u542f\u7528\u5355: {
                RentEquipmentStartEntity startEntity = (RentEquipmentStartEntity)((Object)this.startService.selectById((Serializable)((Object)id)));
                startEntity.setSupOperateTime(new Date());
                startEntity.setSupOperatorPhone(user.getUserMobile());
                startEntity.setSupOperatorName(user.getUserName());
                startEntity.setSupOperatorUserCode(user.getUserCode());
                startEntity.setSignState(SupplierSignStatusEnum.\u4e59\u65b9\u5df2\u7b7e\u5b57.getCode());
                this.startService.saveOrUpdate((Object)startEntity, false);
                break;
            }
            case \u505c\u7528\u5355: {
                RentEquipmentStopEntity stopEntity = (RentEquipmentStopEntity)((Object)this.stopService.selectById((Serializable)((Object)id)));
                stopEntity.setSupOperateTime(new Date());
                stopEntity.setSupOperatorPhone(user.getUserMobile());
                stopEntity.setSupOperatorName(user.getUserName());
                stopEntity.setSupOperatorUserCode(user.getUserCode());
                stopEntity.setSignStatus(SupplierSignStatusEnum.\u4e59\u65b9\u5df2\u7b7e\u5b57.getCode());
                this.stopService.saveOrUpdate((Object)stopEntity, false);
                break;
            }
            default: {
                RentSettlementEntity settleEntity = (RentSettlementEntity)((Object)this.settleService.selectById((Serializable)((Object)id)));
                settleEntity.setSupOperateTime(new Date());
                settleEntity.setSupOperatorPhone(user.getUserMobile());
                settleEntity.setSupOperatorName(user.getUserName());
                settleEntity.setSupOperatorUserCode(user.getUserCode());
                settleEntity.setSignStatus(SupplierSignStatusEnum.\u4e59\u65b9\u5df2\u7b7e\u5b57.getCode());
                this.settleService.saveOrUpdate((Object)settleEntity, false);
            }
        }
        this.signSync(id, RentReceiptsEnum.getEnumBySourceName((String)type).getCode(), RentReceiptsEnum.getEnumBySourceName((String)type).getFileType(), StatusTypeEnum.getEnumByName((String)type).getCode(), StatusTypeEnum.getEnumByName((String)type).getFileType());
        return CommonResponse.success((String)"\u56de\u5199\u6210\u529f!");
    }

    private void signSync(String id, String sourceBillType, String sourceBillSourceType, String targetBillType, String targetBillSourceType) {
        CommonResponse response = this.attachmentApi.copyFilesFromSourceBillToTargetBill(id, sourceBillType, sourceBillSourceType, id, targetBillType, targetBillSourceType);
        if (!response.isSuccess()) {
            throw new BusinessException("\u540c\u6b65\u5355\u636e\u9644\u4ef6\u5931\u8d25\uff01");
        }
    }
}

