/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.rent.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.ac.enums.BillPushStatusEnum;
import com.ejianc.business.procost.api.ICostDetailApi;
import com.ejianc.business.rent.bean.RentRentalEntity;
import com.ejianc.business.rent.bean.RentSettlementEntity;
import com.ejianc.business.rent.service.IRentSettlementService;
import com.ejianc.business.rent.vo.ExportRentSettlementVO;
import com.ejianc.business.rent.vo.RentRentalVO;
import com.ejianc.business.rent.vo.RentSettleRecordVO;
import com.ejianc.business.rent.vo.RentSettlementVO;
import com.ejianc.business.targetcost.api.IExecutionApi;
import com.ejianc.business.targetcost.vo.ExecutionVO;
import com.ejianc.business.targetcost.vo.ParamsCheckVO;
import com.ejianc.business.targetcost.vo.TotalExecutionVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.share.api.IProSupplierApi;
import com.ejianc.foundation.share.api.IShareCooperateApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.time.DateFormatUtil;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"rentSettlement"})
@Api(value="\u8bbe\u5907\u79df\u8d41\u7ed3\u7b97\u4e3b\u8868", tags={"\u8bbe\u5907\u79df\u8d41\u7ed3\u7b97\u4e3b\u8868"})
public class RentSettlementController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private IExecutionApi executionApi;
    @Autowired
    private ICostDetailApi costDetailApi;
    private static final String BILL_CODE = "RENT_SETTLE";
    @Autowired
    private IRentSettlementService service;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IShareCooperateApi shareCooperateApi;
    @Autowired
    private IProSupplierApi proSupplierApi;
    private final String mobileBillShareFrontUrl = "/ejc-supbusiness-mobile/#/proEquipments/equipmentRent/card";
    private final String billTypeCode = "EJCBT202204000006";

    @PostMapping(value={"/supSignSync"})
    @ResponseBody
    public CommonResponse<String> supSignSync(HttpServletRequest request) {
        String msg = this.service.updateBillSupSignSyncInfo(request);
        if (StringUtils.isNotBlank((CharSequence)msg)) {
            return CommonResponse.error((String)msg);
        }
        return CommonResponse.success((String)"\u7b7e\u5b57\u72b6\u6001\u56de\u5199\u6210\u529f\uff01");
    }

    @ApiOperation(value="\u83b7\u53d6\u534f\u540c\u94fe\u63a5")
    @RequestMapping(value={"/getBillShareLink"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<JSONObject> getBillShareLink(@RequestParam Long id) {
        RentSettlementEntity entity = (RentSettlementEntity)((Object)this.service.selectById(id));
        CommonResponse supplierResp = this.proSupplierApi.whetherSupplierCoo(entity.getSupplierId());
        if (!supplierResp.isSuccess()) {
            this.logger.error("\u6839\u636e\u4f9b\u5e94\u5546\u4e3b\u952e-{}\u67e5\u8be2\u5931\u8d25\uff0c{}", (Object)entity.getSupplierId(), (Object)supplierResp.getMsg());
            return CommonResponse.error((String)"\u5355\u636e\u83b7\u53d6\u4f9b\u65b9\u4fe1\u606f\u5931\u8d25\uff0c\u751f\u6210\u5206\u4eab\u8fde\u63a5\u5931\u8d25\uff01");
        }
        Boolean flag = (Boolean)supplierResp.getData();
        if (!flag.booleanValue()) {
            return CommonResponse.error((String)"\u8be5\u4f9b\u5e94\u5546\u672a\u5f00\u901a\u534f\u540c\u6743\u9650\uff0c\u65e0\u6cd5\u534f\u540c\u5206\u4eab\u3002");
        }
        if (BillPushStatusEnum.\u672a\u6210\u529f\u63a8\u9001.getStatus().equals(entity.getBillPushFlag())) {
            CommonResponse cooperateResp = this.shareCooperateApi.queryCooperateBybillTypeCode("EJCBT202204000006");
            if (!cooperateResp.isSuccess()) {
                this.logger.error("\u6839\u636e\u5355\u636e\u7c7b\u578b-{}\u67e5\u8be2\u5176\u534f\u540c\u914d\u7f6e\u4fe1\u606f\u5931\u8d25, \u4e0d\u8fdb\u884c\u5355\u636e\u63a8\u9001\u64cd\u4f5c\uff0c{}", (Object)"EJCBT202204000006", (Object)cooperateResp.getMsg());
                return CommonResponse.error((String)"\u5355\u636e\u63a8\u9001\u4f9b\u65b9\u5931\u8d25\uff0c\u751f\u6210\u5206\u4eab\u8fde\u63a5\u5931\u8d25\uff01");
            }
            boolean pushResult = this.service.pushBillToSupCenter(entity);
            this.logger.info("\u83b7\u53d6\u63a8\u9001\u4f9b\u65b9\u7ed3\u679c--" + pushResult);
            if (!pushResult) {
                this.logger.error("\u5355\u636e-{}\u63a8\u9001\u7ed9\u4f9b\u5e94\u5546supplierId-{}\u5931\u8d25\uff01", (Object)id, (Object)entity.getSupplierId());
                return CommonResponse.error((String)"\u5355\u636e\u63a8\u9001\u4f9b\u65b9\u5931\u8d25\uff0c\u751f\u6210\u5206\u4eab\u8fde\u63a5\u5931\u8d25\uff01");
            }
            entity.setBillPushFlag(BillPushStatusEnum.\u63a8\u9001\u6210\u529f.getStatus());
            this.service.saveOrUpdate((Object)entity, false);
        }
        return this.shareCooperateApi.getShareLink(id, "EJCBT202204000006", entity.getSupplierId().toString(), "/ejc-supbusiness-mobile/#/proEquipments/equipmentRent/card", null);
    }

    @ApiOperation(value="\u65b0\u589e\u6216\u8005\u4fee\u6539")
    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<RentSettlementVO> saveOrUpdate(@ApiParam(name="saveOrUpdateVO", required=true) @RequestBody RentSettlementVO saveOrUpdateVO) {
        RentSettlementVO vo = this.service.saveOrUpdate(saveOrUpdateVO);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @ApiOperation(value="\u67e5\u8be2\u8be6\u60c5")
    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<RentSettlementVO> queryDetail(@RequestParam Long id) {
        RentSettlementEntity entity = (RentSettlementEntity)((Object)this.service.selectById(id));
        RentSettlementVO vo = (RentSettlementVO)BeanMapper.map((Object)((Object)entity), RentSettlementVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @ApiOperation(value="\u67e5\u8be2\u79df\u91d1\u5355\u636e")
    @RequestMapping(value={"/queryRental"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<List<RentRentalVO>> queryRental(@RequestParam Long contractId, @RequestParam(value="settleDate") String settleDate) {
        List<RentRentalEntity> rentalEntityList = this.service.queryRental(contractId, settleDate);
        List voList = BeanMapper.mapList(rentalEntityList, RentRentalVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u79df\u91d1\u6570\u636e\u6210\u529f\uff01", (Object)voList);
    }

    @ApiOperation(value="\u540c\u6b65\u7ed3\u7b97\u6c60\u63a5\u53e3")
    @RequestMapping(value={"/syncSettle"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<String> pushSettle(@RequestParam Long id) {
        RentSettlementEntity entity = (RentSettlementEntity)((Object)this.service.selectById(id));
        boolean pool = this.service.pushSettleToPool((RentSettlementVO)BeanMapper.map((Object)((Object)entity), RentSettlementVO.class));
        if (!pool) {
            throw new BusinessException("\u63a8\u9001\u7ed3\u7b97\u6c60\u5931\u8d25");
        }
        return CommonResponse.success((String)"\u540c\u6b65\u6210\u529f");
    }

    @RequestMapping(value={"/pushCost"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<RentSettlementVO> pushCost(@RequestBody RentSettlementVO vo) {
        return this.service.pushCost(vo);
    }

    @ApiOperation(value="\u83b7\u53d6\u6700\u8fd1\u4e00\u6b21\u7ed3\u7b97\u65e5\u671f\u548c\u7ed3\u7b97\u91d1\u989d\u3001\u7ed3\u7b97\u6b21\u6570")
    @RequestMapping(value={"/getDateMny"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<Map> getDateMny(@RequestParam Long contractId) {
        return this.service.getDateMny(contractId);
    }

    @ApiOperation(value="\u6279\u91cf\u5220\u9664\u5355\u636e")
    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<RentSettlementVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            ArrayList<TotalExecutionVO> totalExecutionVOList = new ArrayList<TotalExecutionVO>();
            for (RentSettlementVO vo : vos) {
                ExecutionVO executionVO = this.service.settlementTargetCost((RentSettlementEntity)((Object)this.service.selectById(vo.getId())), false);
                totalExecutionVOList.add(executionVO.getTotalVO());
                CommonResponse stringCommonResponse = this.costDetailApi.deleteSubject(vo.getId());
                this.logger.info("\u7ed3\u679c" + JSONObject.toJSONString((Object)stringCommonResponse));
                if (stringCommonResponse.isSuccess()) continue;
                throw new BusinessException(stringCommonResponse.getMsg());
            }
            CommonResponse response = this.executionApi.aggDel(totalExecutionVOList);
            if (!response.isSuccess()) {
                throw new BusinessException(response.getMsg());
            }
        }
        this.service.delete(vos.stream().map(BaseVO::getId).collect(Collectors.toList()));
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @ApiOperation(value="\u67e5\u8be2\u5217\u8868")
    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<RentSettlementVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("contractName");
        fuzzyFields.add("projectName");
        fuzzyFields.add("supplierName");
        fuzzyFields.add("employeeName");
        fuzzyFields.add("billCode");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (!param.getParams().containsKey("orgId")) {
            UserContext userContextCache = this.sessionManager.getUserContext();
            String authOrgIds = userContextCache.getAuthOrgIds();
            List orgVOList = null;
            orgVOList = StringUtils.isNotBlank((CharSequence)authOrgIds) ? (List)this.getRespData(this.iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002") : (List)this.getRespData(this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002");
            ArrayList commonOrgIds = new ArrayList();
            ArrayList departmentIds = new ArrayList();
            orgVOList.stream().forEach(org -> {
                if (5 == org.getOrgType()) {
                    departmentIds.add(org.getId());
                } else {
                    commonOrgIds.add(org.getId());
                }
            });
            if (CollectionUtils.isNotEmpty(commonOrgIds)) {
                param.getParams().put("parentOrgId", new Parameter("in", commonOrgIds));
            } else if (CollectionUtils.isNotEmpty(departmentIds)) {
                param.getParams().put("orgId", new Parameter("in", departmentIds));
            }
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), RentSettlementVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @ApiOperation(value="\u5bfc\u51fa")
    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("contractName");
        fuzzyFields.add("projectName");
        fuzzyFields.add("supplierName");
        fuzzyFields.add("employeeName");
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        List list = this.service.queryList(param);
        ArrayList<ExportRentSettlementVO> settlementVOS = new ArrayList<ExportRentSettlementVO>();
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            for (RentSettlementEntity entity : list) {
                ExportRentSettlementVO map = (ExportRentSettlementVO)BeanMapper.map((Object)((Object)entity), ExportRentSettlementVO.class);
                if (entity.getSettlementDate() != null) {
                    map.setSettlementDate(DateFormatUtil.formatDate((String)"yyyy-MM-dd", (Date)entity.getSettlementDate()));
                }
                switch (entity.getSignStatus()) {
                    case 0: {
                        map.setSignStatus("\u672a\u7b7e\u5b57");
                        break;
                    }
                    case 1: {
                        map.setSignStatus("\u5df2\u7b7e\u5b57");
                    }
                }
                switch (entity.getSignatureStatus()) {
                    case 0: {
                        map.setSignatureStatus("\u672a\u7b7e\u7ae0");
                    }
                }
                switch (entity.getBillState()) {
                    case 0: {
                        map.setBillState("\u81ea\u7531\u6001");
                        break;
                    }
                    case 1: {
                        map.setBillState("\u5df2\u63d0\u4ea4");
                        break;
                    }
                    case 2: {
                        map.setBillState("\u5ba1\u6279\u4e2d");
                        break;
                    }
                    case 3: {
                        map.setBillState("\u5ba1\u6279\u901a\u8fc7");
                        break;
                    }
                    case 4: {
                        map.setBillState("\u5ba1\u6279\u9a73\u56de");
                        break;
                    }
                    case 5: {
                        map.setBillState("\u5ba1\u6279\u4e2d");
                    }
                }
                settlementVOS.add(map);
            }
        }
        HashMap<String, ArrayList<ExportRentSettlementVO>> beans = new HashMap<String, ArrayList<ExportRentSettlementVO>>();
        beans.put("records", settlementVOS);
        ExcelExport.getInstance().export("RentSettlement-export.xlsx", beans, response);
    }

    @ApiOperation(value="\u53c2\u7167")
    @RequestMapping(value={"/refRentSettlementData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<RentSettlementVO>> refRentSettlementData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject jSONObject = JSONObject.parseObject((String)condition);
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), RentSettlementVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/checkParams"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<ParamsCheckVO> checkParams(@RequestBody RentSettlementVO rentSettlementVO) {
        return CommonResponse.success((String)"\u53c2\u6570\u6821\u9a8c\u6210\u529f\uff01", (Object)this.service.checkParams(rentSettlementVO));
    }

    @RequestMapping(value={"/pushTargetCost"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<String> pushTargetCost(Long id) {
        return this.service.pushTargetCost(id);
    }

    @RequestMapping(value={"/pushSettlementTargetCost"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<String> pushSettlementTargetCost(Long id) {
        return this.service.pushSettlementTargetCost(id);
    }

    @GetMapping(value={"/queryDetailRecord"})
    @ResponseBody
    public CommonResponse<RentSettleRecordVO> queryDetailRecord(Long id) {
        RentSettleRecordVO vo = this.service.queryDetailRecord(id);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @GetMapping(value={"/allRentSettlementPushTargetCost"})
    @ResponseBody
    public CommonResponse<String> allRentSettlementPushTargetCost(@RequestParam(value="projectId", required=false) Long projectId) {
        List settlementEntityList;
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.select(new String[]{"id"});
        if (null != projectId) {
            queryWrapper.eq((Object)"project_id", (Object)projectId);
        }
        if (CollectionUtils.isNotEmpty((Collection)(settlementEntityList = this.service.list((Wrapper)queryWrapper)))) {
            for (RentSettlementEntity settlementEntity : settlementEntityList) {
                this.service.pushSettlementTargetCost(settlementEntity.getId());
            }
        }
        this.logger.info("\u8bbe\u5907\u79df\u8d41\u7ed3\u7b97\u63a8\u9001\u76ee\u6807\u6210\u672c\u6570\u636e{}\u6761", (Object)settlementEntityList.size());
        return CommonResponse.success((String)"\u5168\u8bbe\u5907\u79df\u8d41\u7ed3\u7b97\u63a8\u9001\u76ee\u6807\u6210\u672c\u6570\u636e\u6210\u529f\uff01");
    }

    @GetMapping(value={"/allFinishRentSettlementPushTargetCost"})
    @ResponseBody
    public CommonResponse<String> allFinishRentSettlementPushTargetCost(@RequestParam(value="projectId", required=false) Long projectId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.select(new String[]{"id"});
        if (null != projectId) {
            queryWrapper.eq((Object)"project_id", (Object)projectId);
        }
        queryWrapper.in((Object)"bill_state", Arrays.asList(BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode()));
        queryWrapper.eq((Object)"settlement_type", (Object)1);
        List settleEntityList = this.service.list((Wrapper)queryWrapper);
        if (CollectionUtils.isNotEmpty((Collection)settleEntityList)) {
            for (RentSettlementEntity settle : settleEntityList) {
                this.service.pushTargetCost(settle.getId());
            }
        }
        this.logger.info("\u5168\u751f\u6548\u8bbe\u5907\u79df\u8d41\u6700\u7ec8\u7ed3\u7b97\u63a8\u9001\u76ee\u6807\u6210\u672c\u6570\u636e{}\u6761", (Object)settleEntityList.size());
        return CommonResponse.success((String)"\u5168\u751f\u6548\u8bbe\u5907\u79df\u8d41\u6700\u7ec8\u7ed3\u7b97\u63a8\u9001\u76ee\u6807\u6210\u672c\u6570\u636e\u6210\u529f\uff01");
    }
}

