/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.temporary.contract.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.contractbase.pool.enums.ContractPerformanceStateEnum;
import com.ejianc.business.rent.enums.ChangeStatusEnum;
import com.ejianc.business.rent.enums.DraftTypeEnum;
import com.ejianc.business.rent.enums.SignatureStatusEnum;
import com.ejianc.business.temporary.contract.bean.TemporaryContractChangeEntity;
import com.ejianc.business.temporary.contract.bean.TemporaryContractEntity;
import com.ejianc.business.temporary.contract.service.ITemporaryContractChangeService;
import com.ejianc.business.temporary.contract.service.ITemporaryContractService;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="temporaryContractChange")
public class TemporaryContractChangeBpmServiceImpl
implements ICommonBusinessService {
    @Autowired
    private ITemporaryContractService contractService;
    @Autowired
    private ITemporaryContractChangeService temporaryContractChangeService;
    @Autowired
    private SessionManager sessionManager;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;

    public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        TemporaryContractChangeEntity e = (TemporaryContractChangeEntity)((Object)this.temporaryContractChangeService.selectById(billId));
        UserContext userContext = this.sessionManager.getUserContext();
        e.setCommitDate(new Date());
        e.setCommitUserCode(userContext.getUserCode());
        e.setCommitUserName(userContext.getUserName());
        this.temporaryContractChangeService.saveOrUpdate((Object)e, false);
        return CommonResponse.success((String)"\u53d8\u66f4\u56de\u8c03\u5904\u7406\u5b8c\u6210\uff01");
    }

    public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return this.doBpmBack(billId, state, billTypeCode);
    }

    public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        TemporaryContractChangeEntity changeEntity = (TemporaryContractChangeEntity)((Object)this.temporaryContractChangeService.selectById(billId));
        this.logger.info("\u53d8\u66f4\u5355\u7ec8\u5ba1\u5ba1\u6279\u524d\u53d8\u66f4\u8868\u6570\u636e------------->: {}", (Object)JSONObject.toJSONString((Object)((Object)changeEntity)));
        if (null != changeEntity && !changeEntity.getBillState().equals(BillStateEnum.UNCOMMITED_STATE.getBillStateCode()) && !changeEntity.getBillState().equals(BillStateEnum.UNAPPROVED.getBillStateCode())) {
            return CommonResponse.error((String)"\u8be5\u5355\u636e\u5df2\u88ab\u4fee\u6539\uff0c\u8bf7\u52ff\u91cd\u590d\u63d0\u4ea4\uff01");
        }
        return CommonResponse.success((String)"\u53d8\u66f4\u5355\u7ec8\u5ba1\u5ba1\u6279\u524d\u56de\u8c03\u5904\u7406\u6210\u529f\uff01");
    }

    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        TemporaryContractChangeEntity changeEntity = (TemporaryContractChangeEntity)((Object)this.temporaryContractChangeService.selectById(billId));
        TemporaryContractEntity contractEntity = (TemporaryContractEntity)((Object)this.contractService.selectById(changeEntity.getContractId()));
        if (null != contractEntity && !contractEntity.getContractPerformanceState().equals(ContractPerformanceStateEnum.\u5c65\u7ea6\u4e2d.getStateCode())) {
            return CommonResponse.error((String)"\u5f53\u524d\u53d8\u66f4\u5408\u540c\u6240\u5c5e\u7684\u4e3b\u5408\u540c\u72b6\u6001\u4e0d\u662f\u5c65\u7ea6\u4e2d\uff0c\u8be5\u53d8\u66f4\u5408\u540c\u4e0d\u80fd\u8fdb\u884c\u63d0\u4ea4\u64cd\u4f5c\uff01");
        }
        Boolean commitState = false;
        if (state.equals(BillStateEnum.COMMITED_STATE.getBillStateCode())) {
            commitState = true;
            changeEntity.setCommitDate(new Date());
            changeEntity.setCommitUserCode(this.sessionManager.getUserContext().getUserCode());
            changeEntity.setCommitUserName(this.sessionManager.getUserContext().getUserName());
        }
        if (DraftTypeEnum.\u7ebf\u4e0b\u7b7e\u8ba2.getCode().toString().equals(changeEntity.getChangeDraftType())) {
            return this.temporaryContractChangeService.effectiveSaveWriteContract(billId, billTypeCode, commitState);
        }
        if (commitState.booleanValue()) {
            this.temporaryContractChangeService.saveOrUpdate((Object)changeEntity);
        }
        contractEntity.setChangeStatus(ChangeStatusEnum.\u53d8\u66f4\u5355\u636e\u5ba1\u6279\u901a\u8fc7.getCode());
        this.contractService.saveOrUpdate((Object)contractEntity, false);
        this.logger.info("\u66f4\u65b0\u5408\u540c\u8868\u6570\u636e\u6210\u529f,contractEntity---------->: {}", (Object)JSONObject.toJSONString((Object)((Object)contractEntity)));
        return CommonResponse.success((String)"\u5ba1\u6279\u56de\u8c03\u5408\u540c\u6210\u529f\uff01");
    }

    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    @Transactional(rollbackFor={Exception.class})
    public CommonResponse<String> doBpmBack(Long billId, Integer state, String billTypeCode) {
        Object resp = null;
        TemporaryContractChangeEntity changeEntity = (TemporaryContractChangeEntity)((Object)this.temporaryContractChangeService.selectById(billId));
        if (!SignatureStatusEnum.\u672a\u7b7e\u7ae0.getCode().equals(changeEntity.getSignatureState())) {
            return CommonResponse.error((String)"\u5f53\u524d\u5355\u636e\u5df2\u6709\u7b7e\u7ae0\u6d41\u7a0b\uff0c\u4e0d\u80fd\u64a4\u56de\uff01");
        }
        changeEntity.setCommitDate(null);
        changeEntity.setCommitUserCode(null);
        changeEntity.setCommitUserName(null);
        this.temporaryContractChangeService.saveOrUpdate((Object)changeEntity);
        this.logger.info("\u64a4\u56de\u66f4\u65b0\u53d8\u66f4\u8868\u6570\u636e\u6210\u529f,contractEntity---------->: {}", (Object)JSONObject.toJSONString((Object)((Object)changeEntity)));
        TemporaryContractEntity contractEntity = (TemporaryContractEntity)((Object)this.contractService.selectById(changeEntity.getContractId()));
        contractEntity.setChangeStatus(ChangeStatusEnum.\u53d8\u66f4\u4e2d.getCode());
        this.contractService.saveOrUpdate((Object)contractEntity, false);
        this.logger.info("\u64a4\u56de\u66f4\u65b0\u5408\u540c\u8868\u6570\u636e\u6210\u529f,contractEntity---------->: {}", (Object)JSONObject.toJSONString((Object)((Object)contractEntity)));
        return CommonResponse.success((String)"\u6267\u884c\u53d8\u66f4\u5355\u64a4\u56de\u56de\u8c03\u903b\u8f91\u6210\u529f\uff01");
    }
}

