/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.rent.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.ac.enums.BillPushStatusEnum;
import com.ejianc.business.appearance.vo.PushAppearanceSubVO;
import com.ejianc.business.appearance.vo.PushAppearanceVO;
import com.ejianc.business.rent.bean.RentAcceptanceEntity;
import com.ejianc.business.rent.service.IRentAcceptanceService;
import com.ejianc.business.rent.service.impl.RentAcceptanceBpmServiceImpl;
import com.ejianc.business.rent.vo.RentAcceptanceVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.share.api.IProSupplierApi;
import com.ejianc.foundation.share.api.IShareCooperateApi;
import com.ejianc.foundation.share.vo.CooperateVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseVO;
import io.swagger.annotations.ApiOperation;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"rentAcceptance"})
public class RentAcceptanceController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IShareCooperateApi shareCooperateApi;
    @Autowired
    private RentAcceptanceBpmServiceImpl rentAcceptanceBpmService;
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    private static final String BILL_CODE = "RENT_ACCEPTANCE";
    private static final String BILL_TYPE = "BT220317000000015";
    @Autowired
    private IRentAcceptanceService service;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IProSupplierApi proSupplierApi;
    private static final String PUSH_SAVE_URL = "/ejc-supbusiness-web/openapi/rentAcceptance/saveCheck";
    private final String mobileBillShareFrontUrl = "/ejc-supbusiness-mobile/#/proEquipments/check/card";

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<RentAcceptanceVO> saveOrUpdate(@RequestBody RentAcceptanceVO saveOrUpdateVO) {
        RentAcceptanceEntity entity;
        OrgVO orgVO;
        CommonResponse orgResponse;
        if (StringUtils.isEmpty((CharSequence)saveOrUpdateVO.getParentOrgCode()) && saveOrUpdateVO.getParentOrgId() != null && (orgResponse = this.iOrgApi.getOneById(saveOrUpdateVO.getParentOrgId())).isSuccess()) {
            orgVO = (OrgVO)orgResponse.getData();
            saveOrUpdateVO.setParentOrgCode(orgVO.getCode());
        }
        if (StringUtils.isEmpty((CharSequence)saveOrUpdateVO.getOrgCode()) && saveOrUpdateVO.getOrgId() != null && (orgResponse = this.iOrgApi.getOneById(saveOrUpdateVO.getOrgId())).isSuccess()) {
            orgVO = (OrgVO)orgResponse.getData();
            saveOrUpdateVO.setOrgCode(orgVO.getCode());
        }
        if ((entity = (RentAcceptanceEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, RentAcceptanceEntity.class))).getId() == null || entity.getId() == 0L) {
            BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                entity.setCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        if (entity.getNotSignature() == null) {
            entity.setNotSignature(false);
        }
        entity.setRentType("0");
        entity.setBillPushFlag(BillPushStatusEnum.\u672a\u6210\u529f\u63a8\u9001.getStatus());
        entity.setSignStatus(0);
        this.service.saveOrUpdates(entity);
        RentAcceptanceVO vo = (RentAcceptanceVO)BeanMapper.map((Object)((Object)entity), RentAcceptanceVO.class);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @PostMapping(value={"/supSignSync"})
    @ResponseBody
    public CommonResponse<String> supSignSync(HttpServletRequest request) {
        String msg = this.service.updateBillSupSignSyncInfo(request);
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)msg)) {
            return CommonResponse.error((String)msg);
        }
        return CommonResponse.success((String)"\u7b7e\u5b57\u72b6\u6001\u56de\u5199\u6210\u529f\uff01");
    }

    @GetMapping(value={"/rentAcceptanceBpmService"})
    @ResponseBody
    public CommonResponse<String> rentAcceptanceBpmService() {
        this.rentAcceptanceBpmService.afterApprovalProcessor(579994856613511229L, null, null);
        return CommonResponse.success((String)"\u7b7e\u5b57\u72b6\u6001\u56de\u5199\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<RentAcceptanceVO> queryDetail(Long id) {
        RentAcceptanceEntity entity = (RentAcceptanceEntity)((Object)this.service.selectById(id));
        RentAcceptanceVO vo = (RentAcceptanceVO)BeanMapper.map((Object)((Object)entity), RentAcceptanceVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @ApiOperation(value="\u83b7\u53d6\u534f\u540c\u94fe\u63a5")
    @RequestMapping(value={"/getBillShareLink"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<JSONObject> getBillShareLink(@RequestParam Long id) {
        RentAcceptanceEntity entity = (RentAcceptanceEntity)((Object)this.service.selectById(id));
        CommonResponse supplierResp = this.proSupplierApi.whetherSupplierCoo(entity.getSupplierId());
        if (!supplierResp.isSuccess()) {
            this.logger.error("\u6839\u636e\u4f9b\u5e94\u5546\u4e3b\u952e-{}\u67e5\u8be2\u5931\u8d25\uff0c{}", (Object)entity.getSupplierId(), (Object)supplierResp.getMsg());
            return CommonResponse.error((String)"\u83b7\u53d6\u4f9b\u5e94\u5546\u4fe1\u606f\u5931\u8d25\uff01");
        }
        Boolean flag = (Boolean)supplierResp.getData();
        if (!flag.booleanValue()) {
            return CommonResponse.error((String)"\u8be5\u4f9b\u5e94\u5546\u672a\u5f00\u901a\u534f\u540c\u6743\u9650\uff0c\u65e0\u6cd5\u534f\u540c\u9a8c\u6536\u3002 \u8bf7\u5148\u5230\u4f9b\u5e94\u5546\u5e93\u2014\u751f\u6210\u534f\u540c\u8d26\u53f7\u518d\u8fdb\u884c\u8ba2\u5355\u64cd\u4f5c\u3002");
        }
        if (BillPushStatusEnum.\u672a\u6210\u529f\u63a8\u9001.getStatus().equals(entity.getBillPushFlag())) {
            CommonResponse cooperateResp = this.shareCooperateApi.queryCooperateBybillTypeCode(BILL_TYPE);
            if (!cooperateResp.isSuccess()) {
                this.logger.error("\u6839\u636e\u5355\u636e\u7c7b\u578b-{}\u67e5\u8be2\u5176\u534f\u540c\u914d\u7f6e\u4fe1\u606f\u5931\u8d25, \u4e0d\u8fdb\u884c\u5355\u636e\u63a8\u9001\u64cd\u4f5c\uff0c{}", (Object)BILL_TYPE, (Object)cooperateResp.getMsg());
                return CommonResponse.error((String)"\u5355\u636e\u63a8\u9001\u4f9b\u65b9\u5931\u8d25\uff0c\u751f\u6210\u5206\u4eab\u8fde\u63a5\u5931\u8d25\uff01");
            }
            PushAppearanceVO supplierPushCheckVO = (PushAppearanceVO)BeanMapper.map((Object)((Object)entity), PushAppearanceVO.class);
            supplierPushCheckVO.setSourceId(entity.getId());
            List checkDetailList = supplierPushCheckVO.getRentAcceptanceDetailList();
            for (PushAppearanceSubVO supplierPushCheckDetailVO : checkDetailList) {
                supplierPushCheckDetailVO.setSourceId(entity.getId());
                supplierPushCheckDetailVO.setSourceDetailId(supplierPushCheckDetailVO.getId());
                supplierPushCheckDetailVO.setId(null);
            }
            CommonResponse ejcCloudSystemCode = this.proSupplierApi.getEjcCloudSystemCode();
            if (!ejcCloudSystemCode.isSuccess()) {
                return CommonResponse.error((String)("\u83b7\u53d6\u5f53\u524d\u7cfb\u7edf\u7f16\u7801\u5931\u8d25" + ejcCloudSystemCode.getMsg()));
            }
            supplierPushCheckVO.setSystemId((String)ejcCloudSystemCode.getData());
            String dataInfo = JSONObject.toJSONString((Object)supplierPushCheckVO);
            boolean pushResult = this.service.pushBillToSupCenter(dataInfo, entity.getSupplierId(), entity.getId(), BILL_TYPE, (CooperateVO)cooperateResp.getData(), PUSH_SAVE_URL);
            if (!pushResult) {
                this.logger.error("\u5355\u636e-{}\u63a8\u9001\u7ed9\u4f9b\u5e94\u5546supplierId-{}\u5931\u8d25\uff01", (Object)id, (Object)entity.getSupplierId());
                return CommonResponse.error((String)"\u5355\u636e\u63a8\u9001\u4f9b\u65b9\u5931\u8d25\uff0c\u751f\u6210\u5206\u4eab\u8fde\u63a5\u5931\u8d25\uff01");
            }
            entity.setBillPushFlag(BillPushStatusEnum.\u63a8\u9001\u6210\u529f.getStatus());
            this.service.saveOrUpdate((Object)entity, false);
        }
        return this.shareCooperateApi.getShareLink(id, BILL_TYPE, entity.getSupplierId().toString(), "/ejc-supbusiness-mobile/#/proEquipments/check/card", null);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<RentAcceptanceVO> vos) {
        this.service.deletes(vos);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<RentAcceptanceVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("code");
        fuzzyFields.add("projectName");
        fuzzyFields.add("contractName");
        fuzzyFields.add("supplierName");
        fuzzyFields.add("acceptanceUserName");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (!param.getParams().containsKey("orgId")) {
            UserContext userContextCache = this.sessionManager.getUserContext();
            String authOrgIds = userContextCache.getAuthOrgIds();
            this.logger.info("authOrgIds" + authOrgIds);
            List orgVOList = null;
            if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)authOrgIds)) {
                orgVOList = (List)this.getRespData(this.iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002");
                this.logger.info("\u79fb\u52a8\u7aef" + orgVOList.toString());
            } else {
                orgVOList = (List)this.getRespData(this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002");
                this.logger.info("pc\u7aef" + orgVOList.toString());
            }
            ArrayList commonOrgIds = new ArrayList();
            ArrayList departmentIds = new ArrayList();
            orgVOList.stream().forEach(org -> {
                if (5 == org.getOrgType()) {
                    departmentIds.add(org.getId());
                } else {
                    commonOrgIds.add(org.getId());
                }
            });
            if (CollectionUtils.isNotEmpty(commonOrgIds)) {
                param.getParams().put("parentOrgId", new Parameter("in", commonOrgIds));
                this.logger.info("orgId" + ((Object)commonOrgIds).toString());
            } else if (CollectionUtils.isNotEmpty(departmentIds)) {
                param.getParams().put("projectDepartmentId", new Parameter("in", departmentIds));
                this.logger.info("projectDepartmentId" + ((Object)departmentIds).toString());
            }
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), RentAcceptanceVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(org.apache.commons.lang3.StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        UserContext userContextCache = this.sessionManager.getUserContext();
        String authOrgIds = userContextCache.getAuthOrgIds();
        this.logger.info("authOrgIds" + authOrgIds);
        List orgVOList = null;
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)authOrgIds)) {
            orgVOList = (List)this.getRespData(this.iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002");
            this.logger.info("\u79fb\u52a8\u7aef" + orgVOList.toString());
        } else {
            orgVOList = (List)this.getRespData(this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002");
            this.logger.info("pc\u7aef" + orgVOList.toString());
        }
        ArrayList commonOrgIds = new ArrayList();
        ArrayList departmentIds = new ArrayList();
        orgVOList.stream().forEach(org -> {
            if (5 == org.getOrgType()) {
                departmentIds.add(org.getId());
            } else {
                commonOrgIds.add(org.getId());
            }
        });
        if (CollectionUtils.isNotEmpty(commonOrgIds)) {
            param.getParams().put("parentOrgId", new Parameter("in", commonOrgIds));
            this.logger.info("orgId" + ((Object)commonOrgIds).toString());
        } else if (CollectionUtils.isNotEmpty(departmentIds)) {
            param.getParams().put("projectDepartmentId", new Parameter("in", departmentIds));
            this.logger.info("projectDepartmentId" + ((Object)departmentIds).toString());
        }
        List list = this.service.queryList(param);
        List listVo = new ArrayList();
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            listVo = BeanMapper.mapList((Iterable)list, RentAcceptanceVO.class);
            for (RentAcceptanceVO rentAcceptanceVO : listVo) {
                rentAcceptanceVO.setBillStateName(BillStateEnum.getEnumByStateCode((Integer)rentAcceptanceVO.getBillState()).getDescription());
                rentAcceptanceVO.setSignStatusName(rentAcceptanceVO.getSignStatus() == 0 ? "\u672a\u7b7e\u5b57" : "\u5df2\u7b7e\u5b57");
            }
        }
        HashMap beans = new HashMap();
        beans.put("records", listVo);
        ExcelExport.getInstance().export("RentAcceptance-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/refRentAcceptanceData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<RentAcceptanceVO>> refRentAcceptanceData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject jSONObject = JSONObject.parseObject((String)condition);
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), RentAcceptanceVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }
}

