/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.rent.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.ejianc.business.ac.enums.BillPushStatusEnum;
import com.ejianc.business.appearance.vo.PushAppearanceSubVO;
import com.ejianc.business.appearance.vo.PushAppearanceVO;
import com.ejianc.business.rent.bean.RentAcceptanceEntity;
import com.ejianc.business.rent.bean.RentAcceptanceSubEntity;
import com.ejianc.business.rent.bean.RentContractEntity;
import com.ejianc.business.rent.bean.RentParameterDetailEntity;
import com.ejianc.business.rent.bean.RentParameterEntity;
import com.ejianc.business.rent.enums.EntranceRentFlagEnum;
import com.ejianc.business.rent.enums.RentEquipmentStateEnum;
import com.ejianc.business.rent.enums.RentParameterTypeEnum;
import com.ejianc.business.rent.service.IRentAcceptanceService;
import com.ejianc.business.rent.service.IRentContractService;
import com.ejianc.business.rent.service.IRentParameterDetailService;
import com.ejianc.business.rent.service.IRentParameterService;
import com.ejianc.foundation.share.api.IProSupplierApi;
import com.ejianc.foundation.share.api.IShareCooperateApi;
import com.ejianc.foundation.share.vo.CooperateVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="rentAcceptance")
public class RentAcceptanceBpmServiceImpl
implements ICommonBusinessService {
    @Autowired
    private IRentAcceptanceService rentAcceptanceService;
    @Autowired
    private IRentParameterService parameterService;
    private static final String BILL_TYPE_CODE = "BT220317000000015";
    private final String PUSH_SAVE_URL = "/ejc-supbusiness-web/openapi/rentAcceptance/saveCheck";
    private final String PUSH_DELETE_URL = "/ejc-supbusiness-web/openapi/rentAcceptance/deleteCheck";
    private final String OPERATE = "RENT-PROEQUIPMENT-ACCEPTANCE";
    @Autowired
    private IRentParameterDetailService parameterDetailService;
    @Autowired
    private IRentContractService contractService;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IProSupplierApi proSupplierApi;
    @Autowired
    private IShareCooperateApi shareCooperateApi;
    @Autowired
    private IRentParameterDetailService rentParameterDetailService;

    public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        ArrayList<RentParameterEntity> parameterList = new ArrayList<RentParameterEntity>();
        RentAcceptanceEntity rentAcceptanceEntity = (RentAcceptanceEntity)((Object)this.rentAcceptanceService.selectById(billId));
        List<RentAcceptanceSubEntity> acceptanceSubList = rentAcceptanceEntity.getRentAcceptanceSubList();
        RentContractEntity contractEntity = (RentContractEntity)((Object)this.contractService.selectById(rentAcceptanceEntity.getContractId()));
        for (RentAcceptanceSubEntity rentAcceptanceSubEntity : acceptanceSubList) {
            RentParameterEntity parameter = new RentParameterEntity();
            parameter.setContractId(rentAcceptanceEntity.getContractId());
            parameter.setContractName(rentAcceptanceEntity.getContractName());
            parameter.setEngineeringId(rentAcceptanceEntity.getEngineeringId());
            parameter.setEngineeringName(rentAcceptanceEntity.getEngineeringName());
            parameter.setSupplierId(rentAcceptanceEntity.getSupplierId());
            parameter.setSupplierName(rentAcceptanceEntity.getSupplierName());
            parameter.setProjectId(rentAcceptanceEntity.getProjectId());
            parameter.setProjectCode(rentAcceptanceEntity.getProjectCode());
            parameter.setProjectName(rentAcceptanceEntity.getProjectName());
            parameter.setAcceptanceId(rentAcceptanceEntity.getId());
            parameter.setAcceptanceDate(rentAcceptanceEntity.getAcceptanceDate());
            parameter.setSourceId(rentAcceptanceEntity.getId());
            parameter.setOrgId(contractEntity.getOrgId());
            parameter.setOrgName(contractEntity.getOrgName());
            parameter.setParentOrgId(contractEntity.getParentOrgId());
            parameter.setParentOrgCode(contractEntity.getParentOrgCode());
            parameter.setParentOrgName(contractEntity.getParentOrgName());
            parameter.setRentHarborType(contractEntity.getRentHarborType().equals("\u5185\u79df") ? 1 : 2);
            parameter.setFactoryCode(rentAcceptanceSubEntity.getFactoryCode());
            parameter.setCategoryId(rentAcceptanceSubEntity.getCategoryId());
            parameter.setCategoryName(rentAcceptanceSubEntity.getCategoryName());
            parameter.setSpec(rentAcceptanceSubEntity.getSpecs());
            parameter.setUnitName(rentAcceptanceSubEntity.getUnitName());
            parameter.setStartDate(rentAcceptanceEntity.getAcceptanceDate());
            parameter.setPlanIntoDate(rentAcceptanceSubEntity.getPlanIntoDate());
            parameter.setPlanOutDate(rentAcceptanceSubEntity.getPlanOutDate());
            parameter.setProductionManufactor(rentAcceptanceSubEntity.getProductionManufactor());
            parameter.setMemo(rentAcceptanceSubEntity.getMemo());
            parameter.setEquipmentCode(rentAcceptanceSubEntity.getEquipmentCode());
            parameter.setEquipmentId(rentAcceptanceSubEntity.getEquipmentId());
            parameter.setName(rentAcceptanceSubEntity.getName());
            parameter.setNum(rentAcceptanceSubEntity.getNum());
            parameter.setRentNum(rentAcceptanceSubEntity.getNum());
            parameter.setRentTypeId(rentAcceptanceSubEntity.getRentTypeId());
            parameter.setRentTypeName(rentAcceptanceSubEntity.getRentTypeName());
            parameter.setAcceptanceDetailId(rentAcceptanceSubEntity.getId());
            parameter.setEquipmentName(rentAcceptanceSubEntity.getName());
            parameter.setPrice(rentAcceptanceSubEntity.getPrice());
            parameter.setNotTaxPrice(rentAcceptanceSubEntity.getNotTaxPrice());
            parameter.setFlagOil(rentAcceptanceSubEntity.getFlagOil());
            parameter.setFlagOperation(rentAcceptanceSubEntity.getFlagOperation());
            if (EntranceRentFlagEnum.\u662f.getCode().equals(rentAcceptanceEntity.getEntranceRentFlag())) {
                parameter.setMeterRentDate(rentAcceptanceSubEntity.getMeterRentDate());
                parameter.setEquipmentState(RentEquipmentStateEnum.\u542f\u7528.getCode());
            } else {
                parameter.setMeterRentDate(null);
                parameter.setEquipmentState(RentEquipmentStateEnum.\u5f85\u542f\u7528.getCode());
            }
            parameter.setOperationDate(new Date());
            parameter.setQuantitiesNum(rentAcceptanceSubEntity.getQuantitiesNum() == null ? BigDecimal.ZERO : rentAcceptanceSubEntity.getQuantitiesNum());
            RentParameterDetailEntity detailEntity = new RentParameterDetailEntity();
            detailEntity.setEquipmentState(RentEquipmentStateEnum.\u542f\u7528.getCode());
            if (EntranceRentFlagEnum.\u662f.getCode().equals(rentAcceptanceEntity.getEntranceRentFlag())) {
                detailEntity.setOperationDate(rentAcceptanceSubEntity.getMeterRentDate());
            } else {
                detailEntity.setOperationDate(null);
            }
            detailEntity.setSourceId(rentAcceptanceEntity.getId());
            detailEntity.setSourceType(RentParameterTypeEnum.\u9a8c\u6536\u5355.getCode());
            ArrayList detailEntityList = new ArrayList();
            detailEntityList.add(detailEntity);
            parameter.setRentParameterDetailList(detailEntityList);
            parameterList.add(parameter);
        }
        this.logger.info("\u5904\u7406\u53f0\u8d26\u4e3b\u8868\u6570\u636e\uff1a{}", (Object)JSONObject.toJSONString(parameterList));
        this.parameterService.saveOrUpdateBatch(parameterList);
        ArrayList<RentParameterDetailEntity> addParameterDetailList = new ArrayList<RentParameterDetailEntity>();
        for (RentParameterEntity entity : parameterList) {
            List<RentParameterDetailEntity> detailEntityList = entity.getRentParameterDetailList();
            for (RentParameterDetailEntity detailEntity : detailEntityList) {
                detailEntity.setParameterId(entity.getId());
            }
            addParameterDetailList.addAll(detailEntityList);
        }
        this.logger.info("\u5904\u7406\u53f0\u8d26\u5b50\u8868\u6570\u636e\uff1a{}", (Object)JSONObject.toJSONString(addParameterDetailList));
        this.parameterDetailService.saveOrUpdateBatch(addParameterDetailList);
        rentAcceptanceEntity.setCheckState(1);
        PushAppearanceVO pushAppearanceVO = (PushAppearanceVO)BeanMapper.map((Object)((Object)rentAcceptanceEntity), PushAppearanceVO.class);
        List pushAppearanceSubVOList = BeanMapper.mapList(rentAcceptanceEntity.getRentAcceptanceSubList(), PushAppearanceSubVO.class);
        pushAppearanceVO.setRentAcceptanceDetailList(pushAppearanceSubVOList);
        pushAppearanceVO.setSourceId(rentAcceptanceEntity.getId());
        List checkDetailList = pushAppearanceVO.getRentAcceptanceDetailList();
        for (PushAppearanceSubVO supplierPushCheckDetailVO : checkDetailList) {
            supplierPushCheckDetailVO.setSourceId(rentAcceptanceEntity.getId());
            supplierPushCheckDetailVO.setSourceDetailId(supplierPushCheckDetailVO.getId());
            supplierPushCheckDetailVO.setId(null);
        }
        CommonResponse ejcCloudSystemCode = this.proSupplierApi.getEjcCloudSystemCode();
        if (!ejcCloudSystemCode.isSuccess()) {
            this.logger.error("\u83b7\u53d6\u5f53\u524d\u7cfb\u7edf\u7f16\u7801\u5931\u8d25" + ejcCloudSystemCode.getMsg());
        } else {
            pushAppearanceVO.setSystemId((String)ejcCloudSystemCode.getData());
            String dataInfo = JSONObject.toJSONString((Object)pushAppearanceVO);
            this.logger.info("dataInfo:" + dataInfo);
            CommonResponse cooperateResp = this.shareCooperateApi.queryCooperateBybillTypeCode(billTypeCode);
            if (!cooperateResp.isSuccess()) {
                this.logger.error("\u6839\u636e\u5355\u636e\u7c7b\u578b-{}\u67e5\u8be2\u5176\u534f\u540c\u914d\u7f6e\u4fe1\u606f\u5931\u8d25, \u4e0d\u8fdb\u884c\u5355\u636e\u63a8\u9001\u64cd\u4f5c\uff0c{}", (Object)BILL_TYPE_CODE, (Object)cooperateResp.getMsg());
            } else {
                boolean b = this.rentAcceptanceService.pushBillToSupCenter(dataInfo, rentAcceptanceEntity.getSupplierId(), rentAcceptanceEntity.getId(), BILL_TYPE_CODE, (CooperateVO)cooperateResp.getData(), "/ejc-supbusiness-web/openapi/rentAcceptance/saveCheck");
                if (!b) {
                    this.logger.error("\u63a8\u9001\u4f9b\u65b9\u5931\u8d25\uff01\u5355\u636e\u4fe1\u606f\uff1a{}", (Object)dataInfo);
                } else {
                    rentAcceptanceEntity.setBillPushFlag(BillPushStatusEnum.\u63a8\u9001\u6210\u529f.getStatus());
                }
            }
        }
        this.rentAcceptanceService.updateById((Object)rentAcceptanceEntity);
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        RentAcceptanceEntity entity = (RentAcceptanceEntity)((Object)this.rentAcceptanceService.selectById(billId));
        QueryParam queryParamp = new QueryParam();
        queryParamp.getParams().put("sourceId", new Parameter("eq", (Object)entity.getId()));
        queryParamp.getOrderMap().put("createTime", "desc");
        List parameterEntities = this.parameterService.queryList(queryParamp, false);
        for (RentParameterEntity parameterEntity : parameterEntities) {
            QueryParam queryParam = new QueryParam();
            queryParam.getParams().put("parameterId", new Parameter("eq", (Object)parameterEntity.getId()));
            queryParam.getOrderMap().put("createTime", "desc");
            List detailEntityList = this.rentParameterDetailService.queryList(queryParam, false);
            if (!CollectionUtils.isNotEmpty((Collection)detailEntityList)) continue;
            RentParameterDetailEntity detailEntity = (RentParameterDetailEntity)((Object)detailEntityList.get(0));
            if (detailEntityList.size() <= 1 || billId.equals(detailEntity.getSourceId())) continue;
            return CommonResponse.error((String)"\u5f03\u5ba1\u5931\u8d25:\u8be5\u5355\u636e\u5df2\u5b58\u5728\u4e0b\u6e38\u5355\u636e\u6216\u5df2\u505a\u79df\u91d1\u8ba1\u7b97\uff0c\u8bf7\u68c0\u67e5");
        }
        return CommonResponse.success();
    }

    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        RentAcceptanceEntity entity = (RentAcceptanceEntity)((Object)this.rentAcceptanceService.selectById(billId));
        this.parameterService.deleteAcceptanceId(entity.getId());
        return CommonResponse.success();
    }
}

