/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.rent.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ejianc.business.rent.bean.RentContractEntity;
import com.ejianc.business.rent.bean.RentContractRelieveEntity;
import com.ejianc.business.rent.bean.RentDayDetailedEntity;
import com.ejianc.business.rent.bean.RentMonthDetailedEntity;
import com.ejianc.business.rent.bean.RentQuantitiesDetailedEntity;
import com.ejianc.business.rent.bean.RentRentalDayEntity;
import com.ejianc.business.rent.bean.RentRentalMonthEntity;
import com.ejianc.business.rent.bean.RentRentalQuantitiesEntity;
import com.ejianc.business.rent.bean.RentSettlementDayEntity;
import com.ejianc.business.rent.bean.RentSettlementEntity;
import com.ejianc.business.rent.bean.RentSettlementMonthEntity;
import com.ejianc.business.rent.bean.RentSettlementQuantitiesEntity;
import com.ejianc.business.rent.bean.RentSettlementRentalEntity;
import com.ejianc.business.rent.mapper.RentContractRelieveMapper;
import com.ejianc.business.rent.service.IRentContractRelieveService;
import com.ejianc.business.rent.service.IRentContractService;
import com.ejianc.business.rent.service.IRentRentalDayService;
import com.ejianc.business.rent.service.IRentRentalMonthService;
import com.ejianc.business.rent.service.IRentRentalQuantitiesService;
import com.ejianc.business.rent.service.IRentSettlementDayService;
import com.ejianc.business.rent.service.IRentSettlementMonthService;
import com.ejianc.business.rent.service.IRentSettlementQuantitiesService;
import com.ejianc.business.rent.service.IRentSettlementRentalService;
import com.ejianc.business.rent.service.IRentSettlementService;
import com.ejianc.business.targetcost.enums.BillCategoryEnum;
import com.ejianc.business.targetcost.enums.BussinessTypeEnum;
import com.ejianc.business.targetcost.enums.DocTypeEnum;
import com.ejianc.business.targetcost.vo.DetailExecutionVO;
import com.ejianc.business.targetcost.vo.ExecutionVO;
import com.ejianc.business.targetcost.vo.TotalExecutionVO;
import com.ejianc.foundation.share.api.IShareMaterialApi;
import com.ejianc.foundation.share.vo.MaterialCategoryVO;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service(value="rentContractRelieveService")
public class RentContractRelieveServiceImpl
extends BaseServiceImpl<RentContractRelieveMapper, RentContractRelieveEntity>
implements IRentContractRelieveService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IRentSettlementService rentSettlementService;
    @Autowired
    private IRentSettlementRentalService rentSettlementRentalService;
    @Autowired
    private IRentSettlementDayService rentSettlementDayService;
    @Autowired
    private IRentSettlementMonthService rentSettlementMonthService;
    @Autowired
    private IRentSettlementQuantitiesService rentSettlementQuantitiesService;
    @Autowired
    private IRentContractService rentContractService;
    @Value(value="${common.env.base-host}")
    private String baseHost;
    @Value(value="${refer.base-host:null}")
    private String BASE_HOST_FRONTEND;
    @Autowired
    private RentContractRelieveMapper relieveService;
    @Autowired
    private IShareMaterialApi materialApi;
    @Autowired
    private IRentRentalDayService rentRentalDayService;
    @Autowired
    private IRentRentalMonthService rentRentalMonthService;
    @Autowired
    private IRentRentalQuantitiesService rentRentalQuantitiesService;

    @Override
    public ExecutionVO targetCost(RentContractRelieveEntity entity) {
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(RentSettlementEntity::getContractId, (Object)entity.getContractId());
        wrapper.in(RentSettlementEntity::getBillState, Arrays.asList(1, 3));
        List settleList = this.rentSettlementService.list((Wrapper)wrapper);
        BigDecimal totalSettleTaxMny = settleList.stream().filter(e -> e.getSettlementTaxMny() != null).map(RentSettlementEntity::getSettlementTaxMny).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal totalSettleMny = settleList.stream().filter(e -> e.getSettlementMny() != null).map(RentSettlementEntity::getSettlementMny).reduce(BigDecimal.ZERO, BigDecimal::add);
        RentContractEntity contractEntity = (RentContractEntity)((Object)this.rentContractService.getById(entity.getContractId()));
        ExecutionVO executionVO = new ExecutionVO();
        TotalExecutionVO totalVO = new TotalExecutionVO();
        totalVO.setSourceId(entity.getId());
        totalVO.setTenantId(entity.getTenantId());
        totalVO.setBillCode(entity.getCode());
        totalVO.setBillType("BTC220314000000001");
        totalVO.setBillCategory(BillCategoryEnum.\u5408\u540c.getCode());
        totalVO.setBussinessType(BussinessTypeEnum.\u65bd\u5de5\u673a\u68b0\u79df\u8d41\u5408\u540c.getCode());
        totalVO.setProjectId(entity.getProjectId());
        totalVO.setContractId(entity.getContractId());
        totalVO.setOrgId(entity.getCompanyId());
        totalVO.setMoney(ComputeUtil.safeSub((BigDecimal)totalSettleMny, (BigDecimal)contractEntity.getContractMny()));
        totalVO.setTaxMoney(ComputeUtil.safeSub((BigDecimal)totalSettleTaxMny, (BigDecimal)contractEntity.getContractTaxMny()));
        String frontendBaseHost = "";
        frontendBaseHost = StringUtils.isNotBlank((CharSequence)this.BASE_HOST_FRONTEND) && !"null".equals(this.BASE_HOST_FRONTEND) ? this.BASE_HOST_FRONTEND : this.baseHost;
        totalVO.setLinkUrl(frontendBaseHost + "ejc-proequipment-frontend/#/leaseContractContractRelieveCard?id=" + entity.getId());
        executionVO.setTotalVO(totalVO);
        executionVO.setDetailList(this.numDetailExecution(contractEntity, settleList));
        this.logger.info("\u7b56\u5212\u6210\u672c\u63a8\u9001\u6570\u636e---\u8bbe\u5907\u79df\u8d41\u5408\u540c\u89e3\u9664---->{}", (Object)JSONObject.toJSONString((Object)executionVO));
        return executionVO;
    }

    private List<DetailExecutionVO> numDetailExecution(RentContractEntity contractEntity, List<RentSettlementEntity> list) {
        List categoryIdList;
        List categoryVOList;
        DetailExecutionVO detailExecutionVO;
        BigDecimal sumTaxMny;
        BigDecimal sumMny;
        ArrayList<DetailExecutionVO> detailList = new ArrayList<DetailExecutionVO>();
        Boolean dayDataFlag = CollectionUtils.isNotEmpty(contractEntity.getRentDayDetailedList());
        Boolean monthDataFlag = CollectionUtils.isNotEmpty(contractEntity.getRentMonthDetailedList());
        Boolean quantitiesDataFlag = CollectionUtils.isNotEmpty(contractEntity.getRentQuantitiesDetailedList());
        Map<Object, Object> settlementDayMap = new HashMap();
        Map<Object, Object> rentalDayMap = new HashMap();
        Map<Object, Object> settlementMonthMap = new HashMap();
        Map<Object, Object> rentalMonthMap = new HashMap();
        Map<Object, Object> settlementQuantitiesMap = new HashMap();
        Map<Object, Object> rentalQuantitiesMap = new HashMap();
        if (CollectionUtils.isNotEmpty(list)) {
            List settlementIdList = list.stream().map(BaseEntity::getId).collect(Collectors.toList());
            if (dayDataFlag.booleanValue()) {
                LambdaQueryWrapper settlementDayQueryWrapper = new LambdaQueryWrapper();
                settlementDayQueryWrapper.in(RentSettlementDayEntity::getSettlementId, settlementIdList);
                List settlementDayList = this.rentSettlementDayService.list((Wrapper)settlementDayQueryWrapper);
                if (CollectionUtils.isNotEmpty((Collection)settlementDayList)) {
                    settlementDayMap = settlementDayList.stream().filter(t -> null != t.getEquipmentId()).collect(Collectors.groupingBy(RentSettlementDayEntity::getEquipmentId));
                }
            }
            if (monthDataFlag.booleanValue()) {
                LambdaQueryWrapper settlementMonthQueryWrapper = new LambdaQueryWrapper();
                settlementMonthQueryWrapper.in(RentSettlementMonthEntity::getSettlementId, settlementIdList);
                List settlementMonthList = this.rentSettlementMonthService.list((Wrapper)settlementMonthQueryWrapper);
                if (CollectionUtils.isNotEmpty((Collection)settlementMonthList)) {
                    settlementMonthMap = settlementMonthList.stream().filter(t -> null != t.getEquipmentId()).collect(Collectors.groupingBy(RentSettlementMonthEntity::getEquipmentId));
                }
            }
            if (quantitiesDataFlag.booleanValue()) {
                LambdaQueryWrapper settlementQuantitiesQueryWrapper = new LambdaQueryWrapper();
                settlementQuantitiesQueryWrapper.in(RentSettlementQuantitiesEntity::getSettlementId, settlementIdList);
                List settlementQuantitiesList = this.rentSettlementQuantitiesService.list((Wrapper)settlementQuantitiesQueryWrapper);
                if (CollectionUtils.isNotEmpty((Collection)settlementQuantitiesList)) {
                    settlementQuantitiesMap = settlementQuantitiesList.stream().filter(t -> null != t.getEquipmentId()).collect(Collectors.groupingBy(RentSettlementQuantitiesEntity::getEquipmentId));
                }
            }
            LambdaQueryWrapper rentSettlementRentalQueryWrapper = new LambdaQueryWrapper();
            rentSettlementRentalQueryWrapper.in(RentSettlementRentalEntity::getSettlementId, settlementIdList);
            List rentSettlementRentalList = this.rentSettlementRentalService.list((Wrapper)rentSettlementRentalQueryWrapper);
            if (CollectionUtils.isNotEmpty((Collection)rentSettlementRentalList)) {
                if (dayDataFlag.booleanValue()) {
                    LambdaQueryWrapper rentRentalDayWrapper = new LambdaQueryWrapper();
                    rentRentalDayWrapper.in(RentRentalDayEntity::getRentalId, (Collection)rentSettlementRentalList.stream().map(RentSettlementRentalEntity::getSourceId).collect(Collectors.toList()));
                    List rentRentalDayList = this.rentRentalDayService.list((Wrapper)rentRentalDayWrapper);
                    if (CollectionUtils.isNotEmpty((Collection)rentRentalDayList)) {
                        rentalDayMap = rentRentalDayList.stream().filter(t -> t.getEquipmentId() != null).collect(Collectors.groupingBy(RentRentalDayEntity::getEquipmentId));
                    }
                }
                if (monthDataFlag.booleanValue()) {
                    LambdaQueryWrapper rentRentalMonthWrapper = new LambdaQueryWrapper();
                    rentRentalMonthWrapper.in(RentRentalMonthEntity::getRentalId, (Collection)rentSettlementRentalList.stream().map(RentSettlementRentalEntity::getSourceId).collect(Collectors.toList()));
                    List rentRentalMonthList = this.rentRentalMonthService.list((Wrapper)rentRentalMonthWrapper);
                    if (CollectionUtils.isNotEmpty((Collection)rentRentalMonthList)) {
                        rentalMonthMap = rentRentalMonthList.stream().filter(t -> t.getEquipmentId() != null).collect(Collectors.groupingBy(RentRentalMonthEntity::getEquipmentId));
                    }
                }
                if (quantitiesDataFlag.booleanValue()) {
                    Iterator<BaseEntity> rentRentalQuantitiesWrapper = new LambdaQueryWrapper();
                    rentRentalQuantitiesWrapper.in(RentRentalQuantitiesEntity::getRentalId, rentSettlementRentalList.stream().map(RentSettlementRentalEntity::getSourceId).collect(Collectors.toList()));
                    List rentRentalQuantitiesList = this.rentRentalQuantitiesService.list((Wrapper)rentRentalQuantitiesWrapper);
                    if (CollectionUtils.isNotEmpty((Collection)rentRentalQuantitiesList)) {
                        rentalQuantitiesMap = rentRentalQuantitiesList.stream().filter(t -> t.getEquipmentId() != null).collect(Collectors.groupingBy(RentRentalQuantitiesEntity::getEquipmentId));
                    }
                }
            }
        }
        if (CollectionUtils.isNotEmpty(contractEntity.getRentDayDetailedList())) {
            for (RentDayDetailedEntity rentDayDetailedEntity : contractEntity.getRentDayDetailedList()) {
                sumMny = BigDecimal.ZERO;
                sumTaxMny = BigDecimal.ZERO;
                detailExecutionVO = new DetailExecutionVO();
                detailExecutionVO.setSourceId(rentDayDetailedEntity.getId());
                detailExecutionVO.setSourceBillId(rentDayDetailedEntity.getPid());
                detailExecutionVO.setContractId(contractEntity.getId());
                detailExecutionVO.setCategoryId(rentDayDetailedEntity.getCategoryId());
                detailExecutionVO.setCategoryName(rentDayDetailedEntity.getCategoryName());
                detailExecutionVO.setCategoryFlag(Boolean.valueOf(false));
                detailExecutionVO.setDocId(rentDayDetailedEntity.getEquipmentId());
                detailExecutionVO.setCode(rentDayDetailedEntity.getEquipmentCode());
                detailExecutionVO.setName(rentDayDetailedEntity.getName());
                detailExecutionVO.setCategoryContainFlag(Boolean.valueOf(false));
                detailExecutionVO.setDocType(DocTypeEnum.\u8bbe\u5907\u6863\u6848.getCode());
                detailExecutionVO.setUnitName(rentDayDetailedEntity.getUnitName());
                detailExecutionVO.setSpec(rentDayDetailedEntity.getSpec());
                detailExecutionVO.setPrice(rentDayDetailedEntity.getDayRentPrice());
                detailExecutionVO.setTaxPrice(rentDayDetailedEntity.getDayRentNotTaxPrice());
                detailExecutionVO.setNum(new BigDecimal(rentDayDetailedEntity.getRentNum()));
                if (settlementDayMap.containsKey(rentDayDetailedEntity.getEquipmentId())) {
                    sumMny = ((List)settlementDayMap.get(rentDayDetailedEntity.getEquipmentId())).stream().filter(e -> null != e.getDayMny()).map(RentSettlementDayEntity::getDayMny).reduce(sumMny, BigDecimal::add);
                    sumTaxMny = ((List)settlementDayMap.get(rentDayDetailedEntity.getEquipmentId())).stream().filter(e -> null != e.getDayTaxMny()).map(RentSettlementDayEntity::getDayTaxMny).reduce(sumTaxMny, BigDecimal::add);
                }
                if (rentalDayMap.containsKey(rentDayDetailedEntity.getEquipmentId())) {
                    sumMny = ((List)rentalDayMap.get(rentDayDetailedEntity.getEquipmentId())).stream().filter(e -> null != e.getRentDayMny()).map(RentRentalDayEntity::getRentDayMny).reduce(sumMny, BigDecimal::add);
                    sumTaxMny = ((List)rentalDayMap.get(rentDayDetailedEntity.getEquipmentId())).stream().filter(e -> null != e.getRentDayTaxMny()).map(RentRentalDayEntity::getRentDayTaxMny).reduce(sumTaxMny, BigDecimal::add);
                }
                detailExecutionVO.setMoney(ComputeUtil.safeSub((BigDecimal)sumMny, (BigDecimal)rentDayDetailedEntity.getRentMny()));
                detailExecutionVO.setTaxMoney(ComputeUtil.safeSub((BigDecimal)sumTaxMny, (BigDecimal)rentDayDetailedEntity.getRentTaxMny()));
                detailList.add(detailExecutionVO);
            }
        }
        if (CollectionUtils.isNotEmpty(contractEntity.getRentMonthDetailedList())) {
            for (RentMonthDetailedEntity rentMonthDetailedEntity : contractEntity.getRentMonthDetailedList()) {
                sumMny = BigDecimal.ZERO;
                sumTaxMny = BigDecimal.ZERO;
                detailExecutionVO = new DetailExecutionVO();
                detailExecutionVO.setSourceId(rentMonthDetailedEntity.getId());
                detailExecutionVO.setSourceBillId(rentMonthDetailedEntity.getPid());
                detailExecutionVO.setContractId(contractEntity.getId());
                detailExecutionVO.setCategoryId(rentMonthDetailedEntity.getCategoryId());
                detailExecutionVO.setCategoryName(rentMonthDetailedEntity.getCategoryName());
                detailExecutionVO.setCategoryFlag(Boolean.valueOf(false));
                detailExecutionVO.setDocId(rentMonthDetailedEntity.getEquipmentId());
                detailExecutionVO.setCode(rentMonthDetailedEntity.getEquipmentCode());
                detailExecutionVO.setName(rentMonthDetailedEntity.getName());
                detailExecutionVO.setCategoryContainFlag(Boolean.valueOf(false));
                detailExecutionVO.setDocType(DocTypeEnum.\u8bbe\u5907\u6863\u6848.getCode());
                detailExecutionVO.setUnitName(rentMonthDetailedEntity.getUnitName());
                detailExecutionVO.setSpec(rentMonthDetailedEntity.getSpec());
                detailExecutionVO.setPrice(rentMonthDetailedEntity.getMonthRentPrice());
                detailExecutionVO.setTaxPrice(rentMonthDetailedEntity.getMonthRentNotTaxPrice());
                detailExecutionVO.setNum(new BigDecimal(rentMonthDetailedEntity.getRentNum()));
                if (settlementMonthMap.containsKey(rentMonthDetailedEntity.getEquipmentId())) {
                    sumMny = ((List)settlementMonthMap.get(rentMonthDetailedEntity.getEquipmentId())).stream().filter(e -> null != e.getMonthMny()).map(RentSettlementMonthEntity::getMonthMny).reduce(sumMny, BigDecimal::add);
                    sumTaxMny = ((List)settlementMonthMap.get(rentMonthDetailedEntity.getEquipmentId())).stream().filter(e -> null != e.getMonthTaxMny()).map(RentSettlementMonthEntity::getMonthTaxMny).reduce(sumTaxMny, BigDecimal::add);
                }
                if (rentalMonthMap.containsKey(rentMonthDetailedEntity.getEquipmentId())) {
                    sumMny = ((List)rentalMonthMap.get(rentMonthDetailedEntity.getEquipmentId())).stream().filter(e -> null != e.getRentMonthMny()).map(RentRentalMonthEntity::getRentMonthMny).reduce(sumMny, BigDecimal::add);
                    sumTaxMny = ((List)rentalMonthMap.get(rentMonthDetailedEntity.getEquipmentId())).stream().filter(e -> null != e.getRentMonthTaxMny()).map(RentRentalMonthEntity::getRentMonthTaxMny).reduce(sumTaxMny, BigDecimal::add);
                }
                detailExecutionVO.setMoney(ComputeUtil.safeSub((BigDecimal)sumMny, (BigDecimal)rentMonthDetailedEntity.getRentMny()));
                detailExecutionVO.setTaxMoney(ComputeUtil.safeSub((BigDecimal)sumTaxMny, (BigDecimal)rentMonthDetailedEntity.getRentTaxMny()));
                detailList.add(detailExecutionVO);
            }
        }
        if (CollectionUtils.isNotEmpty(contractEntity.getRentQuantitiesDetailedList())) {
            for (RentQuantitiesDetailedEntity rentQuantitiesDetailedEntity : contractEntity.getRentQuantitiesDetailedList()) {
                sumMny = BigDecimal.ZERO;
                sumTaxMny = BigDecimal.ZERO;
                BigDecimal quantitiesNum = BigDecimal.ZERO;
                detailExecutionVO = new DetailExecutionVO();
                detailExecutionVO.setSourceId(rentQuantitiesDetailedEntity.getId());
                detailExecutionVO.setSourceBillId(rentQuantitiesDetailedEntity.getPid());
                detailExecutionVO.setContractId(contractEntity.getId());
                detailExecutionVO.setCategoryId(rentQuantitiesDetailedEntity.getCategoryId());
                detailExecutionVO.setCategoryName(rentQuantitiesDetailedEntity.getCategoryName());
                detailExecutionVO.setCategoryFlag(Boolean.valueOf(false));
                detailExecutionVO.setDocId(rentQuantitiesDetailedEntity.getEquipmentId());
                detailExecutionVO.setCode(rentQuantitiesDetailedEntity.getEquipmentCode());
                detailExecutionVO.setName(rentQuantitiesDetailedEntity.getName());
                detailExecutionVO.setCategoryContainFlag(Boolean.valueOf(false));
                detailExecutionVO.setDocType(DocTypeEnum.\u8bbe\u5907\u6863\u6848.getCode());
                detailExecutionVO.setUnitName(rentQuantitiesDetailedEntity.getUnitName());
                detailExecutionVO.setSpec(rentQuantitiesDetailedEntity.getSpec());
                detailExecutionVO.setPrice(rentQuantitiesDetailedEntity.getQuantitiesPrice());
                detailExecutionVO.setTaxPrice(rentQuantitiesDetailedEntity.getNotTaxQuantitiesPrice());
                detailExecutionVO.setNum(new BigDecimal(rentQuantitiesDetailedEntity.getRentNum()));
                if (settlementQuantitiesMap.containsKey(rentQuantitiesDetailedEntity.getEquipmentId())) {
                    sumMny = ((List)settlementQuantitiesMap.get(rentQuantitiesDetailedEntity.getEquipmentId())).stream().filter(e -> null != e.getQuantitiesMny()).map(RentSettlementQuantitiesEntity::getQuantitiesMny).reduce(sumMny, BigDecimal::add);
                    sumTaxMny = ((List)settlementQuantitiesMap.get(rentQuantitiesDetailedEntity.getEquipmentId())).stream().filter(e -> null != e.getQuantitiesTaxMny()).map(RentSettlementQuantitiesEntity::getQuantitiesTaxMny).reduce(sumTaxMny, BigDecimal::add);
                    quantitiesNum = ((List)settlementQuantitiesMap.get(rentQuantitiesDetailedEntity.getEquipmentId())).stream().filter(e -> null != e.getQuantitiesNum()).map(RentSettlementQuantitiesEntity::getQuantitiesNum).reduce(quantitiesNum, BigDecimal::add);
                }
                if (rentalQuantitiesMap.containsKey(rentQuantitiesDetailedEntity.getEquipmentId())) {
                    sumMny = ((List)rentalQuantitiesMap.get(rentQuantitiesDetailedEntity.getEquipmentId())).stream().filter(e -> null != e.getRentQuantitiesMny()).map(RentRentalQuantitiesEntity::getRentQuantitiesMny).reduce(sumMny, BigDecimal::add);
                    sumTaxMny = ((List)rentalQuantitiesMap.get(rentQuantitiesDetailedEntity.getEquipmentId())).stream().filter(e -> null != e.getRentQuantitiesTaxMny()).map(RentRentalQuantitiesEntity::getRentQuantitiesTaxMny).reduce(sumTaxMny, BigDecimal::add);
                    quantitiesNum = ((List)rentalQuantitiesMap.get(rentQuantitiesDetailedEntity.getEquipmentId())).stream().filter(e -> null != e.getQuantitiesNum()).map(RentRentalQuantitiesEntity::getQuantitiesNum).reduce(quantitiesNum, BigDecimal::add);
                }
                detailExecutionVO.setMoney(ComputeUtil.safeSub((BigDecimal)sumMny, (BigDecimal)rentQuantitiesDetailedEntity.getRentMny()));
                detailExecutionVO.setTaxMoney(ComputeUtil.safeSub((BigDecimal)sumTaxMny, (BigDecimal)rentQuantitiesDetailedEntity.getRentTaxMny()));
                detailExecutionVO.setQuantityNum(ComputeUtil.safeSub((BigDecimal)quantitiesNum, (BigDecimal)rentQuantitiesDetailedEntity.getQuantitiesNum()));
                detailList.add(detailExecutionVO);
            }
        }
        if (CollectionUtils.isNotEmpty(detailList) && CollectionUtils.isNotEmpty((Collection)(categoryVOList = (List)this.materialApi.queryCategoryListByIds(categoryIdList = detailList.stream().map(DetailExecutionVO::getCategoryId).collect(Collectors.toList())).getData()))) {
            Map categoryMap = categoryVOList.stream().collect(Collectors.toMap(MaterialCategoryVO::getId, Function.identity(), (key1, key2) -> key2));
            for (DetailExecutionVO detailExecutionVO2 : detailList) {
                if (null == categoryMap.get(detailExecutionVO2.getCategoryId())) continue;
                detailExecutionVO2.setCategoryInnerCode(((MaterialCategoryVO)categoryMap.get(detailExecutionVO2.getCategoryId())).getInnerCode());
                detailExecutionVO2.setCategoryCode(((MaterialCategoryVO)categoryMap.get(detailExecutionVO2.getCategoryId())).getCode());
            }
        }
        return detailList;
    }

    @Override
    public void delById(Long id) {
        this.relieveService.delById(id);
    }
}

