/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.temporary.contract.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.contractbase.api.ITemplateCategoryApi;
import com.ejianc.business.contractbase.pool.enums.ContractPerformanceStateEnum;
import com.ejianc.business.contractbase.vo.TemplateCategoryVO;
import com.ejianc.business.rent.enums.SignatureStatusEnum;
import com.ejianc.business.rent.vo.RentContractVO;
import com.ejianc.business.temporary.contract.bean.TemporaryContractEntity;
import com.ejianc.business.temporary.contract.service.ITemporaryContractService;
import com.ejianc.business.temporary.contract.service.ITemporaryEquipmentDetailedService;
import com.ejianc.business.temporary.contract.vo.TemporaryContractVO;
import com.ejianc.business.temporary.contract.vo.TemporaryEquipmentDetailedVO;
import com.ejianc.business.temporary.useapply.bean.TemporaryUseApplyEntity;
import com.ejianc.business.temporary.useapply.bean.TemporaryUseApplySubEntity;
import com.ejianc.business.temporary.useapply.service.ITemporaryUseApplyService;
import com.ejianc.business.temporary.useapply.service.ITemporaryUseApplySubService;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"temporaryContract"})
public class TemporaryContractController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    private static final String BILL_CODE = "TEMPORARY_CONTRACT";
    @Autowired
    private ITemplateCategoryApi templateCategoryApi;
    @Autowired
    private ITemporaryContractService service;
    private final String TEMPORARY_CONTRACT = "BT220326000000001";
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private ITemporaryUseApplySubService useApplySubService;
    @Autowired
    private ITemporaryUseApplyService useApplyService;
    @Autowired
    private ITemporaryEquipmentDetailedService equipmentDetailedService;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<TemporaryContractVO> saveOrUpdate(@RequestBody TemporaryContractVO saveOrUpdateVO, HttpServletRequest req) {
        String authority = req.getHeader("authority");
        TemporaryContractVO vo = this.service.insertOrUpdate(saveOrUpdateVO, authority, false);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<TemporaryContractVO> queryDetail(Long id) {
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)this.service.queryDetail(id));
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<TemporaryContractVO> vos) {
        return this.service.deleteByIds(vos);
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<JSONObject> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("contractName");
        fuzzyFields.add("projectName");
        fuzzyFields.add("partyName");
        fuzzyFields.add("supplierName");
        fuzzyFields.add("code");
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        Long orgId = InvocationInfoProxy.getOrgId();
        CommonResponse orgResp = this.iOrgApi.findChildrenByParentId(orgId);
        if (!orgResp.isSuccess()) {
            this.logger.error("\u5206\u9875\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25, {}", (Object)orgResp.getMsg());
            return CommonResponse.error((String)"\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\uff01");
        }
        if (ListUtil.isEmpty((List)((List)orgResp.getData()))) {
            return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", (Object)new JSONObject());
        }
        param.getParams().put("companyId", new Parameter("in", ((List)orgResp.getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        LinkedHashMap orderMap = new LinkedHashMap();
        if (null != param.getOrderMap().get("createTime")) {
            orderMap.put("main_contract_create_date", param.getOrderMap().get("createTime"));
        } else {
            orderMap.put("main_contract_create_date", "desc");
        }
        orderMap.put("supplement_flag", "asc");
        orderMap.put("create_time", "desc");
        param.setOrderMap(orderMap);
        IPage pageData = this.service.queryPage(param, false);
        Map<String, Object> contractAmountMap = this.service.countContractAmount(param);
        JSONObject page = new JSONObject();
        page.put("records", (Object)BeanMapper.mapList((Iterable)pageData.getRecords(), RentContractVO.class));
        page.put("total", (Object)pageData.getTotal());
        page.put("current", (Object)pageData.getCurrent());
        page.put("size", (Object)pageData.getSize());
        page.put("pages", (Object)pageData.getPages());
        page.put("sumMnyMap", contractAmountMap);
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)page);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(org.apache.commons.lang3.StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        HashMap beans = new HashMap();
        param.setPageSize(-1);
        CommonResponse<JSONObject> commonResponse = this.queryList(param);
        List contractVOList = new ArrayList();
        if (null != commonResponse.getData() && null != (contractVOList = (List)((JSONObject)commonResponse.getData()).get((Object)"records")) && contractVOList.size() > 0) {
            contractVOList.forEach(vo -> {
                if (StringUtils.isBlank((String)vo.getContractPerformanceState().toString())) {
                    vo.setContractPerformanceState(ContractPerformanceStateEnum.\u672a\u7b7e\u8ba2.getStateName());
                } else {
                    vo.setContractPerformanceState(ContractPerformanceStateEnum.getByStateCode((String)vo.getContractPerformanceState().toString()).getStateName());
                }
                if (StringUtils.isBlank((String)vo.getSignatureState())) {
                    vo.setSignatureState(SignatureStatusEnum.\u672a\u7b7e\u7ae0.getDescription());
                } else {
                    vo.setSignatureState(SignatureStatusEnum.getEnumByCode(vo.getSignatureState()).getDescription());
                }
                vo.setBillStateName(BillStateEnum.getEnumByStateCode((Integer)vo.getBillState()).getDescription());
            });
        }
        beans.put("records", contractVOList);
        ExcelExport.getInstance().export("rentContract-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/refTemporaryContractData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<TemporaryContractVO>> refTemporaryContractData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        JSONObject _con;
        QueryParam param = new QueryParam();
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("contractName");
        fuzzyFields.add("projectName");
        fuzzyFields.add("partyName");
        fuzzyFields.add("supplierName");
        fuzzyFields.add("code");
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("contractPerformanceState", new Parameter("eq", (Object)"2"));
        param.getParams().put("billState", new Parameter("in", (Object)"1,3"));
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        Long projectId = null;
        if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)condition) && (projectId = (_con = JSONObject.parseObject((String)condition)).getLong("projectId")) != null) {
            param.getParams().put("projectId", new Parameter("eq", (Object)projectId));
        }
        LinkedHashMap<String, String> orderMap = new LinkedHashMap<String, String>();
        orderMap.put("createTime", "desc");
        param.setOrderMap(orderMap);
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), TemporaryContractVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/saveOrUpdateSupplement"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<TemporaryContractVO> saveOrUpdateSupplement(@RequestBody TemporaryContractVO temporaryContractVO) {
        if (temporaryContractVO.getMainContractId() == null) {
            return CommonResponse.error((String)"\u4fdd\u5b58\u5931\u8d25\uff0c\u4e3b\u5408\u540c\u4fe1\u606f\u4e3a\u7a7a\uff01");
        }
        TemporaryContractVO vo = this.service.saveOrUpdateSupplement(temporaryContractVO);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6210\u529f", (Object)vo);
    }

    @RequestMapping(value={"/addConvertByConId"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<TemporaryContractVO> addConvertByConId(Long contractId) {
        TemporaryContractVO vo = this.service.addConvertByConId(contractId);
        return CommonResponse.success((String)"\u65b0\u589e\u8f6c\u6362\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/addSupplementFlag"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<String> addSupplementFlag(Long id) {
        Boolean flag = this.service.addSupplementFlag(id);
        if (flag.booleanValue()) {
            return CommonResponse.success((String)"\u6821\u9a8c\u901a\u8fc7\uff0c\u8be5\u5408\u540c\u53ef\u4ee5\u65b0\u589e\u8865\u5145\u534f\u8bae\uff01");
        }
        return CommonResponse.error((String)"\u5f53\u524d\u5408\u540c\u5b58\u5728\u672a\u751f\u6548\u7684\u8865\u5145\u534f\u8bae\uff0c\u4e0d\u80fd\u65b0\u589e\uff01");
    }

    @RequestMapping(value={"/signatureProcess"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<String> signatureProcess(Long id) {
        TemporaryContractEntity temporaryContractEntity = (TemporaryContractEntity)((Object)this.service.selectById(id));
        if (temporaryContractEntity != null) {
            temporaryContractEntity.setContractPerformanceState(SignatureStatusEnum.\u5df2\u7b7e\u7ae0.getCode());
            temporaryContractEntity.setSignatureState(ContractPerformanceStateEnum.\u5c65\u7ea6\u4e2d.getStateCode());
            temporaryContractEntity.setEffectiveDate(new Date());
            this.service.saveOrUpdate((Object)temporaryContractEntity);
        }
        return CommonResponse.success();
    }

    @RequestMapping(value={"/querySupplementRecord"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<TemporaryContractVO> querySupplementRecord(Long id) {
        TemporaryContractVO vo = this.service.querySupplementRecord(id);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/refTemporaryContractEquipmentData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<TemporaryEquipmentDetailedVO>> refTemporaryContractEquipmentData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("name");
        fuzzyFields.add("categoryName");
        Long contractId = null;
        String flag = null;
        if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject _con = JSONObject.parseObject((String)condition);
            contractId = _con.getLong("contractId");
            flag = _con.getString("flag");
            if (contractId != null) {
                param.getParams().put("pid", new Parameter("eq", (Object)contractId));
            }
        } else {
            throw new BusinessException("\u5408\u540cid\u4e0d\u80fd\u4e3a\u7a7a");
        }
        LinkedHashMap<String, String> orderMap = new LinkedHashMap<String, String>();
        orderMap.put("createTime", "desc");
        param.setOrderMap(orderMap);
        IPage page = this.equipmentDetailedService.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), TemporaryEquipmentDetailedVO.class));
        if ("1".equals(flag)) {
            ArrayList<Long> ids = new ArrayList<Long>();
            for (TemporaryEquipmentDetailedVO vo : pageData.getRecords()) {
                ids.add(vo.getId());
            }
            if (CollectionUtils.isNotEmpty(ids)) {
                QueryParam useApplyParam = new QueryParam();
                ArrayList<Integer> list = new ArrayList<Integer>();
                list.add(BillStateEnum.COMMITED_STATE.getBillStateCode());
                list.add(BillStateEnum.PASSED_STATE.getBillStateCode());
                useApplyParam.getParams().put("contractId", new Parameter("eq", (Object)contractId));
                useApplyParam.getParams().put("billState", new Parameter("in", list));
                useApplyParam.getParams().put("dr", new Parameter("eq", (Object)0));
                List useApplyEntities = this.useApplyService.queryList(useApplyParam);
                ArrayList<Long> applyIds = new ArrayList<Long>();
                if (CollectionUtils.isNotEmpty((Collection)useApplyEntities)) {
                    for (TemporaryUseApplyEntity entity : useApplyEntities) {
                        applyIds.add(entity.getId());
                    }
                }
                if (CollectionUtils.isNotEmpty(applyIds)) {
                    QueryParam useApplySubParam = new QueryParam();
                    useApplySubParam.getParams().put("pid", new Parameter("in", applyIds));
                    List useApplySubEntities = this.useApplySubService.queryList(useApplySubParam);
                    for (TemporaryEquipmentDetailedVO vo : pageData.getRecords()) {
                        for (TemporaryUseApplySubEntity entity : useApplySubEntities) {
                            if (!vo.getId().equals(entity.getEquipmentId())) continue;
                            if (vo.getApplyNum() == null) {
                                vo.setApplyNum(entity.getApplyNum());
                                continue;
                            }
                            vo.setApplyNum(vo.getApplyNum().add(entity.getApplyNum()));
                        }
                    }
                }
            }
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @GetMapping(value={"/getContractFileMgrInfo"})
    @ResponseBody
    public CommonResponse<JSONObject> getContractFileMgrInfo(@RequestParam(value="contractId") Long contractId) {
        JSONObject resp = new JSONObject();
        TemporaryContractEntity contractEntity = (TemporaryContractEntity)((Object)this.service.selectById(contractId));
        CommonResponse categoryResp = this.templateCategoryApi.queryTmplCategoryById(contractEntity.getContractType());
        if (!categoryResp.isSuccess()) {
            this.logger.error("\u6839\u636e\u5408\u540c\u7c7b\u522bI\u7684-{}\u67e5\u8be2\u5bf9\u5e94\u5408\u540c\u7c7b\u522b\u4fe1\u606f\u5931\u8d25, \u539f\u56e0\uff1a{}", (Object)contractEntity.getContractType(), (Object)categoryResp.getMsg());
            return CommonResponse.error((String)"\u67e5\u8be2\u5408\u540c\u7c7b\u522b\u4fe1\u606f\u5931\u8d25");
        }
        TemplateCategoryVO category = (TemplateCategoryVO)categoryResp.getData();
        resp.put("contactId", (Object)contractEntity.getId());
        resp.put("contractBillTypeCode", (Object)"BT220326000000001");
        resp.put("contractCategoryId", (Object)category.getId());
        resp.put("boBillType", (Object)category.getBillTypeCode());
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", (Object)resp);
    }
}

