/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.temporary.settlement.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.business.contractbase.pool.enums.ContractTypeEnum;
import com.ejianc.business.contractbase.pool.enums.SettleSourceTypeEnum;
import com.ejianc.business.contractbase.pool.settlepool.api.ISettlePoolApi;
import com.ejianc.business.contractbase.pool.settlepool.vo.SettlePoolVO;
import com.ejianc.business.contractpub.util.BeanConvertorUtil;
import com.ejianc.business.pro.income.api.IProincomeContractApi;
import com.ejianc.business.pro.income.vo.ContractRegisterVO;
import com.ejianc.business.procost.api.ICostDetailApi;
import com.ejianc.business.procost.enums.SourceTypeEnum;
import com.ejianc.business.procost.vo.CostDetailVO;
import com.ejianc.business.promaterial.settlement.api.IProMaterialSettleApi;
import com.ejianc.business.targetcost.api.IExecutionApi;
import com.ejianc.business.targetcost.enums.BillCategoryEnum;
import com.ejianc.business.targetcost.vo.CostCtrlDetailVO;
import com.ejianc.business.targetcost.vo.CostCtrlVO;
import com.ejianc.business.targetcost.vo.DetailExecutionVO;
import com.ejianc.business.targetcost.vo.ExecutionVO;
import com.ejianc.business.targetcost.vo.ParamsCheckDsVO;
import com.ejianc.business.targetcost.vo.ParamsCheckVO;
import com.ejianc.business.targetcost.vo.TotalExecutionVO;
import com.ejianc.business.temporary.contract.bean.TemporaryContractEntity;
import com.ejianc.business.temporary.contract.service.ITemporaryContractService;
import com.ejianc.business.temporary.settlement.bean.TemporarySettlementDetailEntity;
import com.ejianc.business.temporary.settlement.bean.TemporarySettlementEntity;
import com.ejianc.business.temporary.settlement.bean.TemporarySettlementFeeEntity;
import com.ejianc.business.temporary.settlement.mapper.TemporarySettlementMapper;
import com.ejianc.business.temporary.settlement.service.ITemporarySettlementDetailService;
import com.ejianc.business.temporary.settlement.service.ITemporarySettlementService;
import com.ejianc.business.temporary.settlement.vo.SupTemporarySettlementDetailVO;
import com.ejianc.business.temporary.settlement.vo.SupTemporarySettlementFeeVO;
import com.ejianc.business.temporary.settlement.vo.SupTemporarySettlementVO;
import com.ejianc.business.temporary.settlement.vo.TemporarySettlementDetailVO;
import com.ejianc.business.temporary.settlement.vo.TemporarySettlementFeeVO;
import com.ejianc.business.temporary.settlement.vo.TemporarySettlementVO;
import com.ejianc.business.temporary.userecord.service.ITemporaryUseRecordSubService;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.file.vo.AttachmentVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.share.api.IProSupplierApi;
import com.ejianc.foundation.share.api.IShareMaterialApi;
import com.ejianc.foundation.share.utils.FileUtil;
import com.ejianc.foundation.share.vo.MaterialCategoryVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.api.IParamConfigApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.vo.BillParamVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.cache.utils.RedisTool;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.time.DateFormatUtil;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.skeleton.dataPush.ISystemDataPushService;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.ejianc.support.idworker.util.IdWorker;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;

@Service(value="temporarySettlementService")
public class TemporarySettlementServiceImpl
extends BaseServiceImpl<TemporarySettlementMapper, TemporarySettlementEntity>
implements ITemporarySettlementService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IExecutionApi executionApi;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private ICostDetailApi costDetailApi;
    private static final String BILL_CODE = "TP_EQUIPMENT_SETTLE";
    private static final String BILL_TYPE = "EJCBT202204000005";
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private ITemporaryUseRecordSubService temporaryUseRecordSubService;
    @Autowired
    private ITemporarySettlementDetailService detailService;
    @Autowired
    private ITemporaryContractService temporaryContractService;
    @Autowired
    private ISettlePoolApi settlePoolApi;
    @Autowired
    private JedisPool jedisPool;
    private final String OPERATE = "TEMPORARY_SETTLE";
    private final String PUSH_BILL_SERVER_URL = "/ejc-supbusiness-web/openapi/temporarySettlement/saveTemporarySettlement";
    private final String DELPUSH_BILL_SERVER_URL = "/ejc-supbusiness-web/openapi/temporarySettlement/deleteTemporarySettlement";
    @Autowired
    private IProSupplierApi proSupplierApi;
    @Autowired
    private IAttachmentApi attachmentApi;
    @Autowired
    private ISystemDataPushService systemDataPushService;
    @Autowired
    private IParamConfigApi paramConfigApi;
    @Autowired
    private IProMaterialSettleApi proMaterialSettleApi;
    @Autowired
    private IProincomeContractApi proincomeContrantApi;
    @Autowired
    private IShareMaterialApi materialApi;
    @Value(value="${common.env.base-host}")
    private String BaseHost;
    @Value(value="${refer.base-host:null}")
    private String BASE_HOST_FRONTEND;
    private static final String CHECK_MNY_CODE = "P-pK8E6C0137";
    private static final String CHECK_MNY_SUP_CODE = "P-70aP6H0138";
    private static final String CHECK_MNY_CON_CODE = "P-9236fn0143";

    private String getBaseHost() {
        return StringUtils.isNotBlank((CharSequence)this.BASE_HOST_FRONTEND) && !"null".equals(this.BASE_HOST_FRONTEND) ? this.BASE_HOST_FRONTEND : this.BaseHost;
    }

    @Override
    public TemporarySettlementVO saveOrUpdate(TemporarySettlementVO saveOrUpdateVO) {
        TemporarySettlementEntity entity = (TemporarySettlementEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, TemporarySettlementEntity.class));
        if (entity.getId() == null || entity.getId() == 0L) {
            BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (!billCode.isSuccess()) {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
            entity.setBillCode((String)billCode.getData());
            if (entity.getContractId() != null && this.queryExist(entity.getContractId())) {
                throw new BusinessException("\u8be5\u5408\u540c\u4e0b\u6709\u672a\u751f\u6548\u7684\u7ed3\u7b97\u5355\uff01");
            }
            entity.setProportionFlag("0");
            entity.setRelationFlag("0");
            entity.setSignStatus(0);
            entity.setSignatureStatus(0);
        }
        List<TemporarySettlementDetailEntity> detailList = entity.getTemporarySettlementDetailList();
        ArrayList<TemporarySettlementDetailEntity> detailListAdd = new ArrayList<TemporarySettlementDetailEntity>();
        ArrayList<TemporarySettlementDetailEntity> detailListDel = new ArrayList<TemporarySettlementDetailEntity>();
        if (CollectionUtils.isNotEmpty(detailList)) {
            for (TemporarySettlementDetailEntity detailEntity : detailList) {
                if (detailEntity.getId() == null) {
                    detailListAdd.add(detailEntity);
                    continue;
                }
                if (!"del".equals(detailEntity.getRowState())) continue;
                detailListDel.add(detailEntity);
            }
        }
        this.updateSettle(detailListAdd, 1);
        this.updateSettle(detailListDel, 0);
        super.saveOrUpdate((Object)entity, false);
        this.saveCost(entity, 0);
        TemporarySettlementVO vo = (TemporarySettlementVO)BeanMapper.map((Object)((Object)entity), TemporarySettlementVO.class);
        this.pushSettleToCost(vo);
        return vo;
    }

    @Override
    public void delete(List<TemporarySettlementVO> vos) {
        List ids = vos.stream().map(BaseVO::getId).collect(Collectors.toList());
        List temporarySettlementEntities = this.list((Wrapper)new QueryWrapper().in((Object)"id", ids));
        ArrayList<TotalExecutionVO> totalExecutionVOList = new ArrayList<TotalExecutionVO>();
        for (TemporarySettlementEntity entity : temporarySettlementEntities) {
            TemporarySettlementVO temporarySettlementVO = (TemporarySettlementVO)BeanMapper.map((Object)this.selectById(entity.getId()), TemporarySettlementVO.class);
            ExecutionVO executionVO = this.settleCost(temporarySettlementVO, "");
            totalExecutionVOList.add(executionVO.getTotalVO());
            this.logger.info("\u7b56\u5212\u6210\u672c\u5220\u9664\u6570\u636e" + JSON.toJSONString((Object)executionVO));
            CommonResponse stringCommonResponse = this.costDetailApi.deleteSubject(entity.getId());
            this.logger.info("\u5220\u9664\u5b9e\u9645\u6210\u672c\u7ed3\u679c" + JSONObject.toJSONString((Object)stringCommonResponse));
            if (stringCommonResponse.isSuccess()) continue;
            throw new BusinessException(stringCommonResponse.getMsg());
        }
        if (ListUtil.isNotEmpty(totalExecutionVOList)) {
            CommonResponse response = this.executionApi.aggDel(totalExecutionVOList);
            this.logger.info("\u7b56\u5212\u6210\u672c\u5220\u9664\u6570\u636e\u7ed3\u679c---:{}", (Object)JSONObject.toJSONString((Object)response));
            if (!response.isSuccess()) {
                throw new BusinessException("\u7b56\u5212\u6210\u672c\u5220\u9664\u5931\u8d25," + response.getMsg());
            }
        }
        if (CollectionUtils.isNotEmpty(ids)) {
            LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
            wrapper.in(TemporarySettlementDetailEntity::getSettlementId, ids);
            wrapper.eq(BaseEntity::getDr, (Object)0);
            List detailList = this.detailService.list((Wrapper)wrapper);
            this.updateSettle(detailList, 0);
        }
        super.removeByIds((Collection)vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
    }

    public boolean queryExist(Long contractId) {
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(TemporarySettlementEntity::getContractId, (Object)contractId);
        wrapper.notIn(TemporarySettlementEntity::getBillState, new Object[]{1, 3});
        List list = super.list((Wrapper)wrapper);
        return CollectionUtils.isNotEmpty((Collection)list);
    }

    public void updateSettle(List<TemporarySettlementDetailEntity> list, Integer settleFlag) {
        if (CollectionUtils.isNotEmpty(list)) {
            ArrayList<Long> recordIds = new ArrayList<Long>();
            ArrayList<Long> controllerIds = new ArrayList<Long>();
            for (TemporarySettlementDetailEntity detailEntity : list) {
                switch (detailEntity.getSourceType()) {
                    case 0: {
                        recordIds.add(detailEntity.getSourceDetailId());
                        break;
                    }
                    case 1: {
                        controllerIds.add(detailEntity.getSourceDetailId());
                    }
                }
            }
            this.temporaryUseRecordSubService.updateSettleFlag(recordIds, settleFlag);
        }
    }

    @Override
    public CommonResponse<Map> getDateMny(Long contractId) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        BigDecimal currentTaxMny = BigDecimal.ZERO;
        BigDecimal currentMny = BigDecimal.ZERO;
        String sTDate = null;
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.orderByDesc(BaseEntity::getCreateTime);
        wrapper.in(TemporarySettlementEntity::getBillState, new Object[]{1, 3});
        wrapper.eq(BaseEntity::getDr, (Object)0);
        wrapper.eq(TemporarySettlementEntity::getContractId, (Object)contractId);
        List list = super.list((Wrapper)wrapper);
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            sTDate = DateFormatUtil.formatDate((String)"yyyy-MM-dd", (Date)((TemporarySettlementEntity)((Object)list.get(0))).getSettlementDate());
            currentTaxMny = list.stream().filter(e -> null != e.getSettlementTaxMny()).map(TemporarySettlementEntity::getSettlementTaxMny).reduce(BigDecimal.ZERO, BigDecimal::add);
            currentMny = list.stream().filter(e -> null != e.getSettlementMny()).map(TemporarySettlementEntity::getSettlementMny).reduce(BigDecimal.ZERO, BigDecimal::add);
        }
        map.put("currentTaxMny", currentTaxMny);
        map.put("currentMny", currentMny);
        map.put("sTDate", sTDate);
        map.put("settlementNum", list.size());
        return CommonResponse.success((String)"\u83b7\u53d6\u91d1\u989d\u548c\u65f6\u95f4\u6210\u529f\uff01", map);
    }

    @Override
    public boolean pushSettleToPool(TemporarySettlementVO vo) {
        SettlePoolVO spv = new SettlePoolVO();
        boolean flag = false;
        try {
            this.logger.info("\u7ed3\u7b97\u5355\u5bf9\u8c61 -> \u7ed3\u7b97\u6c60\u5bf9\u8c61\u81ea\u52a8\u8f6c\u6362\u5f00\u59cb-----" + JSONObject.toJSONString((Object)vo));
            BeanConvertorUtil.convert((Object)vo, (Object)spv);
            this.logger.info("\u7ed3\u7b97\u5355\u5bf9\u8c61 -> \u7ed3\u7b97\u6c60\u5bf9\u8c61\u81ea\u52a8\u8f6c\u6362\u7ed3\u675f\uff0c\u4e0b\u9762\u5f00\u59cb\u624b\u52a8\u8f6c\u6362");
            this.convertSettleVOToSettlePoolVO(vo, spv);
            if (vo.getContractId() == null) {
                spv.setBillCodeUrl("/ejc-proequipment-frontend/#/temporarySettleList/temporarySettleNoCard?id=" + vo.getId());
            } else {
                spv.setBillCodeUrl("/ejc-proequipment-frontend/#/temporarySettleList/temporarySettleNoCard?id=" + vo.getId());
            }
            this.logger.info("\u63a8\u9001\u53c2\u6570----" + JSONObject.toJSONString((Object)spv));
            CommonResponse res = this.settlePoolApi.saveOrUpdateSettle(spv);
            this.logger.info("\u7ed3\u7b97\u5355\u63a8\u9001\u7ed3\u7b97\u6c60\u7ed3\u675f---" + JSONObject.toJSONString((Object)res));
            if (!res.isSuccess()) {
                this.logger.error("\u7ed3\u7b97\u5355\u63a8\u9001\u7ed3\u7b97\u6c60\u5931\u8d25\uff01\u7ed3\u7b97\u5355id-{}\uff0c{}", (Object)vo.getId(), (Object)res.getMsg());
                throw new BusinessException("\u7ed3\u7b97\u5355\u5f03\u5ba1\u63a8\u9001\u7ed3\u7b97\u6c60\u5931\u8d25!");
            }
            flag = true;
            this.logger.info("\u7ed3\u7b97\u5355\u63a8\u9001\u7ed3\u7b97\u6c60\u6210\u529f---{}", (Object)res.getMsg());
        }
        catch (Exception e) {
            this.logger.error("\u7ed3\u7b97\u5355\u63a8\u9001\u7ed3\u7b97\u6c60\u5931\u8d25\uff01\u7ed3\u7b97\u5355id-{}", (Object)vo.getId(), (Object)e);
            throw new BusinessException("\u7ed3\u7b97\u5355\u63a8\u9001\u7ed3\u7b97\u6c60\u5f02\u5e38!");
        }
        return flag;
    }

    @Override
    public boolean delSettleFromPool(Long id) {
        SettlePoolVO spv = new SettlePoolVO();
        boolean flag = false;
        spv.setSourceId(id);
        try {
            this.logger.info("\u7ed3\u7b97\u5355\u5f03\u5ba1\u63a8\u9001\u7ed3\u7b97\u6c60\u5f00\u59cb,\u7ed3\u7b97\u5355id-{}", (Object)id);
            CommonResponse res = this.settlePoolApi.deleteSettle(spv);
            this.logger.info("\u7ed3\u7b97\u5355\u63a8\u9001\u7ed3\u7b97\u6c60\u7ed3\u675f---" + JSONObject.toJSONString((Object)res));
            if (!res.isSuccess()) {
                this.logger.error("\u7ed3\u7b97\u5355\u63a8\u9001\u7ed3\u7b97\u6c60\u5931\u8d25\uff01\u7ed3\u7b97\u5355id-{}\uff0c{}", (Object)id, (Object)res.getMsg());
                throw new BusinessException("\u7ed3\u7b97\u5355\u5f03\u5ba1\u63a8\u9001\u7ed3\u7b97\u6c60\u5931\u8d25!");
            }
            flag = true;
            this.logger.info("\u7ed3\u7b97\u5355\u5f03\u5ba1\u63a8\u9001\u7ed3\u7b97\u6c60\u6210\u529f---{}", (Object)res.getMsg());
        }
        catch (Exception e) {
            this.logger.error("\u7ed3\u7b97\u5355\u5f03\u5ba1\u63a8\u9001\u7ed3\u7b97\u6c60\u5931\u8d25\uff01\u7ed3\u7b97\u5355id-{}", (Object)id, (Object)e);
            throw new BusinessException("\u7ed3\u7b97\u5355\u5f03\u5ba1\u63a8\u9001\u7ed3\u7b97\u6c60\u5f02\u5e38!");
        }
        return flag;
    }

    private void convertSettleVOToSettlePoolVO(TemporarySettlementVO vo, SettlePoolVO spv) {
        if (null == vo || null == spv) {
            this.logger.error("\u5c06\u7ed3\u7b97\u5355\u63a8\u9001\u81f3\u7ed3\u7b97\u6c60\u5931\u8d25\uff01\u539f\u56e0\uff1a\u7ed3\u7b97\u5355\u5bf9\u8c61\u4e3a\u7a7a\u6216\u7ed3\u7b97\u6c60\u5bf9\u8c61\u4e3a\u7a7a\uff0c\u7ed3\u7b97\u5355\u5bf9\u8c61 -> \u7ed3\u7b97\u6c60\u5bf9\u8c61\u65e0\u6cd5\u8f6c\u6362\uff01");
            return;
        }
        this.logger.info("\u7ed3\u7b97\u5355\u5bf9\u8c61 -> \u7ed3\u7b97\u6c60\u5bf9\u8c61\u624b\u52a8\u8f6c\u6362\u5f00\u59cb");
        spv.setBillStateName(BillStateEnum.getEnumByStateCode((Integer)vo.getBillState()).getDescription());
        spv.setId(vo.getId());
        spv.setSourceType(SettleSourceTypeEnum.\u4e34\u65f6\u8bbe\u5907\u7ed3\u7b97.getCode());
        spv.setSettlePropertyName("\u652f\u51fa");
        spv.setSettleProperty(Integer.valueOf(0));
        spv.setSourceId(vo.getId());
        spv.setHandleType(Integer.valueOf(0));
        spv.setCreateUserCode(vo.getCreateUserCode());
        spv.setCreateTime(vo.getCreateTime());
        spv.setUpdateUserCode(vo.getUpdateUserCode());
        spv.setUpdateTime(vo.getUpdateTime());
        spv.setContractFlag(Integer.valueOf(0));
        if (vo.getContractId() != null) {
            spv.setContractFlag(Integer.valueOf(1));
            TemporaryContractEntity contractEntity = (TemporaryContractEntity)((Object)this.temporaryContractService.selectById(vo.getContractId()));
            spv.setContractType(ContractTypeEnum.\u4e34\u65f6\u8bbe\u5907.getTypeCode());
            spv.setSupplementFlag(contractEntity.getSupplementFlag());
            spv.setMaiContractId(contractEntity.getMainContractId());
            spv.setMaiContractName(contractEntity.getMainContractName());
            spv.setMaiContractCode(contractEntity.getMainContractCode());
            spv.setContractCode(contractEntity.getCode());
            spv.setPartyaId(contractEntity.getPartyId());
            spv.setPartyaName(contractEntity.getPartyName());
            spv.setSignDate(contractEntity.getSignedDate());
            spv.setLastTaxMny(ComputeUtil.safeSub((BigDecimal)vo.getCurrentSettlementTaxMny(), (BigDecimal)vo.getSettlementTaxMny()));
            spv.setLastMny(ComputeUtil.safeSub((BigDecimal)vo.getCurrentSettlementMny(), (BigDecimal)vo.getSettlementMny()));
            spv.setLastTax(ComputeUtil.safeSub((BigDecimal)spv.getLastTaxMny(), (BigDecimal)spv.getLastMny()));
        }
        this.logger.info("\u7ed3\u7b97\u5355\u5bf9\u8c61 -> \u7ed3\u7b97\u6c60\u5bf9\u8c61\u624b\u52a8\u8f6c\u6362\u5b8c\u6210\uff0c\u4e0b\u9762\u5f00\u59cb\u63a8\u9001\u81f3\u7ed3\u7b97\u6c60");
    }

    private BigDecimal getSubStractAbs(BigDecimal a, BigDecimal b) {
        if (a == null || b == null) {
            return null;
        }
        BigDecimal subtract = a.subtract(b);
        if (subtract == null) {
            return null;
        }
        return subtract.abs();
    }

    @Override
    public ExecutionVO targetCost(TemporarySettlementEntity entity) {
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(TemporarySettlementEntity::getContractId, (Object)entity.getContractId());
        wrapper.in(TemporarySettlementEntity::getBillState, Arrays.asList(1, 3));
        List list = this.list((Wrapper)wrapper);
        BigDecimal totalSettleTaxMny = list.stream().filter(e -> e.getSettlementTaxMny() != null).map(TemporarySettlementEntity::getSettlementTaxMny).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal totalSettleMny = list.stream().filter(e -> e.getSettlementMny() != null).map(TemporarySettlementEntity::getSettlementMny).reduce(BigDecimal.ZERO, BigDecimal::add);
        TemporaryContractEntity contractEntity = (TemporaryContractEntity)((Object)this.temporaryContractService.getById(entity.getContractId()));
        ExecutionVO executionVO = new ExecutionVO();
        TotalExecutionVO totalVO = new TotalExecutionVO();
        totalVO.setSourceId(entity.getId());
        totalVO.setTenantId(entity.getTenantId());
        totalVO.setBillCode(entity.getBillCode());
        totalVO.setBillType(BILL_TYPE);
        totalVO.setBillCategory(BillCategoryEnum.\u5408\u540c.getCode());
        totalVO.setProjectId(entity.getProjectId());
        totalVO.setOrgId(entity.getOrgId());
        totalVO.setMoney(ComputeUtil.safeSub((BigDecimal)totalSettleMny, (BigDecimal)contractEntity.getContractMny()));
        totalVO.setTaxMoney(ComputeUtil.safeSub((BigDecimal)totalSettleTaxMny, (BigDecimal)contractEntity.getContractTaxMny()));
        totalVO.setLinkUrl(this.getBaseHost() + "ejc-proequipment-frontend/#/temporarySettleList/temporarySettleNoCard?id=" + entity.getId());
        executionVO.setTotalVO(totalVO);
        return executionVO;
    }

    @Override
    public CommonResponse<TemporarySettlementVO> pushCost(TemporarySettlementVO temporarySettlementVO) {
        TemporarySettlementEntity entity = (TemporarySettlementEntity)((Object)((TemporarySettlementMapper)this.baseMapper).selectById(temporarySettlementVO.getId()));
        if (CollectionUtils.isNotEmpty((Collection)temporarySettlementVO.getTemporarySettlementDetailList())) {
            List detailEntityList = BeanMapper.mapList((Iterable)temporarySettlementVO.getTemporarySettlementDetailList(), TemporarySettlementDetailEntity.class);
            entity.setTemporarySettlementDetailList(detailEntityList);
        }
        if (CollectionUtils.isNotEmpty((Collection)temporarySettlementVO.getTemporarySettlementFeeList())) {
            List feeEntityList = BeanMapper.mapList((Iterable)temporarySettlementVO.getTemporarySettlementFeeList(), TemporarySettlementFeeEntity.class);
            entity.setTemporarySettlementFeeList(feeEntityList);
        }
        super.saveOrUpdate((Object)entity, false);
        this.costPush(entity);
        return CommonResponse.success((Object)BeanMapper.map((Object)((Object)entity), TemporarySettlementVO.class));
    }

    @Override
    public void costPush(TemporarySettlementEntity temporarySettlementEntity) {
        this.logger.info("\u5f00\u59cbcostPush");
        List<TemporarySettlementDetailEntity> detailList = temporarySettlementEntity.getTemporarySettlementDetailList();
        List<TemporarySettlementFeeEntity> feeList = temporarySettlementEntity.getTemporarySettlementFeeList();
        String newRelationFlag = "1";
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty(detailList)) {
            for (TemporarySettlementDetailEntity detailEntity : detailList) {
                if (null != detailEntity.getSubjectId() && null != detailEntity.getWbsId()) continue;
                newRelationFlag = "0";
                break;
            }
        }
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty(feeList)) {
            for (TemporarySettlementFeeEntity feeEntity : feeList) {
                if (null != feeEntity.getSubjectId() && null != feeEntity.getWbsId()) continue;
                newRelationFlag = "0";
                break;
            }
        }
        if (ListUtil.isEmpty(detailList) && ListUtil.isEmpty(feeList)) {
            newRelationFlag = "0";
        }
        String oldRelationFlag = temporarySettlementEntity.getRelationFlag();
        this.saveCost(temporarySettlementEntity, 1);
        temporarySettlementEntity.setRelationFlag(newRelationFlag);
        LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
        updateWrapper.in(BaseEntity::getId, new Object[]{temporarySettlementEntity.getId()});
        updateWrapper.set(TemporarySettlementEntity::getRelationFlag, (Object)newRelationFlag);
        super.update((Wrapper)updateWrapper);
    }

    private void saveCost(TemporarySettlementEntity temporarySettlementEntity, Integer effectiveStatus) {
        CostDetailVO costDetailVO;
        ArrayList<CostDetailVO> costDetailVOList = new ArrayList<CostDetailVO>();
        List<TemporarySettlementDetailEntity> detailList = temporarySettlementEntity.getTemporarySettlementDetailList();
        List<TemporarySettlementFeeEntity> feeList = temporarySettlementEntity.getTemporarySettlementFeeList();
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty(detailList)) {
            for (TemporarySettlementDetailEntity detailEntity : detailList) {
                costDetailVO = (CostDetailVO)BeanMapper.map((Object)((Object)detailEntity), CostDetailVO.class);
                costDetailVO.setSourceDetailId(detailEntity.getId());
                costDetailVO.setHappenTaxMny(detailEntity.getTaxMny());
                costDetailVO.setHappenMny(detailEntity.getMny());
                costDetailVO.setSourceTabType("TEMP_EQ_JS_DETAIL");
                costDetailVO.setProjectId(temporarySettlementEntity.getProjectId());
                costDetailVO.setEffectiveStatus(effectiveStatus);
                costDetailVOList.add(costDetailVO);
            }
        }
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty(feeList)) {
            for (TemporarySettlementFeeEntity FeeEntity : feeList) {
                costDetailVO = (CostDetailVO)BeanMapper.map((Object)((Object)FeeEntity), CostDetailVO.class);
                costDetailVO.setSourceDetailId(FeeEntity.getId());
                costDetailVO.setHappenTaxMny(FeeEntity.getFeeTaxMny());
                costDetailVO.setHappenMny(FeeEntity.getFeeMny());
                costDetailVO.setSourceTabType("TEMP_EQ_JS_FEE");
                costDetailVO.setEffectiveStatus(effectiveStatus);
                costDetailVOList.add(costDetailVO);
            }
        }
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty(costDetailVOList)) {
            for (CostDetailVO costDetailVO2 : costDetailVOList) {
                costDetailVO2.setSourceBillCode(temporarySettlementEntity.getBillCode());
                costDetailVO2.setSourceBillName(SourceTypeEnum.\u4e34\u65f6\u673a\u68b0\u8bbe\u5907\u7ed3\u7b97\u5355.getTypeName());
                costDetailVO2.setSourceBillUrl(this.getBaseHost() + "ejc-proequipment-frontend/#/temporarySettleList/temporarySettleNoCard?id=" + temporarySettlementEntity.getId());
                costDetailVO2.setSourceId(temporarySettlementEntity.getId());
                costDetailVO2.setHappenDate(temporarySettlementEntity.getSettlementDate());
                costDetailVO2.setCreateUserName(this.sessionManager.getUserContext().getUserName());
                costDetailVO2.setId(null);
                costDetailVO2.setSourceType("TEMP_EQ_JS");
                costDetailVO2.setEffectiveStatus(effectiveStatus);
                costDetailVO2.setProjectId(temporarySettlementEntity.getProjectId());
            }
        }
        if (ListUtil.isNotEmpty(costDetailVOList)) {
            this.logger.info("\u63a8\u9001\u6570\u636e--------" + JSONObject.toJSONString(costDetailVOList));
            CommonResponse stringCommonResponse = this.costDetailApi.saveSubject(costDetailVOList);
            this.logger.info("\u63a8\u9001\u7ed3\u679c--------" + JSONObject.toJSONString((Object)stringCommonResponse));
            if (!stringCommonResponse.isSuccess()) {
                throw new BusinessException(stringCommonResponse.getMsg());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean pushBillToSupCenter(TemporarySettlementEntity entity, String billTypeCode) {
        boolean locked = false;
        boolean syncFlag = false;
        Jedis jedis = this.jedisPool.getResource();
        String key = billTypeCode + "::" + entity.getId().toString();
        CommonResponse ejcCloudSystemCode = this.proSupplierApi.getEjcCloudSystemCode();
        if (!ejcCloudSystemCode.isSuccess()) {
            this.logger.error("\u63a8\u9001\u8ba1\u91cf\u5355\u636e-{}\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u7cfb\u7edf\u7f16\u7801\u5931\u8d25,{}", (Object)entity.getId(), (Object)ejcCloudSystemCode.getMsg());
            return false;
        }
        entity.setSystemId((String)ejcCloudSystemCode.getData());
        try {
            locked = RedisTool.tryLock((Jedis)jedis, (String)key, (String)"TEMPORARY_SETTLE", (int)600);
            if (!locked) {
                this.logger.error("\u5355\u636e\u63a8\u9001\u5931\u8d25\uff0c\u5355\u636e\u9501\u83b7\u53d6\u5931\u8d25\uff01");
                this.releaseLock(jedis, false, key, "TEMPORARY_SETTLE");
                boolean bl = false;
                return bl;
            }
            HashMap<String, String> paramMap = new HashMap<String, String>();
            SupTemporarySettlementVO supVO = (SupTemporarySettlementVO)BeanMapper.map((Object)((Object)entity), SupTemporarySettlementVO.class);
            List supDetailVOS = BeanMapper.mapList(entity.getTemporarySettlementDetailList(), SupTemporarySettlementDetailVO.class);
            List supFeeVOS = BeanMapper.mapList(entity.getTemporarySettlementFeeList(), SupTemporarySettlementFeeVO.class);
            supVO.setTemporarySettlementDetailList(supDetailVOS);
            supVO.setTemporarySettlementFeeList(supFeeVOS);
            paramMap.put("transData", JSONObject.toJSONString((Object)supVO));
            CommonResponse fileResp = this.attachmentApi.queryListBySourceId(entity.getId(), billTypeCode, "projectMangerSign", null);
            if (fileResp.isSuccess()) {
                HashMap files = new HashMap();
                List fileList = (List)fileResp.getData();
                ArrayList<Long> fileIds = new ArrayList<Long>();
                for (AttachmentVO attach : fileList) {
                    fileIds.add(attach.getId());
                }
                if (CollectionUtils.isNotEmpty((Collection)fileList)) {
                    Map fileMap = FileUtil.getInstance().batchDownFileFlow(fileIds, true);
                    fileMap.keySet().stream().forEach(fileKey -> {
                        HashMap file = new HashMap(1);
                        file.put((String)fileKey, fileMap.get(fileKey));
                        files.put("file", file);
                    });
                }
                this.logger.info("\u5411\u4f9b\u5e94\u5546-{}\u63a8\u9001\u9644\u4ef6\u53c2\u6570-{}", (Object)entity.getSupplierId(), (Object)JSONObject.toJSONString(files));
                this.logger.info("\u5411\u4f9b\u5e94\u5546-{}\u63a8\u9001\u8ba1\u91cf\u5355\u636e\u53c2\u6570-{}", (Object)entity.getSupplierId(), (Object)JSONObject.toJSONString(paramMap));
                CommonResponse syncReqResp = this.systemDataPushService.exchangeDataAndFilesWithEachLinkSystem("/ejc-supbusiness-web/openapi/temporarySettlement/saveTemporarySettlement", paramMap, entity.getSupplierId().toString(), files);
                if (syncReqResp.isSuccess()) {
                    CommonResponse billPushResp = (CommonResponse)JSONObject.parseObject((String)((String)syncReqResp.getData()), CommonResponse.class);
                    if (billPushResp.isSuccess()) {
                        syncFlag = true;
                    } else {
                        this.logger.error("\u4f9b\u65b9id-{}\u5904\u7406\u63a8\u9001\u5355\u636eid-{}\u5931\u8d25, {}", new Object[]{entity.getSupplierId(), entity.getId(), billPushResp.getMsg()});
                    }
                } else {
                    this.logger.error("\u53d1\u9001\u8bf7\u6c42\u63a8\u9001\u5355\u636eid-{}\u7ed9\u4f9b\u65b9id-{}\u5931\u8d25, {}", new Object[]{entity.getId(), entity.getSupplierId(), syncReqResp.getMsg()});
                }
            } else {
                this.logger.error("\u83b7\u53d6\u5355\u636eid-{}\u5bf9\u5e94\u9644\u4ef6\u4fe1\u606f\u5931\u8d25, {}", (Object)entity.getId(), (Object)fileResp.getMsg());
            }
        }
        catch (Exception e) {
            this.logger.error("\u63a8\u9001\u5355\u636eid-{}\u7ed9\u4f9b\u65b9id-{} \u5f02\u5e38\uff0c", new Object[]{entity.getId(), entity.getSupplierId(), e});
        }
        finally {
            this.releaseLock(jedis, locked, key, "TEMPORARY_SETTLE");
        }
        return syncFlag;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public CommonResponse<String> updatePushBill(TemporarySettlementEntity entity, String billTypeCode) {
        locked = false;
        jedis = this.jedisPool.getResource();
        key = billTypeCode + "::" + entity.getId().toString();
        ejcCloudSystemCode = this.proSupplierApi.getEjcCloudSystemCode();
        if (!ejcCloudSystemCode.isSuccess()) {
            this.logger.error("\u63a8\u9001\u5355\u636e-{}\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u7cfb\u7edf\u7f16\u7801\u5931\u8d25,{}", (Object)entity.getId(), (Object)ejcCloudSystemCode.getMsg());
            return CommonResponse.error((String)"\u63a8\u9001\u4f9b\u65b9\u5f02\u5e38!");
        }
        entity.setSystemId((String)ejcCloudSystemCode.getData());
        entity.setSignStatus(0);
        ((TemporarySettlementMapper)this.baseMapper).updateById((Object)entity);
        this.logger.info("\u4fee\u6539\u7b7e\u5b57\u4fe1\u606f\uff1a{}", (Object)JSONObject.toJSONString((Object)entity));
        try {
            jedis = this.jedisPool.getResource();
            locked = RedisTool.tryLock((Jedis)jedis, (String)key, (String)"TEMPORARY_SETTLE", (int)600);
            if (!locked) {
                this.logger.error("\u5355\u636e\u4f5c\u5e9f\u5931\u8d25\uff0c\u5355\u636e\u9501\u83b7\u53d6\u5931\u8d25\uff01");
                this.releaseLock(jedis, false, key, "TEMPORARY_SETTLE");
                var7_7 = CommonResponse.error((String)"\u5355\u636e\u4f5c\u5e9f\u5931\u8d25\uff0c\u5355\u636e\u9501\u83b7\u53d6\u5931\u8d25!");
                return var7_7;
            }
            paramMap = new HashMap<String, String>();
            paramMap.put("id", entity.getId().toString());
            paramMap.put("systemId", entity.getSystemId());
            this.logger.info("\u5355\u636eid-{}\u5f03\u5ba1\uff0c\u901a\u77e5\u4f9b\u65b9-{}\u5355\u636e\u4f5c\u5e9f!", (Object)entity.getSupplierId(), (Object)entity.getId());
            syncReqResp = this.systemDataPushService.exchangeDataWithEachLinkSystem("/ejc-supbusiness-web/openapi/temporarySettlement/deleteTemporarySettlement", RequestMethod.POST, JSONObject.toJSONString(paramMap), entity.getSupplierId().toString());
            if (!syncReqResp.isSuccess()) ** GOTO lbl36
            supHandleResp = (CommonResponse)JSONObject.parseObject((String)((String)syncReqResp.getData()), CommonResponse.class);
            if (supHandleResp.isSuccess()) {
                var10_12 = supHandleResp;
                return var10_12;
            }
            try {
                this.logger.error("\u4f9b\u65b9-{}\u5904\u7406\u4f5c\u5e9f\u5355\u636eid-{}\u4f5c\u5e9f\u5931\u8d25, {}", new Object[]{entity.getSupplierId(), entity.getId(), supHandleResp.getMsg()});
                throw new BusinessException(supHandleResp.getMsg());
lbl36:
                // 1 sources

                this.logger.error("\u53d1\u9001\u8bf7\u6c42\u901a\u77e5\u4f9b\u65b9-{} \u5355\u636eid-{}\u4f5c\u5e9f\u5931\u8d25, {}", new Object[]{entity.getSupplierId(), entity.getId(), syncReqResp.getMsg()});
                throw new BusinessException(syncReqResp.getMsg());
            }
            catch (Exception e) {
                this.logger.error("\u901a\u77e5\u4f9b\u65b9\u5355\u636eid-{}\u4f5c\u5e9f\u5f02\u5e38\uff0c", (Object)entity.getId(), (Object)e);
                throw new BusinessException("\u63a8\u9001\u4f9b\u65b9\u5f02\u5e38!");
            }
        }
        finally {
            this.releaseLock(jedis, locked, key, "TEMPORARY_SETTLE");
        }
    }

    @Override
    public String updateBillSupSignSyncInfo(HttpServletRequest request) {
        String authority = request.getHeader("authority");
        String msg = null;
        Jedis jedis = null;
        boolean locked = false;
        String billId = request.getParameter("billId");
        String supOperatorName = request.getParameter("supOperatorName");
        String supOperatorPhone = request.getParameter("supOperatorPhone");
        String supOperatorUserCode = request.getParameter("supOperatorUserCode");
        Date supOperateTime = new Date(Long.parseLong(request.getParameter("supOperateTime")));
        String nameSourceTypeMapping = request.getParameter("nameSourceTypeMapping");
        Map mp = (Map)JSONObject.parseObject((String)nameSourceTypeMapping, Map.class);
        TemporarySettlementEntity entity = (TemporarySettlementEntity)((Object)super.selectById((Serializable)((Object)billId)));
        entity.setSupOperateTime(supOperateTime);
        entity.setSupOperatorName(supOperatorName);
        entity.setSupOperatorPhone(supOperatorPhone);
        entity.setSupOperatorUserCode(supOperatorUserCode);
        String key = "EJCBT202204000005::" + entity.getId().toString();
        try {
            jedis = this.jedisPool.getResource();
            locked = RedisTool.tryLock((Jedis)jedis, (String)key, (String)"TEMPORARY_SETTLE", (int)600);
            if (!locked) {
                this.logger.error("\u5355\u636eid-{}\u7b7e\u5b57\u4fe1\u606f\u56de\u5199\u52a0\u9501\u5931\u8d25\uff01", (Object)entity.getId());
                this.releaseLock(jedis, false, key, "TEMPORARY_SETTLE");
                String string = "\u5355\u636e\u7b7e\u5b57\u4fe1\u606f\u56de\u5199\u52a0\u9501\u5931\u8d25";
                return string;
            }
            Map attachIdsMap = FileUtil.getInstance().handleReqFile((MultipartHttpServletRequest)request, mp, BILL_TYPE, authority, entity.getId().toString());
            ArrayList attchIdsList = new ArrayList();
            for (List attachIds : attachIdsMap.values()) {
                if (!CollectionUtils.isNotEmpty((Collection)attachIds)) continue;
                attchIdsList.addAll(attachIds);
            }
            entity.setAttachIds(attchIdsList);
            entity.setSignStatus(1);
            super.saveOrUpdate((Object)entity, false);
        }
        catch (Exception e) {
            this.logger.error("\u5355\u636eid-{}\u7b7e\u5b57\u4fe1\u606f\u56de\u5199\u5f02\u5e38\uff0c", (Object)entity.getId(), (Object)e);
            msg = "\u5355\u636e\u7b7e\u5b57\u4fe1\u606f\u56de\u5199\u5931\u8d25\uff01";
            throw e;
        }
        finally {
            this.releaseLock(jedis, locked, key, "TEMPORARY_SETTLE");
        }
        return msg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseLock(Jedis jedis, boolean locked, String key, String OPERATE) {
        try {
            if (locked) {
                RedisTool.releaseLock((Jedis)jedis, (String)key, (String)OPERATE);
            }
        }
        finally {
            if (null != jedis) {
                jedis.close();
            }
        }
    }

    @Override
    public CommonResponse<String> pushTargetCost(Long id) {
        TemporarySettlementEntity entity = (TemporarySettlementEntity)((Object)this.selectById(id));
        if (entity.getSettlementType() != null && entity.getSettlementType() == 1) {
            this.logger.info("\u63a8\u9001\u7b56\u5212\u6210\u672c\u5f00\u59cb");
            CommonResponse response = this.executionApi.aggPush(this.targetCost(entity));
            this.logger.info("\u63a8\u9001\u7b56\u5212\u6210\u672c\u5165\u53c2\uff1a" + JSONObject.toJSONString((Object)this.targetCost(entity)));
            if (!response.isSuccess()) {
                this.logger.error("\u63a8\u9001\u7b56\u5212\u6210\u672c\u5931\u8d25: , {}", (Object)response.getMsg());
                throw new BusinessException(response.getMsg());
            }
        }
        return CommonResponse.success((String)"\u7b56\u5212\u6210\u672c\u63a8\u9001\u6210\u529f");
    }

    @Override
    public ParamsCheckVO checkParams(TemporarySettlementVO vo) {
        CostCtrlVO costCtrlVO;
        ArrayList<ParamsCheckVO> paramsCheckVOS = new ArrayList<ParamsCheckVO>();
        ParamsCheckVO paramsCheckVO = new ParamsCheckVO();
        paramsCheckVO.setWarnType("none");
        if (CollectionUtils.isNotEmpty(this.checkParamsMny(vo))) {
            paramsCheckVOS.addAll(this.checkParamsMny(vo));
        }
        if (CollectionUtils.isNotEmpty(this.checkParamsSupplierMny(vo))) {
            paramsCheckVOS.addAll(this.checkParamsSupplierMny(vo));
        }
        if (CollectionUtils.isNotEmpty(this.checkParamsConstruction(vo))) {
            paramsCheckVOS.addAll(this.checkParamsConstruction(vo));
        }
        if (null == vo.getId()) {
            vo.setId(Long.valueOf(IdWorker.getId()));
        }
        List temporarySettlementDetailList = vo.getTemporarySettlementDetailList();
        ArrayList<TemporarySettlementDetailVO> temporarySettlementDetailListNew = new ArrayList<TemporarySettlementDetailVO>();
        if (CollectionUtils.isNotEmpty((Collection)temporarySettlementDetailList)) {
            for (TemporarySettlementDetailVO detailVO : temporarySettlementDetailList) {
                if (detailVO.getId() == null) {
                    detailVO.setId(Long.valueOf(IdWorker.getId()));
                    detailVO.setSettlementId(vo.getId());
                }
                if ("del".equals(detailVO.getRowState())) continue;
                temporarySettlementDetailListNew.add(detailVO);
            }
            vo.setTemporarySettlementDetailList(temporarySettlementDetailListNew);
        }
        String linkUrl = this.getBaseHost() + "ejc-proequipment-frontend/#/temporarySettlement/settlementNoCard?id=" + vo.getId();
        ExecutionVO executionVO = this.settleCost(vo, linkUrl);
        this.logger.error("\u7b56\u5212\u6210\u672c\u63a7\u5236\u63a8\u9001\u4f20\u53c2\uff1a" + JSONObject.toJSONString((Object)executionVO));
        CommonResponse response = this.executionApi.ctrlCheckVO(executionVO);
        if (!response.isSuccess()) {
            throw new BusinessException("\u7b56\u5212\u6210\u672c\u63a7\u5236\u5931\u8d25," + response.getMsg());
        }
        ParamsCheckVO tarRes = (ParamsCheckVO)response.getData();
        if (null != tarRes) {
            paramsCheckVOS.add(tarRes);
        }
        if (null != (costCtrlVO = this.sjCost(vo))) {
            CommonResponse costResponse = this.executionApi.ctrlCost(costCtrlVO);
            if (!costResponse.isSuccess()) {
                throw new BusinessException("\u6210\u672c\u79d1\u76ee\u63a7\u5236\u5931\u8d25," + costResponse.getMsg());
            }
            ParamsCheckVO costRes = (ParamsCheckVO)costResponse.getData();
            if (null != costRes) {
                paramsCheckVOS.add(costRes);
            }
        }
        HashMap<String, List> map = new HashMap<String, List>();
        String[] paramsArray = new String[]{"alert", "warn", "none"};
        if (CollectionUtils.isNotEmpty(paramsCheckVOS)) {
            for (ParamsCheckVO checkVO : paramsCheckVOS) {
                String warnType = checkVO.getWarnType();
                if (map.containsKey(warnType)) {
                    List checkDsVOS = (List)map.get(warnType);
                    checkDsVOS.addAll(checkVO.getDataSource());
                    map.put(warnType, checkDsVOS);
                    continue;
                }
                map.put(warnType, checkVO.getDataSource());
            }
        }
        for (String s : paramsArray) {
            if (!map.containsKey(s)) continue;
            paramsCheckVO.setWarnType(s);
            paramsCheckVO.setDataSource((List)map.get(s));
            if (CollectionUtils.isEmpty((Collection)paramsCheckVO.getDataSource())) {
                paramsCheckVO.setWarnType("none");
                continue;
            }
            return paramsCheckVO;
        }
        return paramsCheckVO;
    }

    public CostCtrlVO sjCost(TemporarySettlementVO vo) {
        CostCtrlDetailVO costCtrlDetailVO;
        BigDecimal taxMny;
        BigDecimal mny;
        List detailList = vo.getTemporarySettlementDetailList();
        List feeList = vo.getTemporarySettlementFeeList();
        HashMap<Long, CostCtrlDetailVO> map = new HashMap<Long, CostCtrlDetailVO>();
        if (CollectionUtils.isNotEmpty((Collection)detailList)) {
            for (TemporarySettlementDetailVO detailVO : detailList) {
                if (null == detailVO.getSubjectId() || "del".equals(detailVO.getRowState())) continue;
                mny = detailVO.getMny() == null ? BigDecimal.ZERO : detailVO.getMny();
                BigDecimal bigDecimal = taxMny = detailVO.getTaxMny() == null ? BigDecimal.ZERO : detailVO.getTaxMny();
                if (map.containsKey(detailVO.getSubjectId())) {
                    costCtrlDetailVO = (CostCtrlDetailVO)map.get(detailVO.getSubjectId());
                    costCtrlDetailVO.setMny(ComputeUtil.safeAdd((BigDecimal)costCtrlDetailVO.getMny(), (BigDecimal)mny));
                    costCtrlDetailVO.setTaxMny(ComputeUtil.safeAdd((BigDecimal)costCtrlDetailVO.getTaxMny(), (BigDecimal)taxMny));
                    continue;
                }
                costCtrlDetailVO = new CostCtrlDetailVO();
                costCtrlDetailVO.setSubjectId(detailVO.getSubjectId());
                costCtrlDetailVO.setMny(mny);
                costCtrlDetailVO.setTaxMny(taxMny);
                map.put(detailVO.getSubjectId(), costCtrlDetailVO);
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)feeList)) {
            for (TemporarySettlementFeeVO feeVO : feeList) {
                if (null == feeVO.getSubjectId() || "del".equals(feeVO.getRowState())) continue;
                mny = feeVO.getFeeMny() == null ? BigDecimal.ZERO : feeVO.getFeeMny();
                BigDecimal bigDecimal = taxMny = feeVO.getFeeTaxMny() == null ? BigDecimal.ZERO : feeVO.getFeeTaxMny();
                if (map.containsKey(feeVO.getSubjectId())) {
                    costCtrlDetailVO = (CostCtrlDetailVO)map.get(feeVO.getSubjectId());
                    costCtrlDetailVO.setMny(ComputeUtil.safeAdd((BigDecimal)costCtrlDetailVO.getMny(), (BigDecimal)mny));
                    costCtrlDetailVO.setTaxMny(ComputeUtil.safeAdd((BigDecimal)costCtrlDetailVO.getTaxMny(), (BigDecimal)taxMny));
                    continue;
                }
                costCtrlDetailVO = new CostCtrlDetailVO();
                costCtrlDetailVO.setSubjectId(feeVO.getSubjectId());
                costCtrlDetailVO.setMny(mny);
                costCtrlDetailVO.setTaxMny(taxMny);
                map.put(feeVO.getSubjectId(), costCtrlDetailVO);
            }
        }
        if (null != map && !map.isEmpty()) {
            CostCtrlVO ctrlVO = new CostCtrlVO();
            if (vo.getId() != null) {
                ctrlVO.setSourceId(vo.getId());
            }
            ctrlVO.setOrgId(vo.getOrgId());
            ctrlVO.setProjectId(vo.getProjectId());
            ctrlVO.setDetailList(new ArrayList(map.values()));
            return ctrlVO;
        }
        return null;
    }

    @Override
    public List<ParamsCheckVO> checkParamsMny(TemporarySettlementVO vo) {
        String[] paramsArray = new String[]{"none", "warn", "alert"};
        ArrayList<ParamsCheckVO> paramsCheckVOList = new ArrayList<ParamsCheckVO>();
        CommonResponse billParamByCode = this.paramConfigApi.getBillParamByCodeAndOrgId(CHECK_MNY_CODE, vo.getOrgId());
        if (billParamByCode.isSuccess() && null != billParamByCode.getData()) {
            List data = (List)billParamByCode.getData();
            this.logger.info("\u5355\u6b21\u4e34\u65f6\u79df\u8d41\u7ed3\u7b97\u91d1\u989d\u63a7\u5236\u4fe1\u606f\u8fd4\u56de\uff1a" + JSONObject.toJSONString((Object)data));
            if (CollectionUtils.isNotEmpty((Collection)data)) {
                for (BillParamVO datum : data) {
                    ParamsCheckVO paramsCheckVO = new ParamsCheckVO();
                    ArrayList<ParamsCheckDsVO> checkDsVOS = new ArrayList<ParamsCheckDsVO>();
                    BigDecimal roleValue = datum.getRoleValue();
                    BigDecimal mny = null == vo.getSettlementTaxMny() ? BigDecimal.ZERO : vo.getSettlementTaxMny();
                    paramsCheckVO.setWarnType(paramsArray[datum.getControlType()]);
                    if (mny.compareTo(roleValue) > 0) {
                        ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO();
                        paramsCheckDsVO.setOrgName(datum.getOrgName());
                        paramsCheckDsVO.setWarnItem("\u672c\u6b21\u7ed3\u7b97\u91d1\u989d\u8d85\u8fc7\u9650\u5b9a\u91d1\u989d");
                        paramsCheckDsVO.setWarnName("\u5355\u6b21\u4e34\u65f6\u8bbe\u5907\u7ed3\u7b97\u91d1\u989d\u8d85\u9650\u5b9a\u91d1\u989d");
                        StringBuffer stringBuffer = new StringBuffer();
                        stringBuffer.append("\u672c\u6b21\u7ed3\u7b97\u91d1\u989d\uff1a").append(mny.setScale(2, 4)).append("\u5143\uff0c\u9650\u5b9a\u91d1\u989d\uff1a").append(roleValue.setScale(2, 4)).append("\u5143\u3002\u8d85\u51fa\u91d1\u989d\uff1a").append(ComputeUtil.safeSub((BigDecimal)mny, (BigDecimal)roleValue).setScale(2, 4)).append("\u5143");
                        paramsCheckDsVO.setContent(stringBuffer.toString());
                        checkDsVOS.add(paramsCheckDsVO);
                    }
                    paramsCheckVO.setDataSource(checkDsVOS);
                    paramsCheckVOList.add(paramsCheckVO);
                }
            }
        } else {
            this.logger.info(billParamByCode.getMsg());
            throw new BusinessException("\u83b7\u53d6\u63a7\u5236\u53c2\u6570\u5931\u8d25");
        }
        return paramsCheckVOList;
    }

    @Override
    public List<ParamsCheckVO> checkParamsSupplierMny(TemporarySettlementVO vo) {
        String[] paramsArray = new String[]{"none", "warn", "alert"};
        ArrayList<ParamsCheckVO> paramsCheckVOList = new ArrayList<ParamsCheckVO>();
        BigDecimal mny = null == vo.getSettlementTaxMny() ? BigDecimal.ZERO : vo.getSettlementTaxMny();
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(TemporarySettlementEntity::getSupplierId, (Object)vo.getSupplierId());
        wrapper.eq(TemporarySettlementEntity::getProjectId, (Object)vo.getProjectId());
        if (null != vo.getId()) {
            wrapper.ne(BaseEntity::getId, (Object)vo.getId());
        }
        List list = super.list((Wrapper)wrapper);
        BigDecimal totalMny = list.stream().filter(e -> null != e.getSettlementTaxMny()).map(TemporarySettlementEntity::getSettlementTaxMny).reduce(BigDecimal.ZERO, BigDecimal::add);
        totalMny = ComputeUtil.safeAdd((BigDecimal)totalMny, (BigDecimal)mny);
        CommonResponse billParamByCode = this.paramConfigApi.getBillParamByCodeAndOrgId(CHECK_MNY_SUP_CODE, vo.getOrgId());
        if (billParamByCode.isSuccess() && null != billParamByCode.getData()) {
            List data = (List)billParamByCode.getData();
            this.logger.info("\u5355\u4e2a\u4f9b\u5e94\u5546\u4e34\u65f6\u79df\u8d41\u7ed3\u7b97\u91d1\u989d\u63a7\u5236\u4fe1\u606f\u8fd4\u56de\uff1a" + JSONObject.toJSONString((Object)data));
            if (CollectionUtils.isNotEmpty((Collection)data)) {
                for (BillParamVO datum : data) {
                    ParamsCheckVO paramsCheckVO = new ParamsCheckVO();
                    ArrayList<ParamsCheckDsVO> checkDsVOS = new ArrayList<ParamsCheckDsVO>();
                    BigDecimal roleValue = datum.getRoleValue();
                    paramsCheckVO.setWarnType(paramsArray[datum.getControlType()]);
                    if (totalMny.compareTo(roleValue) > 0) {
                        ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO();
                        paramsCheckDsVO.setOrgName(datum.getOrgName());
                        paramsCheckDsVO.setWarnItem("\u4f9b\u5e94\u5546\u96f6\u661f\u673a\u68b0\u8d39\u7528\u8d85\u8fc7\u9650\u5b9a\u91d1\u989d");
                        paramsCheckDsVO.setWarnName("\u4f9b\u5e94\u5546\u96f6\u661f\u673a\u68b0\u8d39\u7528\u8d85\u8fc7\u9650\u5b9a\u91d1\u989d");
                        StringBuffer stringBuffer = new StringBuffer();
                        stringBuffer.append("\u672c\u6b21\u91d1\u989d\uff1a").append(mny.setScale(2, 4)).append("\u5143\uff0c\u542b\u672c\u6b21\u7d2f\u8ba1\u91d1\u989d\uff1a").append(totalMny.setScale(2, 4)).append("\u5143\uff0c\u9650\u5b9a\u91d1\u989d\uff1a").append(roleValue.setScale(2, 4)).append("\u5143\u3002\u8d85\u51fa\u91d1\u989d\uff1a").append(ComputeUtil.safeSub((BigDecimal)totalMny, (BigDecimal)roleValue).setScale(2, 4)).append("\u5143");
                        paramsCheckDsVO.setContent(stringBuffer.toString());
                        checkDsVOS.add(paramsCheckDsVO);
                    }
                    paramsCheckVO.setDataSource(checkDsVOS);
                    paramsCheckVOList.add(paramsCheckVO);
                }
            }
        } else {
            this.logger.info(billParamByCode.getMsg());
            throw new BusinessException("\u83b7\u53d6\u63a7\u5236\u53c2\u6570\u5931\u8d25");
        }
        return paramsCheckVOList;
    }

    @Override
    public List<ParamsCheckVO> checkParamsConstruction(TemporarySettlementVO vo) {
        CommonResponse billParamByCode;
        List list;
        BigDecimal mny;
        String[] paramsArray = new String[]{"none", "warn", "alert"};
        ArrayList<ParamsCheckVO> paramsCheckVOList = new ArrayList<ParamsCheckVO>();
        BigDecimal contractTaxMny = BigDecimal.ZERO;
        BigDecimal totalMny = mny = null == vo.getSettlementTaxMny() ? BigDecimal.ZERO : vo.getSettlementTaxMny();
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(TemporarySettlementEntity::getProjectId, (Object)vo.getProjectId());
        if (null != vo.getId()) {
            wrapper.ne(BaseEntity::getId, (Object)vo.getId());
        }
        if (CollectionUtils.isNotEmpty((Collection)(list = super.list((Wrapper)wrapper)))) {
            BigDecimal totalSettleMny = list.stream().filter(e -> null != e.getSettlementTaxMny()).map(TemporarySettlementEntity::getSettlementTaxMny).reduce(BigDecimal.ZERO, BigDecimal::add);
            totalMny = ComputeUtil.safeAdd((BigDecimal)totalMny, (BigDecimal)totalSettleMny);
        }
        CommonResponse response = this.proMaterialSettleApi.querySettleMnyProjectId(vo.getProjectId());
        this.logger.info("\u8be5\u9879\u76ee\uff1a{}-\u4e0b\u6240\u6709\u72b6\u6001\u7684\u3010\u65e0\u5408\u540c\u6750\u6599\u7ed3\u7b97+\u65e0\u5408\u540c\u6df7\u51dd\u571f\u7ed3\u7b97\u3011\u91d1\u989d\u7ed3\u679c:{}", (Object)vo.getProjectId(), (Object)JSONObject.toJSONString((Object)response));
        if (response.isSuccess() && null != response.getData()) {
            BigDecimal settleTaxMny = ((JSONObject)response.getData()).getBigDecimal("settleTaxMny");
            totalMny = ComputeUtil.safeAdd((BigDecimal)totalMny, (BigDecimal)settleTaxMny);
        }
        CommonResponse commonResponse = this.proincomeContrantApi.queryContranctMny(vo.getProjectId());
        this.logger.info("\u8be5\u9879\u76ee:{}-\u4e0b\u751f\u6548\u7684\u6700\u65b0\u6b63\u5f0f\u65bd\u5de5\u5408\u540c:{}", (Object)vo.getProjectId(), (Object)JSONObject.toJSONString((Object)commonResponse));
        if (commonResponse.isSuccess() && null != commonResponse.getData()) {
            BigDecimal bigDecimal = contractTaxMny = null == ((ContractRegisterVO)commonResponse.getData()).getContractTaxMny() ? BigDecimal.ZERO : ((ContractRegisterVO)commonResponse.getData()).getContractTaxMny();
        }
        if ((billParamByCode = this.paramConfigApi.getBillParamByCodeAndOrgId(CHECK_MNY_CON_CODE, vo.getOrgId())).isSuccess() && null != billParamByCode.getData()) {
            List data = (List)billParamByCode.getData();
            this.logger.info("\u3010\u65bd\u5de5\u5408\u540c\u91d1\u989d\u3011\u63a7\u3010\u65e0\u5408\u540c\u7ed3\u7b97\u3001\u96f6\u661f\u673a\u68b0\u91d1\u989d\u3011\u4fe1\u606f\u8fd4\u56de\uff1a" + JSONObject.toJSONString((Object)data));
            if (CollectionUtils.isNotEmpty((Collection)data)) {
                for (BillParamVO datum : data) {
                    ParamsCheckVO paramsCheckVO = new ParamsCheckVO();
                    ArrayList<ParamsCheckDsVO> checkDsVOS = new ArrayList<ParamsCheckDsVO>();
                    BigDecimal roleValue = datum.getRoleValue();
                    BigDecimal comMny = ComputeUtil.safeDiv((BigDecimal)ComputeUtil.safeMultiply((BigDecimal)contractTaxMny, (BigDecimal)roleValue), (BigDecimal)new BigDecimal("100"));
                    paramsCheckVO.setWarnType(paramsArray[datum.getControlType()]);
                    if (totalMny.compareTo(comMny) > 0) {
                        ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO();
                        paramsCheckDsVO.setOrgName(datum.getOrgName());
                        paramsCheckDsVO.setWarnItem("\u65e0\u5408\u540c\u7ed3\u7b97\u3001\u4e34\u673a\u8d39\u7528\u8d85\u65bd\u5de5\u5408\u540c\u989d");
                        paramsCheckDsVO.setWarnName("\u65e0\u5408\u540c\u7ed3\u7b97\u3001\u4e34\u673a\u8d39\u7528\u7d2f\u8ba1\u91d1\u989d\u8d85\u65bd\u5de5\u5408\u540c\u91d1\u989d");
                        StringBuffer stringBuffer = new StringBuffer();
                        stringBuffer.append("\u672c\u6b21\u91d1\u989d\uff1a").append(mny.setScale(2, 4)).append("\u5143\uff0c\u542b\u672c\u6b21\u96f6\u6750\u3001\u96f6\u673a\u53d1\u751f\u91d1\u989d\uff1a").append(totalMny.setScale(2, 4)).append("\u5143\uff0c\u5408\u540c\u91d1\u989d*").append(roleValue).append("%:").append(comMny.setScale(2, 4)).append("\u5143\u3002\u8d85\u51fa\u91d1\u989d\uff1a").append(ComputeUtil.safeSub((BigDecimal)totalMny, (BigDecimal)comMny).setScale(2, 4)).append("\u5143");
                        paramsCheckDsVO.setContent(stringBuffer.toString());
                        checkDsVOS.add(paramsCheckDsVO);
                    }
                    paramsCheckVO.setDataSource(checkDsVOS);
                    paramsCheckVOList.add(paramsCheckVO);
                }
            }
        } else {
            this.logger.info(billParamByCode.getMsg());
            throw new BusinessException("\u83b7\u53d6\u63a7\u5236\u53c2\u6570\u5931\u8d25");
        }
        return paramsCheckVOList;
    }

    @Override
    public CommonResponse<String> pushSettleToCost(TemporarySettlementVO temporarySettlementVO) {
        TemporarySettlementEntity temporarySettlementEntity = (TemporarySettlementEntity)((Object)this.selectById(temporarySettlementVO.getId()));
        TemporarySettlementVO vo = (TemporarySettlementVO)BeanMapper.map((Object)((Object)temporarySettlementEntity), TemporarySettlementVO.class);
        String linkUrl = this.getBaseHost() + "ejc-proequipment-frontend/#/temporarySettlement/settlementNoCard?id=" + vo.getId();
        ExecutionVO executionVO = this.settleCost(vo, linkUrl);
        this.logger.info("\u624b\u52a8\u63a8\u9001 \u4e34\u65f6\u8bbe\u5907\u7ed3\u7b97\u7b56\u5212\u6210\u672c\u63a8\u9001\u6570\u636e" + JSON.toJSONString((Object)executionVO));
        CommonResponse response = this.executionApi.aggPush(executionVO);
        this.logger.info("\u624b\u52a8\u63a8\u9001 \u4e34\u65f6\u8bbe\u5907\u7ed3\u7b97\u7b56\u5212\u6210\u672c\u63a8\u9001\u7ed3\u679c---:{}", (Object)JSONObject.toJSONString((Object)response));
        return response;
    }

    @Override
    public ExecutionVO settleCost(TemporarySettlementVO temporarySettlementVO, String linkUrl) {
        ExecutionVO executionVO = new ExecutionVO();
        TotalExecutionVO totalVO = new TotalExecutionVO();
        ArrayList<DetailExecutionVO> detailList = new ArrayList<DetailExecutionVO>();
        totalVO.setSourceId(temporarySettlementVO.getId());
        totalVO.setTenantId(temporarySettlementVO.getTenantId());
        totalVO.setBillCode(temporarySettlementVO.getBillCode());
        totalVO.setOrgId(temporarySettlementVO.getOrgId());
        totalVO.setProjectId(temporarySettlementVO.getProjectId());
        totalVO.setContractId(temporarySettlementVO.getContractId());
        totalVO.setBillDate(DateFormatUtil.formatDate((String)"yyyy-MM-dd", (Date)temporarySettlementVO.getSettlementDate()));
        totalVO.setMoney(temporarySettlementVO.getSettlementMny());
        totalVO.setTaxMoney(temporarySettlementVO.getSettlementTaxMny());
        totalVO.setBillType(BILL_TYPE);
        totalVO.setBillCategory(BillCategoryEnum.\u7ed3\u7b97.getCode());
        List detailVOList = temporarySettlementVO.getTemporarySettlementDetailList();
        if (CollectionUtils.isNotEmpty((Collection)detailVOList)) {
            for (TemporarySettlementDetailVO detailVO : detailVOList) {
                DetailExecutionVO detailExecutionVO = new DetailExecutionVO();
                detailExecutionVO.setSourceId(Long.valueOf(detailVO.getId() == null ? IdWorker.getId() : detailVO.getId()));
                detailExecutionVO.setSourceBillId(detailVO.getSettlementId());
                detailExecutionVO.setContractId(temporarySettlementVO.getContractId());
                detailExecutionVO.setContractDetailId(detailVO.getId());
                detailExecutionVO.setCategoryId(detailVO.getEquipmentTypeId());
                CommonResponse categoryResp = this.materialApi.queryCategoryById(detailVO.getEquipmentTypeId());
                detailExecutionVO.setCategoryCode(((MaterialCategoryVO)categoryResp.getData()).getCode());
                detailExecutionVO.setCategoryName(detailVO.getEquipmentTypeName());
                detailExecutionVO.setCategoryFlag(Boolean.valueOf(false));
                detailExecutionVO.setDocId(detailVO.getEquipmentId());
                detailExecutionVO.setCode(detailVO.getEquipmentCode());
                detailExecutionVO.setName(detailVO.getEquipmentName());
                detailExecutionVO.setUnitId(detailVO.getUnitId());
                detailExecutionVO.setUnitName(detailVO.getUnit());
                detailExecutionVO.setNum(detailVO.getNum());
                detailExecutionVO.setMoney(detailVO.getMny());
                detailExecutionVO.setTaxMoney(detailVO.getTaxMny());
                detailExecutionVO.setCategoryContainFlag(Boolean.valueOf(false));
                detailList.add(detailExecutionVO);
            }
        }
        totalVO.setLinkUrl(linkUrl);
        executionVO.setTotalVO(totalVO);
        executionVO.setDetailList(detailList);
        return executionVO;
    }
}

