package com.ejianc.business.rent.bean;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * 施工机械结算子表
 * 
 * @author generator
 * 
 */
 @TableName("ejc_proequipment_settlement_content")
public class RentMachineSettlementContentEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="settlement_id")
    private Long settlementId; // 结算单主表ID
    @TableField(value="equipment_code")
    private String equipmentCode; // 设备自编码
    @TableField(value="equipment_name")
    private String equipmentName; // 设备名称
    @TableField(value="spec")
    private String spec; // 规格型号
    @TableField(value="rental_unit")
    private String rentalUnit; // 计租单位
    @TableField(value="enable_time")
    private String enableTime; // 启用时间
    @TableField(value="disable_time")
    private String disableTime; // 停用时间
    @TableField(value="quantity")
    private BigDecimal quantity; // 数量
    @TableField(value="price")
    private BigDecimal price; // 单价
    @TableField(value="amount")
    private BigDecimal amount; // 金额
    @TableField(value="settlement_no_tax_amount")
    private BigDecimal settlementNoTaxAmount; // 无税金额
    @TableField(value="settlement_tax_amount")
    private BigDecimal settlementTaxAmount; // 税额
    @TableField(value="use_date")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date useDate; // 停用日期
    @TableField(value="work_content")
    private String workContent; // 工作内容
    @TableField(value = "rent_unit_id")
    private Long rentUnitId;

    @TableField(value = "equipment_id")
    private Long equipmentId;

    @TableField(value = "category_id")
    private Long categoryId;
    @TableField(value = "category_name")
    private String categoryName;
    @TableField(value = "category_code")
    private String categoryCode;
    @TableField(value = "source_id")
    private Long sourceId; // 来源ID
    @TableField(value="subject_id")
    private Long subjectId; // 成本科目主键
    @TableField(value="subject_code")
    private String subjectCode; // 成本科目编码
    @TableField(value="subject_name")
    private String subjectName; // 成本科目名称

    public Long getSourceId() {
        return sourceId;
    }

    public void setSourceId(Long sourceId) {
        this.sourceId = sourceId;
    }

    public Long getRentUnitId() {
        return rentUnitId;
    }

    public void setRentUnitId(Long rentUnitId) {
        this.rentUnitId = rentUnitId;
    }

    public Long getSubjectId() {
        return subjectId;
    }

    public void setSubjectId(Long subjectId) {
        this.subjectId = subjectId;
    }

    public String getSubjectCode() {
        return subjectCode;
    }

    public void setSubjectCode(String subjectCode) {
        this.subjectCode = subjectCode;
    }

    public String getSubjectName() {
        return subjectName;
    }

    public void setSubjectName(String subjectName) {
        this.subjectName = subjectName;
    }


    public Long getEquipmentId() {
        return equipmentId;
    }

    public void setEquipmentId(Long equipmentId) {
        this.equipmentId = equipmentId;
    }

    public Long getCategoryId() {
        return categoryId;
    }

    public void setCategoryId(Long categoryId) {
        this.categoryId = categoryId;
    }

    public String getCategoryName() {
        return categoryName;
    }

    public void setCategoryName(String categoryName) {
        this.categoryName = categoryName;
    }

    public String getCategoryCode() {
        return categoryCode;
    }

    public void setCategoryCode(String categoryCode) {
        this.categoryCode = categoryCode;
    }

    public Long getSettlementId() {
        return settlementId;
    }

    public void setSettlementId(Long settlementId) {
        this.settlementId = settlementId;
    }
    public String getEquipmentCode() {
        return equipmentCode;
    }

    public void setEquipmentCode(String equipmentCode) {
        this.equipmentCode = equipmentCode;
    }
    public String getEquipmentName() {
        return equipmentName;
    }

    public void setEquipmentName(String equipmentName) {
        this.equipmentName = equipmentName;
    }
    public String getSpec() {
        return spec;
    }

    public void setSpec(String spec) {
        this.spec = spec;
    }
    public String getRentalUnit() {
        return rentalUnit;
    }

    public void setRentalUnit(String rentalUnit) {
        this.rentalUnit = rentalUnit;
    }
    public String getEnableTime() {
        return enableTime;
    }

    public void setEnableTime(String enableTime) {
        this.enableTime = enableTime;
    }
    public String getDisableTime() {
        return disableTime;
    }

    public void setDisableTime(String disableTime) {
        this.disableTime = disableTime;
    }
    public BigDecimal getQuantity() {
        return quantity;
    }

    public void setQuantity(BigDecimal quantity) {
        this.quantity = quantity;
    }
    public BigDecimal getPrice() {
        return price;
    }

    public void setPrice(BigDecimal price) {
        this.price = price;
    }
    public BigDecimal getAmount() {
        return amount;
    }

    public void setAmount(BigDecimal amount) {
        this.amount = amount;
    }
    public BigDecimal getSettlementNoTaxAmount() {
        return settlementNoTaxAmount;
    }

    public void setSettlementNoTaxAmount(BigDecimal settlementNoTaxAmount) {
        this.settlementNoTaxAmount = settlementNoTaxAmount;
    }
    public BigDecimal getSettlementTaxAmount() {
        return settlementTaxAmount;
    }

    public void setSettlementTaxAmount(BigDecimal settlementTaxAmount) {
        this.settlementTaxAmount = settlementTaxAmount;
    }
    public String getWorkContent() {
        return workContent;
    }

    public void setWorkContent(String workContent) {
        this.workContent = workContent;
    }

    public Date getUseDate() {
        return useDate;
    }

    public void setUseDate(Date useDate) {
        this.useDate = useDate;
    }
}
