package com.ejianc.business.rent.bean;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

import com.ejianc.business.rent.bean.RentSettlementDayEntity;
import com.ejianc.business.rent.bean.RentSettlementMonthEntity;
import com.ejianc.business.rent.bean.RentSettlementQuantitiesEntity;
import com.ejianc.business.rent.bean.RentSettlementRentalEntity;
import com.ejianc.business.rent.bean.RentSettlementFeeEntity;
/**
 * 设备租赁结算主表
 *
 * @author generator
 *
 */
 @TableName("ejc_proequipment_rent_settlement")
public class RentSettlementEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;

    @TableField(value="bill_code")
    private String billCode; // 单据编号
    @TableField(value="bill_state")
    private Integer billState; // 单据状态（审批必须字段）
    @TableField(value="project_id")
    private Long projectId; // 项目
    @TableField(value="project_code")
    private String projectCode; // 项目编码
    @TableField(value="project_name")
    private String projectName; // 项目名称
    @TableField(value="org_id")
    private Long orgId; // 组织
    @TableField(value="org_name")
    private String orgName; // 组织名称
    @TableField(value="parent_org_id")
    private Long parentOrgId; // 项目部上级组织Id
    @TableField(value="parent_org_name")
    private String parentOrgName; // 项目部上级组织名称
    @TableField(value="contract_id")
    private Long contractId; // 合同主键
    @TableField(value="contract_name")
    private String contractName; // 合同名称
    @TableField(value="contract_code")
    private String contractCode; // 合同编号
    @TableField(value="supplier_id")
    private Long supplierId; // 供应商
    @TableField(value="supplier_name")
    private String supplierName; // 供应商名称
    @TableField(value="employee_id")
    private Long employeeId; // 经办人
    @TableField(value="employee_name")
    private String employeeName; // 经办人名称
    @TableField(value="settlement_date")
    private Date settlementDate; // 结算日期
    @TableField(value="department_id")
    private Long departmentId; // 经办部门
    @TableField(value="department_name")
    private String departmentName; // 经办部门名称
    @TableField(value="memo")
    private String memo; // 备注
    @TableField(value="signature_status")
    private Integer signatureStatus; // 签章状态：1、未签章；2、待乙方签章；3、待甲方签章；4、已签章；  单据新增后默认为未签章
    @TableField(value="sign_status")
    private Integer signStatus; // 签字状态，0-未签字,1-已签字
    @TableField(value="settlement_type")
    private Integer settlementType; // 结算类型，0-过程,1-最终
    @TableField(value="meter_rent_type")
    private String meterRentType; // 计租方式
    @TableField(value="meter_rent_type_name")
    private String meterRentTypeName; // 计租方式名称
    @TableField(value="settlement_mny")
    private BigDecimal settlementMny; // 结算金额(无税)
    @TableField(value="settlement_tax_mny")
    private BigDecimal settlementTaxMny; // 结算金额
    @TableField(value="settlement_tax")
    private BigDecimal settlementTax; // 结算税额
    @TableField(value="rent_total_mny")
    private BigDecimal rentTotalMny; // 租赁金额(无税)
    @TableField(value="rent_total_tax_mny")
    private BigDecimal rentTotalTaxMny; // 租赁金额
    @TableField(value="rent_total_tax")
    private BigDecimal rentTotalTax; // 租赁税额
    @TableField(value="other_mny")
    private BigDecimal otherMny; // 其他金额(无税)
    @TableField(value="other_tax_mny")
    private BigDecimal otherTaxMny; // 其他金额
    @TableField(value="other_tax")
    private BigDecimal otherTax; // 其他税额
    @TableField(value="contract_tax_mny")
    private BigDecimal contractTaxMny; // 合同金额
    @TableField(value="contract_mny")
    private BigDecimal contractMny; // 合同金额（无税）
    @TableField(value="contract_tax")
    private BigDecimal contractTax; // 合同税额
    @TableField(value="contract_invoice_tax_mny")
    private BigDecimal contractInvoiceTaxMny; // 合同收票金额
    @TableField(value="contract_invoice_mny")
    private BigDecimal contractInvoiceMny; // 合同收票金额(不含税)
    @TableField(value="contract_pay_mny")
    private BigDecimal contractPayMny; // 合同已付金额
    @TableField(value="current_settlement_tax_mny")
    private BigDecimal currentSettlementTaxMny; // 含本期结算金额
    @TableField(value="current_settlement_mny")
    private BigDecimal currentSettlementMny; // 含本期结算金额（无税）
    @TableField(value="contract_payment_ratio")
    private BigDecimal contractPaymentRatio; // 合同支付比例
    @TableField(value="sup_operator_user_code")
    private String supOperatorUserCode; //
    @TableField(value="sup_operator_phone")
    private String supOperatorPhone; //
    @TableField(value="sup_operator_name")
    private String supOperatorName; //
    @TableField(value="sup_operate_time")
    private Date supOperateTime; //
    @TableField(value="bill_push_flag")
    private String billPushFlag; // 单据推送标识：unSucPush-未成功推送供方，sucPushed-已成功推送供方
    @TableField(value="day_total_mny")
    private BigDecimal dayTotalMny; // 日租赁金额(无税)
    @TableField(value="day_total_tax_mny")
    private BigDecimal dayTotalTaxMny; // 日租赁金额
    @TableField(value="day_total_tax")
    private BigDecimal dayTotalTax; // 日租赁税额
    @TableField(value="month_total_mny")
    private BigDecimal monthTotalMny; // 月租赁金额(无税)
    @TableField(value="month_total_tax_mny")
    private BigDecimal monthTotalTaxMny; // 月租赁金额
    @TableField(value="month_total_tax")
    private BigDecimal monthTotalTax; // 月租赁税额
    @TableField(value="quantities_total_mny")
    private BigDecimal quantitiesTotalMny; // 工程量租赁金额(无税)
    @TableField(value="quantities_total_tax_mny")
    private BigDecimal quantitiesTotalTaxMny; // 工程量租赁金额
    @TableField(value="quantities_total_tax")
    private BigDecimal quantitiesTotalTax; // 工程量租赁税额
    @TableField(value="rental_total_mny")
    private BigDecimal rentalTotalMny; // 租金额(无税)
    @TableField(value="rental_total_tax_mny")
    private BigDecimal rentalTotalTaxMny; // 租金金额
    @TableField(value="rental_total_tax")
    private BigDecimal rentalTotalTax; // 租金税额
    @TableField(value="relation_flag")
    private String relationFlag; // 关联状态(1:是，0：否)
    @TableField(value="proportion_flag")
    private String proportionFlag; // 分摊状态(1:是，0：否)
    @TableField(value = "settlement_num")
    private Integer settlementNum;//生效结算次数
    /**
     * 供方经办人签字文件id
     */
    @TableField(exist = false)
    private Long supOperateFileId;
    /**
     * 来源业务系统id
     */
    @TableField(exist = false)
    private String systemId;
    @TableField(value="org_code")
    private String orgCode; // 组织编码
    @TableField(value="parent_org_code")
    private String parentOrgCode; // 项目部上级组织编码
    @TableField(value="rent_type")
    private String rentType; // 租赁方式租赁方式(0-外租，1-内租)
    @TableField(value="financial_org_id")
    private Long financialOrgId; //财务组织
    @TableField(value="financial_org_name")
    private String financialOrgName; //财务组织名称
    @TableField(value="financial_org_code")
    private String financialOrgCode; //财务组织编码
    @TableField(value="levy_flag")
    private String levyFlag; //是否简易征收项目：(0：否，1:是)
    @TableField(value="category_type_id")
    private Long categoryTypeId; //合同类型
    @TableField(value="category_type_name")
    private String categoryTypeName; //合同类型名称
    @TableField(value="financial_number")
    private String financialNumber; //凭证号
    @TableField(value="financial_cross_flag")
    private String financialCrossFlag; //是否传会计平台：(0：否，1:是)
    @TableField(value="singlenes_bill_flag")
    private String singlenesBillFlag; //是否专票：(0：否，1:是)
    @TableField(exist=false)
    @SubEntity(serviceName="rentSettlementDayService",pidName = "settlementId")//此处有pid="xxx"，默认值pid="pid"
    private List<RentSettlementDayEntity> rentSettlementDayList = new ArrayList<>(); // 设备租赁结算日租明细
    @TableField(exist=false)
    @SubEntity(serviceName="rentSettlementMonthService",pidName = "settlementId")//此处有pid="xxx"，默认值pid="pid"
    private List<RentSettlementMonthEntity> rentSettlementMonthList = new ArrayList<>(); // 设备租赁结算月租明细
    @TableField(exist=false)
    @SubEntity(serviceName="rentSettlementQuantitiesService",pidName = "settlementId")//此处有pid="xxx"，默认值pid="pid"
    private List<RentSettlementQuantitiesEntity> rentSettlementQuantitiesList = new ArrayList<>(); // 设备租赁结算工程量明细
    @TableField(exist=false)
    @SubEntity(serviceName="rentSettlementRentalService",pidName = "settlementId")//此处有pid="xxx"，默认值pid="pid"
    private List<RentSettlementRentalEntity> rentSettlementRentalList = new ArrayList<>(); // 设备租赁结算租金明细
    @TableField(exist=false)
    @SubEntity(serviceName="rentSettlementFeeService",pidName = "settlementId")//此处有pid="xxx"，默认值pid="pid"
    private List<RentSettlementFeeEntity> rentSettlementFeeList = new ArrayList<>(); // 设备租赁结算费用明细
    @TableField(exist=false)
    @SubEntity(serviceName="rentSettlementFragmentaryService",pidName = "settlementId")//此处有pid="xxx"，默认值pid="pid"
    private List<RentSettlementFragmentaryEntity> rentSettlementFragmentaryList = new ArrayList<>(); // 设备租赁结算零星机械费用明细

    public List<RentSettlementFragmentaryEntity> getRentSettlementFragmentaryList() {
        return rentSettlementFragmentaryList;
    }

    public void setRentSettlementFragmentaryList(List<RentSettlementFragmentaryEntity> rentSettlementFragmentaryList) {
        this.rentSettlementFragmentaryList = rentSettlementFragmentaryList;
    }

    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }

    public String getParentOrgCode() {
        return parentOrgCode;
    }

    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }

    public Integer getSettlementNum() {
        return settlementNum;
    }

    public void setSettlementNum(Integer settlementNum) {
        this.settlementNum = settlementNum;
    }

    public String getRelationFlag() {
        return relationFlag;
    }

    public void setRelationFlag(String relationFlag) {
        this.relationFlag = relationFlag;
    }

    public String getProportionFlag() {
        return proportionFlag;
    }

    public void setProportionFlag(String proportionFlag) {
        this.proportionFlag = proportionFlag;
    }

    public Long getSupOperateFileId() {
        return supOperateFileId;
    }

    public void setSupOperateFileId(Long supOperateFileId) {
        this.supOperateFileId = supOperateFileId;
    }

    public String getSystemId() {
        return systemId;
    }

    public void setSystemId(String systemId) {
        this.systemId = systemId;
    }

    public BigDecimal getDayTotalMny() {
        return dayTotalMny;
    }

    public void setDayTotalMny(BigDecimal dayTotalMny) {
        this.dayTotalMny = dayTotalMny;
    }

    public BigDecimal getDayTotalTaxMny() {
        return dayTotalTaxMny;
    }

    public void setDayTotalTaxMny(BigDecimal dayTotalTaxMny) {
        this.dayTotalTaxMny = dayTotalTaxMny;
    }

    public BigDecimal getDayTotalTax() {
        return dayTotalTax;
    }

    public void setDayTotalTax(BigDecimal dayTotalTax) {
        this.dayTotalTax = dayTotalTax;
    }

    public BigDecimal getMonthTotalMny() {
        return monthTotalMny;
    }

    public void setMonthTotalMny(BigDecimal monthTotalMny) {
        this.monthTotalMny = monthTotalMny;
    }

    public BigDecimal getMonthTotalTaxMny() {
        return monthTotalTaxMny;
    }

    public void setMonthTotalTaxMny(BigDecimal monthTotalTaxMny) {
        this.monthTotalTaxMny = monthTotalTaxMny;
    }

    public BigDecimal getMonthTotalTax() {
        return monthTotalTax;
    }

    public void setMonthTotalTax(BigDecimal monthTotalTax) {
        this.monthTotalTax = monthTotalTax;
    }

    public BigDecimal getQuantitiesTotalMny() {
        return quantitiesTotalMny;
    }

    public void setQuantitiesTotalMny(BigDecimal quantitiesTotalMny) {
        this.quantitiesTotalMny = quantitiesTotalMny;
    }

    public BigDecimal getQuantitiesTotalTaxMny() {
        return quantitiesTotalTaxMny;
    }

    public void setQuantitiesTotalTaxMny(BigDecimal quantitiesTotalTaxMny) {
        this.quantitiesTotalTaxMny = quantitiesTotalTaxMny;
    }

    public BigDecimal getQuantitiesTotalTax() {
        return quantitiesTotalTax;
    }

    public void setQuantitiesTotalTax(BigDecimal quantitiesTotalTax) {
        this.quantitiesTotalTax = quantitiesTotalTax;
    }

    public BigDecimal getRentalTotalMny() {
        return rentalTotalMny;
    }

    public void setRentalTotalMny(BigDecimal rentalTotalMny) {
        this.rentalTotalMny = rentalTotalMny;
    }

    public BigDecimal getRentalTotalTaxMny() {
        return rentalTotalTaxMny;
    }

    public void setRentalTotalTaxMny(BigDecimal rentalTotalTaxMny) {
        this.rentalTotalTaxMny = rentalTotalTaxMny;
    }

    public BigDecimal getRentalTotalTax() {
        return rentalTotalTax;
    }

    public void setRentalTotalTax(BigDecimal rentalTotalTax) {
        this.rentalTotalTax = rentalTotalTax;
    }

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectCode() {
        return projectCode;
    }

    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public Long getParentOrgId() {
        return parentOrgId;
    }

    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }
    public String getParentOrgName() {
        return parentOrgName;
    }

    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }
    public Long getContractId() {
        return contractId;
    }

    public void setContractId(Long contractId) {
        this.contractId = contractId;
    }
    public String getContractName() {
        return contractName;
    }

    public void setContractName(String contractName) {
        this.contractName = contractName;
    }
    public String getContractCode() {
        return contractCode;
    }

    public void setContractCode(String contractCode) {
        this.contractCode = contractCode;
    }
    public Long getSupplierId() {
        return supplierId;
    }

    public void setSupplierId(Long supplierId) {
        this.supplierId = supplierId;
    }
    public String getSupplierName() {
        return supplierName;
    }

    public void setSupplierName(String supplierName) {
        this.supplierName = supplierName;
    }
    public Long getEmployeeId() {
        return employeeId;
    }

    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    public Date getSettlementDate() {
        return settlementDate;
    }

    public void setSettlementDate(Date settlementDate) {
        this.settlementDate = settlementDate;
    }
    public Long getDepartmentId() {
        return departmentId;
    }

    public void setDepartmentId(Long departmentId) {
        this.departmentId = departmentId;
    }
    public String getDepartmentName() {
        return departmentName;
    }

    public void setDepartmentName(String departmentName) {
        this.departmentName = departmentName;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    public Integer getSignatureStatus() {
        return signatureStatus;
    }

    public void setSignatureStatus(Integer signatureStatus) {
        this.signatureStatus = signatureStatus;
    }
    public Integer getSignStatus() {
        return signStatus;
    }

    public void setSignStatus(Integer signStatus) {
        this.signStatus = signStatus;
    }
    public Integer getSettlementType() {
        return settlementType;
    }

    public void setSettlementType(Integer settlementType) {
        this.settlementType = settlementType;
    }
    public String getMeterRentType() {
        return meterRentType;
    }

    public void setMeterRentType(String meterRentType) {
        this.meterRentType = meterRentType;
    }
    public String getMeterRentTypeName() {
        return meterRentTypeName;
    }

    public void setMeterRentTypeName(String meterRentTypeName) {
        this.meterRentTypeName = meterRentTypeName;
    }
    public BigDecimal getSettlementMny() {
        return settlementMny;
    }

    public void setSettlementMny(BigDecimal settlementMny) {
        this.settlementMny = settlementMny;
    }
    public BigDecimal getSettlementTaxMny() {
        return settlementTaxMny;
    }

    public void setSettlementTaxMny(BigDecimal settlementTaxMny) {
        this.settlementTaxMny = settlementTaxMny;
    }
    public BigDecimal getSettlementTax() {
        return settlementTax;
    }

    public void setSettlementTax(BigDecimal settlementTax) {
        this.settlementTax = settlementTax;
    }
    public BigDecimal getRentTotalMny() {
        return rentTotalMny;
    }

    public void setRentTotalMny(BigDecimal rentTotalMny) {
        this.rentTotalMny = rentTotalMny;
    }
    public BigDecimal getRentTotalTaxMny() {
        return rentTotalTaxMny;
    }

    public void setRentTotalTaxMny(BigDecimal rentTotalTaxMny) {
        this.rentTotalTaxMny = rentTotalTaxMny;
    }
    public BigDecimal getRentTotalTax() {
        return rentTotalTax;
    }

    public void setRentTotalTax(BigDecimal rentTotalTax) {
        this.rentTotalTax = rentTotalTax;
    }
    public BigDecimal getOtherMny() {
        return otherMny;
    }

    public void setOtherMny(BigDecimal otherMny) {
        this.otherMny = otherMny;
    }
    public BigDecimal getOtherTaxMny() {
        return otherTaxMny;
    }

    public void setOtherTaxMny(BigDecimal otherTaxMny) {
        this.otherTaxMny = otherTaxMny;
    }
    public BigDecimal getOtherTax() {
        return otherTax;
    }

    public void setOtherTax(BigDecimal otherTax) {
        this.otherTax = otherTax;
    }
    public BigDecimal getContractTaxMny() {
        return contractTaxMny;
    }

    public void setContractTaxMny(BigDecimal contractTaxMny) {
        this.contractTaxMny = contractTaxMny;
    }
    public BigDecimal getContractMny() {
        return contractMny;
    }

    public void setContractMny(BigDecimal contractMny) {
        this.contractMny = contractMny;
    }
    public BigDecimal getContractTax() {
        return contractTax;
    }

    public void setContractTax(BigDecimal contractTax) {
        this.contractTax = contractTax;
    }
    public BigDecimal getContractInvoiceTaxMny() {
        return contractInvoiceTaxMny;
    }

    public void setContractInvoiceTaxMny(BigDecimal contractInvoiceTaxMny) {
        this.contractInvoiceTaxMny = contractInvoiceTaxMny;
    }
    public BigDecimal getContractInvoiceMny() {
        return contractInvoiceMny;
    }

    public void setContractInvoiceMny(BigDecimal contractInvoiceMny) {
        this.contractInvoiceMny = contractInvoiceMny;
    }
    public BigDecimal getContractPayMny() {
        return contractPayMny;
    }

    public void setContractPayMny(BigDecimal contractPayMny) {
        this.contractPayMny = contractPayMny;
    }
    public BigDecimal getCurrentSettlementTaxMny() {
        return currentSettlementTaxMny;
    }

    public void setCurrentSettlementTaxMny(BigDecimal currentSettlementTaxMny) {
        this.currentSettlementTaxMny = currentSettlementTaxMny;
    }
    public BigDecimal getCurrentSettlementMny() {
        return currentSettlementMny;
    }

    public void setCurrentSettlementMny(BigDecimal currentSettlementMny) {
        this.currentSettlementMny = currentSettlementMny;
    }
    public BigDecimal getContractPaymentRatio() {
        return contractPaymentRatio;
    }

    public void setContractPaymentRatio(BigDecimal contractPaymentRatio) {
        this.contractPaymentRatio = contractPaymentRatio;
    }
    public String getSupOperatorUserCode() {
        return supOperatorUserCode;
    }

    public void setSupOperatorUserCode(String supOperatorUserCode) {
        this.supOperatorUserCode = supOperatorUserCode;
    }
    public String getSupOperatorPhone() {
        return supOperatorPhone;
    }

    public void setSupOperatorPhone(String supOperatorPhone) {
        this.supOperatorPhone = supOperatorPhone;
    }
    public String getSupOperatorName() {
        return supOperatorName;
    }

    public void setSupOperatorName(String supOperatorName) {
        this.supOperatorName = supOperatorName;
    }
    public Date getSupOperateTime() {
        return supOperateTime;
    }

    public void setSupOperateTime(Date supOperateTime) {
        this.supOperateTime = supOperateTime;
    }
    public String getBillPushFlag() {
        return billPushFlag;
    }

    public void setBillPushFlag(String billPushFlag) {
        this.billPushFlag = billPushFlag;
    }

    public List<RentSettlementDayEntity> getRentSettlementDayList() {
        return rentSettlementDayList;
    }

    public void setRentSettlementDayList(List<RentSettlementDayEntity> rentSettlementDayList) {
        this.rentSettlementDayList = rentSettlementDayList;
    }
    public List<RentSettlementMonthEntity> getRentSettlementMonthList() {
        return rentSettlementMonthList;
    }

    public void setRentSettlementMonthList(List<RentSettlementMonthEntity> rentSettlementMonthList) {
        this.rentSettlementMonthList = rentSettlementMonthList;
    }
    public List<RentSettlementQuantitiesEntity> getRentSettlementQuantitiesList() {
        return rentSettlementQuantitiesList;
    }

    public void setRentSettlementQuantitiesList(List<RentSettlementQuantitiesEntity> rentSettlementQuantitiesList) {
        this.rentSettlementQuantitiesList = rentSettlementQuantitiesList;
    }
    public List<RentSettlementRentalEntity> getRentSettlementRentalList() {
        return rentSettlementRentalList;
    }

    public void setRentSettlementRentalList(List<RentSettlementRentalEntity> rentSettlementRentalList) {
        this.rentSettlementRentalList = rentSettlementRentalList;
    }
    public List<RentSettlementFeeEntity> getRentSettlementFeeList() {
        return rentSettlementFeeList;
    }

    public void setRentSettlementFeeList(List<RentSettlementFeeEntity> rentSettlementFeeList) {
        this.rentSettlementFeeList = rentSettlementFeeList;
    }

    public String getRentType() {
        return rentType;
    }

    public void setRentType(String rentType) {
        this.rentType = rentType;
    }

    public Long getFinancialOrgId() {
        return financialOrgId;
    }

    public void setFinancialOrgId(Long financialOrgId) {
        this.financialOrgId = financialOrgId;
    }

    public String getFinancialOrgName() {
        return financialOrgName;
    }

    public void setFinancialOrgName(String financialOrgName) {
        this.financialOrgName = financialOrgName;
    }

    public String getFinancialOrgCode() {
        return financialOrgCode;
    }

    public void setFinancialOrgCode(String financialOrgCode) {
        this.financialOrgCode = financialOrgCode;
    }

    public String getLevyFlag() {
        return levyFlag;
    }

    public void setLevyFlag(String levyFlag) {
        this.levyFlag = levyFlag;
    }

    public Long getCategoryTypeId() {
        return categoryTypeId;
    }

    public void setCategoryTypeId(Long categoryTypeId) {
        this.categoryTypeId = categoryTypeId;
    }

    public String getCategoryTypeName() {
        return categoryTypeName;
    }

    public void setCategoryTypeName(String categoryTypeName) {
        this.categoryTypeName = categoryTypeName;
    }

    public String getFinancialNumber() {
        return financialNumber;
    }

    public void setFinancialNumber(String financialNumber) {
        this.financialNumber = financialNumber;
    }

    public String getFinancialCrossFlag() {
        return financialCrossFlag;
    }

    public void setFinancialCrossFlag(String financialCrossFlag) {
        this.financialCrossFlag = financialCrossFlag;
    }

    public String getSinglenesBillFlag() {
        return singlenesBillFlag;
    }

    public void setSinglenesBillFlag(String singlenesBillFlag) {
        this.singlenesBillFlag = singlenesBillFlag;
    }
}
