/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.userecord.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.ac.enums.BillPushStatusEnum;
import com.ejianc.business.userecord.bean.UseRecordEntity;
import com.ejianc.business.userecord.service.impl.UseRecordServiceImpl;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="useRecord")
public class UseRecordBpmServiceImpl
implements ICommonBusinessService {
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private UseRecordServiceImpl service;
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        UseRecordEntity e = (UseRecordEntity)((Object)this.service.selectById(billId));
        UserContext userContext = this.sessionManager.getUserContext();
        e.setCommitDate(new Date());
        e.setCommitUserCode(userContext.getUserCode());
        e.setCommitUserName(userContext.getUserName());
        this.service.saveOrUpdate((Object)e, false);
        return CommonResponse.success((String)"\u4f7f\u7528\u8bb0\u5f55\u5ba1\u6279\u56de\u8c03\u5904\u7406\u6210\u529f\uff01");
    }

    public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        UseRecordEntity entity = (UseRecordEntity)((Object)this.service.selectById(billId));
        UserContext userContext = this.sessionManager.getUserContext();
        if (state.equals(BillStateEnum.COMMITED_STATE.getBillStateCode())) {
            entity.setCommitDate(new Date());
            entity.setCommitUserCode(userContext.getUserCode());
            entity.setCommitUserName(userContext.getUserName());
        }
        boolean pushFlag = this.service.pushBillToSupCenter(entity, billTypeCode);
        this.logger.info("\u83b7\u53d6\u63a8\u9001\u4f9b\u65b9\u7ed3\u679c--" + pushFlag);
        if (!pushFlag) {
            entity.setBillPushFlag(BillPushStatusEnum.\u672a\u6210\u529f\u63a8\u9001.getStatus());
        } else {
            entity.setBillPushFlag(BillPushStatusEnum.\u63a8\u9001\u6210\u529f.getStatus());
        }
        this.service.saveOrUpdate((Object)entity, false);
        return CommonResponse.success((String)"\u4f7f\u7528\u8bb0\u5f55\u5ba1\u6279\u56de\u8c03\u5904\u7406\u6210\u529f\uff01");
    }

    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        UseRecordEntity entity = (UseRecordEntity)((Object)this.service.selectById(billId));
        if (entity.getNotSignature().booleanValue()) {
            throw new BusinessException("\u5df2\u7b7e\u5b57\u4e0d\u80fd\u64a4\u56de\uff01");
        }
        return CommonResponse.success();
    }

    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        UseRecordEntity entity = (UseRecordEntity)((Object)this.service.selectById(billId));
        if (BillPushStatusEnum.\u63a8\u9001\u6210\u529f.getStatus().equals(entity.getBillPushFlag())) {
            CommonResponse<String> commonResponse = this.service.updatePushBill(entity, billTypeCode);
            this.logger.info("\u4f9b\u65b9\u7ed3\u679c" + JSONObject.toJSONString(commonResponse));
            if (!commonResponse.isSuccess()) {
                throw new BusinessException(commonResponse.getMsg());
            }
        }
        entity.setBillPushFlag(BillPushStatusEnum.\u672a\u6210\u529f\u63a8\u9001.getStatus());
        this.service.saveOrUpdate((Object)entity, false);
        return CommonResponse.success();
    }
}

