package com.ejianc.business.proequipmentcorppur.purchase.controller.api;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.pricelib.vo.PriceContractVO;
import com.ejianc.business.proequipmentcorppur.purchase.service.IPurchaseContractService;
import com.ejianc.business.tender.common.vo.SignContractVo;
import com.ejianc.framework.core.response.CommonResponse;
import io.swagger.annotations.ApiOperation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;

@RestController
@RequestMapping("/api/purchase/")
public class ContractApi {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IPurchaseContractService service;

    /**
     * 根据定标参照id查询对应的合同
     *
     * @param targetResultIdList 定标结果参照id
     * @return 修改结果
     */
    @ApiOperation("根据定标参照id查询对应的合同")
    @RequestMapping(value = "/queryContractByTargetResultId", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<List<SignContractVo>> queryContractByTargetResultId(@RequestParam("targetResultIdList") List<String> targetResultIdList) {
        logger.info("根据定标结果id查询合同，查询参数：{}", JSONObject.toJSONString(targetResultIdList));
        List<SignContractVo> list = service.queryContractByTargetResultId(targetResultIdList);
        logger.info("根据定标结果id查询合同，查询结果：{}", JSONObject.toJSONString(list));
        return CommonResponse.success("查询成功", list);
    }



    /**
     * 查询设备购置价格库所需-设备公司-购置合同-数据
     * @param initFlag
     * @return
     */
    @GetMapping(value = "/getPriceContractDataByCorpPurchase")
    CommonResponse<List<PriceContractVO>> getPriceContractDataByCorpPurchase(@RequestParam(value = "initFlag") String initFlag){
        List<PriceContractVO> rentPriceContractVOList = service.queryPriceContractDataByCorpPurchase(initFlag);
        return CommonResponse.success("查询设备购置价格库所需-设备公司-租出合同-数据结束！", rentPriceContractVOList);
    }
}
