package com.ejianc.business.proequipmentcorppur.purchaseApply.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.ejianc.business.proequipmentcorppur.purchaseApply.bean.PurchaseApplyDetailedEntity;
import com.ejianc.business.proequipmentcorppur.purchaseApply.bean.PurchaseApplyEntity;
import com.ejianc.business.proequipmentcorppur.purchaseApply.mapper.PurchaseApplyMapper;
import com.ejianc.business.proequipmentcorppur.purchaseApply.service.IPurchaseApplyDetailedService;
import com.ejianc.business.proequipmentcorppur.purchaseApply.service.IPurchaseApplyService;
import com.ejianc.business.proequipmentcorppur.purchaseApply.vo.PurchaseApplyDetailedVO;
import com.ejianc.business.proequipmentcorppur.purchaseApply.vo.PurchaseApplyVO;
import com.ejianc.business.proequipmentcorppur.purchaseplan.bean.PurchasePlanDetailedEntity;
import com.ejianc.business.proequipmentcorppur.purchaseplan.service.IPurchasePlanDetailedService;
import com.ejianc.business.proequipmentcorppur.purchaseplan.vo.PurchasePlanEnum;
import com.ejianc.business.promaterial.plan.vo.BatPlanEnum;
import com.ejianc.business.targetcost.vo.ParamsCheckDsVO;
import com.ejianc.business.targetcost.vo.ParamsCheckVO;
import com.ejianc.foundation.share.api.IPriceDepotParamSetApi;
import com.ejianc.foundation.share.consts.PrinceDepotEnum;
import com.ejianc.foundation.share.vo.dto.PriceDepotParamSetDTO;
import com.ejianc.foundation.support.api.IParamConfigApi;
import com.ejianc.foundation.support.vo.BillParamVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.CollectionUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 设备采购-采购申请
 *
 * @author generator
 */
@Service("purchaseApplyService")
public class PurchaseApplyServiceImpl extends BaseServiceImpl<PurchaseApplyMapper, PurchaseApplyEntity> implements IPurchaseApplyService {
    @Autowired
    private PurchaseApplyMapper mapper;

    @Autowired
    private IPurchasePlanDetailedService purchasePlanDetailedService;

    @Autowired
    private IPurchaseApplyDetailedService purchaseApplyDetailedService;

    private Logger logger = LoggerFactory.getLogger(this.getClass());
    //【设备采购历史最高价】控【机械设备采购申请】
    private final String HISTORY_MAX_PRICE_CTRL_PURCHASE_PLAN_PRICE = "P-j9W94S0287";
    //【设备采购历史最低价】控【机械设备采购申请】
    private final String HISTORY_MIN_PRICE_CTRL_PURCHASE_PLAN_PRICE = "P-98J8xN0289";
    @Autowired
    private IPriceDepotParamSetApi priceDepotParamSetApi;
    @Autowired
    private IParamConfigApi paramConfigApi;

    @Override
    public void saveOrUpdates(PurchaseApplyEntity entity) {
        List<PurchaseApplyDetailedEntity> listbs = entity.getDetailList();

        if(CollectionUtil.isNotEmpty(listbs)){
            List<Long> planSubIds = new ArrayList<>();
            StringBuilder equipmentTypes = new StringBuilder();
            Map<Long, Long> idMap = new HashMap<>();
            for (PurchaseApplyDetailedEntity cdEntity : listbs) {
                planSubIds.add(cdEntity.getSourceId());
                if(!"del".equals(cdEntity.getRowState())) {
                    equipmentTypes.append(cdEntity.getEquipmentName()).append(",");
                }
                if (null == cdEntity.getParentId()) {
                    idMap.put(cdEntity.getDocCategoryId(), cdEntity.getId());
                }
            }

            //查询出对应的计划子项
            PurchasePlanDetailedEntity tmp = null;
            QueryWrapper<PurchasePlanDetailedEntity> planSubQuery = new QueryWrapper<>();
            planSubQuery.in("id", planSubIds);
            List<PurchasePlanDetailedEntity> planSubList = purchasePlanDetailedService.list(planSubQuery);
            Map<Long, PurchasePlanDetailedEntity> planSubMap = planSubList.stream().collect(Collectors.toMap(PurchasePlanDetailedEntity::getId, item -> item));

            if(null != entity.getId()) {
                //单据更新
                PurchaseApplyEntity dbEntity = super.selectById(entity.getId());
                for(PurchaseApplyDetailedEntity cdEntity : dbEntity.getDetailList()) {
                    tmp =planSubMap.get(cdEntity.getSourceId());
                    tmp.setAppliedNum(tmp.getAppliedNum() - cdEntity.getPlanNum());
                    tmp.setRemainingNum(tmp.getPlanNum() - tmp.getAppliedNum());
                }
            }

            for (PurchaseApplyDetailedEntity cdEntity : listbs) {
                if (null != cdEntity.getParentId()) {
                    cdEntity.setParentId(idMap.get(cdEntity.getDocCategoryId()));
                    cdEntity.setTid(cdEntity.getId());
                } else {
                    cdEntity.setTid(cdEntity.getId());
                }
                if(!"del".equals(cdEntity.getRowState())) {
                    tmp =planSubMap.get(cdEntity.getSourceId());
                    tmp.setAppliedNum(tmp.getAppliedNum() + cdEntity.getPlanNum());
                    tmp.setRemainingNum(tmp.getPlanNum() - tmp.getAppliedNum());
                }
            }

            //更新计划子表
            boolean updateResult = purchasePlanDetailedService.saveOrUpdateBatch(planSubList);
            if(!updateResult) {
                throw new BusinessException("保存失败，更新计划已申请数量失败！");
            }
            entity.setEquipmentTypes(equipmentTypes.substring(0, equipmentTypes.length()-1));
        }

        super.saveOrUpdate(entity, false);
    }

    @Override
    public List<PurchaseApplyVO> queryApplyListByOrgId(Long orgId) {
        QueryWrapper<PurchaseApplyEntity> query = new QueryWrapper<>();
        query.eq("org_id", orgId);
        List<PurchaseApplyEntity> entities = super.list(query);
        return BeanMapper.mapList(entities, PurchaseApplyVO.class);
    }

    /**
     * 检查单据是否存在相同编码
     * @param contractVO
     * @return
     */
    @Override
    public Boolean checkSameBillCode(PurchaseApplyVO contractVO) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        LambdaQueryWrapper<PurchaseApplyEntity> lambda = new LambdaQueryWrapper<>();
        lambda.eq(PurchaseApplyEntity::getBillCode, contractVO.getBillCode());
        lambda.eq(PurchaseApplyEntity::getTenantId, tenantId);
        if (null != contractVO.getId() && contractVO.getId() > 0) {
            lambda.ne(PurchaseApplyEntity::getId, contractVO.getId());
        }
        return super.list(lambda).size() > 0;
    }

    @Override
    public void updateBatApplyByQuoteType(List<String> idList, Integer planState) {
        if (StringUtils.isEmpty(PurchasePlanEnum.getDescriptionByStateCode(planState))) {
            throw new BusinessException("计划状态错误");
        }
        // 批量更改
        if (CollectionUtils.isNotEmpty(idList)) {
            List<PurchaseApplyEntity> entityList = (List<PurchaseApplyEntity>) super.listByIds(idList);
            if (CollectionUtils.isNotEmpty(entityList)) {
                for (PurchaseApplyEntity entity : entityList) {
                    // 采购完成不允许做其他操作
                    if (BatPlanEnum.PLAN_STATE_OVER.getPlanState().equals(entity.getPlanState())) {
                        throw new BusinessException("采购计划编码【" + entity.getBillCode() + "】已采购完成！");
                    }
                    entity.setPlanState(planState);
                }
                super.saveOrUpdateBatch(entityList);
            }
        }
    }

    @Override
    public void removeBatch(List<Long> applyIds) {
        QueryWrapper<PurchaseApplyDetailedEntity> detailQuery = new QueryWrapper<>();
        detailQuery.in("apply_id", applyIds);
        detailQuery.eq("dr", 0);
        List<PurchaseApplyDetailedEntity> detailList = purchaseApplyDetailedService.list(detailQuery);


        PurchasePlanDetailedEntity tmp = null;
        QueryWrapper<PurchasePlanDetailedEntity> planSubQuery = new QueryWrapper<>();
        planSubQuery.in("id", detailList.stream().map(PurchaseApplyDetailedEntity::getSourceId).collect(Collectors.toList()));
        List<PurchasePlanDetailedEntity> planSubList = purchasePlanDetailedService.list(planSubQuery);
        Map<Long, PurchasePlanDetailedEntity> planSubMap = planSubList.stream().collect(Collectors.toMap(PurchasePlanDetailedEntity::getId, item -> item));

        for(PurchaseApplyDetailedEntity detail : detailList) {
            tmp = planSubMap.get(detail.getSourceId());
            tmp.setAppliedNum(tmp.getAppliedNum() - detail.getPlanNum());
            tmp.setRemainingNum(tmp.getPlanNum() - tmp.getAppliedNum());
        }

        //更新计划子表
        boolean updateResult = purchasePlanDetailedService.saveOrUpdateBatch(planSubList);
        if(!updateResult) {
            throw new BusinessException("更新计划已申请数量失败！");
        }
        super.removeByIds(applyIds, false);
    }

    @Override
    public ParamsCheckVO checkParams(PurchaseApplyVO vo) {
        List<ParamsCheckVO> paramsCheckVOS = new ArrayList<>();
        ParamsCheckVO paramsCheckVO = new ParamsCheckVO();
        paramsCheckVO.setWarnType("none");

        // 历史价控 总计划价
        paramsCheckVOS.addAll(this.historyPriceCtrlPlanPrice(vo));

        /*添加参数控制区域---*/
        Map<String, List<ParamsCheckDsVO>> map = new HashMap<>();
        String[] paramsArray = {"alert", "warn", "none"};
        if(CollectionUtils.isNotEmpty(paramsCheckVOS)){
            for (ParamsCheckVO checkVO : paramsCheckVOS) {
                String warnType = checkVO.getWarnType();
                if(map.containsKey(warnType)){
                    List<ParamsCheckDsVO> checkDsVOS = map.get(warnType);
                    checkDsVOS.addAll(checkVO.getDataSource());
                    map.put(warnType,checkDsVOS);
                }else {
                    map.put(warnType,checkVO.getDataSource());
                }
            }
        }
        for (String s : paramsArray) {
            if(map.containsKey(s)){
                paramsCheckVO.setWarnType(s);
                paramsCheckVO.setDataSource(map.get(s));
                if(CollectionUtils.isEmpty(paramsCheckVO.getDataSource())){
                    paramsCheckVO.setWarnType("none");
                }else {
                    return paramsCheckVO;
                }
            }
        }
        return paramsCheckVO;
    }

    private List<ParamsCheckVO> historyPriceCtrlPlanPrice(PurchaseApplyVO batchPlanVO) {
        logger.info("proequipmentcorp---PurchasePlanServiceImpl---historyPriceCtrlPlanPrice()--- 历史价控购置申请单价入参：{}", JSONObject.toJSONString(batchPlanVO));
        // 三种控制方式：不控制，提醒，无法保存 (默认为提醒)
        String[] paramsArray = {"none", "warn", "alert"};
        List<ParamsCheckVO> paramsCheckVOList = new ArrayList<>();

        CommonResponse<List<BillParamVO>> maxParamByCode = new CommonResponse<>();
        CommonResponse<List<BillParamVO>> minParamByCode = new CommonResponse<>();
        List<PurchaseApplyDetailedVO> detailList = batchPlanVO.getDetailList();

        maxParamByCode = paramConfigApi.getBillParamByCodeAndOrgId(HISTORY_MAX_PRICE_CTRL_PURCHASE_PLAN_PRICE, batchPlanVO.getOrgId());
        minParamByCode = paramConfigApi.getBillParamByCodeAndOrgId(HISTORY_MIN_PRICE_CTRL_PURCHASE_PLAN_PRICE, batchPlanVO.getOrgId());

        if (!maxParamByCode.isSuccess() || null == maxParamByCode.getData()) {
            logger.info("查询价格库历史单价参数查询失败：{}", maxParamByCode.getMsg());
            return paramsCheckVOList;
        }
        if (!minParamByCode.isSuccess() || null == minParamByCode.getData()) {
            logger.info("查询价格库历史单价参数查询失败：{}", minParamByCode.getMsg());
            return paramsCheckVOList;
        }
        logger.info("单据控制参数查询结果：{}", JSONObject.toJSONString(maxParamByCode));


        List<BillParamVO> maxParamVOS = maxParamByCode.getData();//校验结果
        List<BillParamVO> minParamVOS = minParamByCode.getData();
        logger.info("设备租赁合同历史高价控制信息返回："+JSONObject.toJSONString(maxParamVOS));
        logger.info("设备租赁合同历史低价控制信息返回："+JSONObject.toJSONString(minParamVOS));
        //todo 取优先级
        boolean flag = true;
        logger.info("传入参数--{}",JSONObject.toJSONString(PrinceDepotEnum.设备采购价格库.getCode()));
        CommonResponse<List<PriceDepotParamSetDTO>> commonResponse = priceDepotParamSetApi.queryPriceDepotParamSetList(PrinceDepotEnum.设备采购价格库.getCode());
        if(!commonResponse.isSuccess()){
            throw new BusinessException(commonResponse.getMsg());
        }
        List<PriceDepotParamSetDTO> data = commonResponse.getData();
        Integer priorityFlag = data.get(0).getPriorityFlag();
        if(null!=priorityFlag&&2==priorityFlag){
            //指导价优先
            flag = false;
        }
        if(CollectionUtils.isNotEmpty(maxParamVOS)){//遍历高价
            for (BillParamVO maxParamVO : maxParamVOS) {
                ParamsCheckVO paramsCheckVOMax = new ParamsCheckVO();//高价
                List<ParamsCheckDsVO> checkDsVOSMax = new ArrayList<>();
                BigDecimal roleValueMax = maxParamVO.getRoleValue();//高价校验比例
                paramsCheckVOMax.setWarnType(paramsArray[maxParamVO.getControlType()]);//高价赋值控制类型
                //控制方式为none时不需要控制
                if ("none".equals(paramsArray[maxParamVO.getControlType()])) {
                    continue;
                }
                for (PurchaseApplyDetailedVO  detailVO: detailList) {//遍历明细
                    //根据优先级取价格
                    String getHistoryPriceArea = "";
                    if(flag){
                        //历史价格优先   先去历史价  为空再取  指导价
                        getHistoryPriceArea = detailVO.getHistoryPriceArea();
                        if(com.baomidou.mybatisplus.core.toolkit.StringUtils.isEmpty(getHistoryPriceArea)){
                            getHistoryPriceArea = detailVO.getGuidePriceArea();
                        }
                    }else{
                        //指导价优先   先去指导价  为空再取  历史价
                        getHistoryPriceArea = detailVO.getGuidePriceArea();
                        if(com.baomidou.mybatisplus.core.toolkit.StringUtils.isEmpty(getHistoryPriceArea)){
                            getHistoryPriceArea = detailVO.getHistoryPriceArea();
                        }
                    }
                    if(getHistoryPriceArea!=null && !getHistoryPriceArea.isEmpty()){//历史区间不为空"-"
                        String[] split = getHistoryPriceArea.split("-");//截取高低价
                        BigDecimal maxPrice = new BigDecimal(split[1]);
                        BigDecimal minPrice =new BigDecimal(split[0]);
                        logger.info("明细：{}--高价：{}---低价：{}",detailVO.getEquipmentName() ,split[1], split[0]);
                        if(maxPrice.compareTo(minPrice)==0){//相等跳过循环
                            continue;
                        }
                        BigDecimal price = detailVO.getEstimatePrice()==null ? BigDecimal.ZERO : detailVO.getEstimatePrice().setScale(4, BigDecimal.ROUND_HALF_UP);//单价
                        BigDecimal maxPriceParam = ComputeUtil.safeDiv(ComputeUtil.safeMultiply(maxPrice, roleValueMax), new BigDecimal("100")).setScale(4, BigDecimal.ROUND_HALF_UP);
                        if (price.compareTo(maxPriceParam) >0) {
                            ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO();
                            paramsCheckDsVO.setOrgName(maxParamVO.getOrgName());
                            paramsCheckDsVO.setWarnItem(detailVO.getEquipmentName()+(detailVO.getSpec()==null ? "" : "+"+detailVO.getSpec()));
                            paramsCheckDsVO.setWarnName("单价大于历史最高价");
                            StringBuffer stringBuffer = new StringBuffer();
                            stringBuffer.append("单价：").append(price)
                                    .append("，历史价格区间:(").append(getHistoryPriceArea)
                                    .append("),历史最高价*").append(roleValueMax).append("%:").append(maxPriceParam)
                                    .append("，超出最高价：").append(ComputeUtil.safeSub(price,maxPriceParam).setScale(4,BigDecimal.ROUND_HALF_UP));
                            paramsCheckDsVO.setContent(stringBuffer.toString());
                            checkDsVOSMax.add(paramsCheckDsVO);
                        }
                    }
                }
                paramsCheckVOMax.setDataSource(checkDsVOSMax);
                paramsCheckVOList.add(paramsCheckVOMax);
            }
        }
        if(CollectionUtils.isNotEmpty(minParamVOS)){//遍历低价
            for (BillParamVO minParamVO : minParamVOS) {
                ParamsCheckVO paramsCheckVOMin = new ParamsCheckVO();//低价
                List<ParamsCheckDsVO> checkDsVOSMin = new ArrayList<>();
                BigDecimal roleValueMin = minParamVO.getRoleValue();//低价校验比例
                paramsCheckVOMin.setWarnType(paramsArray[minParamVO.getControlType()]);//低价赋值控制类型
                //控制方式为none时不需要控制
                if ("none".equals(paramsArray[minParamVO.getControlType()])) {
                    continue;
                }
                for (PurchaseApplyDetailedVO  detailVO: detailList) {//遍历明细
                    //根据优先级取价格
                    String getHistoryPriceArea = "";
                    if(flag){
                        //历史价格优先   先去历史价  为空再取  指导价
                        getHistoryPriceArea = detailVO.getHistoryPriceArea();
                        if(com.baomidou.mybatisplus.core.toolkit.StringUtils.isEmpty(getHistoryPriceArea)){
                            getHistoryPriceArea = detailVO.getGuidePriceArea();
                        }
                    }else{
                        //指导价优先   先去指导价  为空再取  历史价
                        getHistoryPriceArea = detailVO.getGuidePriceArea();
                        if(com.baomidou.mybatisplus.core.toolkit.StringUtils.isEmpty(getHistoryPriceArea)){
                            getHistoryPriceArea = detailVO.getHistoryPriceArea();
                        }
                    }
                    if(getHistoryPriceArea!=null && !getHistoryPriceArea.isEmpty()){//历史区间不为空"-"
                        String[] split = getHistoryPriceArea.split("-");//截取高低价
                        BigDecimal maxPrice = new BigDecimal(split[1]);
                        BigDecimal minPrice =new BigDecimal(split[0]);
                        logger.info("分包清单：{}--高价：{}---低价：{}",detailVO.getEquipmentName() ,split[1], split[0]);
                        if(maxPrice.compareTo(minPrice)==0){//相等跳过循环
                            continue;
                        }
                        BigDecimal price = detailVO.getEstimatePrice()==null ? BigDecimal.ZERO : detailVO.getEstimatePrice().setScale(4, BigDecimal.ROUND_HALF_UP);//单价
                        BigDecimal minPriceParam = ComputeUtil.safeDiv(ComputeUtil.safeMultiply(minPrice, roleValueMin), new BigDecimal("100")).setScale(4, BigDecimal.ROUND_HALF_UP);
                        if (price.compareTo(minPriceParam) < 0) {
                            ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO();
                            paramsCheckDsVO.setOrgName(minParamVO.getOrgName());
                            paramsCheckDsVO.setWarnItem(detailVO.getEquipmentName()+(detailVO.getSpec()==null ? "" : "+"+detailVO.getSpec()));
                            paramsCheckDsVO.setWarnName("单价小于于历史最低价");
                            StringBuffer stringBuffer = new StringBuffer();
                            stringBuffer.append("单价：").append(price)
                                    .append("，历史价格区间:(").append(getHistoryPriceArea)
                                    .append("),历史最低价*").append(roleValueMin).append("%:").append(minPriceParam)
                                    .append("，低于最低价：").append(ComputeUtil.safeSub(minPriceParam,price).setScale(4,BigDecimal.ROUND_HALF_UP));
                            paramsCheckDsVO.setContent(stringBuffer.toString());
                            checkDsVOSMin.add(paramsCheckDsVO);
                        }
                    }
                }
                paramsCheckVOMin.setDataSource(checkDsVOSMin);
                paramsCheckVOList.add(paramsCheckVOMin);
            }
        }

        return paramsCheckVOList;
    }

}
