/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.proequipmentcorpout.contract.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.contractbase.filing.enums.FilingStatusEnum;
import com.ejianc.business.proequipmentcorpout.constants.OutRentConstants;
import com.ejianc.business.proequipmentcorpout.contract.bean.OutRentContractEntity;
import com.ejianc.business.proequipmentcorpout.contract.enums.PerformanceStatusEnum;
import com.ejianc.business.proequipmentcorpout.contract.enums.SignatureStatusEnum;
import com.ejianc.business.proequipmentcorpout.contract.service.IOutRentContractChangeService;
import com.ejianc.business.proequipmentcorpout.contract.service.IOutRentContractService;
import com.ejianc.business.proequipmentcorpout.contract.service.IOutRentSignatureService;
import com.ejianc.business.proequipmentcorpout.contract.vo.OutRentContractVO;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.support.api.IParamConfigApi;
import com.ejianc.foundation.support.vo.ParamRegisterSetVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="outRentSignatureService")
public class OutRentSignatureServiceImpl
implements IOutRentSignatureService {
    @Autowired
    private IOutRentContractService contractService;
    @Autowired
    private IOutRentContractChangeService changeService;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IAttachmentApi attachmentApi;
    @Autowired
    private IParamConfigApi paramConfigApi;
    private static final String UPDATE_CON_SIGN_DATE_PARAM_NAME = "P-U9uddl0182";

    @Override
    public CommonResponse<String> changeStatus(Long id, int signatureStatus, String refCode) {
        this.logger.info("\u8fdb\u5165\u7b7e\u7ae0\u72b6\u6001\u4fee\u6539\u6d41\u7a0b------------->{}", (Object)refCode);
        OutRentContractEntity contractEntity = (OutRentContractEntity)((Object)this.contractService.selectById(id));
        if (contractEntity != null) {
            if (signatureStatus == Integer.valueOf(SignatureStatusEnum.\u5df2\u7b7e\u7ae0.getCode())) {
                contractEntity.setSignatureState(SignatureStatusEnum.\u5df2\u7b7e\u7ae0.getCode());
                contractEntity.setContractPerformanceState(PerformanceStatusEnum.\u5c65\u7ea6\u4e2d.getCode());
                contractEntity.setFilingStatus(FilingStatusEnum.\u5df2\u5f52\u6863.getTypeCode());
                contractEntity.setFilingRef(0);
                contractEntity.setEffectiveDate(new Date());
                CommonResponse response = this.paramConfigApi.getByCode(UPDATE_CON_SIGN_DATE_PARAM_NAME);
                if (!response.isSuccess()) {
                    this.logger.error("\u67e5\u8be2\u7535\u4e2d\u7b7e\u7ae0\u5408\u540c-\u3010id-{}\u3011\u662f\u5426\u66f4\u65b0\u5408\u540c\u7b7e\u8ba2\u65e5\u671f\u53c2\u6570\u5931\u8d25\uff0c\u6682\u4e0d\u66f4\u65b0\u5408\u540c\u7b7e\u8ba2\u65e5\u671f: {}", (Object)id, (Object)JSONObject.toJSONString((Object)response));
                }
                if (null != response.getData() && "1".equals(((ParamRegisterSetVO)response.getData()).getValueData())) {
                    SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
                    this.logger.info("\u5408\u540c\u3010id-{}\uff0c\u539f\u7b7e\u8ba2\u65e5\u671f\uff1a{}, \u6839\u636e\u7535\u5b50\u7b7e\u7ae0\u5408\u540c\u66f4\u65b0\u5408\u540c\u7b7e\u8ba2\u65e5\u671f\u53c2\u6570:{}\uff0c\u5c06\u5408\u540c\u7b7e\u8ba2\u65e5\u671f\u6539\u4e3a\u5f53\u524d\u7b7e\u7ae0\u5b8c\u6210\u65e5\u671f:{}\u3011", new Object[]{id, sdf.format(contractEntity.getSignedDate()), JSONObject.toJSONString((Object)response.getData()), sdf.format(new Date())});
                    contractEntity.setSignedDate(new Date());
                }
                this.contractService.pushContractToRent(JSONObject.toJSONString((Object)((Object)contractEntity)), OutRentConstants.PUSH_RENT_OPT_TYPE_ADD, "contract");
            } else {
                contractEntity.setSignatureState(String.valueOf(signatureStatus));
            }
        } else {
            return CommonResponse.error((String)"\u627e\u4e0d\u5230\u5408\u540c\uff0c\u8bf7\u68c0\u67e5\u5408\u540c\u4e3b\u952e\uff01");
        }
        this.contractService.saveOrUpdate((Object)contractEntity, false);
        this.contractService.pushContract((OutRentContractVO)BeanMapper.map((Object)((Object)contractEntity), OutRentContractVO.class));
        this.logger.info("\u4e3b\u5408\u540c\u7b7e\u7ae0\u72b6\u6001\u5df2\u4fee\u6539---------------->");
        return CommonResponse.success((String)"\u7b7e\u7ae0\u72b6\u6001\u4fee\u6539\u6210\u529f\uff01");
    }
}

