/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.proequipmentcorppur.purchase.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.proequipmentcorppur.constants.PurCommonBillTypeEnum;
import com.ejianc.business.proequipmentcorppur.purchase.bean.ChangePurchaseContractEntity;
import com.ejianc.business.proequipmentcorppur.purchase.bean.PurchaseContractEntity;
import com.ejianc.business.proequipmentcorppur.purchase.enums.ChangeStatusEnum;
import com.ejianc.business.proequipmentcorppur.purchase.enums.DraftTypeEnum;
import com.ejianc.business.proequipmentcorppur.purchase.enums.PerformanceStatusEnum;
import com.ejianc.business.proequipmentcorppur.purchase.enums.SignatureStatusEnum;
import com.ejianc.business.proequipmentcorppur.purchase.service.IChangePurchaseContractService;
import com.ejianc.business.proequipmentcorppur.purchase.service.IPurchaseContractService;
import com.ejianc.business.proequipmentcorppur.purchase.vo.ChangePurchaseContractVO;
import com.ejianc.business.targetcost.vo.ParamsCheckVO;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.file.vo.AttachmentVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service(value="changePurchaseContract")
public class ChangePurchaseContractBpmServiceImpl
implements ICommonBusinessService {
    @Autowired
    private IChangePurchaseContractService changeService;
    @Autowired
    private IPurchaseContractService contractService;
    @Autowired
    private SessionManager sessionManager;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IAttachmentApi attachmentApi;

    public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        ChangePurchaseContractEntity e = (ChangePurchaseContractEntity)((Object)this.changeService.selectById(billId));
        UserContext userContext = this.sessionManager.getUserContext();
        e.setCommitDate(new Date());
        e.setCommitUserCode(userContext.getUserCode());
        e.setCommitUserName(userContext.getUserName());
        this.changeService.saveOrUpdate((Object)e, false);
        return CommonResponse.success((String)"\u53d8\u66f4\u56de\u8c03\u5904\u7406\u5b8c\u6210\uff01");
    }

    public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return this.bpmBackCheck(billId, state, billTypeCode);
    }

    public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return this.doBpmBack(billId, state, billTypeCode);
    }

    public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        ChangePurchaseContractEntity changeEntity = (ChangePurchaseContractEntity)((Object)this.changeService.selectById(billId));
        this.logger.info("\u53d8\u66f4\u5355\u7ec8\u5ba1\u5ba1\u6279\u524d\u53d8\u66f4\u8868\u6570\u636e------------->: {}", (Object)JSONObject.toJSONString((Object)((Object)changeEntity)));
        return CommonResponse.success((String)"\u53d8\u66f4\u5355\u7ec8\u5ba1\u5ba1\u6279\u524d\u56de\u8c03\u5904\u7406\u6210\u529f\uff01");
    }

    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        ChangePurchaseContractEntity changeEntity = (ChangePurchaseContractEntity)((Object)this.changeService.selectById(billId));
        this.logger.info("\u66f4\u65b0\u5408\u540c\u8868\u6570\u636e\u6210\u529f,contractEntity---------->: {}", (Object)JSONObject.toJSONString((Object)((Object)changeEntity)));
        Boolean commitState = false;
        if (state.equals(BillStateEnum.COMMITED_STATE.getBillStateCode())) {
            commitState = true;
            changeEntity.setCommitDate(new Date());
            changeEntity.setCommitUserCode(this.sessionManager.getUserContext().getUserCode());
            changeEntity.setCommitUserName(this.sessionManager.getUserContext().getUserName());
            this.logger.info("\u66f4\u65b0\u5408\u540c\u8868\u6570\u636e\u6210\u529f1,contractEntity---------->: {}", (Object)JSONObject.toJSONString((Object)((Object)changeEntity)));
        }
        if (DraftTypeEnum.\u7ebf\u4e0b\u7b7e\u8ba2.getCode().toString().equals(changeEntity.getChangeDraftType())) {
            this.logger.info("\u66f4\u65b0\u5408\u540c\u8868\u6570\u636e\u6210\u529f2,contractEntity---------->: {}", (Object)JSONObject.toJSONString((Object)((Object)changeEntity)));
            CommonResponse<String> rsp = this.changeService.effectiveSaveWriteContract(billId, billTypeCode, commitState, false);
            if (!rsp.isSuccess()) {
                throw new BusinessException("\u5ba1\u6279\u56de\u5199\u5931\u8d25!\u5931\u8d25\u539f\u56e0\uff1a" + rsp.getMsg());
            }
        } else {
            if (commitState.booleanValue()) {
                this.changeService.saveOrUpdate((Object)changeEntity);
            }
            PurchaseContractEntity contractEntity = (PurchaseContractEntity)((Object)this.contractService.selectById(changeEntity.getContractId()));
            contractEntity.setChangeStatus(ChangeStatusEnum.\u53d8\u66f4\u5355\u636e\u5ba1\u6279\u901a\u8fc7.getCode());
            this.contractService.saveOrUpdate((Object)contractEntity, false);
            this.logger.info("\u66f4\u65b0\u5408\u540c\u8868\u6570\u636e\u6210\u529f,contractEntity---------->: {}", (Object)JSONObject.toJSONString((Object)((Object)contractEntity)));
        }
        this.checkContractFile(changeEntity);
        this.changeService.asyncWatermarkById(billId);
        return CommonResponse.success((String)"\u5ba1\u6279\u56de\u8c03\u5408\u540c\u6210\u529f\uff01");
    }

    private void checkContractFile(ChangePurchaseContractEntity changeEntity) {
        CommonResponse attachResp = this.attachmentApi.queryDetail(changeEntity.getChangeFileId().toString());
        if (!attachResp.isSuccess() || null == attachResp.getData()) {
            this.logger.info("\u5408\u540c\u5b58\u50a8\u6587\u4ef6Id-{}\u5728\u6587\u4ef6\u4e2d\u5fc3\u4e0d\u5b58\u5728\uff0c\u6839\u636e\u53c2\u6570sourceId-{}, sourceType-{}, billType-{} \u67e5\u8be2\u5bf9\u5e94\u6587\u4ef6\u4fe1\u606f", new Object[]{changeEntity.getChangeFileId(), changeEntity.getId(), "contractChangeFile", PurCommonBillTypeEnum.\u8bbe\u5907\u516c\u53f8\u8bbe\u5907\u91c7\u8d2d\u5408\u540c\u53d8\u66f4.getBillTypeCode()});
            CommonResponse attachListResp = this.attachmentApi.queryListBySourceId(changeEntity.getId(), PurCommonBillTypeEnum.\u8bbe\u5907\u516c\u53f8\u8bbe\u5907\u91c7\u8d2d\u5408\u540c\u53d8\u66f4.getBillTypeCode(), "contractChangeFile", "desc");
            this.logger.info("\u6839\u636e\u53c2\u6570sourceId-{}, sourceType-{}, billType-{} \u67e5\u8be2\u5bf9\u5e94\u6587\u4ef6\u4fe1\u606f\u7ed3\u679c\uff1a{}", new Object[]{changeEntity.getId(), "contractChangeFile", PurCommonBillTypeEnum.\u8bbe\u5907\u516c\u53f8\u8bbe\u5907\u91c7\u8d2d\u5408\u540c\u53d8\u66f4.getBillTypeCode(), JSONObject.toJSONString((Object)attachListResp)});
            if (attachListResp.isSuccess() || CollectionUtils.isEmpty((Collection)((Collection)attachListResp.getData()))) {
                AttachmentVO attachmentVO = (AttachmentVO)((List)attachListResp.getData()).get(0);
                this.logger.info("\u5c06\u5408\u540cid-{}\u5bf9\u5e94\u5408\u540c\u6587\u4ef6Id-{}\u6539\u4e3a{}", new Object[]{changeEntity.getId(), changeEntity.getChangeFileId(), attachmentVO.getId()});
                changeEntity.setChangeFileId(attachmentVO.getId());
            } else {
                throw new BusinessException("\u5ba1\u6279\u5931\u8d25\uff0c\u83b7\u53d6\u5408\u540c\u6587\u4ef6\u4fe1\u606f\u5931\u8d25, \u8bf7\u68c0\u67e5\u5408\u540c\u6587\u4ef6\uff01");
            }
        }
    }

    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        return this.bpmBackCheck(billId, state, billTypeCode);
    }

    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        return this.doBpmBack(billId, state, billTypeCode);
    }

    @Transactional(rollbackFor={Exception.class})
    public CommonResponse<String> doBpmBack(Long billId, Integer state, String billTypeCode) {
        Object resp = null;
        ChangePurchaseContractEntity changeEntity = (ChangePurchaseContractEntity)((Object)this.changeService.selectById(billId));
        if (!SignatureStatusEnum.\u672a\u7b7e\u7ae0.getCode().equals(changeEntity.getSignatureStatus())) {
            return CommonResponse.error((String)"\u5f53\u524d\u5355\u636e\u5df2\u6709\u7b7e\u7ae0\u6d41\u7a0b\uff0c\u4e0d\u80fd\u64a4\u56de\uff01");
        }
        changeEntity.setCommitDate(null);
        changeEntity.setCommitUserCode(null);
        changeEntity.setCommitUserName(null);
        this.changeService.saveOrUpdate((Object)changeEntity);
        PurchaseContractEntity contractEntity = (PurchaseContractEntity)((Object)this.contractService.selectById(changeEntity.getContractId()));
        contractEntity.setChangeStatus(ChangeStatusEnum.\u53d8\u66f4\u4e2d.getCode());
        this.contractService.saveOrUpdate((Object)contractEntity, false);
        return CommonResponse.success((String)"\u6267\u884c\u53d8\u66f4\u5355\u64a4\u56de\u56de\u8c03\u903b\u8f91\u6210\u529f\uff01");
    }

    private CommonResponse<String> bpmBackCheck(Long billId, Integer state, String billTypeCode) {
        ChangePurchaseContractEntity contractChangeEntity = (ChangePurchaseContractEntity)((Object)this.changeService.selectById(billId));
        ArrayList<String> statusList = new ArrayList<String>();
        statusList.add(SignatureStatusEnum.\u672a\u7b7e\u7ae0.getCode());
        statusList.add(SignatureStatusEnum.\u5df2\u9000\u56de.getCode());
        statusList.add(SignatureStatusEnum.\u5df2\u64a4\u56de.getCode());
        statusList.add(SignatureStatusEnum.\u5df2\u8fc7\u671f.getCode());
        if (!DraftTypeEnum.\u7ebf\u4e0b\u7b7e\u8ba2.getCode().toString().equals(contractChangeEntity.getChangeDraftType()) && !statusList.contains(contractChangeEntity.getSignatureStatus())) {
            return CommonResponse.error((String)"\u5f53\u524d\u5355\u636e\u5df2\u6709\u7b7e\u7ae0\u6d41\u7a0b\uff0c\u4e0d\u80fd\u64a4\u56de\uff01");
        }
        if (SignatureStatusEnum.\u5df2\u7b7e\u7ae0.getCode().equals(contractChangeEntity.getSignatureStatus())) {
            contractChangeEntity.setSignatureStatus(SignatureStatusEnum.\u672a\u7b7e\u7ae0.getCode());
            contractChangeEntity.setContractPerformanceState(PerformanceStatusEnum.\u672a\u7b7e\u8ba2.getCode());
        }
        contractChangeEntity.setCommitDate(null);
        contractChangeEntity.setCommitUserCode(null);
        contractChangeEntity.setCommitUserName(null);
        this.changeService.saveOrUpdate((Object)contractChangeEntity);
        this.logger.info("\u64a4\u56de\u66f4\u65b0\u53d8\u66f4\u8868\u6570\u636e\u6210\u529f,contractEntity---------->: {}", (Object)JSONObject.toJSONString((Object)((Object)contractChangeEntity)));
        PurchaseContractEntity contractEntity = (PurchaseContractEntity)((Object)this.contractService.selectById(contractChangeEntity.getContractId()));
        contractEntity.setChangeStatus(ChangeStatusEnum.\u53d8\u66f4\u4e2d.getCode());
        this.contractService.saveOrUpdate((Object)contractEntity, false);
        this.logger.info("\u64a4\u56de\u66f4\u65b0\u5408\u540c\u8868\u6570\u636e\u6210\u529f,contractEntity---------->: {}", (Object)JSONObject.toJSONString((Object)((Object)contractEntity)));
        return CommonResponse.success((String)"\u5f03\u5ba1/\u64a4\u56de\u524d\u6821\u9a8c\u56de\u8c03\u6210\u529f\uff01");
    }

    public CommonResponse<JSONObject> getBpmVariable(Long billId, String billTypeCode) {
        ChangePurchaseContractEntity e = (ChangePurchaseContractEntity)((Object)this.changeService.selectById(billId));
        List<ParamsCheckVO> paramsCheckVO = this.changeService.historyPriceCtrlContractPrice((ChangePurchaseContractVO)BeanMapper.map((Object)((Object)e), ChangePurchaseContractVO.class));
        JSONObject object = new JSONObject();
        if (paramsCheckVO.size() > 0 && paramsCheckVO.get(0).getDataSource().size() > 0) {
            this.logger.info("\u5355\u4ef7\u5f02\u5e38");
            object.put("priceFlag", (Object)"\u662f");
        } else {
            this.logger.info("\u5355\u4ef7\u6b63\u5e38");
            object.put("priceFlag", (Object)"\u5426");
        }
        return CommonResponse.success((Object)object);
    }
}

