package com.ejianc.business.proequipmentcorpout.contract.utils;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.IBaseService;
import org.apache.poi.ss.formula.functions.T;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;

/**
 * @author yqls
 * @date 2022-02-14 14:13:47
 */
public class ListCallable implements Callable<JSONArray> {
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    private QueryParam queryParam;
    private IBaseService service;

    /**
     *  注入service使用Callable查询数据列表
     * @param threadPool
     * @param queryParam
     * @param service
     * @return
     * @throws ExecutionException
     * @throws InterruptedException
     */
    public static Future<JSONArray> excute(ExecutorService threadPool, QueryParam queryParam, IBaseService service) {
        Callable<JSONArray> callable = new ListCallable(queryParam, service);
        Future<JSONArray> future = threadPool.submit(callable);
        return future;
    }

    public ListCallable(QueryParam queryParam, IBaseService service) {
        this.queryParam = queryParam;
        this.service = service;
    }

    @Override
    public JSONArray call() throws Exception {
        List<T> list = service.queryList(queryParam, false);
        OutRentDetailListUtil.setDetailList(list);
        String json = JSON.toJSONString(list);
        JSONArray records = JSONArray.parseArray(json);
        return records;
    }
}
