package com.ejianc.business.proequipmentcorpout.order.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.proequipmentcorpout.order.bean.OutOrderEntity;
import com.ejianc.business.proequipmentcorpout.order.service.IOutOrderService;
import com.ejianc.business.proequipmentcorpout.order.vo.CommonConstant;
import com.ejianc.business.proequipmentcorpout.order.vo.OutOrderVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

import java.io.Serializable;
import java.util.List;
import java.util.stream.Collectors;

/**
 * 租赁订单
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("outOrder")
public class OutOrderController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());


    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "ASSISTRMAT_ORDER";//此处需要根据实际修改

    @Autowired
    private IOutOrderService service;

    @Autowired
    private SessionManager sessionManager;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<OutOrderVO> saveOrUpdate(@RequestBody OutOrderVO saveOrUpdateVO) {
        OutOrderVO orderVO = service.saveOrUpdate(saveOrUpdateVO);
        OutOrderEntity entity = service.selectById(orderVO.getId());
        OutOrderVO vo = BeanMapper.map(entity, OutOrderVO.class);
        vo.setReceiveStateName(CommonConstant.ORDER_RECEIVE_STATE.get(vo.getReceiveState()));
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<OutOrderVO> queryDetail(Long id) {
    	OutOrderEntity entity = service.selectById(id);
    	OutOrderVO vo = BeanMapper.map(entity, OutOrderVO.class);
        vo.setReceiveStateName(CommonConstant.ORDER_RECEIVE_STATE.get(vo.getReceiveState()));
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<OutOrderVO> vos) {
        if(ListUtil.isNotEmpty(vos)){
            for (OutOrderVO vo : vos) {
                // 参数是单据类型编码字符串 根据需求是否打开下面代码
                /* CommonResponse<String> resp = billTypeApi.checkQuote("billTypeCode", vo.getId());
                if(!resp.isSuccess()){
                    return CommonResponse.error("删除失败！"+resp.getMsg());
                }*/
            }
        }
        service.removeByIds(vos.stream().map(OutOrderVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<OutOrderVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("contractName");
        fuzzyFields.add("supplierName");
        fuzzyFields.add("projectName");
        fuzzyFields.add("outOrgName");

        /** 数据隔离 本下 没有组织orgId的删除下面代码-------------开始 */
        if(!param.getParams().containsKey("orgId")) {
            //pc端
            param.getParams().put("orgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).
                    getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        }else{
            //移动端 需要取orgId的本下
            Long orgId = Long.valueOf(param.getParams().get("orgId").getValue().toString());
            param.getParams().put("orgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentId(orgId).
                    getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        }
        /** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */
        IPage<OutOrderEntity> page = service.queryPage(param,false);
        IPage<OutOrderVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        List<OutOrderVO> records = BeanMapper.mapList(page.getRecords(), OutOrderVO.class);
        pageData.setRecords(records);
        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }

}
