package com.ejianc.business.proequipmentcorprent.temporary.contract.controller;

import java.io.Serializable;


import com.alibaba.fastjson.JSON;
import com.ejianc.business.contractbase.api.ITemplateCategoryApi;
import com.ejianc.business.contractbase.vo.TemplateCategoryVO;
import com.ejianc.business.proequipmentcorprent.rent.bean.RentContractEntity;
import com.ejianc.business.proequipmentcorprent.rent.enums.ChangeStatusEnum;
import com.ejianc.business.proequipmentcorprent.rent.enums.DraftTypeEnum;
import com.ejianc.business.proequipmentcorprent.rent.enums.PerformanceStatusEnum;
import com.ejianc.business.proequipmentcorprent.rent.enums.SignatureStatusEnum;
import com.ejianc.business.proequipmentcorprent.rent.vo.RentContractVO;
import com.ejianc.business.proequipmentcorprent.rent.vo.RentParameterVO;
import com.ejianc.business.targetcost.vo.ExecutionVO;
import com.ejianc.business.targetcost.vo.ParamsCheckVO;
import com.ejianc.business.proequipmentcorprent.temporary.contract.bean.TemporaryEquipmentDetailedEntity;
import com.ejianc.business.proequipmentcorprent.temporary.contract.service.ITemporaryEquipmentDetailedService;
import com.ejianc.business.proequipmentcorprent.temporary.contract.service.impl.TemporaryEquipmentDetailedServiceImpl;
import com.ejianc.business.proequipmentcorprent.temporary.contract.vo.TemporaryEquipmentDetailedVO;
import com.ejianc.business.proequipmentcorprent.temporary.useapply.bean.TemporaryUseApplyEntity;
import com.ejianc.business.proequipmentcorprent.temporary.useapply.bean.TemporaryUseApplySubEntity;
import com.ejianc.business.proequipmentcorprent.temporary.useapply.service.ITemporaryUseApplyService;
import com.ejianc.business.proequipmentcorprent.temporary.useapply.service.ITemporaryUseApplySubService;
import com.ejianc.business.proequipmentcorprent.userecord.bean.UseRecordSubEntity;
import com.ejianc.business.proequipmentcorprent.userecord.service.IUseRecordSubService;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.math.BigDecimal;
import java.util.*;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import org.apache.commons.collections.CollectionUtils;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.business.proequipmentcorprent.temporary.contract.bean.TemporaryContractEntity;
import com.ejianc.business.proequipmentcorprent.temporary.contract.service.ITemporaryContractService;
import com.ejianc.business.proequipmentcorprent.temporary.contract.vo.TemporaryContractVO;

/**
 * 临时设备租赁合同
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("temporaryContract")
public class TemporaryContractController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "TEMPORARY_CONTRACT";//此处需要根据实际修改
    @Autowired
    private ITemplateCategoryApi templateCategoryApi;
    @Autowired
    private ITemporaryContractService service;
    private final String TEMPORARY_CONTRACT = "BT220326000000001";

    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private ITemporaryUseApplySubService useApplySubService;
    @Autowired
    private ITemporaryUseApplyService useApplyService;

    @Autowired
    private ITemporaryEquipmentDetailedService equipmentDetailedService;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<TemporaryContractVO> saveOrUpdate(@RequestBody TemporaryContractVO saveOrUpdateVO,HttpServletRequest req) {
        String authority = req.getHeader("authority");
        TemporaryContractVO vo =  service.insertOrUpdate(saveOrUpdateVO,authority,false);
        return CommonResponse.success("保存或修改单据成功！",vo);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<TemporaryContractVO> queryDetail(Long id) {
        return CommonResponse.success("查询详情数据成功！",service.queryDetail(id));
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<TemporaryContractVO> vos) {
        return service.deleteByIds(vos);
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<JSONObject> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("contractName");
        fuzzyFields.add("projectName");
        fuzzyFields.add("partyName");
        fuzzyFields.add("supplierName");
        fuzzyFields.add("code");
        param.getParams().put("tenant_id",new Parameter("eq",InvocationInfoProxy.getTenantid()));

        //查询本下范围内日的合同
        Long orgId = InvocationInfoProxy.getOrgId();
        //若当前上下文为项目部，则根据项目部Id来进行查询
        CommonResponse<List<OrgVO>> orgResp = iOrgApi.findChildrenByParentId(orgId);
        if(!orgResp.isSuccess()) {
            logger.error("分页查询失败，获取当前本下组织信息失败, {}", orgResp.getMsg());
            return CommonResponse.error("查询失败，获取组织信息失败！");
        }
        if(ListUtil.isEmpty(orgResp.getData())) {
            return CommonResponse.success("查询成功！",new JSONObject());
        }
        param.getParams().put("companyId", new Parameter(QueryParam.IN,
                orgResp.getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        LinkedHashMap<String, String> orderMap = new LinkedHashMap<>();

        //设置排序：为了保证主合同与补充协议排列在一起，先用主合同创建时间排序
       /* if(null != param.getOrderMap().get("createTime")) {
            orderMap.put("main_contract_create_date", param.getOrderMap().get("createTime"));
        }else {
            orderMap.put("main_contract_create_date", QueryParam.DESC);
        }
        orderMap.put("supplement_flag", QueryParam.ASC);
        orderMap.put("create_time", QueryParam.DESC);

        param.setOrderMap(orderMap);*/

        //设置排序：为了保证主合同与补充协议排列在一起，先用主合同创建时间排序
        if(null != param.getOrderMap().get("createTime")) {
            orderMap.put("main_contract_create_date", param.getOrderMap().get("createTime"));
        }else {
            orderMap.put("main_contract_create_date", QueryParam.DESC);
        }
        orderMap.put("supplement_flag", QueryParam.ASC);
        orderMap.put("create_time", QueryParam.DESC);

        param.setOrderMap(orderMap);

        IPage<TemporaryContractEntity> pageData= service.queryPage(param,false);

        //页面统计，查询原合同金额，现合同金额
        Map<String, Object> contractAmountMap = service.countContractAmount(param);
        JSONObject page = new JSONObject();
        page.put("records", BeanMapper.mapList(pageData.getRecords(), RentContractVO.class));
        page.put("total", pageData.getTotal());
        page.put("current", pageData.getCurrent());
        page.put("size", pageData.getSize());
        page.put("pages", pageData.getPages());
        page.put("sumMnyMap", contractAmountMap);
        return CommonResponse.success("查询列表数据成功！",page);

    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        Map<String, Object> beans = new HashMap<>();
        param.setPageSize(-1);
        CommonResponse<JSONObject> commonResponse = queryList(param);
        List<TemporaryContractVO> contractVOList = new ArrayList<>();
        if (null != commonResponse.getData()){
            contractVOList = (List<TemporaryContractVO>) commonResponse.getData().get("records");
            if (null != contractVOList && contractVOList.size() > 0){
                contractVOList.forEach(vo -> {
                    if(org.apache.commons.lang.StringUtils.isBlank(vo.getContractPerformanceState().toString())) {
                        vo.setContractPerformanceState(PerformanceStatusEnum.未签订.getDescription());
                    } else {
                        vo.setContractPerformanceState(PerformanceStatusEnum.getEnumByCode(vo.getContractPerformanceState().toString()).getDescription());
                    }

                    if(org.apache.commons.lang.StringUtils.isBlank(vo.getSignatureState())) {
                        vo.setSignatureState(SignatureStatusEnum.未签章.getDescription());
                    } else {
                        vo.setSignatureState(SignatureStatusEnum.getEnumByCode(vo.getSignatureState()).getDescription());
                    }

                    vo.setBillStateName(BillStateEnum.getEnumByStateCode(vo.getBillState()).getDescription());
                });
            }
        }
        beans.put("records", contractVOList);
        ExcelExport.getInstance().export("rentContract-export.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @Return void
     */
    @RequestMapping(value = "/refTemporaryContractData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<TemporaryContractVO>> refTemporaryContractData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("contractName");
        fuzzyFields.add("projectName");
        fuzzyFields.add("partyName");
        fuzzyFields.add("supplierName");
        fuzzyFields.add("code");
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("contractPerformanceState", new Parameter(QueryParam.EQ, "2"));
        param.getParams().put("billState", new Parameter(QueryParam.IN, "1,3"));
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        Long projectId = null;
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
            projectId =_con.getLong("projectId");
            if(projectId != null){
                param.getParams().put("projectId", new Parameter(QueryParam.EQ, projectId));
            }
        }
        LinkedHashMap<String, String> orderMap = new LinkedHashMap<>();
        orderMap.put("createTime", "desc");
        param.setOrderMap(orderMap);
        IPage<TemporaryContractEntity> page = service.queryPage(param,false);
        IPage<TemporaryContractVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), TemporaryContractVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }

    /**
     * 补充协议
     * @return
     */
    @RequestMapping(value = "/saveOrUpdateSupplement", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<TemporaryContractVO> saveOrUpdateSupplement(@RequestBody TemporaryContractVO temporaryContractVO){
        if (temporaryContractVO.getMainContractId() == null) {
            return CommonResponse.error("保存失败，主合同信息为空！");
        }
        TemporaryContractVO vo =service.saveOrUpdateSupplement(temporaryContractVO);
        return CommonResponse.success("保存成功",vo);
    }

    /**
     * @Author
     * @Description  新增根据合同主键查询补充协议需要的主合同字段
     * @param contractId
     * @Return
     */
    @RequestMapping(value = "/addConvertByConId", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<TemporaryContractVO> addConvertByConId(Long contractId) {
        TemporaryContractVO vo = service.addConvertByConId(contractId);
        return CommonResponse.success("新增转换数据成功！",vo);
    }

    /**
     * @Author
     * @Description  判断当前合同是否能新增补充协议
     * @param
     * @Return
     * @return
     */
    @RequestMapping(value = "/addSupplementFlag", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<String> addSupplementFlag(Long id) {
        Boolean flag = service.addSupplementFlag(id);
        if (flag){
            return CommonResponse.success("校验通过，该合同可以新增补充协议！");
        }
        return CommonResponse.error("当前合同存在未生效的补充协议，不能新增！");
    }

    /**
     * 签章流程
     * @param
     * @return
     */
    @RequestMapping(value = "/signatureProcess", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<String> signatureProcess(Long id) {
        /*
            后期修改：签章流程暂定为点击就改为已签章
         */
        TemporaryContractEntity temporaryContractEntity = service.selectById(id);
        if (temporaryContractEntity != null){
            temporaryContractEntity.setContractPerformanceState(SignatureStatusEnum.已签章.getCode());
            temporaryContractEntity.setSignatureState(PerformanceStatusEnum.履约中.getCode());
            temporaryContractEntity.setEffectiveDate(new Date());
            service.saveOrUpdate(temporaryContractEntity);
        }
        return CommonResponse.success();
    }
    /**
     * 查询当前合同下补充协议信息
     * @param id
     * @return
     */
    @RequestMapping(value = "/querySupplementRecord", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<TemporaryContractVO> querySupplementRecord(Long id) {
        TemporaryContractVO vo = service.querySupplementRecord(id);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description 参照
     * @Return void（临时合同设备明细）
     */
    @RequestMapping(value = "/refTemporaryContractEquipmentData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<TemporaryEquipmentDetailedVO>> refTemporaryContractEquipmentData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                                        String condition,
                                                                                        String searchObject,
                                                                                        String searchText) {
        QueryParam param = new QueryParam();

        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("name");
        fuzzyFields.add("categoryName");
        Long contractId = null;
        String flag = null;
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
            contractId =_con.getLong("contractId");
            flag = _con.getString("flag");
            if(contractId != null){
                param.getParams().put("pid", new Parameter(QueryParam.EQ, contractId));
            }
        }else{
            throw new BusinessException("合同id不能为空");
        }
        LinkedHashMap<String, String> orderMap = new LinkedHashMap<>();
        orderMap.put("createTime", "desc");
        param.setOrderMap(orderMap);
        IPage<TemporaryEquipmentDetailedEntity> page = equipmentDetailedService.queryPage(param,false);
        IPage<TemporaryEquipmentDetailedVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), TemporaryEquipmentDetailedVO.class));
        if ("1".equals(flag)) {
            List<Long> ids = new ArrayList<>();
            for (TemporaryEquipmentDetailedVO vo : pageData.getRecords()) {
                ids.add(vo.getId());
            }
            if(CollectionUtils.isNotEmpty(ids)){
                QueryParam useApplyParam = new QueryParam();
                List<Integer> list = new ArrayList<>();
                list.add(BillStateEnum.COMMITED_STATE.getBillStateCode());
                list.add(BillStateEnum.PASSED_STATE.getBillStateCode());
                useApplyParam.getParams().put("contractId", new Parameter(QueryParam.EQ, contractId));
                useApplyParam.getParams().put("billState", new Parameter(QueryParam.IN, list));
                useApplyParam.getParams().put("dr", new Parameter(QueryParam.EQ, 0));
                List<TemporaryUseApplyEntity> useApplyEntities = useApplyService.queryList(useApplyParam);
                List<Long> applyIds = new ArrayList<>();
                if(CollectionUtils.isNotEmpty(useApplyEntities)){
                    for(TemporaryUseApplyEntity entity: useApplyEntities){
                        applyIds.add(entity.getId());
                    }
                }
                if(CollectionUtils.isNotEmpty(applyIds)){
                    QueryParam useApplySubParam = new QueryParam();
                    useApplySubParam.getParams().put("pid", new Parameter(QueryParam.IN, applyIds));
                    List<TemporaryUseApplySubEntity> useApplySubEntities = useApplySubService.queryList(useApplySubParam);
                    for(TemporaryEquipmentDetailedVO vo : pageData.getRecords()){
                        for(TemporaryUseApplySubEntity entity : useApplySubEntities){
                            if(vo.getId().equals(entity.getEquipmentId())){
                                if(vo.getApplyNum() == null){
                                    vo.setApplyNum(entity.getApplyNum());
                                }else{
                                    vo.setApplyNum(vo.getApplyNum().add(entity.getApplyNum()));
                                }
                            }
                        }
                    }
                }
            }
        }
        return CommonResponse.success("查询参照数据成功！",pageData);
    }

    /**
     * 根据合同Id查询合同文件管理信息
     *
     * @param contractId 合同Id
     * @return
     */
    @GetMapping(value = "/getContractFileMgrInfo")
    @ResponseBody
    public CommonResponse<JSONObject> getContractFileMgrInfo(@RequestParam(value = "contractId") Long contractId) {
        JSONObject resp = new JSONObject();
        TemporaryContractEntity contractEntity = service.selectById(contractId);
        CommonResponse<TemplateCategoryVO> categoryResp = templateCategoryApi.queryTmplCategoryById(contractEntity.getContractType());
        if(!categoryResp.isSuccess()) {
            logger.error("根据合同类别I的-{}查询对应合同类别信息失败, 原因：{}", contractEntity.getContractType(), categoryResp.getMsg());
            return CommonResponse.error("查询合同类别信息失败");
        }
        TemplateCategoryVO category = categoryResp.getData();
        resp.put("contactId", contractEntity.getId());
        resp.put("contractBillTypeCode", TEMPORARY_CONTRACT);
        resp.put("contractCategoryId", category.getId());
        resp.put("boBillType", category.getBillTypeCode());

        return CommonResponse.success("查询成功！", resp);
    }

//    @RequestMapping(value = "/targetCostCtrl", method=RequestMethod.POST)
//    @ResponseBody
//    public CommonResponse<ParamsCheckVO> targetCostCtrl(@RequestBody TemporaryContractVO contractVO,HttpServletRequest req) {
//        String authority = req.getHeader("authority");
//        return CommonResponse.success("参数校验成功！", service.targetCostCtrl(contractVO,authority));
//    }
//
//    @GetMapping(value = "/viewTargetCostCtrlInfo")
//    @ResponseBody
//    public CommonResponse<ParamsCheckVO> viewTargetCostCtrlInfo(@RequestParam(value = "id") Long id) {
//        return CommonResponse.success("参数校验成功！", service.viewTargetCostCtrlInfo(id));
//    }

}
