/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.proequipmentcorpout.order.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.order.api.IRentReceiptsApi;
import com.ejianc.business.proequipmentcorpout.order.bean.OutOrderDetailEntity;
import com.ejianc.business.proequipmentcorpout.order.bean.OutOrderEntity;
import com.ejianc.business.proequipmentcorpout.order.mapper.OutOrderDetailMapper;
import com.ejianc.business.proequipmentcorpout.order.service.IOutOrderDetailService;
import com.ejianc.business.proequipmentcorpout.order.service.IOutOrderService;
import com.ejianc.business.proequipmentcorpout.order.vo.CommonConstant;
import com.ejianc.business.proequipmentcorpout.order.vo.OutOrderDetailVO;
import com.ejianc.business.proequipmentcorpout.order.vo.OutOrderVO;
import com.ejianc.business.proequipmentcorpout.outStore.bean.OutStoreDetailEntity;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="outOrderDetailService")
public class OutOrderDetailServiceImpl
extends BaseServiceImpl<OutOrderDetailMapper, OutOrderDetailEntity>
implements IOutOrderDetailService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IOutOrderService outOrderService;
    @Autowired
    private IRentReceiptsApi receiptsApi;

    @Override
    public Boolean deleteOrderDetailByOrderId(Long orderId) {
        return ((OutOrderDetailMapper)this.baseMapper).deleteOrderDetailByOrderId(orderId);
    }

    @Override
    public List<OutOrderDetailVO> geOutOrderDetail(QueryWrapper queryWrapper, Long contractId) {
        if (null == contractId) {
            return new ArrayList<OutOrderDetailVO>();
        }
        return ((OutOrderDetailMapper)this.baseMapper).geOutOrderDetail(queryWrapper, contractId);
    }

    @Override
    public List<OutOrderVO> queryOrderNumTotal(List<Long> orderIdList) {
        if (CollectionUtils.isEmpty(orderIdList)) {
            return new ArrayList<OutOrderVO>();
        }
        return ((OutOrderDetailMapper)this.baseMapper).queryOrderNumTotal(orderIdList);
    }

    @Override
    public void saveOrUpdateNum(List<OutStoreDetailEntity> detailVOS) {
        ArrayList<Long> addIdList = new ArrayList<Long>();
        ArrayList<Long> delIdList = new ArrayList<Long>();
        if (CollectionUtils.isNotEmpty(detailVOS)) {
            for (OutStoreDetailEntity detailVO : detailVOS) {
                if (detailVO.getSourceType() == null || detailVO.getSourceType() != 0) continue;
                if ("del".equals(detailVO.getRowState())) {
                    delIdList.add(detailVO.getSourceDetailId());
                    continue;
                }
                if (null != detailVO.getId()) continue;
                addIdList.add(detailVO.getSourceDetailId());
            }
        }
        this.addOrderDetail(addIdList);
        this.delOrderDetail(delIdList);
    }

    @Override
    public void deleteNum(List<OutStoreDetailEntity> detailVOS) {
        ArrayList<Long> delIdList = new ArrayList<Long>();
        ArrayList orderDetailList = new ArrayList();
        if (CollectionUtils.isNotEmpty(detailVOS)) {
            for (OutStoreDetailEntity detailVO : detailVOS) {
                if (detailVO.getSourceType() == null || detailVO.getSourceType() != 0) continue;
                delIdList.add(detailVO.getSourceDetailId());
            }
        }
        this.delOrderDetail(delIdList);
    }

    public void addOrderDetail(List<Long> addIdList) {
        if (CollectionUtils.isNotEmpty(addIdList)) {
            LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
            wrapper.in(BaseEntity::getId, addIdList);
            List list = super.list((Wrapper)wrapper);
            if (CollectionUtils.isNotEmpty((Collection)list)) {
                for (OutOrderDetailEntity outOrderDetailEntity : list) {
                    outOrderDetailEntity.setDeliverNumsSum(ComputeUtil.safeAdd((BigDecimal)outOrderDetailEntity.getDeliverNumsSum(), (BigDecimal)new BigDecimal("1")));
                    outOrderDetailEntity.setCheckNumsSum(ComputeUtil.safeAdd((BigDecimal)outOrderDetailEntity.getCheckNumsSum(), (BigDecimal)new BigDecimal("1")));
                    outOrderDetailEntity.setNotDeliveredNumsSum(ComputeUtil.safeSub((BigDecimal)outOrderDetailEntity.getNotDeliveredNumsSum(), (BigDecimal)new BigDecimal("1")));
                }
                super.saveOrUpdateBatch((Collection)list);
                this.updateOrderDeliverState(list, true);
            }
        }
    }

    public void delOrderDetail(List<Long> delIdList) {
        if (CollectionUtils.isNotEmpty(delIdList)) {
            LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
            wrapper.in(BaseEntity::getId, delIdList);
            List list = super.list((Wrapper)wrapper);
            if (CollectionUtils.isNotEmpty((Collection)list)) {
                for (OutOrderDetailEntity outOrderDetailEntity : list) {
                    outOrderDetailEntity.setDeliverNumsSum(ComputeUtil.safeSub((BigDecimal)outOrderDetailEntity.getDeliverNumsSum(), (BigDecimal)new BigDecimal("1")));
                    outOrderDetailEntity.setCheckNumsSum(ComputeUtil.safeSub((BigDecimal)outOrderDetailEntity.getCheckNumsSum(), (BigDecimal)new BigDecimal("1")));
                    outOrderDetailEntity.setNotDeliveredNumsSum(ComputeUtil.safeAdd((BigDecimal)outOrderDetailEntity.getNotDeliveredNumsSum(), (BigDecimal)new BigDecimal("1")));
                }
                super.saveOrUpdateBatch((Collection)list);
                this.updateOrderDeliverState(list, false);
            }
        }
    }

    public void updateOrderDeliverState(List<OutOrderDetailEntity> orderDetailList, Boolean type) {
        Set<Long> longs;
        List<OutOrderVO> outOrderNumList;
        Map<Long, List<OutOrderDetailEntity>> collect;
        this.logger.info((type != false ? "\u5360\u7528" : "\u91ca\u653e") + "\u8981\u4fee\u6539\u7684\u8ba2\u5355\u660e\u7ec6\u6570\u636e\u96c6\u5408:{}", (Object)JSONObject.toJSONString(orderDetailList));
        ArrayList<OutOrderVO> orderDeliverState = new ArrayList<OutOrderVO>();
        if (CollectionUtils.isNotEmpty(orderDetailList) && MapUtils.isNotEmpty(collect = orderDetailList.stream().collect(Collectors.groupingBy(item -> item.getOrderId()))) && CollectionUtils.isNotEmpty(outOrderNumList = this.queryOrderNumTotal(new ArrayList<Long>(longs = collect.keySet())))) {
            for (OutOrderVO orderVO : outOrderNumList) {
                BigDecimal receiveNumsSumTotal = orderVO.getReceiveNumsSumTotal();
                BigDecimal notDeliveredNumsSumTotal = orderVO.getNotDeliveredNumsSumTotal();
                if (notDeliveredNumsSumTotal.compareTo(BigDecimal.ZERO) <= 0) {
                    orderVO.setDeliverState(CommonConstant.ORDER_DELIVER_ALL);
                } else if (receiveNumsSumTotal.compareTo(notDeliveredNumsSumTotal) > 0) {
                    orderVO.setDeliverState(CommonConstant.ORDER_DELIVER_PART);
                } else if (receiveNumsSumTotal.compareTo(notDeliveredNumsSumTotal) == 0) {
                    orderVO.setDeliverState(CommonConstant.ORDER_DELIVER_WAIT);
                } else {
                    this.logger.info("\u8ba2\u5355id:{},\u63a5\u6536\u6570\u91cf\u7d2f\u8ba1\uff1a{}\uff0c\u672a\u53d1\u8d27\u6570\u91cf\u7d2f\u8ba1\uff1a{}", new Object[]{orderVO.getId(), receiveNumsSumTotal, notDeliveredNumsSumTotal});
                    throw new BusinessException("\u8ba2\u5355\u53d1\u8d27\u72b6\u6001\u56de\u663e\u5931\u8d25,\u8ba1\u7b97\u53d1\u751f\u9519\u8bef\uff01");
                }
                List<OutOrderDetailEntity> orderDetailEntities1 = collect.get(orderVO.getId());
                orderVO.setOutOrderDetailList(BeanMapper.mapList(orderDetailEntities1, OutOrderDetailVO.class));
                orderVO.setRentOrderDetailList(BeanMapper.mapList(orderDetailEntities1, OutOrderDetailVO.class));
                orderDeliverState.add(orderVO);
            }
        }
        if (CollectionUtils.isNotEmpty(orderDeliverState)) {
            this.logger.info((type != false ? "\u5360\u7528" : "\u91ca\u653e") + "\u8981\u4fee\u6539\u53d1\u8d27\u72b6\u6001\u7684\u8ba2\u5355\u6570\u636e\u96c6\u5408:{}", (Object)JSONObject.toJSONString(orderDeliverState));
            JSONArray jsonArray = JSONArray.parseArray((String)JSONObject.toJSONString(orderDeliverState));
            this.outOrderService.updateBatchById(BeanMapper.mapList(orderDeliverState, OutOrderEntity.class));
            this.receiptsApi.orderChangeStatus(jsonArray);
        }
    }
}

