/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.proequipmentcorpout.outrent.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.ejianc.business.order.api.IRentReceiptsApi;
import com.ejianc.business.order.enums.RentReceiptsEnum;
import com.ejianc.business.proequipmentcorpout.contract.bean.OutRentContractEntity;
import com.ejianc.business.proequipmentcorpout.contract.enums.PerformanceStatusEnum;
import com.ejianc.business.proequipmentcorpout.contract.enums.RentParameterTypeEnum;
import com.ejianc.business.proequipmentcorpout.contract.service.IOutRentContractService;
import com.ejianc.business.proequipmentcorpout.outLedger.bean.OutRentParameterDetailEntity;
import com.ejianc.business.proequipmentcorpout.outLedger.bean.OutRentParameterEntity;
import com.ejianc.business.proequipmentcorpout.outLedger.service.IOutRentParameterDetailService;
import com.ejianc.business.proequipmentcorpout.outLedger.service.IOutRentParameterService;
import com.ejianc.business.proequipmentcorpout.outrent.Enums.OutRentEquipmentStateEnum;
import com.ejianc.business.proequipmentcorpout.outrent.bean.OutRentEquipmentStartEntity;
import com.ejianc.business.proequipmentcorpout.outrent.bean.OutRentEquipmentStartSubEntity;
import com.ejianc.business.proequipmentcorpout.outrent.service.IOutRentEquipmentStartService;
import com.ejianc.business.proequipmentcorpout.outrent.service.IOutRentSettlementService;
import com.ejianc.business.proequipmentcorpout.outrent.vo.OutRentEquipmentStartSubVO;
import com.ejianc.business.proequipmentcorpout.outrent.vo.OutRentEquipmentStartVO;
import com.ejianc.business.proequipmentcorppur.asset.service.IAssetService;
import com.ejianc.business.proequipmentcorprent.rent.enums.EntranceRentFlagEnum;
import com.ejianc.business.proequipmentcorprent.rent.service.IRentAcceptanceService;
import com.ejianc.foundation.share.api.IShareCooperateApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="outRentEquipmentStart")
public class OutRentEquipmentStartBpmServiceImpl
implements ICommonBusinessService {
    @Autowired
    private IOutRentEquipmentStartService outRentEquipmentStartService;
    @Autowired
    private IOutRentParameterService outRentParameterService;
    @Autowired
    private IOutRentParameterDetailService outRentParameterDetailService;
    @Autowired
    private IShareCooperateApi shareCooperateApi;
    @Autowired
    private IRentReceiptsApi receiptsApi;
    @Autowired
    private IAssetService assetService;
    @Autowired
    private IOutRentContractService contractService;
    @Autowired
    private IOutRentSettlementService outRentSettlementService;
    @Autowired
    private IRentAcceptanceService rentAcceptanceService;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String BILL_TYPE = "BT220221000000003";
    private static final String PUSH_SAVE_URL = "/ejc-supbusiness-web/openapi/equipmentStart/saveStart";
    private final String PUSH_DELETE_URL = "/ejc-supbusiness-web/openapi/equipmentStart/deleteStart";
    private final String OPERATE = "RENT-PROEQUIPMENT-START";

    public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        OutRentEquipmentStartEntity entity = (OutRentEquipmentStartEntity)((Object)this.outRentEquipmentStartService.selectById(billId));
        Boolean entranceRentFlag = false;
        if (EntranceRentFlagEnum.\u662f.getCode().equals(entity.getEntranceRentFlag())) {
            entranceRentFlag = true;
        }
        ArrayList<OutRentParameterEntity> parameterList = new ArrayList<OutRentParameterEntity>();
        List<OutRentEquipmentStartSubEntity> startSubEntityList = entity.getOutRentEquipmentStartSubList();
        for (OutRentEquipmentStartSubEntity subEntity : startSubEntityList) {
            OutRentParameterEntity parameterEntity = new OutRentParameterEntity();
            parameterEntity.setId(subEntity.getSourceId());
            parameterEntity.setStartDate(subEntity.getTypeDate());
            parameterEntity.setOperationDate(new Date());
            parameterEntity.setEquipmentState(OutRentEquipmentStateEnum.\u542f\u7528.getCode());
            parameterEntity.setEquipmentStateName(OutRentEquipmentStateEnum.\u542f\u7528.getDescription());
            if (!entranceRentFlag.booleanValue()) {
                ArrayList<OutRentParameterDetailEntity> parameterDetailList = new ArrayList<OutRentParameterDetailEntity>();
                OutRentParameterDetailEntity detailEntity = new OutRentParameterDetailEntity();
                detailEntity.setSourceType(RentParameterTypeEnum.\u542f\u7528\u5355.getCode());
                detailEntity.setSourceId(entity.getId());
                detailEntity.setOperationDate(subEntity.getTypeDate());
                detailEntity.setEquipmentState(OutRentEquipmentStateEnum.\u542f\u7528.getCode());
                detailEntity.setParameterId(subEntity.getSourceId());
                parameterDetailList.add(detailEntity);
                parameterEntity.setRentParameterDetailList(parameterDetailList);
            } else {
                parameterEntity.setMeterRentDate(subEntity.getTypeDate());
            }
            parameterList.add(parameterEntity);
        }
        if (entranceRentFlag.booleanValue()) {
            List parameterIdList = startSubEntityList.stream().map(OutRentEquipmentStartSubEntity::getSourceId).collect(Collectors.toList());
            Map<Long, Date> startSubDateMap = startSubEntityList.stream().collect(Collectors.toMap(OutRentEquipmentStartSubEntity::getSourceId, OutRentEquipmentStartSubEntity::getTypeDate, (key1, key2) -> key2));
            this.logger.info("\u83b7\u53d6\u8bbe\u5907\u5b50\u8868\u96c6\u5408\uff1a{}", (Object)JSONObject.toJSONString(startSubDateMap));
            this.logger.info("\u83b7\u53d6\u53f0\u8d26\u8bbe\u5907id\u96c6\u5408\uff1a{}", (Object)JSONObject.toJSONString(parameterIdList));
            QueryParam queryParam = new QueryParam();
            queryParam.getParams().put("parameterId", new Parameter("in", parameterIdList));
            List detailEntityList = this.outRentParameterDetailService.queryList(queryParam);
            this.logger.info("\u83b7\u53d6\u53f0\u8d26\u8bbe\u5907\u5b50\u8868\u96c6\u5408\uff1a{}", (Object)JSONObject.toJSONString((Object)detailEntityList));
            if (CollectionUtils.isNotEmpty((Collection)detailEntityList)) {
                for (OutRentParameterDetailEntity detailEntity : detailEntityList) {
                    if (!startSubDateMap.containsKey(detailEntity.getParameterId())) continue;
                    detailEntity.setOperationDate((Date)startSubDateMap.get(detailEntity.getParameterId()));
                }
            }
            this.outRentParameterDetailService.saveOrUpdateBatch(detailEntityList, detailEntityList.size(), false);
        }
        this.logger.info("\u63a8\u9001\u53f0\u8d26\u6570\u636eparameterList\uff1a{}", (Object)JSONObject.toJSONString(parameterList));
        this.outRentParameterService.changeParameter(parameterList, RentParameterTypeEnum.\u542f\u7528\u5355.getCode());
        this.logger.info("\u63a8\u9001\u9879\u76ee\u65b9\u6570\u636eentity\uff1a{}", (Object)JSONObject.toJSONString((Object)((Object)entity)));
        if (entity.getRentHarborType() == 1) {
            OutRentEquipmentStartVO startVO = (OutRentEquipmentStartVO)BeanMapper.map((Object)((Object)entity), OutRentEquipmentStartVO.class);
            startVO.setOrgId(entity.getOutOrgId());
            startVO.setOrgName(entity.getOutOrgName());
            startVO.setOrgCode(entity.getOutOrgCode());
            startVO.setCompanyId(entity.getParentOrgId());
            startVO.setCompanyName(entity.getParentOrgName());
            startVO.setOrganizationDate(entity.getCreateTime());
            this.logger.info("startVO\uff1a{}", (Object)JSONObject.toJSONString((Object)startVO));
            startVO.setRentEquipmentStartSubList(BeanMapper.mapList(entity.getOutRentEquipmentStartSubList(), OutRentEquipmentStartSubVO.class));
            for (OutRentEquipmentStartSubVO startSubVO : startVO.getRentEquipmentStartSubList()) {
                startSubVO.setCategoryName(startSubVO.getEquipmentType());
                startSubVO.setName(startSubVO.getEquipmentName());
            }
            CommonResponse response = this.receiptsApi.receiptsSync((JSONObject)JSONObject.toJSON((Object)startVO), RentReceiptsEnum.\u542f\u7528\u5355.getName());
            if (!response.isSuccess()) {
                throw new BusinessException(response.getMsg());
            }
            this.logger.info("\u63a8\u9001\u9879\u76ee\u65b9\u6570\u636e\u6210\u529f\uff0c\u7ed3\u679c\u4fe1\u606f\uff1a{}", (Object)JSONObject.toJSONString((Object)response.getMsg()));
        }
        return CommonResponse.success((String)"\u5ba1\u6279\u56de\u8c03\u6210\u529f\uff01");
    }

    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        OutRentEquipmentStartEntity entity = (OutRentEquipmentStartEntity)((Object)this.outRentEquipmentStartService.selectById(billId));
        List<Long> parameterIdList = entity.getOutRentEquipmentStartSubList().stream().map(OutRentEquipmentStartSubEntity::getSourceId).collect(Collectors.toList());
        this.outRentParameterService.checkNoEffectData(parameterIdList, billId, entity.getContractId());
        if (entity.getSignStatus() == 1) {
            throw new BusinessException("\u5df2\u7b7e\u5b57\u4e0d\u80fd\u64a4\u56de\uff01");
        }
        OutRentContractEntity contractEntity = (OutRentContractEntity)((Object)this.contractService.selectById(entity.getContractId()));
        if (contractEntity != null && PerformanceStatusEnum.\u5df2\u7ec8\u6b62.getCode().equals(contractEntity.getContractPerformanceState())) {
            return CommonResponse.error((String)"\u5408\u540c\u5df2\u7ec8\u6b62\uff0c\u8be5\u5355\u636e\u4e0d\u80fd\u64a4\u56de\uff01");
        }
        List<OutRentEquipmentStartSubEntity> outRentEquipmentStartSubEntityList = entity.getOutRentEquipmentStartSubList();
        List<Long> outRentParameterIds = outRentEquipmentStartSubEntityList.stream().map(OutRentEquipmentStartSubEntity::getSourceId).collect(Collectors.toList());
        this.logger.info("\u63a8\u9001\u53f0\u8d26\u6570\u636eparameterIdList\uff1a{}", (Object)JSONObject.toJSONString(outRentParameterIds));
        for (OutRentEquipmentStartSubEntity subEntity : outRentEquipmentStartSubEntityList) {
            QueryParam queryParam = new QueryParam();
            queryParam.getParams().put("parameterId", new Parameter("eq", (Object)subEntity.getSourceId()));
            queryParam.getOrderMap().put("operationDate", "desc");
            List detailEntityList = this.outRentParameterDetailService.queryList(queryParam, false);
            if (!CollectionUtils.isNotEmpty((Collection)detailEntityList)) continue;
            OutRentParameterDetailEntity detailEntity = (OutRentParameterDetailEntity)((Object)detailEntityList.get(0));
            if (detailEntityList.size() <= 1 || billId.equals(detailEntity.getSourceId())) continue;
            return CommonResponse.error((String)"\u5f03\u5ba1\u5931\u8d25:\u8be5\u5355\u636e\u5df2\u5b58\u5728\u4e0b\u6e38\u5355\u636e\u6216\u5df2\u505a\u79df\u91d1\u8ba1\u7b97\uff0c\u8bf7\u68c0\u67e5");
        }
        if (EntranceRentFlagEnum.\u662f.getCode().equals(entity.getEntranceRentFlag())) {
            UpdateWrapper updateWrapper = new UpdateWrapper();
            updateWrapper.in((Object)"id", outRentParameterIds);
            updateWrapper.set((Object)"meter_rent_date", null);
            updateWrapper.set((Object)"start_date", null);
            updateWrapper.set((Object)"operation_date", (Object)new Date());
            updateWrapper.set((Object)"equipment_state", (Object)OutRentEquipmentStateEnum.\u5f85\u542f\u7528.getCode());
            updateWrapper.set((Object)"equipment_state_name", (Object)OutRentEquipmentStateEnum.\u5f85\u542f\u7528.getDescription());
            this.outRentParameterService.update((Wrapper)updateWrapper);
            UpdateWrapper detailUpdateWrapper = new UpdateWrapper();
            detailUpdateWrapper.in((Object)"parameter_id", outRentParameterIds);
            detailUpdateWrapper.set((Object)"operation_date", null);
            this.outRentParameterDetailService.update((Wrapper)detailUpdateWrapper);
            QueryParam updateParam = new QueryParam();
            updateParam.getParams().put("id", new Parameter("in", outRentParameterIds));
            List updateList = this.outRentParameterService.queryList(updateParam, false);
            JSONArray jsonArray = JSONArray.parseArray((String)JSONObject.toJSONString((Object)updateList));
            this.receiptsApi.updateEquipmentState(jsonArray, Boolean.valueOf(true));
        } else {
            this.outRentParameterService.cancelParameter(outRentParameterIds, RentParameterTypeEnum.\u542f\u7528\u5355.getCode(), entity.getId());
        }
        if (entity.getRentHarborType() == 1) {
            CommonResponse response = this.receiptsApi.delReceipts(entity.getId(), RentReceiptsEnum.\u542f\u7528\u5355.getName());
            if (!response.isSuccess()) {
                throw new BusinessException(response.getMsg());
            }
            this.logger.info("\u63a8\u9001\u9879\u76ee\u65b9\u6570\u636e\u6210\u529f\uff0c\u7ed3\u679c\u4fe1\u606f\uff1a{}", (Object)JSONObject.toJSONString((Object)response.getMsg()));
        }
        return CommonResponse.success((String)"\u5ba1\u6279\u56de\u8c03\u6210\u529f\uff01");
    }
}

