/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.proequipmentcorprent.ac.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.contractbase.api.IParamCheckApi;
import com.ejianc.business.contractbase.filing.enums.FilingStatusEnum;
import com.ejianc.business.contractbase.pool.contractpool.api.IContractPoolApi;
import com.ejianc.business.contractbase.pool.contractpool.vo.ContractPoolVO;
import com.ejianc.business.proequipmentcorprent.ac.bean.ChangeDetailEntity;
import com.ejianc.business.proequipmentcorprent.ac.bean.ChangeEntity;
import com.ejianc.business.proequipmentcorprent.ac.bean.ChangeOtherCostEntity;
import com.ejianc.business.proequipmentcorprent.ac.bean.ContractClauseEntity;
import com.ejianc.business.proequipmentcorprent.ac.bean.ContractDetailEntity;
import com.ejianc.business.proequipmentcorprent.ac.bean.ContractEntity;
import com.ejianc.business.proequipmentcorprent.ac.bean.ContractOtherCostEntity;
import com.ejianc.business.proequipmentcorprent.ac.bean.ContractPaymentEntity;
import com.ejianc.business.proequipmentcorprent.ac.bean.RecordEntity;
import com.ejianc.business.proequipmentcorprent.ac.enums.BillTypeEnum;
import com.ejianc.business.proequipmentcorprent.ac.enums.ChangeStatusEnum;
import com.ejianc.business.proequipmentcorprent.ac.enums.ChangeTypeEnum;
import com.ejianc.business.proequipmentcorprent.ac.enums.DraftTypeEnum;
import com.ejianc.business.proequipmentcorprent.ac.mapper.ChangeMapper;
import com.ejianc.business.proequipmentcorprent.ac.service.IChangeAsyncService;
import com.ejianc.business.proequipmentcorprent.ac.service.IChangeService;
import com.ejianc.business.proequipmentcorprent.ac.service.IContractClauseService;
import com.ejianc.business.proequipmentcorprent.ac.service.IContractPaymentService;
import com.ejianc.business.proequipmentcorprent.ac.service.IContractService;
import com.ejianc.business.proequipmentcorprent.ac.service.IRecordService;
import com.ejianc.business.proequipmentcorprent.ac.utils.TreeNodeBUtil;
import com.ejianc.business.proequipmentcorprent.ac.vo.ChangeClauseVO;
import com.ejianc.business.proequipmentcorprent.ac.vo.ChangeCompareVO;
import com.ejianc.business.proequipmentcorprent.ac.vo.ChangeDetailVO;
import com.ejianc.business.proequipmentcorprent.ac.vo.ChangeOtherCostVO;
import com.ejianc.business.proequipmentcorprent.ac.vo.ChangePaymentVO;
import com.ejianc.business.proequipmentcorprent.ac.vo.ChangeVO;
import com.ejianc.business.proequipmentcorprent.ac.vo.ContractVO;
import com.ejianc.business.proequipmentcorprent.rent.enums.PerformanceStatusEnum;
import com.ejianc.business.proequipmentcorprent.rent.enums.SignatureStatusEnum;
import com.ejianc.business.signaturemanage.api.ISignatureCommonApi;
import com.ejianc.business.signaturemanage.vo.WatermarkVO;
import com.ejianc.business.targetcost.api.IExecutionApi;
import com.ejianc.business.targetcost.enums.BillCategoryEnum;
import com.ejianc.business.targetcost.enums.BussinessTypeEnum;
import com.ejianc.business.targetcost.vo.ExecutionVO;
import com.ejianc.business.targetcost.vo.ParamsCheckDsVO;
import com.ejianc.business.targetcost.vo.ParamsCheckVO;
import com.ejianc.business.targetcost.vo.TotalExecutionVO;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.api.IParamConfigApi;
import com.ejianc.foundation.support.vo.BillParamVO;
import com.ejianc.foundation.support.vo.ParamRegisterSetVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@Service(value="changeService")
public class ChangeServiceImpl
extends BaseServiceImpl<ChangeMapper, ChangeEntity>
implements IChangeService {
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IContractService contractService;
    @Autowired
    private IChangeService changeService;
    @Autowired
    private IRecordService recordService;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IContractClauseService contractClauseService;
    @Autowired
    private IContractPoolApi contractPoolApi;
    @Autowired
    private IContractPaymentService contractPaymentService;
    @Autowired
    private ChangeMapper changeMapper;
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IAttachmentApi attachmentApi;
    @Autowired
    private IParamCheckApi paramCheckApi;
    @Value(value="${common.env.base-host}")
    private String baseHost;
    @Value(value="${refer.base-host:null}")
    private String BASE_HOST_FRONTEND;
    @Autowired
    private IExecutionApi executionApi;
    @Autowired
    private IParamConfigApi paramConfigApi;
    private static final String CHECK_PARAM_CODE = "P-r5n4tW71";
    @Autowired
    ISignatureCommonApi signatureCommonApi;
    @Autowired
    private IChangeAsyncService changeAsyncService;
    private static final String WATERMARK_CHECK_PARAM_NAME = "P-00a9W886";
    private final String CONTRACT_FILE_SOURCE_TYPE = "subContractFile";
    private final String CONTRACT_ATTACH_SOURCE_TYPE = "subContractBill";
    private static final String BILL_TYPE = "EJCBT202204000008";
    private static final String CHANGE_BILL_TYPE = "EJCBT202204000010";
    private final String LABORSUB_Bill_CODE = "EJCBT202204000008";
    private final String LABORSUB_RECORD_Bill_CODE = "EJCBT202207000037";

    @Override
    public ChangeVO queryDetailRecord(Long id) {
        ContractEntity contractEntity = (ContractEntity)((Object)this.contractService.selectById(id));
        ChangeVO changeVO = new ChangeVO();
        changeVO.setId(id);
        changeVO.setBaseTaxMny(contractEntity.getBaseTaxMny() == null ? BigDecimal.ZERO : contractEntity.getBaseTaxMny());
        changeVO.setContractTaxMny(contractEntity.getContractTaxMny() == null ? BigDecimal.ZERO : contractEntity.getContractTaxMny());
        QueryParam param = new QueryParam();
        param.getParams().put("contract_id", new Parameter("eq", (Object)id));
        param.getParams().put("performance_status", new Parameter("eq", (Object)PerformanceStatusEnum.\u5c65\u7ea6\u4e2d.getCode()));
        param.getOrderMap().put("change_date", "desc");
        param.getOrderMap().put("create_time", "desc");
        Map resp = new HashMap();
        QueryWrapper wrapper = ChangeServiceImpl.changeToQueryWrapper((QueryParam)param);
        wrapper.select(new String[]{"sum(change_mny) as sumChangeMoney, count(*) as changeNum"});
        resp = super.getMap((Wrapper)wrapper);
        changeVO.setChangeList(BeanMapper.mapList((Iterable)this.queryList(param), ChangeVO.class));
        BigDecimal sumChangeMoney = null != resp.get("sumChangeMoney") ? new BigDecimal(resp.get("sumChangeMoney").toString()) : BigDecimal.ZERO;
        BigDecimal changeAmtRate = BigDecimal.ZERO;
        if (null != contractEntity.getBaseTaxMny() && contractEntity.getBaseTaxMny().compareTo(BigDecimal.ZERO) > 0) {
            changeAmtRate = sumChangeMoney.divide(contractEntity.getBaseTaxMny(), 8, 5).multiply(new BigDecimal(100));
        }
        changeVO.setAllChangeMny(sumChangeMoney);
        Long changeNum = (Long)resp.get("changeNum");
        changeVO.setChangeNum(changeNum != null ? Integer.valueOf(String.valueOf(changeNum)) : 0);
        changeVO.setChangeMnyRate(changeAmtRate);
        changeVO.setSupplementFlag(contractEntity.getSupplementFlag());
        changeVO.setAddType(contractEntity.getAddType());
        changeVO.setContractType(contractEntity.getContractType());
        if (SignatureStatusEnum.\u5df2\u7b7e\u7ae0.getCode().equals(contractEntity.getSignatureStatus()) && (BillStateEnum.PASSED_STATE.getBillStateCode().equals(contractEntity.getBillState()) || BillStateEnum.COMMITED_STATE.getBillStateCode().equals(contractEntity.getBillState())) && !PerformanceStatusEnum.\u5df2\u4f5c\u5e9f.getCode().equals(contractEntity.getPerformanceStatus()) && !PerformanceStatusEnum.\u5df2\u51bb\u7ed3.getCode().equals(contractEntity.getPerformanceStatus())) {
            changeVO.setEditFlag(this.editChangeFlag(id));
        } else {
            changeVO.setEditFlag(false);
        }
        return changeVO;
    }

    @Override
    public Boolean editChangeFlag(Long contractId) {
        LambdaQueryWrapper lambda = new LambdaQueryWrapper();
        lambda.eq(ChangeEntity::getContractId, (Object)contractId);
        lambda.and(l -> (LambdaQueryWrapper)((LambdaQueryWrapper)l.ne(ChangeEntity::getSignatureStatus, (Object)SignatureStatusEnum.\u5df2\u7b7e\u7ae0.getCode())).or(c -> (LambdaQueryWrapper)c.notIn(ChangeEntity::getBillState, new Object[]{BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode()})));
        List changeList = super.list((Wrapper)lambda);
        if (changeList.size() > 0) {
            return false;
        }
        return true;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ChangeVO insertOrUpdate(ChangeVO changeVO) {
        List<ChangeDetailEntity> beforeDetails;
        String frontendBaseHost = "";
        frontendBaseHost = StringUtils.isNotBlank((CharSequence)this.BASE_HOST_FRONTEND) && !"null".equals(this.BASE_HOST_FRONTEND) ? this.BASE_HOST_FRONTEND : this.baseHost;
        ContractEntity contract = (ContractEntity)((Object)this.contractService.selectById(changeVO.getContractId()));
        if (CollectionUtils.isNotEmpty((Collection)changeVO.getAttachIds()) && null != contract.getContractFileId()) {
            changeVO.getAttachIds().remove(contract.getContractFileId());
        }
        ChangeEntity changeEntity = (ChangeEntity)((Object)BeanMapper.map((Object)((Object)changeVO), ChangeEntity.class));
        LambdaQueryWrapper lambdachange = Wrappers.lambdaQuery();
        lambdachange.eq(ChangeEntity::getContractId, (Object)changeVO.getContractId());
        if (changeVO.getId() != null) {
            lambdachange.ne(BaseEntity::getId, (Object)changeVO.getId());
        }
        lambdachange.and(l -> (LambdaQueryWrapper)((LambdaQueryWrapper)l.ne(ChangeEntity::getSignatureStatus, (Object)SignatureStatusEnum.\u5df2\u7b7e\u7ae0.getCode())).or(c -> (LambdaQueryWrapper)c.notIn(ChangeEntity::getBillState, new Object[]{BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode()})));
        int num = super.count((Wrapper)lambdachange);
        if (num > 0) {
            throw new BusinessException("\u8be5\u5408\u540c\u5df2\u5b58\u5728\u672a\u751f\u6548\u7684\u53d8\u66f4\u5355!");
        }
        if (changeEntity.getId() == null) {
            changeEntity.setSignatureStatus(SignatureStatusEnum.\u672a\u7b7e\u7ae0.getCode());
            changeEntity.setBillState(BillStateEnum.UNCOMMITED_STATE.getBillStateCode());
            changeEntity.setPerformanceStatus(PerformanceStatusEnum.\u672a\u7b7e\u8ba2.getCode());
            if (changeEntity.getChangeVersion() < 10) {
                changeEntity.setBillCode(changeEntity.getBillCode() + "-1-0" + changeEntity.getChangeVersion());
            } else {
                changeEntity.setBillCode(changeEntity.getBillCode() + "-1-" + changeEntity.getChangeVersion());
            }
        }
        if (CollectionUtils.isNotEmpty(beforeDetails = changeEntity.getDetailList())) {
            HashMap<String, Long> idMap = new HashMap<String, Long>();
            for (ChangeDetailEntity detail : beforeDetails) {
                if (null == changeVO.getId() || null == detail.getId()) {
                    detail.setId(IdWorker.getId());
                }
                idMap.put(detail.getTid(), detail.getId());
                detail.setParentId(null);
            }
            for (ChangeDetailEntity detail : beforeDetails) {
                if (!StringUtils.isNotEmpty((CharSequence)detail.getTpid())) continue;
                detail.setParentId((Long)idMap.get(detail.getTpid()));
            }
        }
        changeEntity.setFilingRef(0);
        if (changeVO.getId() == null) {
            ExecutionVO executionVO1;
            QueryWrapper wrapper = new QueryWrapper();
            ((QueryWrapper)((QueryWrapper)wrapper.eq((Object)"contract_id", (Object)changeVO.getContractId())).eq((Object)"dr", (Object)0)).orderByDesc((Object)"create_time");
            List list = this.changeService.list((Wrapper)wrapper);
            ArrayList<TotalExecutionVO> totalExecutionVOList = new ArrayList<TotalExecutionVO>();
            if (list.size() > 0) {
                ChangeEntity changeEntity1 = (ChangeEntity)((Object)list.get(0));
                String changeLinkUrl = frontendBaseHost + "ejc-proequipment-frontend/#/otherSubList/changeCard?id=" + changeEntity1.getId() + "&cardType=otherSubCard";
                executionVO1 = this.contractService.targetCost((ContractVO)((Object)BeanMapper.map((Object)((Object)changeEntity1), ContractVO.class)), changeLinkUrl, changeEntity1.getContractType());
            } else {
                ContractEntity contractEntity = (ContractEntity)((Object)this.contractService.selectById(changeVO.getContractId()));
                String linkUrl = frontendBaseHost + "ejc-proequipment-frontend/#/otherSubList/card?id=" + contractEntity.getId() + "&cardType=otherSubDirectCard";
                executionVO1 = this.contractService.targetCost((ContractVO)((Object)BeanMapper.map((Object)((Object)contractEntity), ContractVO.class)), linkUrl, contractEntity.getContractType());
            }
            totalExecutionVOList.add(executionVO1.getTotalVO());
            this.logger.info("\u76ee\u6807\u6210\u672c\u63a8\u9001\u6570\u636e" + JSON.toJSONString(totalExecutionVOList));
            CommonResponse response = this.executionApi.aggDel(totalExecutionVOList);
            if (!response.isSuccess()) {
                throw new BusinessException("\u76ee\u6807\u6210\u672c\u63a8\u9001\u5931\u8d25," + response.getMsg());
            }
        }
        super.saveOrUpdate((Object)changeEntity, false);
        this.saveWriteContract(changeEntity);
        String changeLinkUrl = frontendBaseHost + "ejc-proequipment-frontend/#/otherSubList/changeCard?id=" + changeEntity.getId() + "&cardType=otherSubCard";
        ExecutionVO executionVO = this.contractService.targetCost((ContractVO)((Object)BeanMapper.map((Object)((Object)changeEntity), ContractVO.class)), changeLinkUrl, changeEntity.getContractType());
        this.logger.info("\u76ee\u6807\u6210\u672c\u63a8\u9001\u6570\u636e" + JSON.toJSONString((Object)executionVO));
        CommonResponse response = this.executionApi.aggPush(executionVO);
        if (!response.isSuccess()) {
            throw new BusinessException("\u76ee\u6807\u6210\u672c\u63a8\u9001\u5931\u8d25," + response.getMsg());
        }
        return this.queryDetail(changeEntity.getId());
    }

    private void saveWriteContract(ChangeEntity changeEntity) {
        LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
        updateWrapper.set(ContractEntity::getChangeId, (Object)changeEntity.getId());
        if (null != changeEntity.getChangeMny() && null != changeEntity.getChangeTax()) {
            updateWrapper.set(ContractEntity::getChangingMny, (Object)changeEntity.getChangeMny().subtract(changeEntity.getChangeTax()));
        }
        updateWrapper.set(ContractEntity::getChangingTaxMny, (Object)changeEntity.getChangeMny());
        updateWrapper.set(ContractEntity::getChangeCode, (Object)changeEntity.getBillCode());
        updateWrapper.set(ContractEntity::getChangeVersion, (Object)changeEntity.getChangeVersion());
        updateWrapper.set(ContractEntity::getChangeStatus, (Object)ChangeStatusEnum.\u53d8\u66f4\u4e2d.getCode());
        updateWrapper.set(ContractEntity::getChangeDate, (Object)changeEntity.getChangeDate());
        updateWrapper.set(ContractEntity::getChangeDraftType, (Object)changeEntity.getChangeDraftType());
        updateWrapper.set(ContractEntity::getChangeContractSignatureStatus, (Object)Integer.valueOf(changeEntity.getSignatureStatus()));
        updateWrapper.set(ContractEntity::getChangeFileId, (Object)changeEntity.getChangeFileId());
        updateWrapper.set(ContractEntity::getChangeContractName, (Object)changeEntity.getContractName());
        updateWrapper.eq(BaseEntity::getId, (Object)changeEntity.getContractId());
        this.contractService.update(this.contractService.selectById(changeEntity.getContractId()), (Wrapper)updateWrapper, false);
    }

    @Override
    public ChangeVO queryDetail(Long id) {
        HashMap orderMap = new HashMap();
        LinkedHashMap<String, String> orderParams = new LinkedHashMap<String, String>();
        orderParams.put("treeIndex", "asc");
        orderMap.put("detailList", orderParams);
        orderMap.put("otherCostList", orderParams);
        ChangeEntity changeEntity = (ChangeEntity)((Object)super.selectById((Serializable)id, orderMap));
        ChangeVO changeVO = new ChangeVO();
        if (null != changeEntity) {
            changeVO = (ChangeVO)((Object)BeanMapper.map((Object)((Object)changeEntity), ChangeVO.class));
        }
        ArrayList<Long> srcTblIdList = new ArrayList<Long>();
        if (CollectionUtils.isNotEmpty(changeVO.getDetailList())) {
            for (ChangeDetailVO detail : changeVO.getDetailList()) {
                detail.setTid(detail.getId().toString());
                detail.setTpid(detail.getParentId() != null ? detail.getParentId().toString() : null);
                srcTblIdList.add(detail.getSrcTblId());
            }
            changeVO.setDetailList(TreeNodeBUtil.buildTree(changeVO.getDetailList()));
        }
        return changeVO;
    }

    @Override
    public ChangeVO addConvertByConId(Long contractId, Long changeId) {
        HashMap orderMap = new HashMap();
        LinkedHashMap<String, String> orderParams = new LinkedHashMap<String, String>();
        orderParams.put("treeIndex", "asc");
        orderMap.put("detailList", orderParams);
        orderMap.put("otherCostList", orderParams);
        ContractEntity contractEntity = (ContractEntity)((Object)this.contractService.selectById(contractId, orderMap));
        if (ChangeStatusEnum.\u53d8\u66f4\u4e2d.getCode().equals(contractEntity.getChangeStatus()) && null == changeId) {
            return this.queryDetail(contractEntity.getChangeId());
        }
        ChangeVO changeVO = (ChangeVO)((Object)BeanMapper.map((Object)((Object)contractEntity), ChangeVO.class));
        changeVO.setBillState(null);
        changeVO.setBeforeChangeMny(contractEntity.getContractMny());
        changeVO.setBeforeChangeTaxMny(contractEntity.getContractTaxMny());
        changeVO.setBeforeContractName(contractEntity.getContractName());
        changeVO.setChangeDraftType(DraftTypeEnum.\u4e0a\u4f20\u5408\u540c.getCode().toString());
        changeVO.setContractId(contractId);
        changeVO.setChangeVersion(contractEntity.getChangeVersion() == null ? 1 : contractEntity.getChangeVersion() + 1);
        changeVO.setSignatureStatus(SignatureStatusEnum.\u672a\u7b7e\u7ae0.getCode());
        contractEntity.setChangingMny(BigDecimal.ZERO);
        contractEntity.setChangingTaxMny(BigDecimal.ZERO);
        changeVO.setCreateUserCode(null);
        changeVO.setCreateTime(null);
        changeVO.setUpdateUserCode(null);
        changeVO.setUpdateTime(null);
        changeVO.setChangeDate(new Date());
        changeVO.setId(null);
        changeVO.setCommitDate(null);
        changeVO.setCommitUserCode(null);
        changeVO.setCommitUserName(null);
        changeVO.setEffectiveDate(null);
        changeVO.setChangeFileId(null);
        changeVO.setChangeFilePath(null);
        changeVO.setChangeFilingStatus(FilingStatusEnum.\u672a\u5f52\u6863.getTypeCode());
        this.resetSub(changeVO);
        return changeVO;
    }

    private void resetSub(ChangeVO changeVO) {
        List<ChangePaymentVO> payList;
        List<ChangeClauseVO> changeClauseList;
        List<ChangeDetailVO> changeDetailList = changeVO.getDetailList();
        if (CollectionUtils.isNotEmpty(changeDetailList)) {
            ArrayList srcTblIdList = new ArrayList();
            changeDetailList.forEach(changeDetailVO -> {
                changeDetailVO.setSrcTblId(changeDetailVO.getId());
                changeDetailVO.setBeforeChangeNum(changeDetailVO.getDetailNum());
                changeDetailVO.setBeforeChangePrice(changeDetailVO.getDetailPrice());
                changeDetailVO.setBeforeChangeRate(changeDetailVO.getDetailTaxRate());
                changeDetailVO.setTid(changeDetailVO.getId().toString());
                changeDetailVO.setTpid(changeDetailVO.getParentId() != null ? changeDetailVO.getParentId().toString() : null);
                changeDetailVO.setRowState("edit");
                srcTblIdList.add(changeDetailVO.getSrcTblId());
            });
        }
        changeVO.setDetailList(TreeNodeBUtil.buildTree(changeDetailList));
        List<ChangeOtherCostVO> changeOtherCostVOList = changeVO.getOtherCostList();
        if (CollectionUtils.isNotEmpty(changeOtherCostVOList)) {
            changeOtherCostVOList.forEach(changeOtherCostVO -> {
                changeOtherCostVO.setSrcTblId(changeOtherCostVO.getId());
                changeOtherCostVO.setBeforeChangeCostNum(changeOtherCostVO.getCostNum());
                changeOtherCostVO.setBeforeChangeCostPrice(changeOtherCostVO.getCostPrice());
                changeOtherCostVO.setBeforeChangeCostRate(changeOtherCostVO.getCostTaxRate());
                changeOtherCostVO.setRowState("edit");
            });
        }
        if (CollectionUtils.isNotEmpty(changeClauseList = changeVO.getClauseList())) {
            changeClauseList.forEach(changeClauseVO -> {
                changeClauseVO.setRowState("add");
                changeClauseVO.setSrcTblId(changeClauseVO.getId());
                changeClauseVO.setBeforeClauseContent(changeClauseVO.getClauseContent());
            });
        }
        if (CollectionUtils.isNotEmpty(payList = changeVO.getPaymentList())) {
            payList.forEach(item -> {
                item.setRowState("add");
                item.setSrcTblId(item.getId());
                item.setBeforePaymentScale(item.getPaymentScale());
            });
        }
    }

    @Override
    public CommonResponse<String> deleteById(Long changeBillId) {
        String frontendBaseHost = "";
        frontendBaseHost = StringUtils.isNotBlank((CharSequence)this.BASE_HOST_FRONTEND) && !"null".equals(this.BASE_HOST_FRONTEND) ? this.BASE_HOST_FRONTEND : this.baseHost;
        ChangeEntity entity = (ChangeEntity)((Object)super.selectById((Serializable)changeBillId));
        ArrayList<TotalExecutionVO> totalExecutionVOList = new ArrayList<TotalExecutionVO>();
        ArrayList<Object> contractEntityList = new ArrayList<Object>();
        ExecutionVO executionVO = this.contractService.targetCost((ContractVO)((Object)BeanMapper.map((Object)((Object)entity), ContractVO.class)), "", entity.getContractType());
        totalExecutionVOList.add(executionVO.getTotalVO());
        contractEntityList.add(this.contractService.selectById(entity.getContractId()));
        this.logger.info("\u76ee\u6807\u6210\u672c\u5220\u9664\u6570\u636e" + JSON.toJSONString(totalExecutionVOList));
        CommonResponse response = this.executionApi.aggDel(totalExecutionVOList);
        if (!response.isSuccess()) {
            throw new BusinessException("\u76ee\u6807\u6210\u672c\u63a8\u9001\u5931\u8d25," + response.getMsg());
        }
        for (ContractEntity contractEntity : contractEntityList) {
            ExecutionVO executionVO1;
            List contractChangeEntityList = this.changeService.list((Wrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().eq((Object)"contract_id", (Object)contractEntity.getId())).eq((Object)"dr", (Object)0)).orderByDesc((Object)"create_time"));
            if (contractChangeEntityList.size() > 1) {
                String changeLinkUrl = frontendBaseHost + "ejc-proequipment-frontend/#/otherSubList/changeCard?id=" + ((ChangeEntity)((Object)contractChangeEntityList.get(1))).getId() + "&cardType=otherSubCard";
                executionVO1 = this.contractService.targetCost((ContractVO)((Object)BeanMapper.map(contractChangeEntityList.get(1), ContractVO.class)), changeLinkUrl, ((ChangeEntity)((Object)contractChangeEntityList.get(1))).getContractType());
            } else {
                String linkUrl = frontendBaseHost + "ejc-proequipment-frontend/#/otherSubList/card?id=" + contractEntity.getId() + "&cardType=otherSubDirectCard";
                executionVO1 = this.contractService.targetCost((ContractVO)((Object)BeanMapper.map((Object)((Object)contractEntity), ContractVO.class)), linkUrl, contractEntity.getContractType());
            }
            this.logger.info("\u76ee\u6807\u6210\u672c\u63a8\u9001\u6570\u636e" + JSON.toJSONString((Object)executionVO1));
            CommonResponse response1 = this.executionApi.aggPush(executionVO1);
            if (response1.isSuccess()) continue;
            throw new BusinessException("\u76ee\u6807\u6210\u672c\u63a8\u9001\u5931\u8d25," + response1.getMsg());
        }
        ContractEntity contractEntity = (ContractEntity)((Object)this.contractService.selectById(entity.getContractId()));
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"contract_id", (Object)contractEntity.getId());
        queryWrapper.eq((Object)"dr", (Object)BaseVO.DR_UNDELETE);
        queryWrapper.ne((Object)"id", (Object)changeBillId);
        int count = super.count((Wrapper)queryWrapper);
        contractEntity.setChangeVersion(contractEntity.getChangeVersion() - 1);
        contractEntity.setChangeStatus(count > 0 ? ChangeStatusEnum.\u5df2\u53d8\u66f4.getCode() : ChangeStatusEnum.\u672a\u53d8\u66f4.getCode());
        contractEntity.setChangingMny(BigDecimal.ZERO);
        contractEntity.setChangingTaxMny(BigDecimal.ZERO);
        contractEntity.setChangeCode(null);
        contractEntity.setChangeId(null);
        contractEntity.setChangeDate(null);
        contractEntity.setChangeDraftType(null);
        contractEntity.setChangeContractSignatureStatus(null);
        contractEntity.setChangeFileId(null);
        contractEntity.setChangeContractName(null);
        this.contractService.update((Object)contractEntity, (Wrapper)new QueryWrapper().eq((Object)"id", (Object)contractEntity.getId()), false);
        super.removeById((Serializable)changeBillId, false);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @Override
    public Map<String, Object> queryChangeCompare(Long id) {
        LinkedHashMap<String, String> orderByParams = new LinkedHashMap<String, String>();
        orderByParams.put("treeIndex", "asc");
        HashMap<String, LinkedHashMap<String, String>> orders = new HashMap<String, LinkedHashMap<String, String>>();
        orders.put("detailList", orderByParams);
        ChangeEntity changeEntity = (ChangeEntity)((Object)super.selectById((Serializable)id, orders));
        ChangeCompareVO changeCompareVO = (ChangeCompareVO)BeanMapper.map((Object)((Object)changeEntity), ChangeCompareVO.class);
        ContractEntity contractEntity = (ContractEntity)((Object)this.contractService.selectById(changeEntity.getContractId()));
        ChangeCompareVO beforeChangeVO = new ChangeCompareVO();
        Map<Object, Object> beforeDetailMap = new HashMap();
        Map<Object, Object> beforeFeeMap = new HashMap();
        Map<Object, Object> beforeClauseMap = new HashMap();
        Map<Object, Object> beforeStageMap = new HashMap();
        if (BillStateEnum.PASSED_STATE.getBillStateCode().equals(changeEntity.getBillState())) {
            LambdaQueryWrapper lambda = Wrappers.lambdaQuery();
            ((LambdaQueryWrapper)((LambdaQueryWrapper)lambda.eq(RecordEntity::getChangeId, (Object)id)).eq(RecordEntity::getContractId, (Object)changeEntity.getContractId())).orderByDesc(BaseEntity::getCreateTime);
            List recordList = this.recordService.list((Wrapper)lambda);
            if (recordList != null && recordList.size() > 0 && recordList.get(0) != null) {
                beforeChangeVO = (ChangeCompareVO)BeanMapper.map(recordList.get(0), ChangeCompareVO.class);
                beforeDetailMap = beforeChangeVO.getDetailList().stream().collect(Collectors.toMap(ChangeDetailVO::getSrcTblId, detail -> detail, (v1, v2) -> v2));
                beforeFeeMap = beforeChangeVO.getOtherCostList().stream().collect(Collectors.toMap(ChangeOtherCostVO::getSrcTblId, fee -> fee, (v1, v2) -> v2));
                beforeClauseMap = beforeChangeVO.getClauseList().stream().collect(Collectors.toMap(ChangeClauseVO::getSrcTblId, clause -> clause, (v1, v2) -> v2));
                beforeStageMap = beforeChangeVO.getPaymentList().stream().collect(Collectors.toMap(ChangePaymentVO::getSrcTblId, item -> item, (v1, v2) -> v2));
            }
        } else {
            beforeChangeVO = (ChangeCompareVO)BeanMapper.map((Object)((Object)contractEntity), ChangeCompareVO.class);
            beforeDetailMap = beforeChangeVO.getDetailList().stream().collect(Collectors.toMap(BaseVO::getId, detail -> detail, (v1, v2) -> v2));
            beforeFeeMap = beforeChangeVO.getOtherCostList().stream().collect(Collectors.toMap(BaseVO::getId, fee -> fee, (v1, v2) -> v2));
            beforeClauseMap = beforeChangeVO.getClauseList().stream().collect(Collectors.toMap(BaseVO::getId, clause -> clause, (v1, v2) -> v2));
            beforeStageMap = beforeChangeVO.getPaymentList().stream().collect(Collectors.toMap(BaseVO::getId, item -> item, (v1, v2) -> v2));
        }
        HashMap<String, Object> returnMap = new HashMap<String, Object>();
        if (changeCompareVO != null && beforeChangeVO != null) {
            ArrayList<ChangeDetailVO> newDetail = new ArrayList<ChangeDetailVO>();
            Map<Object, Object> finalBeforeDetailMap = beforeDetailMap;
            if (CollectionUtils.isNotEmpty(changeCompareVO.getDetailList())) {
                changeCompareVO.getDetailList().stream().forEach(detail -> {
                    if (!String.valueOf(ChangeTypeEnum.\u672a\u53d8\u66f4.getCode()).equals(detail.getChangeType())) {
                        if (detail.getSrcTblId() == null) {
                            detail.setChangeType("\u589e\u8865\u9879");
                            newDetail.add((ChangeDetailVO)detail);
                        } else if (finalBeforeDetailMap.containsKey(detail.getSrcTblId())) {
                            newDetail.add((ChangeDetailVO)detail);
                            finalBeforeDetailMap.remove(detail.getSrcTblId());
                        }
                    }
                });
            }
            changeCompareVO.setDetailList(newDetail);
            ArrayList<ChangeOtherCostVO> newFee = new ArrayList<ChangeOtherCostVO>();
            Map<Object, Object> finalBeforeFeeMap = beforeFeeMap;
            if (CollectionUtils.isNotEmpty(changeCompareVO.getOtherCostList())) {
                changeCompareVO.getOtherCostList().stream().forEach(fee -> {
                    if (!String.valueOf(ChangeTypeEnum.\u672a\u53d8\u66f4.getCode()).equals(fee.getChangeType())) {
                        if (fee.getSrcTblId() == null) {
                            fee.setChangeType("\u589e\u8865\u9879");
                            newFee.add((ChangeOtherCostVO)((Object)fee));
                        } else if (finalBeforeFeeMap.containsKey(fee.getSrcTblId())) {
                            newFee.add((ChangeOtherCostVO)((Object)fee));
                            finalBeforeFeeMap.remove(fee.getSrcTblId());
                        }
                    }
                });
            }
            changeCompareVO.setOtherCostList(newFee);
            ArrayList<ChangeClauseVO> newClauses = new ArrayList<ChangeClauseVO>();
            Map<Object, Object> finalBeforeClauseMap = beforeClauseMap;
            if (CollectionUtils.isNotEmpty(changeCompareVO.getClauseList())) {
                changeCompareVO.getClauseList().stream().forEach(clause -> {
                    if (clause.getSrcTblId() == null) {
                        clause.setChangeType("\u589e\u8865\u9879");
                        newClauses.add((ChangeClauseVO)((Object)clause));
                    } else if (finalBeforeClauseMap.containsKey(clause.getSrcTblId())) {
                        if (!clause.getClauseContent().equals(clause.getBeforeClauseContent())) {
                            clause.setChangeType("\u5185\u5bb9\u53d8\u66f4");
                            newClauses.add((ChangeClauseVO)((Object)clause));
                        }
                        finalBeforeClauseMap.remove(clause.getSrcTblId());
                    }
                });
            }
            if (MapUtils.isNotEmpty(finalBeforeClauseMap)) {
                finalBeforeClauseMap.values().forEach(c -> {
                    c.setChangeType("\u5220\u9664\u9879");
                    newClauses.add((ChangeClauseVO)((Object)c));
                });
            }
            changeCompareVO.setClauseList(newClauses);
            ArrayList<ChangePaymentVO> newStageList = new ArrayList<ChangePaymentVO>();
            Map<Object, Object> finalBeforeStageMap = beforeStageMap;
            if (CollectionUtils.isNotEmpty(changeCompareVO.getPaymentList())) {
                for (ChangePaymentVO curItem : changeCompareVO.getPaymentList()) {
                    if (curItem.getSrcTblId() == null) {
                        curItem.setChangeType("\u589e\u8865\u9879");
                        newStageList.add(curItem);
                        continue;
                    }
                    if (!finalBeforeStageMap.containsKey(curItem.getSrcTblId())) continue;
                    if (curItem.getPaymentScale().compareTo(curItem.getBeforePaymentScale()) != 0) {
                        curItem.setChangeType("\u5185\u5bb9\u53d8\u66f4");
                        newStageList.add(curItem);
                    }
                    finalBeforeStageMap.remove(curItem.getSrcTblId());
                }
            }
            if (MapUtils.isNotEmpty(finalBeforeStageMap)) {
                finalBeforeStageMap.values().forEach(c -> {
                    c.setChangeType("\u5220\u9664\u9879");
                    newStageList.add((ChangePaymentVO)((Object)c));
                });
            }
            changeCompareVO.setPaymentList(newStageList);
            returnMap.put("newData", changeCompareVO);
            returnMap.put("oldData", beforeChangeVO);
        }
        return returnMap;
    }

    @Override
    public ChangeVO queryChangeRecord(Long contractId, Long changeId) {
        ContractEntity contractEntity = (ContractEntity)((Object)this.contractService.selectById(contractId));
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("contract_id", new Parameter("eq", (Object)contractEntity.getId()));
        queryParam.getParams().put("change_id", new Parameter("eq", (Object)changeId));
        queryParam.getOrderMap().put("createTime", "desc");
        List recordList = this.recordService.queryList(queryParam);
        ChangeVO changeVO = new ChangeVO();
        if (CollectionUtils.isNotEmpty((Collection)recordList)) {
            changeVO = (ChangeVO)((Object)BeanMapper.map(recordList.get(0), ChangeVO.class));
        }
        if (changeVO != null) {
            this.resetSub(changeVO);
        }
        return changeVO;
    }

    @Override
    public CommonResponse<String> effectiveSaveWriteContract(Long changeBillId, String billTypeCode, Boolean commitState, Boolean filingFlag) {
        List<ContractOtherCostEntity> contractOtherCostList;
        List<ContractDetailEntity> contractDetailList;
        CommonResponse resp = null;
        ChangeEntity changeEntity = (ChangeEntity)((Object)this.changeService.selectById(changeBillId));
        if (commitState.booleanValue()) {
            changeEntity.setCommitDate(new Date());
            changeEntity.setCommitUserCode(this.sessionManager.getUserContext().getUserCode());
            changeEntity.setCommitUserName(this.sessionManager.getUserContext().getUserName());
        }
        if (filingFlag.booleanValue()) {
            changeEntity.setChangeFilingStatus(FilingStatusEnum.\u5df2\u5f52\u6863.getTypeCode());
            changeEntity.setFilingRef(0);
        }
        this.logger.info("\u8fdb\u5165\u53d8\u66f4\u7ec8\u5ba1\uff01\u53d8\u66f4\u8868\u6570\u636e------------->: {}", (Object)JSONObject.toJSONString((Object)((Object)changeEntity)));
        ContractVO contractVO = this.contractService.queryDetail(changeEntity.getContractId());
        QueryWrapper countQuery = new QueryWrapper();
        countQuery.eq((Object)"contract_id", (Object)contractVO.getId());
        countQuery.eq((Object)"dr", (Object)BaseVO.DR_UNDELETE);
        int curRecordVersion = this.recordService.count((Wrapper)countQuery);
        HashMap contIdVersionMap = new HashMap();
        RecordEntity recordEntity = (RecordEntity)((Object)BeanMapper.map((Object)((Object)contractVO), RecordEntity.class));
        recordEntity.setContractId(recordEntity.getId());
        recordEntity.setChangeVersion(curRecordVersion + 1);
        recordEntity.setId(null);
        this.logger.info("\u53d8\u66f4\u524d\u4e3b\u5408\u540c\u6570\u636e: {}", (Object)JSONObject.toJSONString((Object)((Object)contractVO)));
        this.logger.info("\u53d8\u66f4\u524d\u4e3b\u5408\u540c\u5b50\u8868detail\u6570\u636e: {}", (Object)JSONObject.toJSONString(contractVO.getDetailList()));
        this.logger.info("\u8bb0\u5f55\u8868\u4ece\u4e3b\u5408\u540c\u8868\u590d\u5236\u7684\u6570\u636e: {}", (Object)JSONObject.toJSONString((Object)((Object)recordEntity)));
        this.logger.info("\u8bb0\u5f55\u8868\u4ece\u4e3b\u5408\u540c\u8868\u590d\u5236\u7684\u6570\u636e\u7684\u5b50\u8868detail\u6570\u636e: {}", (Object)JSONObject.toJSONString(recordEntity.getDetailList()));
        if (CollectionUtils.isNotEmpty(recordEntity.getDetailList())) {
            recordEntity.getDetailList().forEach(vo -> {
                contIdVersionMap.put(vo.getId(), vo.getVersion());
                vo.setSrcTableId(vo.getId());
                vo.setId(null);
            });
        }
        if (CollectionUtils.isNotEmpty(recordEntity.getClauseList())) {
            recordEntity.getClauseList().forEach(vo -> {
                vo.setSrcTableId(vo.getId());
                vo.setId(null);
            });
        }
        if (CollectionUtils.isNotEmpty(recordEntity.getOtherCostList())) {
            recordEntity.getOtherCostList().forEach(vo -> {
                vo.setSrcTableId(vo.getId());
                vo.setId(null);
            });
        }
        if (CollectionUtils.isNotEmpty(recordEntity.getPaymentList())) {
            recordEntity.getPaymentList().forEach(vo -> {
                vo.setSrcTableId(vo.getId());
                vo.setId(null);
            });
        }
        this.logger.info("\u8bb0\u5f55\u8868\u4ece\u4e3b\u5408\u540c\u8868\u590d\u5236\u7684\u5b50\u8868detail\u6570\u636e\uff0c\u8bbe\u7f6eid\u540e\u7684\u503c: {}", (Object)JSONObject.toJSONString(recordEntity.getDetailList()));
        this.recordService.saveOrUpdate((Object)recordEntity, false);
        this.logger.info("\u5ba1\u6279-\u53d8\u66f4\u8bb0\u5f55\u8868\u4fdd\u5b58\u4e3b\u5408\u540c\u6570\u636e\u6210\u529f\uff01");
        String srcBillCode = BILL_TYPE;
        String targetBillCode = "EJCBT202207000037";
        resp = this.copyFile(contractVO.getId().toString(), srcBillCode, recordEntity.getId().toString(), targetBillCode, "subContractBill", true);
        if (resp != null) {
            this.logger.error("\u540c\u6b65\u539f\u5408\u540c\u9644\u4ef6\u5230\u8bb0\u5f55\u5355\u636e\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a{}", (Object)JSONObject.toJSONString((Object)resp));
        }
        this.logger.info("\u66f4\u65b0\u53d8\u66f4\u6570\u636e\u5230\u4e3b\u5408\u540c\u8868,contractVO---------------->: {}", (Object)JSONObject.toJSONString((Object)((Object)contractVO)));
        ContractEntity contractEntity = (ContractEntity)((Object)BeanMapper.map((Object)((Object)contractVO), ContractEntity.class));
        contractEntity.setContractName(changeEntity.getContractName());
        contractEntity.setFirstPartyId(changeEntity.getFirstPartyId());
        contractEntity.setFirstPartyName(changeEntity.getFirstPartyName());
        contractEntity.setSupplierId(changeEntity.getSupplierId());
        contractEntity.setSupplierName(changeEntity.getSupplierName());
        contractEntity.setSignDate(changeEntity.getSignDate());
        contractEntity.setSignPlace(changeEntity.getSignPlace());
        contractEntity.setTaxRate(changeEntity.getTaxRate());
        contractEntity.setDraftType(changeEntity.getDraftType());
        contractEntity.setContractFilePath(changeEntity.getContractFilePath());
        contractEntity.setContractFileId(changeEntity.getContractFileId());
        contractEntity.setContractTemplateId(changeEntity.getContractTemplateId());
        contractEntity.setContractTemplateName(changeEntity.getContractTemplateName());
        contractEntity.setContractFileVersionId(changeEntity.getContractFileVersionId());
        contractEntity.setContractFileVersion(changeEntity.getContractFileVersion());
        contractEntity.setProjectAddress(changeEntity.getProjectAddress());
        contractEntity.setInvoiceTypeId(changeEntity.getInvoiceTypeId());
        contractEntity.setInvoiceTypeName(changeEntity.getInvoiceTypeName());
        contractEntity.setQualifyId(changeEntity.getQualifyId());
        contractEntity.setQualifyName(changeEntity.getQualifyName());
        contractEntity.setQualifyCertifyNo(changeEntity.getQualifyCertifyNo());
        contractEntity.setQualifyLicenceIssuingAuthority(changeEntity.getQualifyLicenceIssuingAuthority());
        contractEntity.setQualifyGrantDate(changeEntity.getQualifyGrantDate());
        contractEntity.setQualifyValidTillDate(changeEntity.getQualifyValidTillDate());
        contractEntity.setSafetyProductionLicenseNo(changeEntity.getSafetyProductionLicenseNo());
        contractEntity.setSafetyCertifyGrantDate(changeEntity.getSafetyCertifyGrantDate());
        contractEntity.setSafetyCertifyValidTillDate(changeEntity.getSafetyCertifyValidTillDate());
        contractEntity.setProjectStartDate(changeEntity.getProjectStartDate());
        contractEntity.setPlannedFinishDate(changeEntity.getPlannedFinishDate());
        contractEntity.setContractDaysLimit(changeEntity.getContractDaysLimit());
        contractEntity.setFirstPartyProjectManagerId(changeEntity.getFirstPartyProjectManagerId());
        contractEntity.setFirstPartyProjectManagerLink(changeEntity.getFirstPartyProjectManagerLink());
        contractEntity.setFirstPartyProjectManagerName(changeEntity.getFirstPartyProjectManagerName());
        contractEntity.setFirstPartyProjectManagerPost(changeEntity.getFirstPartyProjectManagerPost());
        contractEntity.setSupplierProjectManagerId(changeEntity.getSupplierProjectManagerId());
        contractEntity.setSupplierProjectManagerIdCard(changeEntity.getSupplierProjectManagerIdCard());
        contractEntity.setSupplierProjectManagerLink(changeEntity.getSupplierProjectManagerLink());
        contractEntity.setSupplierProjectManagerName(changeEntity.getSupplierProjectManagerName());
        contractEntity.setSupplierProjectManagerPost(changeEntity.getSupplierProjectManagerPost());
        contractEntity.setContractTaxMny(changeEntity.getContractTaxMny());
        contractEntity.setContractMny(changeEntity.getContractMny());
        contractEntity.setContractTax(changeEntity.getContractTax());
        contractEntity.setSubContractTaxMny(changeEntity.getSubContractTaxMny());
        contractEntity.setSubContractMny(changeEntity.getSubContractMny());
        contractEntity.setSubContractTax(changeEntity.getSubContractTax());
        contractEntity.setOtherCostMny(changeEntity.getOtherCostMny());
        contractEntity.setOtherCostTaxMny(changeEntity.getOtherCostTaxMny());
        contractEntity.setOtherCostTaxMny(changeEntity.getOtherCostTaxMny());
        contractEntity.setChangeStatus(ChangeStatusEnum.\u5df2\u53d8\u66f4.getCode());
        contractEntity.setChangingMny(null);
        contractEntity.setChangingTaxMny(null);
        this.logger.info("1212-\u8fdb\u5165\u53d8\u66f4\u7ec8\u5ba1\u5ba1\u6838\u5b8c\u56de\u8c03------>\u5408\u540c\u63d0\u4ea4\uff0c\u7ebf\u4e0b\u7b7e\u8ba2\u76f4\u63a5\u4fee\u6539\u7b7e\u7ae0\u72b6\u6001");
        changeEntity.setSignatureStatus(SignatureStatusEnum.\u5df2\u7b7e\u7ae0.getCode());
        changeEntity.setPerformanceStatus(PerformanceStatusEnum.\u5c65\u7ea6\u4e2d.getCode());
        changeEntity.setEffectiveDate(new Date());
        resp = this.copyFile(changeBillId.toString(), billTypeCode, contractEntity.getId().toString(), srcBillCode, "subChangeContractFile", false);
        if (resp != null) {
            this.logger.error("\u540c\u6b65\u53d8\u66f4\u9644\u4ef6\u5230\u539f\u5408\u540c\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a{}", (Object)JSONObject.toJSONString((Object)resp));
        }
        this.changeService.saveOrUpdate((Object)changeEntity);
        this.logger.info("\u66f4\u65b0\u53d8\u66f4\u8868\u5408\u540c\u72b6\u6001\u548c\u6570\u636e,changeEntity---------->\uff1a {}", (Object)JSONObject.toJSONString((Object)((Object)changeEntity)));
        this.logger.info("\u66f4\u65b0\u53d8\u66f4\u8868\u6570\u636e\u5230\u4e3b\u5408\u540c\u5f00\u59cb----------->" + contractEntity.getChangeStatus());
        ContractEntity contractChangeEntity = (ContractEntity)((Object)BeanMapper.map((Object)((Object)changeEntity), ContractEntity.class));
        List<ChangeDetailEntity> changeDetailList = changeEntity.getDetailList();
        HashMap changDetailIdMap = new HashMap();
        HashMap changeParentIdMap = new HashMap();
        if (CollectionUtils.isNotEmpty(changeDetailList)) {
            changeDetailList.forEach(changeDetailEntity -> changDetailIdMap.put(changeDetailEntity.getId(), changeDetailEntity.getSrcTblId() != null ? changeDetailEntity.getSrcTblId() : IdWorker.getId()));
            changeDetailList.forEach(changeDetailEntity -> {
                if (changeDetailEntity.getParentId() != null) {
                    changeParentIdMap.put(changeDetailEntity.getId(), changDetailIdMap.get(changeDetailEntity.getParentId()));
                }
            });
        }
        if (CollectionUtils.isNotEmpty(contractDetailList = contractChangeEntity.getDetailList())) {
            Long contractBid = null;
            for (ContractDetailEntity contractDetailEntity : contractDetailList) {
                contractBid = (Long)changDetailIdMap.get(contractDetailEntity.getId());
                contractDetailEntity.setContractId(changeEntity.getContractId());
                contractDetailEntity.setChangeBid(contractDetailEntity.getId());
                if (null != contractDetailEntity.getParentId()) {
                    contractDetailEntity.setParentId((Long)changDetailIdMap.get(contractDetailEntity.getParentId()));
                }
                contractDetailEntity.setId(contractBid);
                contractDetailEntity.setVersion((Integer)contIdVersionMap.get(contractBid));
                contractDetailEntity.setChangeType(null);
            }
        }
        contractEntity.setDetailList(contractDetailList);
        List<ChangeOtherCostEntity> changeOtherCostList = changeEntity.getOtherCostList();
        HashMap changOtherCostIdMap = new HashMap();
        if (CollectionUtils.isNotEmpty(changeOtherCostList)) {
            changeOtherCostList.forEach(changeOtherCostEntity -> changOtherCostIdMap.put(changeOtherCostEntity.getId(), changeOtherCostEntity.getSrcTblId()));
        }
        if (CollectionUtils.isNotEmpty(contractOtherCostList = contractChangeEntity.getOtherCostList())) {
            Long contractBid = null;
            for (ContractOtherCostEntity contractOtherCostEntity : contractOtherCostList) {
                contractBid = (Long)changOtherCostIdMap.get(contractOtherCostEntity.getId());
                contractOtherCostEntity.setChangeBid(contractOtherCostEntity.getId());
                contractOtherCostEntity.setId(contractBid);
                contractOtherCostEntity.setVersion((Integer)contIdVersionMap.get(contractBid));
                contractOtherCostEntity.setContractId(contractEntity.getId());
            }
        }
        contractEntity.setOtherCostList(contractOtherCostList);
        List<ContractClauseEntity> contractClauseList = contractEntity.getClauseList();
        List<ContractClauseEntity> contractChangeClauseList = contractChangeEntity.getClauseList();
        if (CollectionUtils.isNotEmpty(contractClauseList)) {
            this.logger.info("\u5220\u9664\u5408\u540c\u6761\u6b3e\u5b50\u8868\u6570\u636e: {}", (Object)JSONObject.toJSONString(contractClauseList));
            this.contractClauseService.deleteByIds(contractClauseList.stream().map(BaseEntity::getId).collect(Collectors.toList()));
            contractChangeClauseList.forEach(clauseEntity -> {
                clauseEntity.setChangeBid(clauseEntity.getId());
                clauseEntity.setId(null);
                clauseEntity.setRowState("add");
                clauseEntity.setContractId(contractEntity.getId());
            });
        }
        contractEntity.setClauseList(contractChangeClauseList);
        List<ContractPaymentEntity> contractPayList = contractEntity.getPaymentList();
        List<ContractPaymentEntity> pList = contractChangeEntity.getPaymentList();
        if (CollectionUtils.isNotEmpty(contractPayList)) {
            this.logger.info("\u5220\u9664\u5408\u540c\u4ed8\u6b3e\u9636\u6bb5\u5b50\u8868\u6570\u636e: {}", (Object)JSONObject.toJSONString(contractPayList));
            this.contractPaymentService.deleteByIds(contractPayList.stream().map(BaseEntity::getId).collect(Collectors.toList()));
            pList.forEach(item -> {
                item.setChangeBid(item.getId());
                item.setId(null);
                item.setRowState("add");
                item.setContractId(contractEntity.getId());
            });
        }
        contractEntity.setPaymentList(pList);
        this.contractService.saveOrUpdate((Object)contractEntity, false);
        boolean pushFlag = this.contractService.pushContract((ContractVO)((Object)BeanMapper.map((Object)((Object)contractEntity), ContractVO.class)));
        if (pushFlag) {
            this.updateTotalChangeDataByContractId(changeEntity, "approve");
        }
        this.logger.info("\u66f4\u65b0\u5408\u540c\u8868\u6570\u636e\u6210\u529f,contractEntity---------->: {}", (Object)JSONObject.toJSONString((Object)((Object)contractEntity)));
        return CommonResponse.success((String)"\u53d8\u66f4\u5355\u751f\u6548\uff0c\u56de\u5199\u5408\u540c\u6210\u529f\uff01");
    }

    @Override
    public void updateTotalChangeDataByContractId(ChangeEntity changeEntity, String type) {
        this.logger.info("\u5408\u540c\u53d8\u66f4" + ("back".equals(type) ? "\u64a4\u56de" : "\u5ba1\u6279\u901a\u8fc7") + "\u540e\u66f4\u65b0\u5408\u540c\u6c60\u7d2f\u8ba1\u53d8\u66f4\u91d1\u989d\uff08\u542b\u7a0e\u3001\u65e0\u7a0e\u3001\u7a0e\u989d\uff09\u548c\u7d2f\u8ba1\u53d8\u66f4\u6bd4\u4f8b\uff0c\u5f00\u59cb\uff0cchangeEntity={}\uff0ctype={}", (Object)JSONObject.toJSONString((Object)((Object)changeEntity)), (Object)type);
        QueryWrapper wrapper = new QueryWrapper();
        ((QueryWrapper)((QueryWrapper)((QueryWrapper)wrapper.eq((Object)"dr", (Object)0)).eq((Object)"tenant_id", (Object)InvocationInfoProxy.getTenantid())).eq((Object)"contract_id", (Object)changeEntity.getContractId())).eq((Object)"performance_status", (Object)PerformanceStatusEnum.\u5c65\u7ea6\u4e2d.getCode());
        if ("back".equals(type)) {
            wrapper.ne((Object)"id", (Object)changeEntity.getId());
        }
        wrapper.select(new String[]{"sum(ifnull(change_mny, 0)) as totalChangeTaxMny, sum(ifnull(change_mny, 0) - ifnull(change_tax, 0)) as totalChangeMny, sum(ifnull(change_tax, 0)) as totalChangeTax"});
        Map totalChangeMap = super.getMap((Wrapper)wrapper);
        this.logger.info("\u67e5\u8be2\u5f53\u524d\u5408\u540c\u7684\u672c\u6b21\u53d8\u66f4\u91d1\u989d\uff08\u542b\u7a0e\u3001\u65e0\u7a0e\u3001\u7a0e\u989d\uff09\u7684\u7d2f\u52a0\u503c\u4f5c\u4e3a\u7d2f\u8ba1\u53d8\u66f4\u91d1\u989d\uff08\u542b\u7a0e\u3001\u65e0\u7a0e\u3001\u7a0e\u989d\uff09\uff0c\u67e5\u8be2\u7ed3\u679c\uff1a{}", (Object)totalChangeMap);
        BigDecimal totalChangeTaxMny = BigDecimal.ZERO;
        BigDecimal totalChangeMny = BigDecimal.ZERO;
        BigDecimal totalChangeTax = BigDecimal.ZERO;
        BigDecimal totalChangeRate = BigDecimal.ZERO;
        if (MapUtils.isNotEmpty((Map)totalChangeMap)) {
            totalChangeTaxMny = totalChangeMap.get("totalChangeTaxMny") == null ? BigDecimal.ZERO : new BigDecimal(totalChangeMap.get("totalChangeTaxMny").toString());
            totalChangeMny = totalChangeMap.get("totalChangeMny") == null ? BigDecimal.ZERO : new BigDecimal(totalChangeMap.get("totalChangeMny").toString());
            BigDecimal bigDecimal = totalChangeTax = totalChangeMap.get("totalChangeTax") == null ? BigDecimal.ZERO : new BigDecimal(totalChangeMap.get("totalChangeTax").toString());
            if (null != changeEntity.getBaseTaxMny() && changeEntity.getBaseTaxMny().compareTo(BigDecimal.ZERO) > 0) {
                totalChangeRate = totalChangeTaxMny.divide(changeEntity.getBaseTaxMny(), 8, 5).multiply(new BigDecimal(100));
            }
            this.logger.info("\u8ba1\u7b97\uff1a\u7d2f\u8ba1\u53d8\u66f4\u6bd4\u4f8b = \u7d2f\u8ba1\u53d8\u66f4\u91d1\u989d\uff08\u542b\u7a0e\uff09 / \u5408\u540c\u521d\u59cb\u91d1\u989d\uff08\u542b\u7a0e\uff09 = {}", (Object)totalChangeRate);
            ContractPoolVO contractPoolVO = new ContractPoolVO();
            contractPoolVO.setTotalChangeTaxMny(totalChangeTaxMny);
            contractPoolVO.setTotalChangeMny(totalChangeMny);
            contractPoolVO.setTotalChangeTax(totalChangeTax);
            contractPoolVO.setTaotalChangeScale(totalChangeRate);
            contractPoolVO.setSourceId(changeEntity.getContractId());
            CommonResponse saveAfterChangeRes = this.contractPoolApi.saveOrUpdateContract(contractPoolVO);
            this.logger.info("\u5408\u540c\u53d8\u66f4" + ("back".equals(type) ? "\u64a4\u56de" : "\u5ba1\u6279\u901a\u8fc7") + "\u540e\u66f4\u65b0\u5408\u540c\u6c60\u7d2f\u8ba1\u53d8\u66f4\u91d1\u989d\uff08\u542b\u7a0e\u3001\u65e0\u7a0e\u3001\u7a0e\u989d\uff09\u548c\u7d2f\u8ba1\u53d8\u66f4\u6bd4\u4f8b\uff0c\u7ed3\u675f\uff0c\u63a5\u53e3\u8fd4\u56de\u7ed3\u679c\uff1a{}", (Object)JSONObject.toJSONString((Object)saveAfterChangeRes));
        }
    }

    private CommonResponse copyFile(String srcBillId, String srcBillTypeCode, String targetBillId, String targetBillTypeCode, String srcAttachSourceType, boolean copyContractFile) {
        CommonResponse copyContractFileResp;
        CommonResponse copyContractAttachResp = this.attachmentApi.copyFilesFromSourceBillToTargetBill(srcBillId, srcBillTypeCode, srcAttachSourceType, targetBillId, targetBillTypeCode, "subContractBill");
        if (!copyContractAttachResp.isSuccess()) {
            this.logger.info("\u540c\u6b65\u5408\u540c\u6587\u4ef6\u5931\u8d25--------------->srcBillId-{},srcBillTypeCode-{},srcSourceType-{},targetBillId-{},targetBillTypeCode-{},targetSourceType-{},\uff1a{}", new Object[]{srcBillId, srcBillTypeCode, "subContractBill", targetBillId, targetBillTypeCode, "subContractBill", copyContractAttachResp.getMsg()});
            this.logger.info("\u540c\u6b65\u9644\u4ef6\u7ba1\u7406\u4e2d\u7684\u9644\u4ef6\u5931\u8d25--------------->\u5931\u8d25\u4fe1\u606f------------>\uff1a{}", (Object)copyContractAttachResp.getMsg());
            return CommonResponse.error((String)("\u5ba1\u6279\u5931\u8d25\uff0c\u540c\u6b65\u9644\u4ef6\u5931\u8d25\uff0c\u9519\u8bef\u4fe1\u606f\uff1a" + copyContractAttachResp.getMsg()));
        }
        if (copyContractFile && !(copyContractFileResp = this.attachmentApi.copyFilesFromSourceBillToTargetBill(srcBillId, srcBillTypeCode, "subContractFile", targetBillId, targetBillTypeCode, "subContractFile")).isSuccess()) {
            this.logger.info("\u540c\u6b65\u5408\u540c\u6587\u4ef6\u5931\u8d25--------------->srcBillId-{},srcBillTypeCode-{},srcSourceType-{},targetBillId-{},targetBillTypeCode-{},targetSourceType-{},\uff1a{}", new Object[]{srcBillId, srcBillTypeCode, "subContractFile", targetBillId, targetBillTypeCode, "subContractFile", copyContractFileResp.getMsg()});
            return CommonResponse.error((String)("\u5ba1\u6279\u5931\u8d25\uff0c\u540c\u6b65\u5408\u540c\u6587\u4ef6\u5931\u8d25\uff0c\u9519\u8bef\u4fe1\u606f\uff1a" + copyContractFileResp.getMsg()));
        }
        return null;
    }

    @Override
    public ParamsCheckVO targetCostCtrl(ChangeVO changeVO) {
        String frontendBaseHost = "";
        frontendBaseHost = StringUtils.isNotBlank((CharSequence)this.BASE_HOST_FRONTEND) && !"null".equals(this.BASE_HOST_FRONTEND) ? this.BASE_HOST_FRONTEND : this.baseHost;
        ChangeEntity entity = (ChangeEntity)((Object)BeanMapper.map((Object)((Object)changeVO), ChangeEntity.class));
        String linkUrl = frontendBaseHost + "ejc-proequiment-frontend/#/otherSubList/changeCard?id=" + entity.getId() + "&cardType=otherSubCard";
        String billType = BillTypeEnum.\u5b89\u62c6\u5408\u540c\u53d8\u66f4.getCode();
        ExecutionVO executionVO = this.changeService.targetCost((ChangeVO)((Object)BeanMapper.map((Object)((Object)entity), ChangeVO.class)), linkUrl, entity.getContractType());
        this.logger.error("ss" + JSONObject.toJSONString((Object)executionVO));
        CommonResponse response = this.executionApi.ctrlCheckVO(executionVO);
        ParamsCheckVO paramsCheckVO = this.checkParams(changeVO, (ParamsCheckVO)response.getData());
        return paramsCheckVO;
    }

    @Override
    public ParamsCheckVO viewTargetCostCtrlInfo(Long id) {
        String frontendBaseHost = "";
        frontendBaseHost = StringUtils.isNotBlank((CharSequence)this.BASE_HOST_FRONTEND) && !"null".equals(this.BASE_HOST_FRONTEND) ? this.BASE_HOST_FRONTEND : this.baseHost;
        ChangeVO changeVO = this.changeService.queryDetail(id);
        String linkUrl = frontendBaseHost + "ejc-proequiment-frontend/#/otherSubList/changeCard?id=" + changeVO.getId() + "&cardType=otherSubCard";
        String billType = BillTypeEnum.\u5b89\u62c6\u5408\u540c\u53d8\u66f4.getCode();
        ExecutionVO executionVO = this.changeService.targetCost((ChangeVO)((Object)BeanMapper.map((Object)((Object)changeVO), ChangeVO.class)), linkUrl, changeVO.getContractType());
        this.logger.error("ss" + JSONObject.toJSONString((Object)executionVO));
        CommonResponse response = this.executionApi.ctrlCheckVO(executionVO);
        ParamsCheckVO paramsCheckVO = this.checkParams(changeVO, (ParamsCheckVO)response.getData());
        return paramsCheckVO;
    }

    @Override
    public ExecutionVO targetCost(ChangeVO changeVO, String linkUrl, Integer contractType) {
        ExecutionVO executionVO = new ExecutionVO();
        TotalExecutionVO totalVO = new TotalExecutionVO();
        ArrayList detailList = new ArrayList();
        totalVO.setSourceId(changeVO.getId());
        totalVO.setTenantId(changeVO.getTenantId());
        totalVO.setBillCode(changeVO.getBillCode());
        totalVO.setOrgId(changeVO.getOrgId());
        totalVO.setBillType(BillTypeEnum.\u5b89\u62c6\u5408\u540c\u53d8\u66f4.getCode());
        totalVO.setBussinessType(BussinessTypeEnum.\u5927\u578b\u8bbe\u5907\u5b89\u62c6\u5408\u540c.getCode());
        totalVO.setBillCategory(BillCategoryEnum.\u5408\u540c.getCode());
        QueryWrapper wrapper = new QueryWrapper();
        ((QueryWrapper)((QueryWrapper)wrapper.eq((Object)"contract_id", (Object)changeVO.getContractId())).eq((Object)"dr", (Object)0)).orderByDesc((Object)"create_time");
        List list = this.changeService.list((Wrapper)wrapper);
        if (list.size() > 0) {
            totalVO.setLastSourceId(((ChangeEntity)((Object)list.get(0))).getId());
        } else {
            totalVO.setLastSourceId(changeVO.getContractId());
        }
        if (changeVO.getProjectId() == null) {
            throw new BusinessException("\u76ee\u6807\u6210\u672c\u63a8\u9001\u5931\u8d25,\u8bf7\u66f4\u6362\u9879\u76ee");
        }
        totalVO.setProjectId(changeVO.getProjectId());
        if (changeVO.getOrgId() == null) {
            throw new BusinessException("\u76ee\u6807\u6210\u672c\u63a8\u9001\u5931\u8d25,\u8bf7\u66f4\u6362\u9879\u76ee");
        }
        totalVO.setOrgId(changeVO.getOrgId());
        totalVO.setMoney(changeVO.getContractMny());
        totalVO.setTaxMoney(changeVO.getContractTaxMny());
        totalVO.setLinkUrl(linkUrl);
        executionVO.setTotalVO(totalVO);
        executionVO.setDetailList(detailList);
        return executionVO;
    }

    @Override
    public ParamsCheckVO checkParams(ChangeVO vo, ParamsCheckVO paramsCheckVO2) {
        ArrayList<ParamsCheckVO> paramsCheckVOS = new ArrayList<ParamsCheckVO>();
        ParamsCheckVO paramsCheckVO = new ParamsCheckVO();
        paramsCheckVO.setWarnType("none");
        if (CollectionUtils.isNotEmpty(this.checkParamsConstruction(vo))) {
            paramsCheckVOS.addAll(this.checkParamsConstruction(vo));
        }
        paramsCheckVOS.addAll(this.checkParamsMny(vo));
        if (paramsCheckVO2 != null) {
            paramsCheckVOS.add(paramsCheckVO2);
        }
        HashMap<String, List> map = new HashMap<String, List>();
        String[] paramsArray = new String[]{"alert", "warn", "none"};
        if (CollectionUtils.isNotEmpty(paramsCheckVOS)) {
            for (ParamsCheckVO checkVO : paramsCheckVOS) {
                String warnType = checkVO.getWarnType();
                if (map.containsKey(warnType)) {
                    List checkDsVOS = (List)map.get(warnType);
                    checkDsVOS.addAll(checkVO.getDataSource());
                    map.put(warnType, checkDsVOS);
                    continue;
                }
                map.put(warnType, checkVO.getDataSource());
            }
        }
        for (String s : paramsArray) {
            if (!map.containsKey(s)) continue;
            paramsCheckVO.setWarnType(s);
            paramsCheckVO.setDataSource((List)map.get(s));
            if (CollectionUtils.isEmpty((Collection)paramsCheckVO.getDataSource())) {
                paramsCheckVO.setWarnType("none");
                continue;
            }
            return paramsCheckVO;
        }
        return paramsCheckVO;
    }

    @Override
    public List<ParamsCheckVO> checkParamsConstruction(ChangeVO vo) {
        CommonResponse response = this.paramCheckApi.paramsCheck(vo.getProjectId(), vo.getContractId(), vo.getContractTaxMny(), vo.getOrgId());
        this.logger.info("\u65bd\u5de5\u5408\u540c\u63a7\u5236\u4fe1\u606f\u8fd4\u56de\uff1a" + JSONObject.toJSONString((Object)response.getData()));
        if (!response.isSuccess()) {
            throw new BusinessException("\u83b7\u53d6\u65bd\u5de5\u53c2\u6570\u63a7\u5236\u4fe1\u606f\u5931\u8d25!" + response.getMsg());
        }
        return (List)response.getData();
    }

    @Override
    public List<ParamsCheckVO> checkParamsMny(ChangeVO vo) {
        BigDecimal changeMoney = vo.getChangeMny() == null ? BigDecimal.ZERO : vo.getChangeMny();
        BigDecimal contractTaxMny = vo.getBaseTaxMny() == null ? BigDecimal.ZERO : vo.getBaseTaxMny();
        BigDecimal totalChangeMoney = changeMoney;
        QueryWrapper query = new QueryWrapper();
        query.eq((Object)"contract_id", (Object)vo.getContractId());
        query.eq((Object)"dr", (Object)BaseVO.DR_UNDELETE);
        query.in((Object)"bill_state", new Object[]{1, 3});
        query.eq((Object)"signature_status", (Object)SignatureStatusEnum.\u5df2\u7b7e\u7ae0.getCode());
        List list = this.list((Wrapper)query);
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            for (ChangeEntity changeEntity : list) {
                totalChangeMoney = ComputeUtil.safeAdd((BigDecimal)changeEntity.getChangeMny(), (BigDecimal)totalChangeMoney);
            }
        }
        String[] paramsArray = new String[]{"none", "warn", "alert"};
        ArrayList<ParamsCheckVO> paramsCheckVOList = new ArrayList<ParamsCheckVO>();
        CommonResponse billParamByCode = this.paramConfigApi.getBillParamByCodeAndOrgId(CHECK_PARAM_CODE, vo.getOrgId());
        if (billParamByCode.isSuccess() && null != billParamByCode.getData()) {
            List data = (List)billParamByCode.getData();
            this.logger.info("\u7d2f\u8ba1\u53d8\u66f4\u91d1\u989d\u63a7\u5236\u4fe1\u606f\u8fd4\u56de\uff1a" + JSONObject.toJSONString((Object)data));
            if (CollectionUtils.isNotEmpty((Collection)data)) {
                for (BillParamVO datum : data) {
                    ParamsCheckVO paramsCheckVO = new ParamsCheckVO();
                    ArrayList<ParamsCheckDsVO> checkDsVOS = new ArrayList<ParamsCheckDsVO>();
                    BigDecimal roleValue = datum.getRoleValue();
                    BigDecimal comMny = ComputeUtil.safeDiv((BigDecimal)ComputeUtil.safeMultiply((BigDecimal)contractTaxMny, (BigDecimal)roleValue), (BigDecimal)new BigDecimal("100")).setScale(2, 4);
                    paramsCheckVO.setWarnType(paramsArray[datum.getControlType()]);
                    if (totalChangeMoney.compareTo(comMny) > 0) {
                        ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO();
                        paramsCheckDsVO.setOrgName(datum.getOrgName());
                        paramsCheckDsVO.setWarnItem("\u53d8\u66f4\u8d85\u5408\u540c\u91d1\u989d");
                        paramsCheckDsVO.setWarnName("\u7d2f\u8ba1\u53d8\u66f4\u91d1\u989d\u5927\u4e8e\u5408\u540c\u91d1\u989d");
                        StringBuffer stringBuffer = new StringBuffer();
                        stringBuffer.append("\u672c\u6b21\u53d8\u66f4\u91d1\u989d\uff1a").append(changeMoney.setScale(2, 4)).append("\u5143\uff0c\u542b\u672c\u6b21\u7d2f\u8ba1\u53d8\u66f4\u91d1\u989d\uff1a").append(totalChangeMoney.setScale(2, 4)).append("\u5143\uff0c\u5408\u540c\u91d1\u989d*").append(roleValue).append("%:").append(comMny.setScale(2, 4)).append("\u5143\u3002\u8d85\u51fa\u91d1\u989d\uff1a").append(ComputeUtil.safeSub((BigDecimal)totalChangeMoney, (BigDecimal)comMny).setScale(2, 4)).append("\u5143");
                        paramsCheckDsVO.setContent(stringBuffer.toString());
                        checkDsVOS.add(paramsCheckDsVO);
                    }
                    paramsCheckVO.setDataSource(checkDsVOS);
                    paramsCheckVOList.add(paramsCheckVO);
                }
            }
        } else {
            this.logger.info(billParamByCode.getMsg());
            throw new BusinessException("\u83b7\u53d6\u63a7\u5236\u53c2\u6570\u5931\u8d25");
        }
        return paramsCheckVOList;
    }

    @Override
    public void asyncWatermarkById(Long id) {
        ChangeEntity changeEntity = (ChangeEntity)((Object)super.selectById((Serializable)id));
        this.logger.info("\u5f00\u59cb\u83b7\u53d6\u6c34\u5370\u53c2\u6570\u4fe1\u606f\uff0c\u53d8\u66f4\u5408\u540cid\uff1a{}--------", (Object)id);
        CommonResponse response = this.paramConfigApi.getByCode(WATERMARK_CHECK_PARAM_NAME);
        this.logger.info("\u83b7\u53d6\u6c34\u5370\u7cfb\u7edf\u53c2\u6570\u8bf7\u6c42\u7ed3\u679c\uff1a{}", (Object)JSONObject.toJSONString((Object)response));
        if (!response.isSuccess() || response.getData() == null) {
            throw new BusinessException("\u83b7\u53d6\u6c34\u5370\u7cfb\u7edf\u53c2\u6570\u8bf7\u6c42\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a" + response.getMsg());
        }
        String valueData = ((ParamRegisterSetVO)response.getData()).getValueData();
        Assert.hasText((String)valueData, (String)"\u83b7\u53d6\u7684\u6c34\u5370\u7cfb\u7edf\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a!");
        if ("0".equals(valueData)) {
            String billType = CHANGE_BILL_TYPE;
            String sourceType = "contractAC";
            WatermarkVO watermarkVO = this.signatureCommonApi.fetchWatermarkConfig(changeEntity.getChangeFileId(), changeEntity.getId(), changeEntity.getBillCode(), billType, sourceType);
            Assert.notNull((Object)watermarkVO, (String)"\u83b7\u53d6\u6c34\u5370\u7cfb\u7edf\u53c2\u6570\u5931\u8d25!");
            HttpServletRequest request = ((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getRequest();
            HashMap<String, String> headers = new HashMap<String, String>();
            headers.put("authority", request.getHeader("authority"));
            headers.put("ejc-token", request.getHeader("ejc-token"));
            this.changeAsyncService.fetchWatermarkAttachment(headers, watermarkVO);
        }
    }
}

