/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.proequipmentcorprent.ac.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ejianc.business.proequipmentcorprent.ac.bean.ContractEntity;
import com.ejianc.business.proequipmentcorprent.ac.bean.ContractRelieveEntity;
import com.ejianc.business.proequipmentcorprent.ac.enums.PerformanceStatusEnum;
import com.ejianc.business.proequipmentcorprent.ac.enums.SignatureStatusEnum;
import com.ejianc.business.proequipmentcorprent.ac.mapper.ContractRelieveMapper;
import com.ejianc.business.proequipmentcorprent.ac.service.IContractRelieveService;
import com.ejianc.business.proequipmentcorprent.ac.service.IContractService;
import com.ejianc.business.proequipmentcorprent.ac.vo.ContractRelieveVO;
import com.ejianc.business.proequipmentcorprent.ac.vo.ContractVO;
import com.ejianc.business.proequipmentcorprent.settle.bean.SettleEntity;
import com.ejianc.business.proequipmentcorprent.settle.service.ISettleService;
import com.ejianc.business.targetcost.api.IExecutionApi;
import com.ejianc.business.targetcost.enums.BillCategoryEnum;
import com.ejianc.business.targetcost.enums.BussinessTypeEnum;
import com.ejianc.business.targetcost.vo.ExecutionVO;
import com.ejianc.business.targetcost.vo.TotalExecutionVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service(value="contractRelieveService")
public class ContractRelieveServiceImpl
extends BaseServiceImpl<ContractRelieveMapper, ContractRelieveEntity>
implements IContractRelieveService {
    @Autowired
    private IContractRelieveService service;
    @Autowired
    private ISettleService settleService;
    @Autowired
    private IContractService contractService;
    @Autowired
    private IExecutionApi executionApi;
    @Value(value="${common.env.base-host}")
    private String BaseHost;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    @Override
    public Boolean isCanRelieve(Long contractId) {
        QueryParam param = new QueryParam();
        param.getParams().put("contract_id", new Parameter("eq", (Object)contractId));
        List list = this.service.queryList(param);
        return list.isEmpty();
    }

    @Override
    public ExecutionVO targetCost(ContractRelieveVO contractRelieveVO, String linkUrl, Integer contractType) {
        ExecutionVO executionVO = new ExecutionVO();
        TotalExecutionVO totalVO = new TotalExecutionVO();
        ArrayList detailList = new ArrayList();
        totalVO.setSourceId(contractRelieveVO.getId());
        totalVO.setTenantId(contractRelieveVO.getTenantId());
        totalVO.setBillCode(contractRelieveVO.getBillCode());
        totalVO.setOrgId(contractRelieveVO.getOrgId());
        totalVO.setBillType("EJCBT202204000013");
        totalVO.setBussinessType(BussinessTypeEnum.\u5927\u578b\u8bbe\u5907\u5b89\u62c6\u5408\u540c.getCode());
        totalVO.setBillCategory(BillCategoryEnum.\u5408\u540c.getCode());
        if (contractRelieveVO.getProjectId() == null) {
            throw new BusinessException("\u76ee\u6807\u6210\u672c\u63a8\u9001\u5931\u8d25,\u8bf7\u66f4\u6362\u9879\u76ee");
        }
        totalVO.setProjectId(contractRelieveVO.getProjectId());
        if (contractRelieveVO.getOrgId() == null) {
            throw new BusinessException("\u76ee\u6807\u6210\u672c\u63a8\u9001\u5931\u8d25,\u8bf7\u66f4\u6362\u9879\u76ee");
        }
        totalVO.setOrgId(contractRelieveVO.getOrgId());
        ContractEntity contractEntity = (ContractEntity)((Object)this.contractService.selectById(contractRelieveVO.getContractId()));
        LambdaQueryWrapper query = new LambdaQueryWrapper();
        query.eq(SettleEntity::getContractId, (Object)contractEntity.getId());
        query.in(SettleEntity::getBillState, new Object[]{1, 3});
        query.eq(BaseEntity::getDr, (Object)0);
        query.eq(SettleEntity::getSettleType, (Object)0);
        List entity = this.settleService.list((Wrapper)query);
        BigDecimal sumMny = BigDecimal.ZERO;
        BigDecimal sumTaxMny = BigDecimal.ZERO;
        for (SettleEntity monthVo : entity) {
            sumMny = ComputeUtil.safeAdd((BigDecimal)sumMny, (BigDecimal)monthVo.getMny());
            sumTaxMny = ComputeUtil.safeAdd((BigDecimal)sumTaxMny, (BigDecimal)monthVo.getTaxMny());
        }
        totalVO.setMoney(ComputeUtil.safeSub((BigDecimal)sumMny, (BigDecimal)contractEntity.getContractMny()));
        totalVO.setTaxMoney(ComputeUtil.safeSub((BigDecimal)sumTaxMny, (BigDecimal)contractEntity.getContractTaxMny()));
        totalVO.setLinkUrl(linkUrl);
        executionVO.setTotalVO(totalVO);
        executionVO.setDetailList(detailList);
        return executionVO;
    }

    @Override
    public CommonResponse<String> relieveContract(String billId, String status, String refCode) {
        this.logger.info("\u66f4\u65b0\u5408\u540c\u89e3\u9664\u5355\u636e\u7b7e\u7ae0\u72b6\u6001\u548c\u5408\u540c\u72b6\u6001\uff0c\u5165\u53c2\uff1aid:{}\uff0csignatureStatus\uff1a{}\uff0crefCode\uff1a{}", new Object[]{billId, status, refCode});
        Long id = Long.valueOf(billId);
        ContractRelieveEntity entity = (ContractRelieveEntity)((Object)super.selectById((Serializable)id));
        this.logger.info("\u89e3\u9664\u5355\u636e{}", (Object)JSONObject.toJSONString((Object)((Object)entity)));
        if (entity != null) {
            if (status.equals(SignatureStatusEnum.\u5df2\u7b7e\u7ae0.getCode()) && entity.getDraftType() == 2) {
                entity.setSignatureStatus(SignatureStatusEnum.\u5df2\u7b7e\u7ae0.getCode());
                entity.setPerformanceStatus(Integer.valueOf(PerformanceStatusEnum.\u5df2\u4f5c\u5e9f.getCode()));
                entity.setEffectiveDate(new Date());
                this.service.saveOrUpdate((Object)entity, false);
                QueryParam param = new QueryParam();
                param.getParams().put("id", new Parameter("eq", (Object)entity.getContractId()));
                List contractEntities = this.contractService.queryList(param, false);
                ((ContractEntity)((Object)contractEntities.get(0))).setPerformanceStatus(PerformanceStatusEnum.\u5df2\u4f5c\u5e9f.getCode());
                this.logger.info("======\u7ec8\u5ba1\u5ba1\u6838\u5b8c\u56de\u8c03,\u5df2\u7b7e\u7ae0======,{}", (Object)JSONObject.toJSONString(contractEntities.get(0)));
                this.contractService.saveOrUpdate(contractEntities.get(0), false);
                this.logger.info("\u63a8\u9001\u5408\u540c\u6c60\uff0c\u5165\u53c2\uff1a{}", (Object)JSONObject.toJSONString(contractEntities.get(0)));
                this.contractService.pushContract((ContractVO)((Object)BeanMapper.map(contractEntities.get(0), ContractVO.class)));
            } else if (entity.getDraftType() == 1) {
                entity.setSignatureStatus(SignatureStatusEnum.\u672a\u7b7e\u7ae0.getCode());
                this.logger.info("======\u7ec8\u5ba1\u5ba1\u6838\u5b8c\u56de\u8c03,\u521d\u59cb\u5316\u6210\u672a\u7b7e\u7ae0======,{}", (Object)JSONObject.toJSONString((Object)((Object)entity)));
                this.service.saveOrUpdate((Object)entity, false);
            }
        } else {
            throw new BusinessException("\u67e5\u8be2\u89e3\u9664\u5355\u5931\u8d25\uff01");
        }
        this.logger.info("\u5408\u540c\u5df2\u89e3\u9664\uff01");
        return CommonResponse.success((String)"\u5408\u540c\u89e3\u9664\u5355\u636e\u7b7e\u7ae0\u72b6\u6001\u66f4\u65b0\u6210\u529f\uff01");
    }
}

