package com.ejianc.business.proequipmentcorpout.contract.controller.api;


import com.ejianc.business.pricelib.vo.RentPriceContractVO;
import com.ejianc.business.proequipmentcorpout.contract.service.IOutRentContractService;
import com.ejianc.framework.core.response.CommonResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.ArrayList;
import java.util.List;



@RestController
@RequestMapping
public class ContractCorpOutApiController {

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IOutRentContractService outRentContractService;

    /**
     * 查询设备租赁价格库所需-设备公司-租出合同-数据
     * @param initFlag
     * @return
     */
    @GetMapping(value = "/api/contractcorpout/getPriceContractDataByCorpOut")
    CommonResponse<List<RentPriceContractVO>> getPriceContractDataByCorpOut(@RequestParam(value = "initFlag") String initFlag){
        List<RentPriceContractVO> rentPriceContractVOList = outRentContractService.queryPriceContractDataByCorpOut(initFlag);
        return CommonResponse.success("查询设备租赁价格库所需-设备公司-租出合同-数据结束！", rentPriceContractVOList);
    }
}
